# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StackInstancesArgs', 'StackInstances']

@pulumi.input_type
class StackInstancesArgs:
    def __init__(__self__, *,
                 stack_set_name: pulumi.Input[builtins.str],
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 call_as: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_targets: Optional[pulumi.Input['StackInstancesDeploymentTargetsArgs']] = None,
                 operation_preferences: Optional[pulumi.Input['StackInstancesOperationPreferencesArgs']] = None,
                 parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 retain_stacks: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a StackInstances resource.
        :param pulumi.Input[builtins.str] stack_set_name: Name of the stack set.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] accounts: Accounts where you want to create stack instances in the specified `regions`. You can specify either `accounts` or `deployment_targets`, but not both.
        :param pulumi.Input[builtins.str] call_as: Whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        :param pulumi.Input['StackInstancesDeploymentTargetsArgs'] deployment_targets: AWS Organizations accounts for which to create stack instances in the `regions`. stack sets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for most of this argument. See deployment_targets below.
        :param pulumi.Input['StackInstancesOperationPreferencesArgs'] operation_preferences: Preferences for how AWS CloudFormation performs a stack set operation. See operation_preferences below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameter_overrides: Key-value map of input parameters to override from the stack set for these instances. This argument's drift detection is limited to the first account and region since each instance can have unique parameters.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] regions: Regions where you want to create stack instances in the specified `accounts`.
        :param pulumi.Input[builtins.bool] retain_stacks: Whether to remove the stack instances from the stack set, but not delete the stacks. You can't reassociate a retained stack or add an existing, saved stack to a new stack set. To retain the stack, ensure `retain_stacks = true` has been successfully applied _before_ an apply that would destroy the resource. Defaults to `false`.
        """
        pulumi.set(__self__, "stack_set_name", stack_set_name)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if call_as is not None:
            pulumi.set(__self__, "call_as", call_as)
        if deployment_targets is not None:
            pulumi.set(__self__, "deployment_targets", deployment_targets)
        if operation_preferences is not None:
            pulumi.set(__self__, "operation_preferences", operation_preferences)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if retain_stacks is not None:
            pulumi.set(__self__, "retain_stacks", retain_stacks)

    @property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the stack set.

        The following arguments are optional:
        """
        return pulumi.get(self, "stack_set_name")

    @stack_set_name.setter
    def stack_set_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stack_set_name", value)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Accounts where you want to create stack instances in the specified `regions`. You can specify either `accounts` or `deployment_targets`, but not both.
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "accounts", value)

    @property
    @pulumi.getter(name="callAs")
    def call_as(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        """
        return pulumi.get(self, "call_as")

    @call_as.setter
    def call_as(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "call_as", value)

    @property
    @pulumi.getter(name="deploymentTargets")
    def deployment_targets(self) -> Optional[pulumi.Input['StackInstancesDeploymentTargetsArgs']]:
        """
        AWS Organizations accounts for which to create stack instances in the `regions`. stack sets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for most of this argument. See deployment_targets below.
        """
        return pulumi.get(self, "deployment_targets")

    @deployment_targets.setter
    def deployment_targets(self, value: Optional[pulumi.Input['StackInstancesDeploymentTargetsArgs']]):
        pulumi.set(self, "deployment_targets", value)

    @property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> Optional[pulumi.Input['StackInstancesOperationPreferencesArgs']]:
        """
        Preferences for how AWS CloudFormation performs a stack set operation. See operation_preferences below.
        """
        return pulumi.get(self, "operation_preferences")

    @operation_preferences.setter
    def operation_preferences(self, value: Optional[pulumi.Input['StackInstancesOperationPreferencesArgs']]):
        pulumi.set(self, "operation_preferences", value)

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of input parameters to override from the stack set for these instances. This argument's drift detection is limited to the first account and region since each instance can have unique parameters.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameter_overrides", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Regions where you want to create stack instances in the specified `accounts`.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="retainStacks")
    def retain_stacks(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to remove the stack instances from the stack set, but not delete the stacks. You can't reassociate a retained stack or add an existing, saved stack to a new stack set. To retain the stack, ensure `retain_stacks = true` has been successfully applied _before_ an apply that would destroy the resource. Defaults to `false`.
        """
        return pulumi.get(self, "retain_stacks")

    @retain_stacks.setter
    def retain_stacks(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "retain_stacks", value)


@pulumi.input_type
class _StackInstancesState:
    def __init__(__self__, *,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 call_as: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_targets: Optional[pulumi.Input['StackInstancesDeploymentTargetsArgs']] = None,
                 operation_preferences: Optional[pulumi.Input['StackInstancesOperationPreferencesArgs']] = None,
                 parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 retain_stacks: Optional[pulumi.Input[builtins.bool]] = None,
                 stack_instance_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['StackInstancesStackInstanceSummaryArgs']]]] = None,
                 stack_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 stack_set_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering StackInstances resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] accounts: Accounts where you want to create stack instances in the specified `regions`. You can specify either `accounts` or `deployment_targets`, but not both.
        :param pulumi.Input[builtins.str] call_as: Whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        :param pulumi.Input['StackInstancesDeploymentTargetsArgs'] deployment_targets: AWS Organizations accounts for which to create stack instances in the `regions`. stack sets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for most of this argument. See deployment_targets below.
        :param pulumi.Input['StackInstancesOperationPreferencesArgs'] operation_preferences: Preferences for how AWS CloudFormation performs a stack set operation. See operation_preferences below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameter_overrides: Key-value map of input parameters to override from the stack set for these instances. This argument's drift detection is limited to the first account and region since each instance can have unique parameters.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] regions: Regions where you want to create stack instances in the specified `accounts`.
        :param pulumi.Input[builtins.bool] retain_stacks: Whether to remove the stack instances from the stack set, but not delete the stacks. You can't reassociate a retained stack or add an existing, saved stack to a new stack set. To retain the stack, ensure `retain_stacks = true` has been successfully applied _before_ an apply that would destroy the resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['StackInstancesStackInstanceSummaryArgs']]] stack_instance_summaries: List of stack instances created from an organizational unit deployment target. This may not always be set depending on whether CloudFormation returns summaries for your configuration. See `stack_instance_summaries`.
        :param pulumi.Input[builtins.str] stack_set_id: Name or unique ID of the stack set that the stack instance is associated with.
        :param pulumi.Input[builtins.str] stack_set_name: Name of the stack set.
               
               The following arguments are optional:
        """
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if call_as is not None:
            pulumi.set(__self__, "call_as", call_as)
        if deployment_targets is not None:
            pulumi.set(__self__, "deployment_targets", deployment_targets)
        if operation_preferences is not None:
            pulumi.set(__self__, "operation_preferences", operation_preferences)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if retain_stacks is not None:
            pulumi.set(__self__, "retain_stacks", retain_stacks)
        if stack_instance_summaries is not None:
            pulumi.set(__self__, "stack_instance_summaries", stack_instance_summaries)
        if stack_set_id is not None:
            pulumi.set(__self__, "stack_set_id", stack_set_id)
        if stack_set_name is not None:
            pulumi.set(__self__, "stack_set_name", stack_set_name)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Accounts where you want to create stack instances in the specified `regions`. You can specify either `accounts` or `deployment_targets`, but not both.
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "accounts", value)

    @property
    @pulumi.getter(name="callAs")
    def call_as(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        """
        return pulumi.get(self, "call_as")

    @call_as.setter
    def call_as(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "call_as", value)

    @property
    @pulumi.getter(name="deploymentTargets")
    def deployment_targets(self) -> Optional[pulumi.Input['StackInstancesDeploymentTargetsArgs']]:
        """
        AWS Organizations accounts for which to create stack instances in the `regions`. stack sets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for most of this argument. See deployment_targets below.
        """
        return pulumi.get(self, "deployment_targets")

    @deployment_targets.setter
    def deployment_targets(self, value: Optional[pulumi.Input['StackInstancesDeploymentTargetsArgs']]):
        pulumi.set(self, "deployment_targets", value)

    @property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> Optional[pulumi.Input['StackInstancesOperationPreferencesArgs']]:
        """
        Preferences for how AWS CloudFormation performs a stack set operation. See operation_preferences below.
        """
        return pulumi.get(self, "operation_preferences")

    @operation_preferences.setter
    def operation_preferences(self, value: Optional[pulumi.Input['StackInstancesOperationPreferencesArgs']]):
        pulumi.set(self, "operation_preferences", value)

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of input parameters to override from the stack set for these instances. This argument's drift detection is limited to the first account and region since each instance can have unique parameters.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameter_overrides", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Regions where you want to create stack instances in the specified `accounts`.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="retainStacks")
    def retain_stacks(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to remove the stack instances from the stack set, but not delete the stacks. You can't reassociate a retained stack or add an existing, saved stack to a new stack set. To retain the stack, ensure `retain_stacks = true` has been successfully applied _before_ an apply that would destroy the resource. Defaults to `false`.
        """
        return pulumi.get(self, "retain_stacks")

    @retain_stacks.setter
    def retain_stacks(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "retain_stacks", value)

    @property
    @pulumi.getter(name="stackInstanceSummaries")
    def stack_instance_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackInstancesStackInstanceSummaryArgs']]]]:
        """
        List of stack instances created from an organizational unit deployment target. This may not always be set depending on whether CloudFormation returns summaries for your configuration. See `stack_instance_summaries`.
        """
        return pulumi.get(self, "stack_instance_summaries")

    @stack_instance_summaries.setter
    def stack_instance_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackInstancesStackInstanceSummaryArgs']]]]):
        pulumi.set(self, "stack_instance_summaries", value)

    @property
    @pulumi.getter(name="stackSetId")
    def stack_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name or unique ID of the stack set that the stack instance is associated with.
        """
        return pulumi.get(self, "stack_set_id")

    @stack_set_id.setter
    def stack_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stack_set_id", value)

    @property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the stack set.

        The following arguments are optional:
        """
        return pulumi.get(self, "stack_set_name")

    @stack_set_name.setter
    def stack_set_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stack_set_name", value)


@pulumi.type_token("aws:cloudformation/stackInstances:StackInstances")
class StackInstances(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 call_as: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_targets: Optional[pulumi.Input[Union['StackInstancesDeploymentTargetsArgs', 'StackInstancesDeploymentTargetsArgsDict']]] = None,
                 operation_preferences: Optional[pulumi.Input[Union['StackInstancesOperationPreferencesArgs', 'StackInstancesOperationPreferencesArgsDict']]] = None,
                 parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 retain_stacks: Optional[pulumi.Input[builtins.bool]] = None,
                 stack_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudformation.StackInstances("example",
            accounts=[
                "123456789012",
                "234567890123",
            ],
            regions=[
                "us-east-1",
                "us-west-2",
            ],
            stack_set_name=example_aws_cloudformation_stack_set["name"])
        ```

        ### Example IAM Setup in Target Account

        ```python
        import pulumi
        import pulumi_aws as aws

        a_ws_cloud_formation_stack_set_execution_role_assume_role_policy = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "effect": "Allow",
            "principals": [{
                "identifiers": [a_ws_cloud_formation_stack_set_administration_role["arn"]],
                "type": "AWS",
            }],
        }])
        a_ws_cloud_formation_stack_set_execution_role = aws.iam.Role("AWSCloudFormationStackSetExecutionRole",
            assume_role_policy=a_ws_cloud_formation_stack_set_execution_role_assume_role_policy.json,
            name="AWSCloudFormationStackSetExecutionRole")
        # Documentation: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html
        # Additional IAM permissions necessary depend on the resources defined in the StackSet template
        a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy = aws.iam.get_policy_document(statements=[{
            "actions": [
                "cloudformation:*",
                "s3:*",
                "sns:*",
            ],
            "effect": "Allow",
            "resources": ["*"],
        }])
        a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy_role_policy = aws.iam.RolePolicy("AWSCloudFormationStackSetExecutionRole_MinimumExecutionPolicy",
            name="MinimumExecutionPolicy",
            policy=a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy.json,
            role=a_ws_cloud_formation_stack_set_execution_role.name)
        ```

        ### Example Deployment across Organizations account

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudformation.StackInstances("example",
            deployment_targets={
                "organizational_unit_ids": [example_aws_organizations_organization["roots"][0]["id"]],
            },
            regions=[
                "us-west-2",
                "us-east-1",
            ],
            stack_set_name=example_aws_cloudformation_stack_set["name"])
        ```

        ## Import

        Import CloudFormation stack instances that target OUs, using the stack set name, `call_as`, and "OU" separated by commas (`,`). For example:

        Using `pulumi import`, import CloudFormation stack instances using the stack set name and `call_as` separated by commas (`,`). If you are importing a stack instance targeting OUs, see the example below. For example:

        ```sh
        $ pulumi import aws:cloudformation/stackInstances:StackInstances example example,SELF
        ```
        Using `pulumi import`, Import CloudFormation stack instances that target OUs, using the stack set name, `call_as`, and "OU" separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:cloudformation/stackInstances:StackInstances example example,SELF,OU
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] accounts: Accounts where you want to create stack instances in the specified `regions`. You can specify either `accounts` or `deployment_targets`, but not both.
        :param pulumi.Input[builtins.str] call_as: Whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        :param pulumi.Input[Union['StackInstancesDeploymentTargetsArgs', 'StackInstancesDeploymentTargetsArgsDict']] deployment_targets: AWS Organizations accounts for which to create stack instances in the `regions`. stack sets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for most of this argument. See deployment_targets below.
        :param pulumi.Input[Union['StackInstancesOperationPreferencesArgs', 'StackInstancesOperationPreferencesArgsDict']] operation_preferences: Preferences for how AWS CloudFormation performs a stack set operation. See operation_preferences below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameter_overrides: Key-value map of input parameters to override from the stack set for these instances. This argument's drift detection is limited to the first account and region since each instance can have unique parameters.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] regions: Regions where you want to create stack instances in the specified `accounts`.
        :param pulumi.Input[builtins.bool] retain_stacks: Whether to remove the stack instances from the stack set, but not delete the stacks. You can't reassociate a retained stack or add an existing, saved stack to a new stack set. To retain the stack, ensure `retain_stacks = true` has been successfully applied _before_ an apply that would destroy the resource. Defaults to `false`.
        :param pulumi.Input[builtins.str] stack_set_name: Name of the stack set.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StackInstancesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudformation.StackInstances("example",
            accounts=[
                "123456789012",
                "234567890123",
            ],
            regions=[
                "us-east-1",
                "us-west-2",
            ],
            stack_set_name=example_aws_cloudformation_stack_set["name"])
        ```

        ### Example IAM Setup in Target Account

        ```python
        import pulumi
        import pulumi_aws as aws

        a_ws_cloud_formation_stack_set_execution_role_assume_role_policy = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "effect": "Allow",
            "principals": [{
                "identifiers": [a_ws_cloud_formation_stack_set_administration_role["arn"]],
                "type": "AWS",
            }],
        }])
        a_ws_cloud_formation_stack_set_execution_role = aws.iam.Role("AWSCloudFormationStackSetExecutionRole",
            assume_role_policy=a_ws_cloud_formation_stack_set_execution_role_assume_role_policy.json,
            name="AWSCloudFormationStackSetExecutionRole")
        # Documentation: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html
        # Additional IAM permissions necessary depend on the resources defined in the StackSet template
        a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy = aws.iam.get_policy_document(statements=[{
            "actions": [
                "cloudformation:*",
                "s3:*",
                "sns:*",
            ],
            "effect": "Allow",
            "resources": ["*"],
        }])
        a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy_role_policy = aws.iam.RolePolicy("AWSCloudFormationStackSetExecutionRole_MinimumExecutionPolicy",
            name="MinimumExecutionPolicy",
            policy=a_ws_cloud_formation_stack_set_execution_role_minimum_execution_policy.json,
            role=a_ws_cloud_formation_stack_set_execution_role.name)
        ```

        ### Example Deployment across Organizations account

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudformation.StackInstances("example",
            deployment_targets={
                "organizational_unit_ids": [example_aws_organizations_organization["roots"][0]["id"]],
            },
            regions=[
                "us-west-2",
                "us-east-1",
            ],
            stack_set_name=example_aws_cloudformation_stack_set["name"])
        ```

        ## Import

        Import CloudFormation stack instances that target OUs, using the stack set name, `call_as`, and "OU" separated by commas (`,`). For example:

        Using `pulumi import`, import CloudFormation stack instances using the stack set name and `call_as` separated by commas (`,`). If you are importing a stack instance targeting OUs, see the example below. For example:

        ```sh
        $ pulumi import aws:cloudformation/stackInstances:StackInstances example example,SELF
        ```
        Using `pulumi import`, Import CloudFormation stack instances that target OUs, using the stack set name, `call_as`, and "OU" separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:cloudformation/stackInstances:StackInstances example example,SELF,OU
        ```

        :param str resource_name: The name of the resource.
        :param StackInstancesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackInstancesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 call_as: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_targets: Optional[pulumi.Input[Union['StackInstancesDeploymentTargetsArgs', 'StackInstancesDeploymentTargetsArgsDict']]] = None,
                 operation_preferences: Optional[pulumi.Input[Union['StackInstancesOperationPreferencesArgs', 'StackInstancesOperationPreferencesArgsDict']]] = None,
                 parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 retain_stacks: Optional[pulumi.Input[builtins.bool]] = None,
                 stack_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackInstancesArgs.__new__(StackInstancesArgs)

            __props__.__dict__["accounts"] = accounts
            __props__.__dict__["call_as"] = call_as
            __props__.__dict__["deployment_targets"] = deployment_targets
            __props__.__dict__["operation_preferences"] = operation_preferences
            __props__.__dict__["parameter_overrides"] = parameter_overrides
            __props__.__dict__["region"] = region
            __props__.__dict__["regions"] = regions
            __props__.__dict__["retain_stacks"] = retain_stacks
            if stack_set_name is None and not opts.urn:
                raise TypeError("Missing required property 'stack_set_name'")
            __props__.__dict__["stack_set_name"] = stack_set_name
            __props__.__dict__["stack_instance_summaries"] = None
            __props__.__dict__["stack_set_id"] = None
        super(StackInstances, __self__).__init__(
            'aws:cloudformation/stackInstances:StackInstances',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            call_as: Optional[pulumi.Input[builtins.str]] = None,
            deployment_targets: Optional[pulumi.Input[Union['StackInstancesDeploymentTargetsArgs', 'StackInstancesDeploymentTargetsArgsDict']]] = None,
            operation_preferences: Optional[pulumi.Input[Union['StackInstancesOperationPreferencesArgs', 'StackInstancesOperationPreferencesArgsDict']]] = None,
            parameter_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            retain_stacks: Optional[pulumi.Input[builtins.bool]] = None,
            stack_instance_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackInstancesStackInstanceSummaryArgs', 'StackInstancesStackInstanceSummaryArgsDict']]]]] = None,
            stack_set_id: Optional[pulumi.Input[builtins.str]] = None,
            stack_set_name: Optional[pulumi.Input[builtins.str]] = None) -> 'StackInstances':
        """
        Get an existing StackInstances resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] accounts: Accounts where you want to create stack instances in the specified `regions`. You can specify either `accounts` or `deployment_targets`, but not both.
        :param pulumi.Input[builtins.str] call_as: Whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        :param pulumi.Input[Union['StackInstancesDeploymentTargetsArgs', 'StackInstancesDeploymentTargetsArgsDict']] deployment_targets: AWS Organizations accounts for which to create stack instances in the `regions`. stack sets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for most of this argument. See deployment_targets below.
        :param pulumi.Input[Union['StackInstancesOperationPreferencesArgs', 'StackInstancesOperationPreferencesArgsDict']] operation_preferences: Preferences for how AWS CloudFormation performs a stack set operation. See operation_preferences below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameter_overrides: Key-value map of input parameters to override from the stack set for these instances. This argument's drift detection is limited to the first account and region since each instance can have unique parameters.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] regions: Regions where you want to create stack instances in the specified `accounts`.
        :param pulumi.Input[builtins.bool] retain_stacks: Whether to remove the stack instances from the stack set, but not delete the stacks. You can't reassociate a retained stack or add an existing, saved stack to a new stack set. To retain the stack, ensure `retain_stacks = true` has been successfully applied _before_ an apply that would destroy the resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackInstancesStackInstanceSummaryArgs', 'StackInstancesStackInstanceSummaryArgsDict']]]] stack_instance_summaries: List of stack instances created from an organizational unit deployment target. This may not always be set depending on whether CloudFormation returns summaries for your configuration. See `stack_instance_summaries`.
        :param pulumi.Input[builtins.str] stack_set_id: Name or unique ID of the stack set that the stack instance is associated with.
        :param pulumi.Input[builtins.str] stack_set_name: Name of the stack set.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackInstancesState.__new__(_StackInstancesState)

        __props__.__dict__["accounts"] = accounts
        __props__.__dict__["call_as"] = call_as
        __props__.__dict__["deployment_targets"] = deployment_targets
        __props__.__dict__["operation_preferences"] = operation_preferences
        __props__.__dict__["parameter_overrides"] = parameter_overrides
        __props__.__dict__["region"] = region
        __props__.__dict__["regions"] = regions
        __props__.__dict__["retain_stacks"] = retain_stacks
        __props__.__dict__["stack_instance_summaries"] = stack_instance_summaries
        __props__.__dict__["stack_set_id"] = stack_set_id
        __props__.__dict__["stack_set_name"] = stack_set_name
        return StackInstances(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accounts(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Accounts where you want to create stack instances in the specified `regions`. You can specify either `accounts` or `deployment_targets`, but not both.
        """
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter(name="callAs")
    def call_as(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
        """
        return pulumi.get(self, "call_as")

    @property
    @pulumi.getter(name="deploymentTargets")
    def deployment_targets(self) -> pulumi.Output[Optional['outputs.StackInstancesDeploymentTargets']]:
        """
        AWS Organizations accounts for which to create stack instances in the `regions`. stack sets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for most of this argument. See deployment_targets below.
        """
        return pulumi.get(self, "deployment_targets")

    @property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> pulumi.Output[Optional['outputs.StackInstancesOperationPreferences']]:
        """
        Preferences for how AWS CloudFormation performs a stack set operation. See operation_preferences below.
        """
        return pulumi.get(self, "operation_preferences")

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of input parameters to override from the stack set for these instances. This argument's drift detection is limited to the first account and region since each instance can have unique parameters.
        """
        return pulumi.get(self, "parameter_overrides")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Regions where you want to create stack instances in the specified `accounts`.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="retainStacks")
    def retain_stacks(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to remove the stack instances from the stack set, but not delete the stacks. You can't reassociate a retained stack or add an existing, saved stack to a new stack set. To retain the stack, ensure `retain_stacks = true` has been successfully applied _before_ an apply that would destroy the resource. Defaults to `false`.
        """
        return pulumi.get(self, "retain_stacks")

    @property
    @pulumi.getter(name="stackInstanceSummaries")
    def stack_instance_summaries(self) -> pulumi.Output[Sequence['outputs.StackInstancesStackInstanceSummary']]:
        """
        List of stack instances created from an organizational unit deployment target. This may not always be set depending on whether CloudFormation returns summaries for your configuration. See `stack_instance_summaries`.
        """
        return pulumi.get(self, "stack_instance_summaries")

    @property
    @pulumi.getter(name="stackSetId")
    def stack_set_id(self) -> pulumi.Output[builtins.str]:
        """
        Name or unique ID of the stack set that the stack instance is associated with.
        """
        return pulumi.get(self, "stack_set_id")

    @property
    @pulumi.getter(name="stackSetName")
    def stack_set_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the stack set.

        The following arguments are optional:
        """
        return pulumi.get(self, "stack_set_name")

