# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContinuousDeploymentPolicyArgs', 'ContinuousDeploymentPolicy']

@pulumi.input_type
class ContinuousDeploymentPolicyArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 staging_distribution_dns_names: Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']] = None,
                 traffic_config: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']] = None):
        """
        The set of arguments for constructing a ContinuousDeploymentPolicy resource.
        :param pulumi.Input[builtins.bool] enabled: Whether this continuous deployment policy is enabled.
        :param pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs'] staging_distribution_dns_names: CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        :param pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs'] traffic_config: Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if staging_distribution_dns_names is not None:
            pulumi.set(__self__, "staging_distribution_dns_names", staging_distribution_dns_names)
        if traffic_config is not None:
            pulumi.set(__self__, "traffic_config", traffic_config)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Whether this continuous deployment policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="stagingDistributionDnsNames")
    def staging_distribution_dns_names(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]:
        """
        CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        """
        return pulumi.get(self, "staging_distribution_dns_names")

    @staging_distribution_dns_names.setter
    def staging_distribution_dns_names(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]):
        pulumi.set(self, "staging_distribution_dns_names", value)

    @property
    @pulumi.getter(name="trafficConfig")
    def traffic_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]:
        """
        Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        return pulumi.get(self, "traffic_config")

    @traffic_config.setter
    def traffic_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]):
        pulumi.set(self, "traffic_config", value)


@pulumi.input_type
class _ContinuousDeploymentPolicyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[builtins.str]] = None,
                 staging_distribution_dns_names: Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']] = None,
                 traffic_config: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']] = None):
        """
        Input properties used for looking up and filtering ContinuousDeploymentPolicy resources.
        :param pulumi.Input[builtins.str] arn: The continuous deployment policy ARN.
        :param pulumi.Input[builtins.bool] enabled: Whether this continuous deployment policy is enabled.
        :param pulumi.Input[builtins.str] etag: Current version of the continuous distribution policy.
        :param pulumi.Input[builtins.str] last_modified_time: Date and time the continuous deployment policy was last modified.
        :param pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs'] staging_distribution_dns_names: CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        :param pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs'] traffic_config: Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if staging_distribution_dns_names is not None:
            pulumi.set(__self__, "staging_distribution_dns_names", staging_distribution_dns_names)
        if traffic_config is not None:
            pulumi.set(__self__, "traffic_config", traffic_config)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The continuous deployment policy ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this continuous deployment policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current version of the continuous distribution policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time the continuous deployment policy was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @property
    @pulumi.getter(name="stagingDistributionDnsNames")
    def staging_distribution_dns_names(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]:
        """
        CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        """
        return pulumi.get(self, "staging_distribution_dns_names")

    @staging_distribution_dns_names.setter
    def staging_distribution_dns_names(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]):
        pulumi.set(self, "staging_distribution_dns_names", value)

    @property
    @pulumi.getter(name="trafficConfig")
    def traffic_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]:
        """
        Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        return pulumi.get(self, "traffic_config")

    @traffic_config.setter
    def traffic_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]):
        pulumi.set(self, "traffic_config", value)


@pulumi.type_token("aws:cloudfront/continuousDeploymentPolicy:ContinuousDeploymentPolicy")
class ContinuousDeploymentPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 staging_distribution_dns_names: Optional[pulumi.Input[Union['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs', 'ContinuousDeploymentPolicyStagingDistributionDnsNamesArgsDict']]] = None,
                 traffic_config: Optional[pulumi.Input[Union['ContinuousDeploymentPolicyTrafficConfigArgs', 'ContinuousDeploymentPolicyTrafficConfigArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CloudFront Continuous Deployment Policy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        staging = aws.cloudfront.Distribution("staging",
            enabled=True,
            staging=True)
        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names={
                "items": [staging.domain_name],
                "quantity": 1,
            },
            traffic_config={
                "type": "SingleWeight",
                "single_weight_config": {
                    "weight": 0.01,
                },
            })
        production = aws.cloudfront.Distribution("production",
            enabled=True,
            continuous_deployment_policy_id=example.id)
        ```

        ### Single Weight Config with Session Stickiness

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names={
                "items": [staging["domainName"]],
                "quantity": 1,
            },
            traffic_config={
                "type": "SingleWeight",
                "single_weight_config": {
                    "weight": 0.01,
                    "session_stickiness_config": {
                        "idle_ttl": 300,
                        "maximum_ttl": 600,
                    },
                },
            })
        ```

        ### Single Header Config

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names={
                "items": [staging["domainName"]],
                "quantity": 1,
            },
            traffic_config={
                "type": "SingleHeader",
                "single_header_config": {
                    "header": "aws-cf-cd-example",
                    "value": "example",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import CloudFront Continuous Deployment Policy using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/continuousDeploymentPolicy:ContinuousDeploymentPolicy example abcd-1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Whether this continuous deployment policy is enabled.
        :param pulumi.Input[Union['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs', 'ContinuousDeploymentPolicyStagingDistributionDnsNamesArgsDict']] staging_distribution_dns_names: CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        :param pulumi.Input[Union['ContinuousDeploymentPolicyTrafficConfigArgs', 'ContinuousDeploymentPolicyTrafficConfigArgsDict']] traffic_config: Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContinuousDeploymentPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CloudFront Continuous Deployment Policy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        staging = aws.cloudfront.Distribution("staging",
            enabled=True,
            staging=True)
        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names={
                "items": [staging.domain_name],
                "quantity": 1,
            },
            traffic_config={
                "type": "SingleWeight",
                "single_weight_config": {
                    "weight": 0.01,
                },
            })
        production = aws.cloudfront.Distribution("production",
            enabled=True,
            continuous_deployment_policy_id=example.id)
        ```

        ### Single Weight Config with Session Stickiness

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names={
                "items": [staging["domainName"]],
                "quantity": 1,
            },
            traffic_config={
                "type": "SingleWeight",
                "single_weight_config": {
                    "weight": 0.01,
                    "session_stickiness_config": {
                        "idle_ttl": 300,
                        "maximum_ttl": 600,
                    },
                },
            })
        ```

        ### Single Header Config

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names={
                "items": [staging["domainName"]],
                "quantity": 1,
            },
            traffic_config={
                "type": "SingleHeader",
                "single_header_config": {
                    "header": "aws-cf-cd-example",
                    "value": "example",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import CloudFront Continuous Deployment Policy using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/continuousDeploymentPolicy:ContinuousDeploymentPolicy example abcd-1234
        ```

        :param str resource_name: The name of the resource.
        :param ContinuousDeploymentPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContinuousDeploymentPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 staging_distribution_dns_names: Optional[pulumi.Input[Union['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs', 'ContinuousDeploymentPolicyStagingDistributionDnsNamesArgsDict']]] = None,
                 traffic_config: Optional[pulumi.Input[Union['ContinuousDeploymentPolicyTrafficConfigArgs', 'ContinuousDeploymentPolicyTrafficConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContinuousDeploymentPolicyArgs.__new__(ContinuousDeploymentPolicyArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["staging_distribution_dns_names"] = staging_distribution_dns_names
            __props__.__dict__["traffic_config"] = traffic_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["last_modified_time"] = None
        super(ContinuousDeploymentPolicy, __self__).__init__(
            'aws:cloudfront/continuousDeploymentPolicy:ContinuousDeploymentPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            last_modified_time: Optional[pulumi.Input[builtins.str]] = None,
            staging_distribution_dns_names: Optional[pulumi.Input[Union['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs', 'ContinuousDeploymentPolicyStagingDistributionDnsNamesArgsDict']]] = None,
            traffic_config: Optional[pulumi.Input[Union['ContinuousDeploymentPolicyTrafficConfigArgs', 'ContinuousDeploymentPolicyTrafficConfigArgsDict']]] = None) -> 'ContinuousDeploymentPolicy':
        """
        Get an existing ContinuousDeploymentPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The continuous deployment policy ARN.
        :param pulumi.Input[builtins.bool] enabled: Whether this continuous deployment policy is enabled.
        :param pulumi.Input[builtins.str] etag: Current version of the continuous distribution policy.
        :param pulumi.Input[builtins.str] last_modified_time: Date and time the continuous deployment policy was last modified.
        :param pulumi.Input[Union['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs', 'ContinuousDeploymentPolicyStagingDistributionDnsNamesArgsDict']] staging_distribution_dns_names: CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        :param pulumi.Input[Union['ContinuousDeploymentPolicyTrafficConfigArgs', 'ContinuousDeploymentPolicyTrafficConfigArgsDict']] traffic_config: Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContinuousDeploymentPolicyState.__new__(_ContinuousDeploymentPolicyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["etag"] = etag
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["staging_distribution_dns_names"] = staging_distribution_dns_names
        __props__.__dict__["traffic_config"] = traffic_config
        return ContinuousDeploymentPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The continuous deployment policy ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether this continuous deployment policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Current version of the continuous distribution policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.str]:
        """
        Date and time the continuous deployment policy was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="stagingDistributionDnsNames")
    def staging_distribution_dns_names(self) -> pulumi.Output[Optional['outputs.ContinuousDeploymentPolicyStagingDistributionDnsNames']]:
        """
        CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        """
        return pulumi.get(self, "staging_distribution_dns_names")

    @property
    @pulumi.getter(name="trafficConfig")
    def traffic_config(self) -> pulumi.Output[Optional['outputs.ContinuousDeploymentPolicyTrafficConfig']]:
        """
        Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        return pulumi.get(self, "traffic_config")

