# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCachePolicyResult',
    'AwaitableGetCachePolicyResult',
    'get_cache_policy',
    'get_cache_policy_output',
]

@pulumi.output_type
class GetCachePolicyResult:
    """
    A collection of values returned by getCachePolicy.
    """
    def __init__(__self__, arn=None, comment=None, default_ttl=None, etag=None, id=None, max_ttl=None, min_ttl=None, name=None, parameters_in_cache_key_and_forwarded_to_origins=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if default_ttl and not isinstance(default_ttl, int):
            raise TypeError("Expected argument 'default_ttl' to be a int")
        pulumi.set(__self__, "default_ttl", default_ttl)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_ttl and not isinstance(max_ttl, int):
            raise TypeError("Expected argument 'max_ttl' to be a int")
        pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl and not isinstance(min_ttl, int):
            raise TypeError("Expected argument 'min_ttl' to be a int")
        pulumi.set(__self__, "min_ttl", min_ttl)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameters_in_cache_key_and_forwarded_to_origins and not isinstance(parameters_in_cache_key_and_forwarded_to_origins, list):
            raise TypeError("Expected argument 'parameters_in_cache_key_and_forwarded_to_origins' to be a list")
        pulumi.set(__self__, "parameters_in_cache_key_and_forwarded_to_origins", parameters_in_cache_key_and_forwarded_to_origins)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The cache policy ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def comment(self) -> builtins.str:
        """
        Comment to describe the cache policy.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> builtins.int:
        """
        Default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        Current version of the cache policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> builtins.int:
        """
        Maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> builtins.int:
        """
        Minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
        """
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parametersInCacheKeyAndForwardedToOrigins")
    def parameters_in_cache_key_and_forwarded_to_origins(self) -> Sequence['outputs.GetCachePolicyParametersInCacheKeyAndForwardedToOriginResult']:
        """
        The HTTP headers, cookies, and URL query strings to include in the cache key. See Parameters In Cache Key And Forwarded To Origin for more information.
        """
        return pulumi.get(self, "parameters_in_cache_key_and_forwarded_to_origins")


class AwaitableGetCachePolicyResult(GetCachePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCachePolicyResult(
            arn=self.arn,
            comment=self.comment,
            default_ttl=self.default_ttl,
            etag=self.etag,
            id=self.id,
            max_ttl=self.max_ttl,
            min_ttl=self.min_ttl,
            name=self.name,
            parameters_in_cache_key_and_forwarded_to_origins=self.parameters_in_cache_key_and_forwarded_to_origins)


def get_cache_policy(id: Optional[builtins.str] = None,
                     name: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCachePolicyResult:
    """
    Use this data source to retrieve information about a CloudFront cache policy.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudfront.get_cache_policy(name="example-policy")
    ```

    ### AWS-Managed Policies

    AWS managed cache policy names are prefixed with `Managed-`, except for `UseOriginCacheControlHeaders` and `UseOriginCacheControlHeaders-QueryStrings`:

    ```python
    import pulumi
    import pulumi_aws as aws

    example1 = aws.cloudfront.get_cache_policy(name="Managed-CachingOptimized")
    example2 = aws.cloudfront.get_cache_policy(name="UseOriginCacheControlHeaders")
    ```


    :param builtins.str id: Identifier for the cache policy.
    :param builtins.str name: Unique name to identify the cache policy.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudfront/getCachePolicy:getCachePolicy', __args__, opts=opts, typ=GetCachePolicyResult).value

    return AwaitableGetCachePolicyResult(
        arn=pulumi.get(__ret__, 'arn'),
        comment=pulumi.get(__ret__, 'comment'),
        default_ttl=pulumi.get(__ret__, 'default_ttl'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        max_ttl=pulumi.get(__ret__, 'max_ttl'),
        min_ttl=pulumi.get(__ret__, 'min_ttl'),
        name=pulumi.get(__ret__, 'name'),
        parameters_in_cache_key_and_forwarded_to_origins=pulumi.get(__ret__, 'parameters_in_cache_key_and_forwarded_to_origins'))
def get_cache_policy_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCachePolicyResult]:
    """
    Use this data source to retrieve information about a CloudFront cache policy.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudfront.get_cache_policy(name="example-policy")
    ```

    ### AWS-Managed Policies

    AWS managed cache policy names are prefixed with `Managed-`, except for `UseOriginCacheControlHeaders` and `UseOriginCacheControlHeaders-QueryStrings`:

    ```python
    import pulumi
    import pulumi_aws as aws

    example1 = aws.cloudfront.get_cache_policy(name="Managed-CachingOptimized")
    example2 = aws.cloudfront.get_cache_policy(name="UseOriginCacheControlHeaders")
    ```


    :param builtins.str id: Identifier for the cache policy.
    :param builtins.str name: Unique name to identify the cache policy.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudfront/getCachePolicy:getCachePolicy', __args__, opts=opts, typ=GetCachePolicyResult)
    return __ret__.apply(lambda __response__: GetCachePolicyResult(
        arn=pulumi.get(__response__, 'arn'),
        comment=pulumi.get(__response__, 'comment'),
        default_ttl=pulumi.get(__response__, 'default_ttl'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        max_ttl=pulumi.get(__response__, 'max_ttl'),
        min_ttl=pulumi.get(__response__, 'min_ttl'),
        name=pulumi.get(__response__, 'name'),
        parameters_in_cache_key_and_forwarded_to_origins=pulumi.get(__response__, 'parameters_in_cache_key_and_forwarded_to_origins')))
