# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLogDeliveryCanonicalUserIdResult',
    'AwaitableGetLogDeliveryCanonicalUserIdResult',
    'get_log_delivery_canonical_user_id',
    'get_log_delivery_canonical_user_id_output',
]

@pulumi.output_type
class GetLogDeliveryCanonicalUserIdResult:
    """
    A collection of values returned by getLogDeliveryCanonicalUserId.
    """
    def __init__(__self__, id=None, region=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")


class AwaitableGetLogDeliveryCanonicalUserIdResult(GetLogDeliveryCanonicalUserIdResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogDeliveryCanonicalUserIdResult(
            id=self.id,
            region=self.region)


def get_log_delivery_canonical_user_id(region: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogDeliveryCanonicalUserIdResult:
    """
    The CloudFront Log Delivery Canonical User ID data source allows access to the [canonical user ID](http://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html) of the AWS `awslogsdelivery` account for CloudFront bucket logging.
    See the [Amazon CloudFront Developer Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) for more information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.s3.get_canonical_user_id()
    example = aws.cloudfront.get_log_delivery_canonical_user_id()
    example_bucket = aws.s3.Bucket("example", bucket="example")
    example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
        bucket=example_bucket.id,
        rule={
            "object_ownership": "BucketOwnerPreferred",
        })
    example_bucket_acl = aws.s3.BucketAcl("example",
        bucket=example_bucket.id,
        access_control_policy={
            "grants": [{
                "grantee": {
                    "id": example.id,
                    "type": "CanonicalUser",
                },
                "permission": "FULL_CONTROL",
            }],
            "owner": {
                "id": current.id,
            },
        },
        opts = pulumi.ResourceOptions(depends_on=[example_bucket_ownership_controls]))
    ```


    :param builtins.str region: Name of the Region whose canonical user ID is desired. Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudfront/getLogDeliveryCanonicalUserId:getLogDeliveryCanonicalUserId', __args__, opts=opts, typ=GetLogDeliveryCanonicalUserIdResult).value

    return AwaitableGetLogDeliveryCanonicalUserIdResult(
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_log_delivery_canonical_user_id_output(region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogDeliveryCanonicalUserIdResult]:
    """
    The CloudFront Log Delivery Canonical User ID data source allows access to the [canonical user ID](http://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html) of the AWS `awslogsdelivery` account for CloudFront bucket logging.
    See the [Amazon CloudFront Developer Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) for more information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.s3.get_canonical_user_id()
    example = aws.cloudfront.get_log_delivery_canonical_user_id()
    example_bucket = aws.s3.Bucket("example", bucket="example")
    example_bucket_ownership_controls = aws.s3.BucketOwnershipControls("example",
        bucket=example_bucket.id,
        rule={
            "object_ownership": "BucketOwnerPreferred",
        })
    example_bucket_acl = aws.s3.BucketAcl("example",
        bucket=example_bucket.id,
        access_control_policy={
            "grants": [{
                "grantee": {
                    "id": example.id,
                    "type": "CanonicalUser",
                },
                "permission": "FULL_CONTROL",
            }],
            "owner": {
                "id": current.id,
            },
        },
        opts = pulumi.ResourceOptions(depends_on=[example_bucket_ownership_controls]))
    ```


    :param builtins.str region: Name of the Region whose canonical user ID is desired. Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudfront/getLogDeliveryCanonicalUserId:getLogDeliveryCanonicalUserId', __args__, opts=opts, typ=GetLogDeliveryCanonicalUserIdResult)
    return __ret__.apply(lambda __response__: GetLogDeliveryCanonicalUserIdResult(
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
