# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeyvaluestoreKeyArgs', 'KeyvaluestoreKey']

@pulumi.input_type
class KeyvaluestoreKeyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 key_value_store_arn: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a KeyvaluestoreKey resource.
        :param pulumi.Input[builtins.str] key: Key to put.
        :param pulumi.Input[builtins.str] key_value_store_arn: Amazon Resource Name (ARN) of the Key Value Store.
        :param pulumi.Input[builtins.str] value: Value to put.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "key_value_store_arn", key_value_store_arn)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        Key to put.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="keyValueStoreArn")
    def key_value_store_arn(self) -> pulumi.Input[builtins.str]:
        """
        Amazon Resource Name (ARN) of the Key Value Store.
        """
        return pulumi.get(self, "key_value_store_arn")

    @key_value_store_arn.setter
    def key_value_store_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_value_store_arn", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Value to put.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _KeyvaluestoreKeyState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 key_value_store_arn: Optional[pulumi.Input[builtins.str]] = None,
                 total_size_in_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeyvaluestoreKey resources.
        :param pulumi.Input[builtins.str] key: Key to put.
        :param pulumi.Input[builtins.str] key_value_store_arn: Amazon Resource Name (ARN) of the Key Value Store.
        :param pulumi.Input[builtins.int] total_size_in_bytes: Total size of the Key Value Store in bytes.
        :param pulumi.Input[builtins.str] value: Value to put.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if key_value_store_arn is not None:
            pulumi.set(__self__, "key_value_store_arn", key_value_store_arn)
        if total_size_in_bytes is not None:
            pulumi.set(__self__, "total_size_in_bytes", total_size_in_bytes)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key to put.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="keyValueStoreArn")
    def key_value_store_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the Key Value Store.
        """
        return pulumi.get(self, "key_value_store_arn")

    @key_value_store_arn.setter
    def key_value_store_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_value_store_arn", value)

    @property
    @pulumi.getter(name="totalSizeInBytes")
    def total_size_in_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total size of the Key Value Store in bytes.
        """
        return pulumi.get(self, "total_size_in_bytes")

    @total_size_in_bytes.setter
    def total_size_in_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_size_in_bytes", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value to put.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("aws:cloudfront/keyvaluestoreKey:KeyvaluestoreKey")
class KeyvaluestoreKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 key_value_store_arn: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.KeyValueStore("example",
            name="ExampleKeyValueStore",
            comment="This is an example key value store")
        example_keyvaluestore_key = aws.cloudfront.KeyvaluestoreKey("example",
            key_value_store_arn=example.arn,
            key="Test Key",
            value="Test Value")
        ```

        ## Import

        Using `pulumi import`, import CloudFront KeyValueStore Key using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/keyvaluestoreKey:KeyvaluestoreKey example arn:aws:cloudfront::111111111111:key-value-store/8562g61f-caba-2845-9d99-b97diwae5d3c,someKey
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] key: Key to put.
        :param pulumi.Input[builtins.str] key_value_store_arn: Amazon Resource Name (ARN) of the Key Value Store.
        :param pulumi.Input[builtins.str] value: Value to put.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyvaluestoreKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.KeyValueStore("example",
            name="ExampleKeyValueStore",
            comment="This is an example key value store")
        example_keyvaluestore_key = aws.cloudfront.KeyvaluestoreKey("example",
            key_value_store_arn=example.arn,
            key="Test Key",
            value="Test Value")
        ```

        ## Import

        Using `pulumi import`, import CloudFront KeyValueStore Key using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/keyvaluestoreKey:KeyvaluestoreKey example arn:aws:cloudfront::111111111111:key-value-store/8562g61f-caba-2845-9d99-b97diwae5d3c,someKey
        ```

        :param str resource_name: The name of the resource.
        :param KeyvaluestoreKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyvaluestoreKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 key_value_store_arn: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyvaluestoreKeyArgs.__new__(KeyvaluestoreKeyArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if key_value_store_arn is None and not opts.urn:
                raise TypeError("Missing required property 'key_value_store_arn'")
            __props__.__dict__["key_value_store_arn"] = key_value_store_arn
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["total_size_in_bytes"] = None
        super(KeyvaluestoreKey, __self__).__init__(
            'aws:cloudfront/keyvaluestoreKey:KeyvaluestoreKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            key_value_store_arn: Optional[pulumi.Input[builtins.str]] = None,
            total_size_in_bytes: Optional[pulumi.Input[builtins.int]] = None,
            value: Optional[pulumi.Input[builtins.str]] = None) -> 'KeyvaluestoreKey':
        """
        Get an existing KeyvaluestoreKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] key: Key to put.
        :param pulumi.Input[builtins.str] key_value_store_arn: Amazon Resource Name (ARN) of the Key Value Store.
        :param pulumi.Input[builtins.int] total_size_in_bytes: Total size of the Key Value Store in bytes.
        :param pulumi.Input[builtins.str] value: Value to put.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyvaluestoreKeyState.__new__(_KeyvaluestoreKeyState)

        __props__.__dict__["key"] = key
        __props__.__dict__["key_value_store_arn"] = key_value_store_arn
        __props__.__dict__["total_size_in_bytes"] = total_size_in_bytes
        __props__.__dict__["value"] = value
        return KeyvaluestoreKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        Key to put.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="keyValueStoreArn")
    def key_value_store_arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the Key Value Store.
        """
        return pulumi.get(self, "key_value_store_arn")

    @property
    @pulumi.getter(name="totalSizeInBytes")
    def total_size_in_bytes(self) -> pulumi.Output[builtins.int]:
        """
        Total size of the Key Value Store in bytes.
        """
        return pulumi.get(self, "total_size_in_bytes")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[builtins.str]:
        """
        Value to put.
        """
        return pulumi.get(self, "value")

