# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PublicKeyArgs', 'PublicKey']

@pulumi.input_type
class PublicKeyArgs:
    def __init__(__self__, *,
                 encoded_key: pulumi.Input[builtins.str],
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PublicKey resource.
        :param pulumi.Input[builtins.str] encoded_key: The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
        :param pulumi.Input[builtins.str] comment: An optional comment about the public key.
        :param pulumi.Input[builtins.str] name: The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
        :param pulumi.Input[builtins.str] name_prefix: The name for the public key. Conflicts with `name`.
               
               **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `cloudfront.PublicKey` resource.
        """
        pulumi.set(__self__, "encoded_key", encoded_key)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)

    @property
    @pulumi.getter(name="encodedKey")
    def encoded_key(self) -> pulumi.Input[builtins.str]:
        """
        The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
        """
        return pulumi.get(self, "encoded_key")

    @encoded_key.setter
    def encoded_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "encoded_key", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional comment about the public key.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the public key. Conflicts with `name`.

        **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `cloudfront.PublicKey` resource.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)


@pulumi.input_type
class _PublicKeyState:
    def __init__(__self__, *,
                 caller_reference: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 encoded_key: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PublicKey resources.
        :param pulumi.Input[builtins.str] caller_reference: Internal value used by CloudFront to allow future updates to the public key configuration.
        :param pulumi.Input[builtins.str] comment: An optional comment about the public key.
        :param pulumi.Input[builtins.str] encoded_key: The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
        :param pulumi.Input[builtins.str] etag: The current version of the public key. For example: `E2QWRUHAPOMQZL`.
        :param pulumi.Input[builtins.str] name: The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
        :param pulumi.Input[builtins.str] name_prefix: The name for the public key. Conflicts with `name`.
               
               **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `cloudfront.PublicKey` resource.
        """
        if caller_reference is not None:
            pulumi.set(__self__, "caller_reference", caller_reference)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if encoded_key is not None:
            pulumi.set(__self__, "encoded_key", encoded_key)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Internal value used by CloudFront to allow future updates to the public key configuration.
        """
        return pulumi.get(self, "caller_reference")

    @caller_reference.setter
    def caller_reference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "caller_reference", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional comment about the public key.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="encodedKey")
    def encoded_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
        """
        return pulumi.get(self, "encoded_key")

    @encoded_key.setter
    def encoded_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encoded_key", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current version of the public key. For example: `E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the public key. Conflicts with `name`.

        **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `cloudfront.PublicKey` resource.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)


@pulumi.type_token("aws:cloudfront/publicKey:PublicKey")
class PublicKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 encoded_key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        The following example below creates a CloudFront public key.

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.cloudfront.PublicKey("example",
            comment="test public key",
            encoded_key=std.file(input="public_key.pem").result,
            name="test_key")
        ```

        ## Import

        Using `pulumi import`, import CloudFront Public Key using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/publicKey:PublicKey example K3D5EWEUDCCXON
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] comment: An optional comment about the public key.
        :param pulumi.Input[builtins.str] encoded_key: The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
        :param pulumi.Input[builtins.str] name: The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
        :param pulumi.Input[builtins.str] name_prefix: The name for the public key. Conflicts with `name`.
               
               **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `cloudfront.PublicKey` resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublicKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        The following example below creates a CloudFront public key.

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.cloudfront.PublicKey("example",
            comment="test public key",
            encoded_key=std.file(input="public_key.pem").result,
            name="test_key")
        ```

        ## Import

        Using `pulumi import`, import CloudFront Public Key using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/publicKey:PublicKey example K3D5EWEUDCCXON
        ```

        :param str resource_name: The name of the resource.
        :param PublicKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 encoded_key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicKeyArgs.__new__(PublicKeyArgs)

            __props__.__dict__["comment"] = comment
            if encoded_key is None and not opts.urn:
                raise TypeError("Missing required property 'encoded_key'")
            __props__.__dict__["encoded_key"] = encoded_key
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["caller_reference"] = None
            __props__.__dict__["etag"] = None
        super(PublicKey, __self__).__init__(
            'aws:cloudfront/publicKey:PublicKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            caller_reference: Optional[pulumi.Input[builtins.str]] = None,
            comment: Optional[pulumi.Input[builtins.str]] = None,
            encoded_key: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[builtins.str]] = None) -> 'PublicKey':
        """
        Get an existing PublicKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] caller_reference: Internal value used by CloudFront to allow future updates to the public key configuration.
        :param pulumi.Input[builtins.str] comment: An optional comment about the public key.
        :param pulumi.Input[builtins.str] encoded_key: The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
        :param pulumi.Input[builtins.str] etag: The current version of the public key. For example: `E2QWRUHAPOMQZL`.
        :param pulumi.Input[builtins.str] name: The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
        :param pulumi.Input[builtins.str] name_prefix: The name for the public key. Conflicts with `name`.
               
               **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `cloudfront.PublicKey` resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicKeyState.__new__(_PublicKeyState)

        __props__.__dict__["caller_reference"] = caller_reference
        __props__.__dict__["comment"] = comment
        __props__.__dict__["encoded_key"] = encoded_key
        __props__.__dict__["etag"] = etag
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        return PublicKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> pulumi.Output[builtins.str]:
        """
        Internal value used by CloudFront to allow future updates to the public key configuration.
        """
        return pulumi.get(self, "caller_reference")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional comment about the public key.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="encodedKey")
    def encoded_key(self) -> pulumi.Output[builtins.str]:
        """
        The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
        """
        return pulumi.get(self, "encoded_key")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        The current version of the public key. For example: `E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[builtins.str]:
        """
        The name for the public key. Conflicts with `name`.

        **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `cloudfront.PublicKey` resource.
        """
        return pulumi.get(self, "name_prefix")

