# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterClusterCertificate',
    'GetClusterClusterCertificateResult',
]

@pulumi.output_type
class ClusterClusterCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsHardwareCertificate":
            suggest = "aws_hardware_certificate"
        elif key == "clusterCertificate":
            suggest = "cluster_certificate"
        elif key == "clusterCsr":
            suggest = "cluster_csr"
        elif key == "hsmCertificate":
            suggest = "hsm_certificate"
        elif key == "manufacturerHardwareCertificate":
            suggest = "manufacturer_hardware_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_hardware_certificate: Optional[builtins.str] = None,
                 cluster_certificate: Optional[builtins.str] = None,
                 cluster_csr: Optional[builtins.str] = None,
                 hsm_certificate: Optional[builtins.str] = None,
                 manufacturer_hardware_certificate: Optional[builtins.str] = None):
        """
        :param builtins.str aws_hardware_certificate: The HSM hardware certificate issued (signed) by AWS CloudHSM.
        :param builtins.str cluster_certificate: The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
        :param builtins.str cluster_csr: The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
        :param builtins.str hsm_certificate: The HSM certificate issued (signed) by the HSM hardware.
        :param builtins.str manufacturer_hardware_certificate: The HSM hardware certificate issued (signed) by the hardware manufacturer.
        """
        if aws_hardware_certificate is not None:
            pulumi.set(__self__, "aws_hardware_certificate", aws_hardware_certificate)
        if cluster_certificate is not None:
            pulumi.set(__self__, "cluster_certificate", cluster_certificate)
        if cluster_csr is not None:
            pulumi.set(__self__, "cluster_csr", cluster_csr)
        if hsm_certificate is not None:
            pulumi.set(__self__, "hsm_certificate", hsm_certificate)
        if manufacturer_hardware_certificate is not None:
            pulumi.set(__self__, "manufacturer_hardware_certificate", manufacturer_hardware_certificate)

    @property
    @pulumi.getter(name="awsHardwareCertificate")
    def aws_hardware_certificate(self) -> Optional[builtins.str]:
        """
        The HSM hardware certificate issued (signed) by AWS CloudHSM.
        """
        return pulumi.get(self, "aws_hardware_certificate")

    @property
    @pulumi.getter(name="clusterCertificate")
    def cluster_certificate(self) -> Optional[builtins.str]:
        """
        The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
        """
        return pulumi.get(self, "cluster_certificate")

    @property
    @pulumi.getter(name="clusterCsr")
    def cluster_csr(self) -> Optional[builtins.str]:
        """
        The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
        """
        return pulumi.get(self, "cluster_csr")

    @property
    @pulumi.getter(name="hsmCertificate")
    def hsm_certificate(self) -> Optional[builtins.str]:
        """
        The HSM certificate issued (signed) by the HSM hardware.
        """
        return pulumi.get(self, "hsm_certificate")

    @property
    @pulumi.getter(name="manufacturerHardwareCertificate")
    def manufacturer_hardware_certificate(self) -> Optional[builtins.str]:
        """
        The HSM hardware certificate issued (signed) by the hardware manufacturer.
        """
        return pulumi.get(self, "manufacturer_hardware_certificate")


@pulumi.output_type
class GetClusterClusterCertificateResult(dict):
    def __init__(__self__, *,
                 aws_hardware_certificate: builtins.str,
                 cluster_certificate: builtins.str,
                 cluster_csr: builtins.str,
                 hsm_certificate: builtins.str,
                 manufacturer_hardware_certificate: builtins.str):
        """
        :param builtins.str aws_hardware_certificate: The HSM hardware certificate issued (signed) by AWS CloudHSM.
        :param builtins.str cluster_certificate: The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
        :param builtins.str cluster_csr: The certificate signing request (CSR). Available only in UNINITIALIZED state.
        :param builtins.str hsm_certificate: The HSM certificate issued (signed) by the HSM hardware.
        :param builtins.str manufacturer_hardware_certificate: The HSM hardware certificate issued (signed) by the hardware manufacturer.
               The number of available cluster certificates may vary depending on state of the cluster.
        """
        pulumi.set(__self__, "aws_hardware_certificate", aws_hardware_certificate)
        pulumi.set(__self__, "cluster_certificate", cluster_certificate)
        pulumi.set(__self__, "cluster_csr", cluster_csr)
        pulumi.set(__self__, "hsm_certificate", hsm_certificate)
        pulumi.set(__self__, "manufacturer_hardware_certificate", manufacturer_hardware_certificate)

    @property
    @pulumi.getter(name="awsHardwareCertificate")
    def aws_hardware_certificate(self) -> builtins.str:
        """
        The HSM hardware certificate issued (signed) by AWS CloudHSM.
        """
        return pulumi.get(self, "aws_hardware_certificate")

    @property
    @pulumi.getter(name="clusterCertificate")
    def cluster_certificate(self) -> builtins.str:
        """
        The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
        """
        return pulumi.get(self, "cluster_certificate")

    @property
    @pulumi.getter(name="clusterCsr")
    def cluster_csr(self) -> builtins.str:
        """
        The certificate signing request (CSR). Available only in UNINITIALIZED state.
        """
        return pulumi.get(self, "cluster_csr")

    @property
    @pulumi.getter(name="hsmCertificate")
    def hsm_certificate(self) -> builtins.str:
        """
        The HSM certificate issued (signed) by the HSM hardware.
        """
        return pulumi.get(self, "hsm_certificate")

    @property
    @pulumi.getter(name="manufacturerHardwareCertificate")
    def manufacturer_hardware_certificate(self) -> builtins.str:
        """
        The HSM hardware certificate issued (signed) by the hardware manufacturer.
        The number of available cluster certificates may vary depending on state of the cluster.
        """
        return pulumi.get(self, "manufacturer_hardware_certificate")


