# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DomainServiceAccessPolicyArgs', 'DomainServiceAccessPolicy']

@pulumi.input_type
class DomainServiceAccessPolicyArgs:
    def __init__(__self__, *,
                 access_policy: pulumi.Input[builtins.str],
                 domain_name: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DomainServiceAccessPolicy resource.
        :param pulumi.Input[builtins.str] access_policy: The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        :param pulumi.Input[builtins.str] domain_name: The CloudSearch domain name the policy applies to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "access_policy", access_policy)
        pulumi.set(__self__, "domain_name", domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> pulumi.Input[builtins.str]:
        """
        The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access_policy", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        The CloudSearch domain name the policy applies to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DomainServiceAccessPolicyState:
    def __init__(__self__, *,
                 access_policy: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainServiceAccessPolicy resources.
        :param pulumi.Input[builtins.str] access_policy: The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        :param pulumi.Input[builtins.str] domain_name: The CloudSearch domain name the policy applies to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if access_policy is not None:
            pulumi.set(__self__, "access_policy", access_policy)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_policy", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CloudSearch domain name the policy applies to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:cloudsearch/domainServiceAccessPolicy:DomainServiceAccessPolicy")
class DomainServiceAccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an CloudSearch domain service access policy resource.

        The provider waits for the domain service access policy to become `Active` when applying a configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_domain = aws.cloudsearch.Domain("example", name="example-domain")
        example = aws.iam.get_policy_document(statements=[{
            "sid": "search_only",
            "effect": "Allow",
            "principals": [{
                "type": "*",
                "identifiers": ["*"],
            }],
            "actions": [
                "cloudsearch:search",
                "cloudsearch:document",
            ],
            "conditions": [{
                "test": "IpAddress",
                "variable": "aws:SourceIp",
                "values": ["192.0.2.0/32"],
            }],
        }])
        example_domain_service_access_policy = aws.cloudsearch.DomainServiceAccessPolicy("example",
            domain_name=example_domain.id,
            access_policy=example.json)
        ```

        ## Import

        Using `pulumi import`, import CloudSearch domain service access policies using the domain name. For example:

        ```sh
        $ pulumi import aws:cloudsearch/domainServiceAccessPolicy:DomainServiceAccessPolicy example example-domain
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_policy: The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        :param pulumi.Input[builtins.str] domain_name: The CloudSearch domain name the policy applies to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainServiceAccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an CloudSearch domain service access policy resource.

        The provider waits for the domain service access policy to become `Active` when applying a configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_domain = aws.cloudsearch.Domain("example", name="example-domain")
        example = aws.iam.get_policy_document(statements=[{
            "sid": "search_only",
            "effect": "Allow",
            "principals": [{
                "type": "*",
                "identifiers": ["*"],
            }],
            "actions": [
                "cloudsearch:search",
                "cloudsearch:document",
            ],
            "conditions": [{
                "test": "IpAddress",
                "variable": "aws:SourceIp",
                "values": ["192.0.2.0/32"],
            }],
        }])
        example_domain_service_access_policy = aws.cloudsearch.DomainServiceAccessPolicy("example",
            domain_name=example_domain.id,
            access_policy=example.json)
        ```

        ## Import

        Using `pulumi import`, import CloudSearch domain service access policies using the domain name. For example:

        ```sh
        $ pulumi import aws:cloudsearch/domainServiceAccessPolicy:DomainServiceAccessPolicy example example-domain
        ```

        :param str resource_name: The name of the resource.
        :param DomainServiceAccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainServiceAccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainServiceAccessPolicyArgs.__new__(DomainServiceAccessPolicyArgs)

            if access_policy is None and not opts.urn:
                raise TypeError("Missing required property 'access_policy'")
            __props__.__dict__["access_policy"] = access_policy
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["region"] = region
        super(DomainServiceAccessPolicy, __self__).__init__(
            'aws:cloudsearch/domainServiceAccessPolicy:DomainServiceAccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy: Optional[pulumi.Input[builtins.str]] = None,
            domain_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'DomainServiceAccessPolicy':
        """
        Get an existing DomainServiceAccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_policy: The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        :param pulumi.Input[builtins.str] domain_name: The CloudSearch domain name the policy applies to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainServiceAccessPolicyState.__new__(_DomainServiceAccessPolicyState)

        __props__.__dict__["access_policy"] = access_policy
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["region"] = region
        return DomainServiceAccessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> pulumi.Output[builtins.str]:
        """
        The access rules you want to configure. These rules replace any existing rules. See the [AWS documentation](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html) for details.
        """
        return pulumi.get(self, "access_policy")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The CloudSearch domain name the policy applies to.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

