# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OrganizationDelegatedAdminAccountArgs', 'OrganizationDelegatedAdminAccount']

@pulumi.input_type
class OrganizationDelegatedAdminAccountArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a OrganizationDelegatedAdminAccount resource.
        :param pulumi.Input[builtins.str] account_id: An organization member account ID that you want to designate as a delegated administrator.
        """
        pulumi.set(__self__, "account_id", account_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        An organization member account ID that you want to designate as a delegated administrator.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)


@pulumi.input_type
class _OrganizationDelegatedAdminAccountState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_principal: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationDelegatedAdminAccount resources.
        :param pulumi.Input[builtins.str] account_id: An organization member account ID that you want to designate as a delegated administrator.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the delegated administrator's account.
        :param pulumi.Input[builtins.str] email: The email address that is associated with the delegated administrator's AWS account.
        :param pulumi.Input[builtins.str] name: The friendly name of the delegated administrator's account.
        :param pulumi.Input[builtins.str] service_principal: The AWS CloudTrail service principal name.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_principal is not None:
            pulumi.set(__self__, "service_principal", service_principal)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An organization member account ID that you want to designate as a delegated administrator.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the delegated administrator's account.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address that is associated with the delegated administrator's AWS account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The friendly name of the delegated administrator's account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS CloudTrail service principal name.
        """
        return pulumi.get(self, "service_principal")

    @service_principal.setter
    def service_principal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_principal", value)


@pulumi.type_token("aws:cloudtrail/organizationDelegatedAdminAccount:OrganizationDelegatedAdminAccount")
class OrganizationDelegatedAdminAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage an AWS CloudTrail Delegated Administrator.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        delegated = aws.get_caller_identity()
        example = aws.cloudtrail.OrganizationDelegatedAdminAccount("example", account_id=delegated.account_id)
        ```

        ## Import

        Using `pulumi import`, import delegated administrators using the delegate account `id`. For example:

        ```sh
        $ pulumi import aws:cloudtrail/organizationDelegatedAdminAccount:OrganizationDelegatedAdminAccount example 12345678901
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: An organization member account ID that you want to designate as a delegated administrator.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationDelegatedAdminAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage an AWS CloudTrail Delegated Administrator.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        delegated = aws.get_caller_identity()
        example = aws.cloudtrail.OrganizationDelegatedAdminAccount("example", account_id=delegated.account_id)
        ```

        ## Import

        Using `pulumi import`, import delegated administrators using the delegate account `id`. For example:

        ```sh
        $ pulumi import aws:cloudtrail/organizationDelegatedAdminAccount:OrganizationDelegatedAdminAccount example 12345678901
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationDelegatedAdminAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationDelegatedAdminAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationDelegatedAdminAccountArgs.__new__(OrganizationDelegatedAdminAccountArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["email"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["service_principal"] = None
        super(OrganizationDelegatedAdminAccount, __self__).__init__(
            'aws:cloudtrail/organizationDelegatedAdminAccount:OrganizationDelegatedAdminAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            service_principal: Optional[pulumi.Input[builtins.str]] = None) -> 'OrganizationDelegatedAdminAccount':
        """
        Get an existing OrganizationDelegatedAdminAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: An organization member account ID that you want to designate as a delegated administrator.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the delegated administrator's account.
        :param pulumi.Input[builtins.str] email: The email address that is associated with the delegated administrator's AWS account.
        :param pulumi.Input[builtins.str] name: The friendly name of the delegated administrator's account.
        :param pulumi.Input[builtins.str] service_principal: The AWS CloudTrail service principal name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationDelegatedAdminAccountState.__new__(_OrganizationDelegatedAdminAccountState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["email"] = email
        __props__.__dict__["name"] = name
        __props__.__dict__["service_principal"] = service_principal
        return OrganizationDelegatedAdminAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        An organization member account ID that you want to designate as a delegated administrator.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the delegated administrator's account.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The email address that is associated with the delegated administrator's AWS account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The friendly name of the delegated administrator's account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> pulumi.Output[builtins.str]:
        """
        The AWS CloudTrail service principal name.
        """
        return pulumi.get(self, "service_principal")

