# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ContributorInsightRuleArgs', 'ContributorInsightRule']

@pulumi.input_type
class ContributorInsightRuleArgs:
    def __init__(__self__, *,
                 rule_definition: pulumi.Input[builtins.str],
                 rule_name: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rule_state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ContributorInsightRule resource.
        :param pulumi.Input[builtins.str] rule_definition: Definition of the rule, as a JSON object. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
        :param pulumi.Input[builtins.str] rule_name: Unique name of the rule.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] rule_state: State of the rule. Valid values are `ENABLED` and `DISABLED`.
        """
        pulumi.set(__self__, "rule_definition", rule_definition)
        pulumi.set(__self__, "rule_name", rule_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_state is not None:
            pulumi.set(__self__, "rule_state", rule_state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="ruleDefinition")
    def rule_definition(self) -> pulumi.Input[builtins.str]:
        """
        Definition of the rule, as a JSON object. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
        """
        return pulumi.get(self, "rule_definition")

    @rule_definition.setter
    def rule_definition(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rule_definition", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[builtins.str]:
        """
        Unique name of the rule.

        The following arguments are optional:
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ruleState")
    def rule_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the rule. Valid values are `ENABLED` and `DISABLED`.
        """
        return pulumi.get(self, "rule_state")

    @rule_state.setter
    def rule_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ContributorInsightRuleState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[builtins.str]] = None,
                 rule_definition: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ContributorInsightRule resources.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_arn: ARN of the Contributor Insight Rule.
        :param pulumi.Input[builtins.str] rule_definition: Definition of the rule, as a JSON object. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
        :param pulumi.Input[builtins.str] rule_name: Unique name of the rule.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] rule_state: State of the rule. Valid values are `ENABLED` and `DISABLED`.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if rule_definition is not None:
            pulumi.set(__self__, "rule_definition", rule_definition)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if rule_state is not None:
            pulumi.set(__self__, "rule_state", rule_state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Contributor Insight Rule.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter(name="ruleDefinition")
    def rule_definition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Definition of the rule, as a JSON object. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
        """
        return pulumi.get(self, "rule_definition")

    @rule_definition.setter
    def rule_definition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_definition", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name of the rule.

        The following arguments are optional:
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="ruleState")
    def rule_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the rule. Valid values are `ENABLED` and `DISABLED`.
        """
        return pulumi.get(self, "rule_state")

    @rule_state.setter
    def rule_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:cloudwatch/contributorInsightRule:ContributorInsightRule")
class ContributorInsightRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rule_definition: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CloudWatch Contributor Insight Rule.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.ContributorInsightRule("test",
            rule_name="testing",
            rule_state="ENABLED",
            rule_definition="{\\"Schema\\":{\\"Name\\":\\"CloudWatchLogRule\\",\\"Version\\":1},\\"AggregateOn\\":\\"Count\\",\\"Contribution\\":{\\"Filters\\":[{\\"In\\":[\\"some-keyword\\"],\\"Match\\":\\"$.message\\"}],\\"Keys\\":[\\"$.country\\"]},\\"LogFormat\\":\\"JSON\\",\\"LogGroupNames\\":[\\"/aws/lambda/api-prod\\"]}")
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Contributor Insight Rule using the `rule_name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/contributorInsightRule:ContributorInsightRule example contributor_insight_rule-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] rule_definition: Definition of the rule, as a JSON object. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
        :param pulumi.Input[builtins.str] rule_name: Unique name of the rule.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] rule_state: State of the rule. Valid values are `ENABLED` and `DISABLED`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContributorInsightRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CloudWatch Contributor Insight Rule.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.ContributorInsightRule("test",
            rule_name="testing",
            rule_state="ENABLED",
            rule_definition="{\\"Schema\\":{\\"Name\\":\\"CloudWatchLogRule\\",\\"Version\\":1},\\"AggregateOn\\":\\"Count\\",\\"Contribution\\":{\\"Filters\\":[{\\"In\\":[\\"some-keyword\\"],\\"Match\\":\\"$.message\\"}],\\"Keys\\":[\\"$.country\\"]},\\"LogFormat\\":\\"JSON\\",\\"LogGroupNames\\":[\\"/aws/lambda/api-prod\\"]}")
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Contributor Insight Rule using the `rule_name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/contributorInsightRule:ContributorInsightRule example contributor_insight_rule-name
        ```

        :param str resource_name: The name of the resource.
        :param ContributorInsightRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContributorInsightRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rule_definition: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContributorInsightRuleArgs.__new__(ContributorInsightRuleArgs)

            __props__.__dict__["region"] = region
            if rule_definition is None and not opts.urn:
                raise TypeError("Missing required property 'rule_definition'")
            __props__.__dict__["rule_definition"] = rule_definition
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["rule_state"] = rule_state
            __props__.__dict__["tags"] = tags
            __props__.__dict__["resource_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(ContributorInsightRule, __self__).__init__(
            'aws:cloudwatch/contributorInsightRule:ContributorInsightRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            resource_arn: Optional[pulumi.Input[builtins.str]] = None,
            rule_definition: Optional[pulumi.Input[builtins.str]] = None,
            rule_name: Optional[pulumi.Input[builtins.str]] = None,
            rule_state: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'ContributorInsightRule':
        """
        Get an existing ContributorInsightRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_arn: ARN of the Contributor Insight Rule.
        :param pulumi.Input[builtins.str] rule_definition: Definition of the rule, as a JSON object. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
        :param pulumi.Input[builtins.str] rule_name: Unique name of the rule.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] rule_state: State of the rule. Valid values are `ENABLED` and `DISABLED`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContributorInsightRuleState.__new__(_ContributorInsightRuleState)

        __props__.__dict__["region"] = region
        __props__.__dict__["resource_arn"] = resource_arn
        __props__.__dict__["rule_definition"] = rule_definition
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["rule_state"] = rule_state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return ContributorInsightRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Contributor Insight Rule.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="ruleDefinition")
    def rule_definition(self) -> pulumi.Output[builtins.str]:
        """
        Definition of the rule, as a JSON object. For details on the valid syntax, see [Contributor Insights Rule Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
        """
        return pulumi.get(self, "rule_definition")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[builtins.str]:
        """
        Unique name of the rule.

        The following arguments are optional:
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="ruleState")
    def rule_state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        State of the rule. Valid values are `ENABLED` and `DISABLED`.
        """
        return pulumi.get(self, "rule_state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

