# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EventArchiveArgs', 'EventArchive']

@pulumi.input_type
class EventArchiveArgs:
    def __init__(__self__, *,
                 event_source_arn: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 event_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a EventArchive resource.
        :param pulumi.Input[builtins.str] event_source_arn: ARN of the event bus associated with the archive. Only events from this event bus are sent to the archive.
        :param pulumi.Input[builtins.str] description: Description for the archive.
        :param pulumi.Input[builtins.str] event_pattern: Event pattern to use to filter events sent to the archive. By default, it attempts to archive every event received in the `event_source_arn`.
        :param pulumi.Input[builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        :param pulumi.Input[builtins.str] name: Name of the archive. The archive name cannot exceed 48 characters.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] retention_days: The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        pulumi.set(__self__, "event_source_arn", event_source_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if kms_key_identifier is not None:
            pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the event bus associated with the archive. Only events from this event bus are sent to the archive.
        """
        return pulumi.get(self, "event_source_arn")

    @event_source_arn.setter
    def event_source_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "event_source_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for the archive.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Event pattern to use to filter events sent to the archive. By default, it attempts to archive every event received in the `event_source_arn`.
        """
        return pulumi.get(self, "event_pattern")

    @event_pattern.setter
    def event_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_pattern", value)

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        """
        return pulumi.get(self, "kms_key_identifier")

    @kms_key_identifier.setter
    def kms_key_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the archive. The archive name cannot exceed 48 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_days", value)


@pulumi.input_type
class _EventArchiveState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 event_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 event_source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering EventArchive resources.
        :param pulumi.Input[builtins.str] arn: ARN of the archive.
        :param pulumi.Input[builtins.str] description: Description for the archive.
        :param pulumi.Input[builtins.str] event_pattern: Event pattern to use to filter events sent to the archive. By default, it attempts to archive every event received in the `event_source_arn`.
        :param pulumi.Input[builtins.str] event_source_arn: ARN of the event bus associated with the archive. Only events from this event bus are sent to the archive.
        :param pulumi.Input[builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        :param pulumi.Input[builtins.str] name: Name of the archive. The archive name cannot exceed 48 characters.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] retention_days: The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if event_source_arn is not None:
            pulumi.set(__self__, "event_source_arn", event_source_arn)
        if kms_key_identifier is not None:
            pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the archive.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for the archive.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Event pattern to use to filter events sent to the archive. By default, it attempts to archive every event received in the `event_source_arn`.
        """
        return pulumi.get(self, "event_pattern")

    @event_pattern.setter
    def event_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_pattern", value)

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the event bus associated with the archive. Only events from this event bus are sent to the archive.
        """
        return pulumi.get(self, "event_source_arn")

    @event_source_arn.setter
    def event_source_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_source_arn", value)

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        """
        return pulumi.get(self, "kms_key_identifier")

    @kms_key_identifier.setter
    def kms_key_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the archive. The archive name cannot exceed 48 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_days", value)


@pulumi.type_token("aws:cloudwatch/eventArchive:EventArchive")
class EventArchive(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 event_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 event_source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Provides an EventBridge event archive resource.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        order = aws.cloudwatch.EventBus("order", name="orders")
        order_event_archive = aws.cloudwatch.EventArchive("order",
            name="order-archive",
            event_source_arn=order.arn)
        ```

        ### Optional Arguments

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        order = aws.cloudwatch.EventBus("order", name="orders")
        order_event_archive = aws.cloudwatch.EventArchive("order",
            name="order-archive",
            description="Archived events from order service",
            event_source_arn=order.arn,
            retention_days=7,
            event_pattern=json.dumps({
                "source": ["company.team.order"],
            }))
        ```

        ### CMK Encryption

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        example = aws.cloudwatch.EventBus("example", name="example")
        example_key = aws.kms.Key("example",
            deletion_window_in_days=7,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Id": "key-policy-example",
                "Statement": [
                    {
                        "Sid": "Enable IAM User Permissions",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
                        },
                        "Action": "kms:*",
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow describing of the key",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "events.amazonaws.com",
                        },
                        "Action": ["kms:DescribeKey"],
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow use of the key",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "events.amazonaws.com",
                        },
                        "Action": [
                            "kms:GenerateDataKey",
                            "kms:Decrypt",
                            "kms:ReEncrypt*",
                        ],
                        "Resource": "*",
                        "Condition": {
                            "StringEquals": {
                                "kms:EncryptionContext:aws:events:event-bus:arn": example.arn,
                            },
                        },
                    },
                ],
            }),
            tags={
                "EventBridgeApiDestinations": "true",
            })
        example_event_archive = aws.cloudwatch.EventArchive("example",
            name="example",
            event_source_arn=example.arn,
            kms_key_identifier=example_key.id)
        ```

        ## Import

        Using `pulumi import`, import an EventBridge archive using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/eventArchive:EventArchive imported_event_archive order-archive
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description for the archive.
        :param pulumi.Input[builtins.str] event_pattern: Event pattern to use to filter events sent to the archive. By default, it attempts to archive every event received in the `event_source_arn`.
        :param pulumi.Input[builtins.str] event_source_arn: ARN of the event bus associated with the archive. Only events from this event bus are sent to the archive.
        :param pulumi.Input[builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        :param pulumi.Input[builtins.str] name: Name of the archive. The archive name cannot exceed 48 characters.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] retention_days: The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventArchiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EventBridge event archive resource.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        order = aws.cloudwatch.EventBus("order", name="orders")
        order_event_archive = aws.cloudwatch.EventArchive("order",
            name="order-archive",
            event_source_arn=order.arn)
        ```

        ### Optional Arguments

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        order = aws.cloudwatch.EventBus("order", name="orders")
        order_event_archive = aws.cloudwatch.EventArchive("order",
            name="order-archive",
            description="Archived events from order service",
            event_source_arn=order.arn,
            retention_days=7,
            event_pattern=json.dumps({
                "source": ["company.team.order"],
            }))
        ```

        ### CMK Encryption

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        example = aws.cloudwatch.EventBus("example", name="example")
        example_key = aws.kms.Key("example",
            deletion_window_in_days=7,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Id": "key-policy-example",
                "Statement": [
                    {
                        "Sid": "Enable IAM User Permissions",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
                        },
                        "Action": "kms:*",
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow describing of the key",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "events.amazonaws.com",
                        },
                        "Action": ["kms:DescribeKey"],
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow use of the key",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "events.amazonaws.com",
                        },
                        "Action": [
                            "kms:GenerateDataKey",
                            "kms:Decrypt",
                            "kms:ReEncrypt*",
                        ],
                        "Resource": "*",
                        "Condition": {
                            "StringEquals": {
                                "kms:EncryptionContext:aws:events:event-bus:arn": example.arn,
                            },
                        },
                    },
                ],
            }),
            tags={
                "EventBridgeApiDestinations": "true",
            })
        example_event_archive = aws.cloudwatch.EventArchive("example",
            name="example",
            event_source_arn=example.arn,
            kms_key_identifier=example_key.id)
        ```

        ## Import

        Using `pulumi import`, import an EventBridge archive using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/eventArchive:EventArchive imported_event_archive order-archive
        ```

        :param str resource_name: The name of the resource.
        :param EventArchiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventArchiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 event_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 event_source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventArchiveArgs.__new__(EventArchiveArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["event_pattern"] = event_pattern
            if event_source_arn is None and not opts.urn:
                raise TypeError("Missing required property 'event_source_arn'")
            __props__.__dict__["event_source_arn"] = event_source_arn
            __props__.__dict__["kms_key_identifier"] = kms_key_identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["retention_days"] = retention_days
            __props__.__dict__["arn"] = None
        super(EventArchive, __self__).__init__(
            'aws:cloudwatch/eventArchive:EventArchive',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            event_pattern: Optional[pulumi.Input[builtins.str]] = None,
            event_source_arn: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            retention_days: Optional[pulumi.Input[builtins.int]] = None) -> 'EventArchive':
        """
        Get an existing EventArchive resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the archive.
        :param pulumi.Input[builtins.str] description: Description for the archive.
        :param pulumi.Input[builtins.str] event_pattern: Event pattern to use to filter events sent to the archive. By default, it attempts to archive every event received in the `event_source_arn`.
        :param pulumi.Input[builtins.str] event_source_arn: ARN of the event bus associated with the archive. Only events from this event bus are sent to the archive.
        :param pulumi.Input[builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        :param pulumi.Input[builtins.str] name: Name of the archive. The archive name cannot exceed 48 characters.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] retention_days: The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventArchiveState.__new__(_EventArchiveState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["event_pattern"] = event_pattern
        __props__.__dict__["event_source_arn"] = event_source_arn
        __props__.__dict__["kms_key_identifier"] = kms_key_identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["retention_days"] = retention_days
        return EventArchive(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the archive.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description for the archive.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Event pattern to use to filter events sent to the archive. By default, it attempts to archive every event received in the `event_source_arn`.
        """
        return pulumi.get(self, "event_pattern")

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the event bus associated with the archive. Only events from this event bus are sent to the archive.
        """
        return pulumi.get(self, "event_source_arn")

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        """
        return pulumi.get(self, "kms_key_identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the archive. The archive name cannot exceed 48 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        return pulumi.get(self, "retention_days")

