# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventConnectionArgs', 'EventConnection']

@pulumi.input_type
class EventConnectionArgs:
    def __init__(__self__, *,
                 auth_parameters: pulumi.Input['EventConnectionAuthParametersArgs'],
                 authorization_type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invocation_connectivity_parameters: Optional[pulumi.Input['EventConnectionInvocationConnectivityParametersArgs']] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EventConnection resource.
        :param pulumi.Input['EventConnectionAuthParametersArgs'] auth_parameters: Parameters used for authorization. A maximum of 1 are allowed. Documented below.
        :param pulumi.Input[builtins.str] authorization_type: Type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
        :param pulumi.Input[builtins.str] description: Description for the connection. Maximum of 512 characters.
        :param pulumi.Input['EventConnectionInvocationConnectivityParametersArgs'] invocation_connectivity_parameters: Parameters to use for invoking a private API. Documented below.
        :param pulumi.Input[builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        :param pulumi.Input[builtins.str] name: The name for the connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "auth_parameters", auth_parameters)
        pulumi.set(__self__, "authorization_type", authorization_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if invocation_connectivity_parameters is not None:
            pulumi.set(__self__, "invocation_connectivity_parameters", invocation_connectivity_parameters)
        if kms_key_identifier is not None:
            pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="authParameters")
    def auth_parameters(self) -> pulumi.Input['EventConnectionAuthParametersArgs']:
        """
        Parameters used for authorization. A maximum of 1 are allowed. Documented below.
        """
        return pulumi.get(self, "auth_parameters")

    @auth_parameters.setter
    def auth_parameters(self, value: pulumi.Input['EventConnectionAuthParametersArgs']):
        pulumi.set(self, "auth_parameters", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for the connection. Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="invocationConnectivityParameters")
    def invocation_connectivity_parameters(self) -> Optional[pulumi.Input['EventConnectionInvocationConnectivityParametersArgs']]:
        """
        Parameters to use for invoking a private API. Documented below.
        """
        return pulumi.get(self, "invocation_connectivity_parameters")

    @invocation_connectivity_parameters.setter
    def invocation_connectivity_parameters(self, value: Optional[pulumi.Input['EventConnectionInvocationConnectivityParametersArgs']]):
        pulumi.set(self, "invocation_connectivity_parameters", value)

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        """
        return pulumi.get(self, "kms_key_identifier")

    @kms_key_identifier.setter
    def kms_key_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EventConnectionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 auth_parameters: Optional[pulumi.Input['EventConnectionAuthParametersArgs']] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invocation_connectivity_parameters: Optional[pulumi.Input['EventConnectionInvocationConnectivityParametersArgs']] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EventConnection resources.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the connection.
        :param pulumi.Input['EventConnectionAuthParametersArgs'] auth_parameters: Parameters used for authorization. A maximum of 1 are allowed. Documented below.
        :param pulumi.Input[builtins.str] authorization_type: Type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
        :param pulumi.Input[builtins.str] description: Description for the connection. Maximum of 512 characters.
        :param pulumi.Input['EventConnectionInvocationConnectivityParametersArgs'] invocation_connectivity_parameters: Parameters to use for invoking a private API. Documented below.
        :param pulumi.Input[builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        :param pulumi.Input[builtins.str] name: The name for the connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] secret_arn: The Amazon Resource Name (ARN) of the secret created from the authorization parameters specified for the connection.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auth_parameters is not None:
            pulumi.set(__self__, "auth_parameters", auth_parameters)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if invocation_connectivity_parameters is not None:
            pulumi.set(__self__, "invocation_connectivity_parameters", invocation_connectivity_parameters)
        if kms_key_identifier is not None:
            pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the connection.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="authParameters")
    def auth_parameters(self) -> Optional[pulumi.Input['EventConnectionAuthParametersArgs']]:
        """
        Parameters used for authorization. A maximum of 1 are allowed. Documented below.
        """
        return pulumi.get(self, "auth_parameters")

    @auth_parameters.setter
    def auth_parameters(self, value: Optional[pulumi.Input['EventConnectionAuthParametersArgs']]):
        pulumi.set(self, "auth_parameters", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for the connection. Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="invocationConnectivityParameters")
    def invocation_connectivity_parameters(self) -> Optional[pulumi.Input['EventConnectionInvocationConnectivityParametersArgs']]:
        """
        Parameters to use for invoking a private API. Documented below.
        """
        return pulumi.get(self, "invocation_connectivity_parameters")

    @invocation_connectivity_parameters.setter
    def invocation_connectivity_parameters(self, value: Optional[pulumi.Input['EventConnectionInvocationConnectivityParametersArgs']]):
        pulumi.set(self, "invocation_connectivity_parameters", value)

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        """
        return pulumi.get(self, "kms_key_identifier")

    @kms_key_identifier.setter
    def kms_key_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the secret created from the authorization parameters specified for the connection.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_arn", value)


@pulumi.type_token("aws:cloudwatch/eventConnection:EventConnection")
class EventConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_parameters: Optional[pulumi.Input[Union['EventConnectionAuthParametersArgs', 'EventConnectionAuthParametersArgsDict']]] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invocation_connectivity_parameters: Optional[pulumi.Input[Union['EventConnectionInvocationConnectivityParametersArgs', 'EventConnectionInvocationConnectivityParametersArgsDict']]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an EventBridge connection resource.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="API_KEY",
            auth_parameters={
                "api_key": {
                    "key": "x-signature",
                    "value": "1234",
                },
            })
        ```

        ### Basic Authorization

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="BASIC",
            auth_parameters={
                "basic": {
                    "username": "user",
                    "password": "Pass1234!",
                },
            })
        ```

        ### OAuth Authorization

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="OAUTH_CLIENT_CREDENTIALS",
            auth_parameters={
                "oauth": {
                    "authorization_endpoint": "https://auth.url.com/endpoint",
                    "http_method": "GET",
                    "client_parameters": {
                        "client_id": "1234567890",
                        "client_secret": "Pass1234!",
                    },
                    "oauth_http_parameters": {
                        "bodies": [{
                            "key": "body-parameter-key",
                            "value": "body-parameter-value",
                            "is_value_secret": False,
                        }],
                        "headers": [{
                            "key": "header-parameter-key",
                            "value": "header-parameter-value",
                            "is_value_secret": False,
                        }],
                        "query_strings": [{
                            "key": "query-string-parameter-key",
                            "value": "query-string-parameter-value",
                            "is_value_secret": False,
                        }],
                    },
                },
            })
        ```

        ### Invocation Http Parameters

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="BASIC",
            auth_parameters={
                "basic": {
                    "username": "user",
                    "password": "Pass1234!",
                },
                "invocation_http_parameters": {
                    "bodies": [
                        {
                            "key": "body-parameter-key",
                            "value": "body-parameter-value",
                            "is_value_secret": False,
                        },
                        {
                            "key": "body-parameter-key2",
                            "value": "body-parameter-value2",
                            "is_value_secret": True,
                        },
                    ],
                    "headers": [{
                        "key": "header-parameter-key",
                        "value": "header-parameter-value",
                        "is_value_secret": False,
                    }],
                    "query_strings": [{
                        "key": "query-string-parameter-key",
                        "value": "query-string-parameter-value",
                        "is_value_secret": False,
                    }],
                },
            })
        ```

        ### CMK Encryption

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        test = aws.kms.Key("test",
            deletion_window_in_days=7,
            policy=json.dumps({
                "Version": "2012-10-17",
                "Id": "key-policy-example",
                "Statement": [
                    {
                        "Sid": "Enable IAM User Permissions",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
                        },
                        "Action": "kms:*",
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow use of the key",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
                        },
                        "Action": [
                            "kms:DescribeKey",
                            "kms:Decrypt",
                            "kms:GenerateDataKey",
                        ],
                        "Resource": "*",
                        "Condition": {
                            "StringLike": {
                                "kms:ViaService": "secretsmanager.*.amazonaws.com",
                                "kms:EncryptionContext:SecretARN": ["arn:aws:secretsmanager:*:*:secret:events!connection/*"],
                            },
                        },
                    },
                ],
            }),
            tags={
                "EventBridgeApiDestinations": "true",
            })
        test_event_connection = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="BASIC",
            auth_parameters={
                "basic": {
                    "username": "user",
                    "password": "Pass1234!",
                },
            },
            kms_key_identifier=example["id"])
        ```

        ## Import

        Using `pulumi import`, import EventBridge EventBridge connection using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/eventConnection:EventConnection test ngrok-connection
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EventConnectionAuthParametersArgs', 'EventConnectionAuthParametersArgsDict']] auth_parameters: Parameters used for authorization. A maximum of 1 are allowed. Documented below.
        :param pulumi.Input[builtins.str] authorization_type: Type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
        :param pulumi.Input[builtins.str] description: Description for the connection. Maximum of 512 characters.
        :param pulumi.Input[Union['EventConnectionInvocationConnectivityParametersArgs', 'EventConnectionInvocationConnectivityParametersArgsDict']] invocation_connectivity_parameters: Parameters to use for invoking a private API. Documented below.
        :param pulumi.Input[builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        :param pulumi.Input[builtins.str] name: The name for the connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EventBridge connection resource.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="API_KEY",
            auth_parameters={
                "api_key": {
                    "key": "x-signature",
                    "value": "1234",
                },
            })
        ```

        ### Basic Authorization

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="BASIC",
            auth_parameters={
                "basic": {
                    "username": "user",
                    "password": "Pass1234!",
                },
            })
        ```

        ### OAuth Authorization

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="OAUTH_CLIENT_CREDENTIALS",
            auth_parameters={
                "oauth": {
                    "authorization_endpoint": "https://auth.url.com/endpoint",
                    "http_method": "GET",
                    "client_parameters": {
                        "client_id": "1234567890",
                        "client_secret": "Pass1234!",
                    },
                    "oauth_http_parameters": {
                        "bodies": [{
                            "key": "body-parameter-key",
                            "value": "body-parameter-value",
                            "is_value_secret": False,
                        }],
                        "headers": [{
                            "key": "header-parameter-key",
                            "value": "header-parameter-value",
                            "is_value_secret": False,
                        }],
                        "query_strings": [{
                            "key": "query-string-parameter-key",
                            "value": "query-string-parameter-value",
                            "is_value_secret": False,
                        }],
                    },
                },
            })
        ```

        ### Invocation Http Parameters

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="BASIC",
            auth_parameters={
                "basic": {
                    "username": "user",
                    "password": "Pass1234!",
                },
                "invocation_http_parameters": {
                    "bodies": [
                        {
                            "key": "body-parameter-key",
                            "value": "body-parameter-value",
                            "is_value_secret": False,
                        },
                        {
                            "key": "body-parameter-key2",
                            "value": "body-parameter-value2",
                            "is_value_secret": True,
                        },
                    ],
                    "headers": [{
                        "key": "header-parameter-key",
                        "value": "header-parameter-value",
                        "is_value_secret": False,
                    }],
                    "query_strings": [{
                        "key": "query-string-parameter-key",
                        "value": "query-string-parameter-value",
                        "is_value_secret": False,
                    }],
                },
            })
        ```

        ### CMK Encryption

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        test = aws.kms.Key("test",
            deletion_window_in_days=7,
            policy=json.dumps({
                "Version": "2012-10-17",
                "Id": "key-policy-example",
                "Statement": [
                    {
                        "Sid": "Enable IAM User Permissions",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
                        },
                        "Action": "kms:*",
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow use of the key",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
                        },
                        "Action": [
                            "kms:DescribeKey",
                            "kms:Decrypt",
                            "kms:GenerateDataKey",
                        ],
                        "Resource": "*",
                        "Condition": {
                            "StringLike": {
                                "kms:ViaService": "secretsmanager.*.amazonaws.com",
                                "kms:EncryptionContext:SecretARN": ["arn:aws:secretsmanager:*:*:secret:events!connection/*"],
                            },
                        },
                    },
                ],
            }),
            tags={
                "EventBridgeApiDestinations": "true",
            })
        test_event_connection = aws.cloudwatch.EventConnection("test",
            name="ngrok-connection",
            description="A connection description",
            authorization_type="BASIC",
            auth_parameters={
                "basic": {
                    "username": "user",
                    "password": "Pass1234!",
                },
            },
            kms_key_identifier=example["id"])
        ```

        ## Import

        Using `pulumi import`, import EventBridge EventBridge connection using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/eventConnection:EventConnection test ngrok-connection
        ```

        :param str resource_name: The name of the resource.
        :param EventConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_parameters: Optional[pulumi.Input[Union['EventConnectionAuthParametersArgs', 'EventConnectionAuthParametersArgsDict']]] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 invocation_connectivity_parameters: Optional[pulumi.Input[Union['EventConnectionInvocationConnectivityParametersArgs', 'EventConnectionInvocationConnectivityParametersArgsDict']]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventConnectionArgs.__new__(EventConnectionArgs)

            if auth_parameters is None and not opts.urn:
                raise TypeError("Missing required property 'auth_parameters'")
            __props__.__dict__["auth_parameters"] = auth_parameters
            if authorization_type is None and not opts.urn:
                raise TypeError("Missing required property 'authorization_type'")
            __props__.__dict__["authorization_type"] = authorization_type
            __props__.__dict__["description"] = description
            __props__.__dict__["invocation_connectivity_parameters"] = invocation_connectivity_parameters
            __props__.__dict__["kms_key_identifier"] = kms_key_identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["arn"] = None
            __props__.__dict__["secret_arn"] = None
        super(EventConnection, __self__).__init__(
            'aws:cloudwatch/eventConnection:EventConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            auth_parameters: Optional[pulumi.Input[Union['EventConnectionAuthParametersArgs', 'EventConnectionAuthParametersArgsDict']]] = None,
            authorization_type: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            invocation_connectivity_parameters: Optional[pulumi.Input[Union['EventConnectionInvocationConnectivityParametersArgs', 'EventConnectionInvocationConnectivityParametersArgsDict']]] = None,
            kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            secret_arn: Optional[pulumi.Input[builtins.str]] = None) -> 'EventConnection':
        """
        Get an existing EventConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the connection.
        :param pulumi.Input[Union['EventConnectionAuthParametersArgs', 'EventConnectionAuthParametersArgsDict']] auth_parameters: Parameters used for authorization. A maximum of 1 are allowed. Documented below.
        :param pulumi.Input[builtins.str] authorization_type: Type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
        :param pulumi.Input[builtins.str] description: Description for the connection. Maximum of 512 characters.
        :param pulumi.Input[Union['EventConnectionInvocationConnectivityParametersArgs', 'EventConnectionInvocationConnectivityParametersArgsDict']] invocation_connectivity_parameters: Parameters to use for invoking a private API. Documented below.
        :param pulumi.Input[builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        :param pulumi.Input[builtins.str] name: The name for the connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] secret_arn: The Amazon Resource Name (ARN) of the secret created from the authorization parameters specified for the connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventConnectionState.__new__(_EventConnectionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["auth_parameters"] = auth_parameters
        __props__.__dict__["authorization_type"] = authorization_type
        __props__.__dict__["description"] = description
        __props__.__dict__["invocation_connectivity_parameters"] = invocation_connectivity_parameters
        __props__.__dict__["kms_key_identifier"] = kms_key_identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_arn"] = secret_arn
        return EventConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the connection.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authParameters")
    def auth_parameters(self) -> pulumi.Output['outputs.EventConnectionAuthParameters']:
        """
        Parameters used for authorization. A maximum of 1 are allowed. Documented below.
        """
        return pulumi.get(self, "auth_parameters")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of authorization to use for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description for the connection. Maximum of 512 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="invocationConnectivityParameters")
    def invocation_connectivity_parameters(self) -> pulumi.Output[Optional['outputs.EventConnectionInvocationConnectivityParameters']]:
        """
        Parameters to use for invoking a private API. Documented below.
        """
        return pulumi.get(self, "invocation_connectivity_parameters")

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.
        """
        return pulumi.get(self, "kms_key_identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the connection. Maximum of 64 characters consisting of numbers, lower/upper case letters, .,-,_.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the secret created from the authorization parameters specified for the connection.
        """
        return pulumi.get(self, "secret_arn")

