# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEventConnectionResult',
    'AwaitableGetEventConnectionResult',
    'get_event_connection',
    'get_event_connection_output',
]

@pulumi.output_type
class GetEventConnectionResult:
    """
    A collection of values returned by getEventConnection.
    """
    def __init__(__self__, arn=None, authorization_type=None, id=None, kms_key_identifier=None, name=None, region=None, secret_arn=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if authorization_type and not isinstance(authorization_type, str):
            raise TypeError("Expected argument 'authorization_type' to be a str")
        pulumi.set(__self__, "authorization_type", authorization_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_identifier and not isinstance(kms_key_identifier, str):
            raise TypeError("Expected argument 'kms_key_identifier' to be a str")
        pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secret_arn and not isinstance(secret_arn, str):
            raise TypeError("Expected argument 'secret_arn' to be a str")
        pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN (Amazon Resource Name) of the connection.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> builtins.str:
        """
        Type of authorization specified for the connection. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> builtins.str:
        """
        (Optional) Identifier of the AWS KMS customer managed key for EventBridge to use to encrypt the connection, if one has been specified.
        """
        return pulumi.get(self, "kms_key_identifier")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> builtins.str:
        """
        ARN of the secret created from the authorization parameters specified for the connection.
        """
        return pulumi.get(self, "secret_arn")


class AwaitableGetEventConnectionResult(GetEventConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventConnectionResult(
            arn=self.arn,
            authorization_type=self.authorization_type,
            id=self.id,
            kms_key_identifier=self.kms_key_identifier,
            name=self.name,
            region=self.region,
            secret_arn=self.secret_arn)


def get_event_connection(name: Optional[builtins.str] = None,
                         region: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventConnectionResult:
    """
    Use this data source to retrieve information about an EventBridge connection.

    > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.cloudwatch.get_event_connection(name="test")
    ```


    :param builtins.str name: Name of the connection.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudwatch/getEventConnection:getEventConnection', __args__, opts=opts, typ=GetEventConnectionResult).value

    return AwaitableGetEventConnectionResult(
        arn=pulumi.get(__ret__, 'arn'),
        authorization_type=pulumi.get(__ret__, 'authorization_type'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_identifier=pulumi.get(__ret__, 'kms_key_identifier'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        secret_arn=pulumi.get(__ret__, 'secret_arn'))
def get_event_connection_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventConnectionResult]:
    """
    Use this data source to retrieve information about an EventBridge connection.

    > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.cloudwatch.get_event_connection(name="test")
    ```


    :param builtins.str name: Name of the connection.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudwatch/getEventConnection:getEventConnection', __args__, opts=opts, typ=GetEventConnectionResult)
    return __ret__.apply(lambda __response__: GetEventConnectionResult(
        arn=pulumi.get(__response__, 'arn'),
        authorization_type=pulumi.get(__response__, 'authorization_type'),
        id=pulumi.get(__response__, 'id'),
        kms_key_identifier=pulumi.get(__response__, 'kms_key_identifier'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        secret_arn=pulumi.get(__response__, 'secret_arn')))
