# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogDeliveryDestinationPolicyArgs', 'LogDeliveryDestinationPolicy']

@pulumi.input_type
class LogDeliveryDestinationPolicyArgs:
    def __init__(__self__, *,
                 delivery_destination_name: pulumi.Input[builtins.str],
                 delivery_destination_policy: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LogDeliveryDestinationPolicy resource.
        :param pulumi.Input[builtins.str] delivery_destination_name: The name of the delivery destination to assign this policy to.
        :param pulumi.Input[builtins.str] delivery_destination_policy: The contents of the policy.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "delivery_destination_name", delivery_destination_name)
        pulumi.set(__self__, "delivery_destination_policy", delivery_destination_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="deliveryDestinationName")
    def delivery_destination_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the delivery destination to assign this policy to.
        """
        return pulumi.get(self, "delivery_destination_name")

    @delivery_destination_name.setter
    def delivery_destination_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "delivery_destination_name", value)

    @property
    @pulumi.getter(name="deliveryDestinationPolicy")
    def delivery_destination_policy(self) -> pulumi.Input[builtins.str]:
        """
        The contents of the policy.
        """
        return pulumi.get(self, "delivery_destination_policy")

    @delivery_destination_policy.setter
    def delivery_destination_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "delivery_destination_policy", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _LogDeliveryDestinationPolicyState:
    def __init__(__self__, *,
                 delivery_destination_name: Optional[pulumi.Input[builtins.str]] = None,
                 delivery_destination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogDeliveryDestinationPolicy resources.
        :param pulumi.Input[builtins.str] delivery_destination_name: The name of the delivery destination to assign this policy to.
        :param pulumi.Input[builtins.str] delivery_destination_policy: The contents of the policy.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if delivery_destination_name is not None:
            pulumi.set(__self__, "delivery_destination_name", delivery_destination_name)
        if delivery_destination_policy is not None:
            pulumi.set(__self__, "delivery_destination_policy", delivery_destination_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="deliveryDestinationName")
    def delivery_destination_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the delivery destination to assign this policy to.
        """
        return pulumi.get(self, "delivery_destination_name")

    @delivery_destination_name.setter
    def delivery_destination_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delivery_destination_name", value)

    @property
    @pulumi.getter(name="deliveryDestinationPolicy")
    def delivery_destination_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The contents of the policy.
        """
        return pulumi.get(self, "delivery_destination_policy")

    @delivery_destination_policy.setter
    def delivery_destination_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delivery_destination_policy", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:cloudwatch/logDeliveryDestinationPolicy:LogDeliveryDestinationPolicy")
class LogDeliveryDestinationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_destination_name: Optional[pulumi.Input[builtins.str]] = None,
                 delivery_destination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CloudWatch Logs Delivery Destination Policy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogDeliveryDestinationPolicy("example",
            delivery_destination_name=example_aws_cloudwatch_log_delivery_destination["name"],
            delivery_destination_policy=example_aws_iam_policy_document["json"])
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Logs Delivery Destination Policy using the `delivery_destination_name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/logDeliveryDestinationPolicy:LogDeliveryDestinationPolicy example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] delivery_destination_name: The name of the delivery destination to assign this policy to.
        :param pulumi.Input[builtins.str] delivery_destination_policy: The contents of the policy.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogDeliveryDestinationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CloudWatch Logs Delivery Destination Policy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogDeliveryDestinationPolicy("example",
            delivery_destination_name=example_aws_cloudwatch_log_delivery_destination["name"],
            delivery_destination_policy=example_aws_iam_policy_document["json"])
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Logs Delivery Destination Policy using the `delivery_destination_name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/logDeliveryDestinationPolicy:LogDeliveryDestinationPolicy example example
        ```

        :param str resource_name: The name of the resource.
        :param LogDeliveryDestinationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogDeliveryDestinationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_destination_name: Optional[pulumi.Input[builtins.str]] = None,
                 delivery_destination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogDeliveryDestinationPolicyArgs.__new__(LogDeliveryDestinationPolicyArgs)

            if delivery_destination_name is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_destination_name'")
            __props__.__dict__["delivery_destination_name"] = delivery_destination_name
            if delivery_destination_policy is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_destination_policy'")
            __props__.__dict__["delivery_destination_policy"] = delivery_destination_policy
            __props__.__dict__["region"] = region
        super(LogDeliveryDestinationPolicy, __self__).__init__(
            'aws:cloudwatch/logDeliveryDestinationPolicy:LogDeliveryDestinationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delivery_destination_name: Optional[pulumi.Input[builtins.str]] = None,
            delivery_destination_policy: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'LogDeliveryDestinationPolicy':
        """
        Get an existing LogDeliveryDestinationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] delivery_destination_name: The name of the delivery destination to assign this policy to.
        :param pulumi.Input[builtins.str] delivery_destination_policy: The contents of the policy.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogDeliveryDestinationPolicyState.__new__(_LogDeliveryDestinationPolicyState)

        __props__.__dict__["delivery_destination_name"] = delivery_destination_name
        __props__.__dict__["delivery_destination_policy"] = delivery_destination_policy
        __props__.__dict__["region"] = region
        return LogDeliveryDestinationPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deliveryDestinationName")
    def delivery_destination_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the delivery destination to assign this policy to.
        """
        return pulumi.get(self, "delivery_destination_name")

    @property
    @pulumi.getter(name="deliveryDestinationPolicy")
    def delivery_destination_policy(self) -> pulumi.Output[builtins.str]:
        """
        The contents of the policy.
        """
        return pulumi.get(self, "delivery_destination_policy")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

