# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricAlarmArgs', 'MetricAlarm']

@pulumi.input_type
class MetricAlarmArgs:
    def __init__(__self__, *,
                 comparison_operator: pulumi.Input[builtins.str],
                 evaluation_periods: pulumi.Input[builtins.int],
                 actions_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 alarm_description: Optional[pulumi.Input[builtins.str]] = None,
                 datapoints_to_alarm: Optional[pulumi.Input[builtins.int]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 evaluate_low_sample_count_percentiles: Optional[pulumi.Input[builtins.str]] = None,
                 extended_statistic: Optional[pulumi.Input[builtins.str]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 metric_name: Optional[pulumi.Input[builtins.str]] = None,
                 metric_queries: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlarmMetricQueryArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 period: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 statistic: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 threshold: Optional[pulumi.Input[builtins.float]] = None,
                 threshold_metric_id: Optional[pulumi.Input[builtins.str]] = None,
                 treat_missing_data: Optional[pulumi.Input[builtins.str]] = None,
                 unit: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MetricAlarm resource.
        :param pulumi.Input[builtins.str] comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`. Additionally, the values  `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
        :param pulumi.Input[builtins.int] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[builtins.bool] actions_enabled: Indicates whether or not actions should be executed during any changes to the alarm's state. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alarm_actions: The list of actions to execute when this alarm transitions into an ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] alarm_description: The description for the alarm.
        :param pulumi.Input[builtins.int] datapoints_to_alarm: The number of datapoints that must be breaching to trigger the alarm.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: The dimensions for the alarm's associated metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[builtins.str] evaluate_low_sample_count_percentiles: Used only for alarms based on percentiles.
               If you specify `ignore`, the alarm state will not change during periods with too few data points to be statistically significant.
               If you specify `evaluate` or omit this parameter, the alarm will always be evaluated and possibly change state no matter how many data points are available.
               The following values are supported: `ignore`, and `evaluate`.
        :param pulumi.Input[builtins.str] extended_statistic: The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] insufficient_data_actions: The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] metric_name: The name for the alarm's associated metric.
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[Sequence[pulumi.Input['MetricAlarmMetricQueryArgs']]] metric_queries: Enables you to create an alarm based on a metric math expression. You may specify at most 20.
        :param pulumi.Input[builtins.str] name: The descriptive name for the alarm. This name must be unique within the user's AWS account
        :param pulumi.Input[builtins.str] namespace: The namespace for the alarm's associated metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ok_actions: The list of actions to execute when this alarm transitions into an OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.int] period: The period in seconds over which the specified `statistic` is applied.
               Valid values are `10`, `20`, `30`, or any multiple of `60`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] statistic: The statistic to apply to the alarm's associated metric.
               Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               See [related part of AWS Docs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html)
               for details about valid values.
               
               > **NOTE:**  If you specify at least one `metric_query`, you may not specify a `metric_name`, `namespace`, `period` or `statistic`. If you do not specify a `metric_query`, you must specify each of these (although you may use `extended_statistic` instead of `statistic`).
        :param pulumi.Input[builtins.float] threshold: The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        :param pulumi.Input[builtins.str] threshold_metric_id: If this is an alarm based on an anomaly detection model, make this value match the ID of the ANOMALY_DETECTION_BAND function.
        :param pulumi.Input[builtins.str] treat_missing_data: Sets how this alarm is to handle missing data points. The following values are supported: `missing`, `ignore`, `breaching` and `notBreaching`. Defaults to `missing`.
        :param pulumi.Input[builtins.str] unit: The unit for the alarm's associated metric.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if actions_enabled is not None:
            pulumi.set(__self__, "actions_enabled", actions_enabled)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_description is not None:
            pulumi.set(__self__, "alarm_description", alarm_description)
        if datapoints_to_alarm is not None:
            pulumi.set(__self__, "datapoints_to_alarm", datapoints_to_alarm)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluate_low_sample_count_percentiles is not None:
            pulumi.set(__self__, "evaluate_low_sample_count_percentiles", evaluate_low_sample_count_percentiles)
        if extended_statistic is not None:
            pulumi.set(__self__, "extended_statistic", extended_statistic)
        if insufficient_data_actions is not None:
            pulumi.set(__self__, "insufficient_data_actions", insufficient_data_actions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metric_queries is not None:
            pulumi.set(__self__, "metric_queries", metric_queries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_metric_id is not None:
            pulumi.set(__self__, "threshold_metric_id", threshold_metric_id)
        if treat_missing_data is not None:
            pulumi.set(__self__, "treat_missing_data", treat_missing_data)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Input[builtins.str]:
        """
        The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`. Additionally, the values  `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Input[builtins.int]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter(name="actionsEnabled")
    def actions_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not actions should be executed during any changes to the alarm's state. Defaults to `true`.
        """
        return pulumi.get(self, "actions_enabled")

    @actions_enabled.setter
    def actions_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "actions_enabled", value)

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of actions to execute when this alarm transitions into an ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "alarm_actions", value)

    @property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the alarm.
        """
        return pulumi.get(self, "alarm_description")

    @alarm_description.setter
    def alarm_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alarm_description", value)

    @property
    @pulumi.getter(name="datapointsToAlarm")
    def datapoints_to_alarm(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of datapoints that must be breaching to trigger the alarm.
        """
        return pulumi.get(self, "datapoints_to_alarm")

    @datapoints_to_alarm.setter
    def datapoints_to_alarm(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "datapoints_to_alarm", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The dimensions for the alarm's associated metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="evaluateLowSampleCountPercentiles")
    def evaluate_low_sample_count_percentiles(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used only for alarms based on percentiles.
        If you specify `ignore`, the alarm state will not change during periods with too few data points to be statistically significant.
        If you specify `evaluate` or omit this parameter, the alarm will always be evaluated and possibly change state no matter how many data points are available.
        The following values are supported: `ignore`, and `evaluate`.
        """
        return pulumi.get(self, "evaluate_low_sample_count_percentiles")

    @evaluate_low_sample_count_percentiles.setter
    def evaluate_low_sample_count_percentiles(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "evaluate_low_sample_count_percentiles", value)

    @property
    @pulumi.getter(name="extendedStatistic")
    def extended_statistic(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
        """
        return pulumi.get(self, "extended_statistic")

    @extended_statistic.setter
    def extended_statistic(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extended_statistic", value)

    @property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "insufficient_data_actions")

    @insufficient_data_actions.setter
    def insufficient_data_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "insufficient_data_actions", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the alarm's associated metric.
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="metricQueries")
    def metric_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlarmMetricQueryArgs']]]]:
        """
        Enables you to create an alarm based on a metric math expression. You may specify at most 20.
        """
        return pulumi.get(self, "metric_queries")

    @metric_queries.setter
    def metric_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlarmMetricQueryArgs']]]]):
        pulumi.set(self, "metric_queries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The descriptive name for the alarm. This name must be unique within the user's AWS account
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace for the alarm's associated metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of actions to execute when this alarm transitions into an OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ok_actions", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The period in seconds over which the specified `statistic` is applied.
        Valid values are `10`, `20`, `30`, or any multiple of `60`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The statistic to apply to the alarm's associated metric.
        Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        See [related part of AWS Docs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html)
        for details about valid values.

        > **NOTE:**  If you specify at least one `metric_query`, you may not specify a `metric_name`, `namespace`, `period` or `statistic`. If you do not specify a `metric_query`, you must specify each of these (although you may use `extended_statistic` instead of `statistic`).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="thresholdMetricId")
    def threshold_metric_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If this is an alarm based on an anomaly detection model, make this value match the ID of the ANOMALY_DETECTION_BAND function.
        """
        return pulumi.get(self, "threshold_metric_id")

    @threshold_metric_id.setter
    def threshold_metric_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "threshold_metric_id", value)

    @property
    @pulumi.getter(name="treatMissingData")
    def treat_missing_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets how this alarm is to handle missing data points. The following values are supported: `missing`, `ignore`, `breaching` and `notBreaching`. Defaults to `missing`.
        """
        return pulumi.get(self, "treat_missing_data")

    @treat_missing_data.setter
    def treat_missing_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "treat_missing_data", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unit for the alarm's associated metric.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class _MetricAlarmState:
    def __init__(__self__, *,
                 actions_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 alarm_description: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 comparison_operator: Optional[pulumi.Input[builtins.str]] = None,
                 datapoints_to_alarm: Optional[pulumi.Input[builtins.int]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 evaluate_low_sample_count_percentiles: Optional[pulumi.Input[builtins.str]] = None,
                 evaluation_periods: Optional[pulumi.Input[builtins.int]] = None,
                 extended_statistic: Optional[pulumi.Input[builtins.str]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 metric_name: Optional[pulumi.Input[builtins.str]] = None,
                 metric_queries: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlarmMetricQueryArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 period: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 statistic: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 threshold: Optional[pulumi.Input[builtins.float]] = None,
                 threshold_metric_id: Optional[pulumi.Input[builtins.str]] = None,
                 treat_missing_data: Optional[pulumi.Input[builtins.str]] = None,
                 unit: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MetricAlarm resources.
        :param pulumi.Input[builtins.bool] actions_enabled: Indicates whether or not actions should be executed during any changes to the alarm's state. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alarm_actions: The list of actions to execute when this alarm transitions into an ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] alarm_description: The description for the alarm.
        :param pulumi.Input[builtins.str] arn: The ARN of the CloudWatch Metric Alarm.
        :param pulumi.Input[builtins.str] comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`. Additionally, the values  `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
        :param pulumi.Input[builtins.int] datapoints_to_alarm: The number of datapoints that must be breaching to trigger the alarm.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: The dimensions for the alarm's associated metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[builtins.str] evaluate_low_sample_count_percentiles: Used only for alarms based on percentiles.
               If you specify `ignore`, the alarm state will not change during periods with too few data points to be statistically significant.
               If you specify `evaluate` or omit this parameter, the alarm will always be evaluated and possibly change state no matter how many data points are available.
               The following values are supported: `ignore`, and `evaluate`.
        :param pulumi.Input[builtins.int] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[builtins.str] extended_statistic: The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] insufficient_data_actions: The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] metric_name: The name for the alarm's associated metric.
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[Sequence[pulumi.Input['MetricAlarmMetricQueryArgs']]] metric_queries: Enables you to create an alarm based on a metric math expression. You may specify at most 20.
        :param pulumi.Input[builtins.str] name: The descriptive name for the alarm. This name must be unique within the user's AWS account
        :param pulumi.Input[builtins.str] namespace: The namespace for the alarm's associated metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ok_actions: The list of actions to execute when this alarm transitions into an OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.int] period: The period in seconds over which the specified `statistic` is applied.
               Valid values are `10`, `20`, `30`, or any multiple of `60`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] statistic: The statistic to apply to the alarm's associated metric.
               Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               See [related part of AWS Docs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html)
               for details about valid values.
               
               > **NOTE:**  If you specify at least one `metric_query`, you may not specify a `metric_name`, `namespace`, `period` or `statistic`. If you do not specify a `metric_query`, you must specify each of these (although you may use `extended_statistic` instead of `statistic`).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.float] threshold: The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        :param pulumi.Input[builtins.str] threshold_metric_id: If this is an alarm based on an anomaly detection model, make this value match the ID of the ANOMALY_DETECTION_BAND function.
        :param pulumi.Input[builtins.str] treat_missing_data: Sets how this alarm is to handle missing data points. The following values are supported: `missing`, `ignore`, `breaching` and `notBreaching`. Defaults to `missing`.
        :param pulumi.Input[builtins.str] unit: The unit for the alarm's associated metric.
        """
        if actions_enabled is not None:
            pulumi.set(__self__, "actions_enabled", actions_enabled)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_description is not None:
            pulumi.set(__self__, "alarm_description", alarm_description)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if datapoints_to_alarm is not None:
            pulumi.set(__self__, "datapoints_to_alarm", datapoints_to_alarm)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluate_low_sample_count_percentiles is not None:
            pulumi.set(__self__, "evaluate_low_sample_count_percentiles", evaluate_low_sample_count_percentiles)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if extended_statistic is not None:
            pulumi.set(__self__, "extended_statistic", extended_statistic)
        if insufficient_data_actions is not None:
            pulumi.set(__self__, "insufficient_data_actions", insufficient_data_actions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metric_queries is not None:
            pulumi.set(__self__, "metric_queries", metric_queries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_metric_id is not None:
            pulumi.set(__self__, "threshold_metric_id", threshold_metric_id)
        if treat_missing_data is not None:
            pulumi.set(__self__, "treat_missing_data", treat_missing_data)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="actionsEnabled")
    def actions_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not actions should be executed during any changes to the alarm's state. Defaults to `true`.
        """
        return pulumi.get(self, "actions_enabled")

    @actions_enabled.setter
    def actions_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "actions_enabled", value)

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of actions to execute when this alarm transitions into an ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "alarm_actions", value)

    @property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the alarm.
        """
        return pulumi.get(self, "alarm_description")

    @alarm_description.setter
    def alarm_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alarm_description", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the CloudWatch Metric Alarm.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`. Additionally, the values  `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="datapointsToAlarm")
    def datapoints_to_alarm(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of datapoints that must be breaching to trigger the alarm.
        """
        return pulumi.get(self, "datapoints_to_alarm")

    @datapoints_to_alarm.setter
    def datapoints_to_alarm(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "datapoints_to_alarm", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The dimensions for the alarm's associated metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="evaluateLowSampleCountPercentiles")
    def evaluate_low_sample_count_percentiles(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used only for alarms based on percentiles.
        If you specify `ignore`, the alarm state will not change during periods with too few data points to be statistically significant.
        If you specify `evaluate` or omit this parameter, the alarm will always be evaluated and possibly change state no matter how many data points are available.
        The following values are supported: `ignore`, and `evaluate`.
        """
        return pulumi.get(self, "evaluate_low_sample_count_percentiles")

    @evaluate_low_sample_count_percentiles.setter
    def evaluate_low_sample_count_percentiles(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "evaluate_low_sample_count_percentiles", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter(name="extendedStatistic")
    def extended_statistic(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
        """
        return pulumi.get(self, "extended_statistic")

    @extended_statistic.setter
    def extended_statistic(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extended_statistic", value)

    @property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "insufficient_data_actions")

    @insufficient_data_actions.setter
    def insufficient_data_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "insufficient_data_actions", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the alarm's associated metric.
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="metricQueries")
    def metric_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlarmMetricQueryArgs']]]]:
        """
        Enables you to create an alarm based on a metric math expression. You may specify at most 20.
        """
        return pulumi.get(self, "metric_queries")

    @metric_queries.setter
    def metric_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlarmMetricQueryArgs']]]]):
        pulumi.set(self, "metric_queries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The descriptive name for the alarm. This name must be unique within the user's AWS account
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace for the alarm's associated metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of actions to execute when this alarm transitions into an OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ok_actions", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The period in seconds over which the specified `statistic` is applied.
        Valid values are `10`, `20`, `30`, or any multiple of `60`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The statistic to apply to the alarm's associated metric.
        Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        See [related part of AWS Docs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html)
        for details about valid values.

        > **NOTE:**  If you specify at least one `metric_query`, you may not specify a `metric_name`, `namespace`, `period` or `statistic`. If you do not specify a `metric_query`, you must specify each of these (although you may use `extended_statistic` instead of `statistic`).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="thresholdMetricId")
    def threshold_metric_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If this is an alarm based on an anomaly detection model, make this value match the ID of the ANOMALY_DETECTION_BAND function.
        """
        return pulumi.get(self, "threshold_metric_id")

    @threshold_metric_id.setter
    def threshold_metric_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "threshold_metric_id", value)

    @property
    @pulumi.getter(name="treatMissingData")
    def treat_missing_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets how this alarm is to handle missing data points. The following values are supported: `missing`, `ignore`, `breaching` and `notBreaching`. Defaults to `missing`.
        """
        return pulumi.get(self, "treat_missing_data")

    @treat_missing_data.setter
    def treat_missing_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "treat_missing_data", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unit for the alarm's associated metric.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unit", value)


@pulumi.type_token("aws:cloudwatch/metricAlarm:MetricAlarm")
class MetricAlarm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 alarm_description: Optional[pulumi.Input[builtins.str]] = None,
                 comparison_operator: Optional[pulumi.Input[builtins.str]] = None,
                 datapoints_to_alarm: Optional[pulumi.Input[builtins.int]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 evaluate_low_sample_count_percentiles: Optional[pulumi.Input[builtins.str]] = None,
                 evaluation_periods: Optional[pulumi.Input[builtins.int]] = None,
                 extended_statistic: Optional[pulumi.Input[builtins.str]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 metric_name: Optional[pulumi.Input[builtins.str]] = None,
                 metric_queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricAlarmMetricQueryArgs', 'MetricAlarmMetricQueryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 period: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 statistic: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 threshold: Optional[pulumi.Input[builtins.float]] = None,
                 threshold_metric_id: Optional[pulumi.Input[builtins.str]] = None,
                 treat_missing_data: Optional[pulumi.Input[builtins.str]] = None,
                 unit: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a CloudWatch Metric Alarm resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        foobar = aws.cloudwatch.MetricAlarm("foobar",
            name="test-foobar5",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=2,
            metric_name="CPUUtilization",
            namespace="AWS/EC2",
            period=120,
            statistic="Average",
            threshold=80,
            alarm_description="This metric monitors ec2 cpu utilization",
            insufficient_data_actions=[])
        ```

        ## Example in Conjunction with Scaling Policies

        ```python
        import pulumi
        import pulumi_aws as aws

        bat = aws.autoscaling.Policy("bat",
            name="foobar3-test",
            scaling_adjustment=4,
            adjustment_type="ChangeInCapacity",
            cooldown=300,
            autoscaling_group_name=bar["name"])
        bat_metric_alarm = aws.cloudwatch.MetricAlarm("bat",
            name="test-foobar5",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=2,
            metric_name="CPUUtilization",
            namespace="AWS/EC2",
            period=120,
            statistic="Average",
            threshold=80,
            dimensions={
                "AutoScalingGroupName": bar["name"],
            },
            alarm_description="This metric monitors ec2 cpu utilization",
            alarm_actions=[bat.arn])
        ```

        ## Example with an Expression

        ```python
        import pulumi
        import pulumi_aws as aws

        foobar = aws.cloudwatch.MetricAlarm("foobar",
            name="test-foobar",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=2,
            threshold=10,
            alarm_description="Request error rate has exceeded 10%",
            insufficient_data_actions=[],
            metric_queries=[
                {
                    "id": "e1",
                    "expression": "m2/m1*100",
                    "label": "Error Rate",
                    "return_data": True,
                },
                {
                    "id": "m1",
                    "metric": {
                        "metric_name": "RequestCount",
                        "namespace": "AWS/ApplicationELB",
                        "period": 120,
                        "stat": "Sum",
                        "unit": "Count",
                        "dimensions": {
                            "LoadBalancer": "app/web",
                        },
                    },
                },
                {
                    "id": "m2",
                    "metric": {
                        "metric_name": "HTTPCode_ELB_5XX_Count",
                        "namespace": "AWS/ApplicationELB",
                        "period": 120,
                        "stat": "Sum",
                        "unit": "Count",
                        "dimensions": {
                            "LoadBalancer": "app/web",
                        },
                    },
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_aws as aws

        xx_anomaly_detection = aws.cloudwatch.MetricAlarm("xx_anomaly_detection",
            name="test-foobar",
            comparison_operator="GreaterThanUpperThreshold",
            evaluation_periods=2,
            threshold_metric_id="e1",
            alarm_description="This metric monitors ec2 cpu utilization",
            insufficient_data_actions=[],
            metric_queries=[
                {
                    "id": "e1",
                    "return_data": True,
                    "expression": "ANOMALY_DETECTION_BAND(m1)",
                    "label": "CPUUtilization (Expected)",
                },
                {
                    "id": "m1",
                    "return_data": True,
                    "metric": {
                        "metric_name": "CPUUtilization",
                        "namespace": "AWS/EC2",
                        "period": 120,
                        "stat": "Average",
                        "unit": "Count",
                        "dimensions": {
                            "InstanceId": "i-abc123",
                        },
                    },
                },
            ])
        ```

        ## Example of monitoring Healthy Hosts on NLB using Target Group and NLB

        ```python
        import pulumi
        import pulumi_aws as aws

        nlb_healthyhosts = aws.cloudwatch.MetricAlarm("nlb_healthyhosts",
            name="alarmname",
            comparison_operator="LessThanThreshold",
            evaluation_periods=1,
            metric_name="HealthyHostCount",
            namespace="AWS/NetworkELB",
            period=60,
            statistic="Average",
            threshold=logstash_servers_count,
            alarm_description="Number of healthy nodes in Target Group",
            actions_enabled=True,
            alarm_actions=[sns["arn"]],
            ok_actions=[sns["arn"]],
            dimensions={
                "TargetGroup": lb_tg["arnSuffix"],
                "LoadBalancer": lb["arnSuffix"],
            })
        ```

        > **NOTE:**  You cannot create a metric alarm consisting of both `statistic` and `extended_statistic` parameters.
        You must choose one or the other

        ## Import

        Using `pulumi import`, import CloudWatch Metric Alarm using the `alarm_name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/metricAlarm:MetricAlarm test alarm-12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] actions_enabled: Indicates whether or not actions should be executed during any changes to the alarm's state. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alarm_actions: The list of actions to execute when this alarm transitions into an ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] alarm_description: The description for the alarm.
        :param pulumi.Input[builtins.str] comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`. Additionally, the values  `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
        :param pulumi.Input[builtins.int] datapoints_to_alarm: The number of datapoints that must be breaching to trigger the alarm.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: The dimensions for the alarm's associated metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[builtins.str] evaluate_low_sample_count_percentiles: Used only for alarms based on percentiles.
               If you specify `ignore`, the alarm state will not change during periods with too few data points to be statistically significant.
               If you specify `evaluate` or omit this parameter, the alarm will always be evaluated and possibly change state no matter how many data points are available.
               The following values are supported: `ignore`, and `evaluate`.
        :param pulumi.Input[builtins.int] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[builtins.str] extended_statistic: The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] insufficient_data_actions: The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] metric_name: The name for the alarm's associated metric.
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricAlarmMetricQueryArgs', 'MetricAlarmMetricQueryArgsDict']]]] metric_queries: Enables you to create an alarm based on a metric math expression. You may specify at most 20.
        :param pulumi.Input[builtins.str] name: The descriptive name for the alarm. This name must be unique within the user's AWS account
        :param pulumi.Input[builtins.str] namespace: The namespace for the alarm's associated metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ok_actions: The list of actions to execute when this alarm transitions into an OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.int] period: The period in seconds over which the specified `statistic` is applied.
               Valid values are `10`, `20`, `30`, or any multiple of `60`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] statistic: The statistic to apply to the alarm's associated metric.
               Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               See [related part of AWS Docs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html)
               for details about valid values.
               
               > **NOTE:**  If you specify at least one `metric_query`, you may not specify a `metric_name`, `namespace`, `period` or `statistic`. If you do not specify a `metric_query`, you must specify each of these (although you may use `extended_statistic` instead of `statistic`).
        :param pulumi.Input[builtins.float] threshold: The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        :param pulumi.Input[builtins.str] threshold_metric_id: If this is an alarm based on an anomaly detection model, make this value match the ID of the ANOMALY_DETECTION_BAND function.
        :param pulumi.Input[builtins.str] treat_missing_data: Sets how this alarm is to handle missing data points. The following values are supported: `missing`, `ignore`, `breaching` and `notBreaching`. Defaults to `missing`.
        :param pulumi.Input[builtins.str] unit: The unit for the alarm's associated metric.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricAlarmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudWatch Metric Alarm resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        foobar = aws.cloudwatch.MetricAlarm("foobar",
            name="test-foobar5",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=2,
            metric_name="CPUUtilization",
            namespace="AWS/EC2",
            period=120,
            statistic="Average",
            threshold=80,
            alarm_description="This metric monitors ec2 cpu utilization",
            insufficient_data_actions=[])
        ```

        ## Example in Conjunction with Scaling Policies

        ```python
        import pulumi
        import pulumi_aws as aws

        bat = aws.autoscaling.Policy("bat",
            name="foobar3-test",
            scaling_adjustment=4,
            adjustment_type="ChangeInCapacity",
            cooldown=300,
            autoscaling_group_name=bar["name"])
        bat_metric_alarm = aws.cloudwatch.MetricAlarm("bat",
            name="test-foobar5",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=2,
            metric_name="CPUUtilization",
            namespace="AWS/EC2",
            period=120,
            statistic="Average",
            threshold=80,
            dimensions={
                "AutoScalingGroupName": bar["name"],
            },
            alarm_description="This metric monitors ec2 cpu utilization",
            alarm_actions=[bat.arn])
        ```

        ## Example with an Expression

        ```python
        import pulumi
        import pulumi_aws as aws

        foobar = aws.cloudwatch.MetricAlarm("foobar",
            name="test-foobar",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=2,
            threshold=10,
            alarm_description="Request error rate has exceeded 10%",
            insufficient_data_actions=[],
            metric_queries=[
                {
                    "id": "e1",
                    "expression": "m2/m1*100",
                    "label": "Error Rate",
                    "return_data": True,
                },
                {
                    "id": "m1",
                    "metric": {
                        "metric_name": "RequestCount",
                        "namespace": "AWS/ApplicationELB",
                        "period": 120,
                        "stat": "Sum",
                        "unit": "Count",
                        "dimensions": {
                            "LoadBalancer": "app/web",
                        },
                    },
                },
                {
                    "id": "m2",
                    "metric": {
                        "metric_name": "HTTPCode_ELB_5XX_Count",
                        "namespace": "AWS/ApplicationELB",
                        "period": 120,
                        "stat": "Sum",
                        "unit": "Count",
                        "dimensions": {
                            "LoadBalancer": "app/web",
                        },
                    },
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_aws as aws

        xx_anomaly_detection = aws.cloudwatch.MetricAlarm("xx_anomaly_detection",
            name="test-foobar",
            comparison_operator="GreaterThanUpperThreshold",
            evaluation_periods=2,
            threshold_metric_id="e1",
            alarm_description="This metric monitors ec2 cpu utilization",
            insufficient_data_actions=[],
            metric_queries=[
                {
                    "id": "e1",
                    "return_data": True,
                    "expression": "ANOMALY_DETECTION_BAND(m1)",
                    "label": "CPUUtilization (Expected)",
                },
                {
                    "id": "m1",
                    "return_data": True,
                    "metric": {
                        "metric_name": "CPUUtilization",
                        "namespace": "AWS/EC2",
                        "period": 120,
                        "stat": "Average",
                        "unit": "Count",
                        "dimensions": {
                            "InstanceId": "i-abc123",
                        },
                    },
                },
            ])
        ```

        ## Example of monitoring Healthy Hosts on NLB using Target Group and NLB

        ```python
        import pulumi
        import pulumi_aws as aws

        nlb_healthyhosts = aws.cloudwatch.MetricAlarm("nlb_healthyhosts",
            name="alarmname",
            comparison_operator="LessThanThreshold",
            evaluation_periods=1,
            metric_name="HealthyHostCount",
            namespace="AWS/NetworkELB",
            period=60,
            statistic="Average",
            threshold=logstash_servers_count,
            alarm_description="Number of healthy nodes in Target Group",
            actions_enabled=True,
            alarm_actions=[sns["arn"]],
            ok_actions=[sns["arn"]],
            dimensions={
                "TargetGroup": lb_tg["arnSuffix"],
                "LoadBalancer": lb["arnSuffix"],
            })
        ```

        > **NOTE:**  You cannot create a metric alarm consisting of both `statistic` and `extended_statistic` parameters.
        You must choose one or the other

        ## Import

        Using `pulumi import`, import CloudWatch Metric Alarm using the `alarm_name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/metricAlarm:MetricAlarm test alarm-12345
        ```

        :param str resource_name: The name of the resource.
        :param MetricAlarmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricAlarmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 alarm_description: Optional[pulumi.Input[builtins.str]] = None,
                 comparison_operator: Optional[pulumi.Input[builtins.str]] = None,
                 datapoints_to_alarm: Optional[pulumi.Input[builtins.int]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 evaluate_low_sample_count_percentiles: Optional[pulumi.Input[builtins.str]] = None,
                 evaluation_periods: Optional[pulumi.Input[builtins.int]] = None,
                 extended_statistic: Optional[pulumi.Input[builtins.str]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 metric_name: Optional[pulumi.Input[builtins.str]] = None,
                 metric_queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricAlarmMetricQueryArgs', 'MetricAlarmMetricQueryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 period: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 statistic: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 threshold: Optional[pulumi.Input[builtins.float]] = None,
                 threshold_metric_id: Optional[pulumi.Input[builtins.str]] = None,
                 treat_missing_data: Optional[pulumi.Input[builtins.str]] = None,
                 unit: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricAlarmArgs.__new__(MetricAlarmArgs)

            __props__.__dict__["actions_enabled"] = actions_enabled
            __props__.__dict__["alarm_actions"] = alarm_actions
            __props__.__dict__["alarm_description"] = alarm_description
            if comparison_operator is None and not opts.urn:
                raise TypeError("Missing required property 'comparison_operator'")
            __props__.__dict__["comparison_operator"] = comparison_operator
            __props__.__dict__["datapoints_to_alarm"] = datapoints_to_alarm
            __props__.__dict__["dimensions"] = dimensions
            __props__.__dict__["evaluate_low_sample_count_percentiles"] = evaluate_low_sample_count_percentiles
            if evaluation_periods is None and not opts.urn:
                raise TypeError("Missing required property 'evaluation_periods'")
            __props__.__dict__["evaluation_periods"] = evaluation_periods
            __props__.__dict__["extended_statistic"] = extended_statistic
            __props__.__dict__["insufficient_data_actions"] = insufficient_data_actions
            __props__.__dict__["metric_name"] = metric_name
            __props__.__dict__["metric_queries"] = metric_queries
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["ok_actions"] = ok_actions
            __props__.__dict__["period"] = period
            __props__.__dict__["region"] = region
            __props__.__dict__["statistic"] = statistic
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threshold"] = threshold
            __props__.__dict__["threshold_metric_id"] = threshold_metric_id
            __props__.__dict__["treat_missing_data"] = treat_missing_data
            __props__.__dict__["unit"] = unit
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(MetricAlarm, __self__).__init__(
            'aws:cloudwatch/metricAlarm:MetricAlarm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            alarm_description: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            comparison_operator: Optional[pulumi.Input[builtins.str]] = None,
            datapoints_to_alarm: Optional[pulumi.Input[builtins.int]] = None,
            dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            evaluate_low_sample_count_percentiles: Optional[pulumi.Input[builtins.str]] = None,
            evaluation_periods: Optional[pulumi.Input[builtins.int]] = None,
            extended_statistic: Optional[pulumi.Input[builtins.str]] = None,
            insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            metric_name: Optional[pulumi.Input[builtins.str]] = None,
            metric_queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricAlarmMetricQueryArgs', 'MetricAlarmMetricQueryArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            period: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            statistic: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            threshold: Optional[pulumi.Input[builtins.float]] = None,
            threshold_metric_id: Optional[pulumi.Input[builtins.str]] = None,
            treat_missing_data: Optional[pulumi.Input[builtins.str]] = None,
            unit: Optional[pulumi.Input[builtins.str]] = None) -> 'MetricAlarm':
        """
        Get an existing MetricAlarm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] actions_enabled: Indicates whether or not actions should be executed during any changes to the alarm's state. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alarm_actions: The list of actions to execute when this alarm transitions into an ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] alarm_description: The description for the alarm.
        :param pulumi.Input[builtins.str] arn: The ARN of the CloudWatch Metric Alarm.
        :param pulumi.Input[builtins.str] comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`. Additionally, the values  `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
        :param pulumi.Input[builtins.int] datapoints_to_alarm: The number of datapoints that must be breaching to trigger the alarm.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: The dimensions for the alarm's associated metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[builtins.str] evaluate_low_sample_count_percentiles: Used only for alarms based on percentiles.
               If you specify `ignore`, the alarm state will not change during periods with too few data points to be statistically significant.
               If you specify `evaluate` or omit this parameter, the alarm will always be evaluated and possibly change state no matter how many data points are available.
               The following values are supported: `ignore`, and `evaluate`.
        :param pulumi.Input[builtins.int] evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param pulumi.Input[builtins.str] extended_statistic: The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] insufficient_data_actions: The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] metric_name: The name for the alarm's associated metric.
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricAlarmMetricQueryArgs', 'MetricAlarmMetricQueryArgsDict']]]] metric_queries: Enables you to create an alarm based on a metric math expression. You may specify at most 20.
        :param pulumi.Input[builtins.str] name: The descriptive name for the alarm. This name must be unique within the user's AWS account
        :param pulumi.Input[builtins.str] namespace: The namespace for the alarm's associated metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ok_actions: The list of actions to execute when this alarm transitions into an OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.int] period: The period in seconds over which the specified `statistic` is applied.
               Valid values are `10`, `20`, `30`, or any multiple of `60`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] statistic: The statistic to apply to the alarm's associated metric.
               Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               See [related part of AWS Docs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html)
               for details about valid values.
               
               > **NOTE:**  If you specify at least one `metric_query`, you may not specify a `metric_name`, `namespace`, `period` or `statistic`. If you do not specify a `metric_query`, you must specify each of these (although you may use `extended_statistic` instead of `statistic`).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.float] threshold: The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        :param pulumi.Input[builtins.str] threshold_metric_id: If this is an alarm based on an anomaly detection model, make this value match the ID of the ANOMALY_DETECTION_BAND function.
        :param pulumi.Input[builtins.str] treat_missing_data: Sets how this alarm is to handle missing data points. The following values are supported: `missing`, `ignore`, `breaching` and `notBreaching`. Defaults to `missing`.
        :param pulumi.Input[builtins.str] unit: The unit for the alarm's associated metric.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricAlarmState.__new__(_MetricAlarmState)

        __props__.__dict__["actions_enabled"] = actions_enabled
        __props__.__dict__["alarm_actions"] = alarm_actions
        __props__.__dict__["alarm_description"] = alarm_description
        __props__.__dict__["arn"] = arn
        __props__.__dict__["comparison_operator"] = comparison_operator
        __props__.__dict__["datapoints_to_alarm"] = datapoints_to_alarm
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["evaluate_low_sample_count_percentiles"] = evaluate_low_sample_count_percentiles
        __props__.__dict__["evaluation_periods"] = evaluation_periods
        __props__.__dict__["extended_statistic"] = extended_statistic
        __props__.__dict__["insufficient_data_actions"] = insufficient_data_actions
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["metric_queries"] = metric_queries
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["ok_actions"] = ok_actions
        __props__.__dict__["period"] = period
        __props__.__dict__["region"] = region
        __props__.__dict__["statistic"] = statistic
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["threshold_metric_id"] = threshold_metric_id
        __props__.__dict__["treat_missing_data"] = treat_missing_data
        __props__.__dict__["unit"] = unit
        return MetricAlarm(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionsEnabled")
    def actions_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether or not actions should be executed during any changes to the alarm's state. Defaults to `true`.
        """
        return pulumi.get(self, "actions_enabled")

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of actions to execute when this alarm transitions into an ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "alarm_actions")

    @property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description for the alarm.
        """
        return pulumi.get(self, "alarm_description")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the CloudWatch Metric Alarm.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Output[builtins.str]:
        """
        The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Either of the following is supported: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanThreshold`, `LessThanOrEqualToThreshold`. Additionally, the values  `LessThanLowerOrGreaterThanUpperThreshold`, `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only for alarms based on anomaly detection models.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="datapointsToAlarm")
    def datapoints_to_alarm(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of datapoints that must be breaching to trigger the alarm.
        """
        return pulumi.get(self, "datapoints_to_alarm")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The dimensions for the alarm's associated metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluateLowSampleCountPercentiles")
    def evaluate_low_sample_count_percentiles(self) -> pulumi.Output[builtins.str]:
        """
        Used only for alarms based on percentiles.
        If you specify `ignore`, the alarm state will not change during periods with too few data points to be statistically significant.
        If you specify `evaluate` or omit this parameter, the alarm will always be evaluated and possibly change state no matter how many data points are available.
        The following values are supported: `ignore`, and `evaluate`.
        """
        return pulumi.get(self, "evaluate_low_sample_count_percentiles")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Output[builtins.int]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="extendedStatistic")
    def extended_statistic(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
        """
        return pulumi.get(self, "extended_statistic")

    @property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of actions to execute when this alarm transitions into an INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "insufficient_data_actions")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name for the alarm's associated metric.
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="metricQueries")
    def metric_queries(self) -> pulumi.Output[Optional[Sequence['outputs.MetricAlarmMetricQuery']]]:
        """
        Enables you to create an alarm based on a metric math expression. You may specify at most 20.
        """
        return pulumi.get(self, "metric_queries")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The descriptive name for the alarm. This name must be unique within the user's AWS account
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The namespace for the alarm's associated metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of actions to execute when this alarm transitions into an OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "ok_actions")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The period in seconds over which the specified `statistic` is applied.
        Valid values are `10`, `20`, `30`, or any multiple of `60`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The statistic to apply to the alarm's associated metric.
        Either of the following is supported: `SampleCount`, `Average`, `Sum`, `Minimum`, `Maximum`
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        See [related part of AWS Docs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html)
        for details about valid values.

        > **NOTE:**  If you specify at least one `metric_query`, you may not specify a `metric_name`, `namespace`, `period` or `statistic`. If you do not specify a `metric_query`, you must specify each of these (although you may use `extended_statistic` instead of `statistic`).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The value against which the specified statistic is compared. This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="thresholdMetricId")
    def threshold_metric_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If this is an alarm based on an anomaly detection model, make this value match the ID of the ANOMALY_DETECTION_BAND function.
        """
        return pulumi.get(self, "threshold_metric_id")

    @property
    @pulumi.getter(name="treatMissingData")
    def treat_missing_data(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets how this alarm is to handle missing data points. The following values are supported: `missing`, `ignore`, `breaching` and `notBreaching`. Defaults to `missing`.
        """
        return pulumi.get(self, "treat_missing_data")

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The unit for the alarm's associated metric.
        """
        return pulumi.get(self, "unit")

