# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAuthorizationTokenResult',
    'AwaitableGetAuthorizationTokenResult',
    'get_authorization_token',
    'get_authorization_token_output',
]

@pulumi.output_type
class GetAuthorizationTokenResult:
    """
    A collection of values returned by getAuthorizationToken.
    """
    def __init__(__self__, authorization_token=None, domain=None, domain_owner=None, duration_seconds=None, expiration=None, id=None, region=None):
        if authorization_token and not isinstance(authorization_token, str):
            raise TypeError("Expected argument 'authorization_token' to be a str")
        pulumi.set(__self__, "authorization_token", authorization_token)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if domain_owner and not isinstance(domain_owner, str):
            raise TypeError("Expected argument 'domain_owner' to be a str")
        pulumi.set(__self__, "domain_owner", domain_owner)
        if duration_seconds and not isinstance(duration_seconds, int):
            raise TypeError("Expected argument 'duration_seconds' to be a int")
        pulumi.set(__self__, "duration_seconds", duration_seconds)
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="authorizationToken")
    def authorization_token(self) -> builtins.str:
        """
        Temporary authorization token.
        """
        return pulumi.get(self, "authorization_token")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainOwner")
    def domain_owner(self) -> builtins.str:
        return pulumi.get(self, "domain_owner")

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "duration_seconds")

    @property
    @pulumi.getter
    def expiration(self) -> builtins.str:
        """
        Time in UTC RFC3339 format when the authorization token expires.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetAuthorizationTokenResult(GetAuthorizationTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthorizationTokenResult(
            authorization_token=self.authorization_token,
            domain=self.domain,
            domain_owner=self.domain_owner,
            duration_seconds=self.duration_seconds,
            expiration=self.expiration,
            id=self.id,
            region=self.region)


def get_authorization_token(domain: Optional[builtins.str] = None,
                            domain_owner: Optional[builtins.str] = None,
                            duration_seconds: Optional[builtins.int] = None,
                            region: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthorizationTokenResult:
    """
    The CodeArtifact Authorization Token data source generates a temporary authentication token for accessing repositories in a CodeArtifact domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.codeartifact.get_authorization_token(domain=test_aws_codeartifact_domain["domain"])
    ```


    :param builtins.str domain: Name of the domain that is in scope for the generated authorization token.
    :param builtins.str domain_owner: Account number of the AWS account that owns the domain.
    :param builtins.int duration_seconds: Time, in seconds, that the generated authorization token is valid. Valid values are `0` and between `900` and `43200`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['domainOwner'] = domain_owner
    __args__['durationSeconds'] = duration_seconds
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:codeartifact/getAuthorizationToken:getAuthorizationToken', __args__, opts=opts, typ=GetAuthorizationTokenResult).value

    return AwaitableGetAuthorizationTokenResult(
        authorization_token=pulumi.get(__ret__, 'authorization_token'),
        domain=pulumi.get(__ret__, 'domain'),
        domain_owner=pulumi.get(__ret__, 'domain_owner'),
        duration_seconds=pulumi.get(__ret__, 'duration_seconds'),
        expiration=pulumi.get(__ret__, 'expiration'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_authorization_token_output(domain: Optional[pulumi.Input[builtins.str]] = None,
                                   domain_owner: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   duration_seconds: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                   region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthorizationTokenResult]:
    """
    The CodeArtifact Authorization Token data source generates a temporary authentication token for accessing repositories in a CodeArtifact domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.codeartifact.get_authorization_token(domain=test_aws_codeartifact_domain["domain"])
    ```


    :param builtins.str domain: Name of the domain that is in scope for the generated authorization token.
    :param builtins.str domain_owner: Account number of the AWS account that owns the domain.
    :param builtins.int duration_seconds: Time, in seconds, that the generated authorization token is valid. Valid values are `0` and between `900` and `43200`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['domainOwner'] = domain_owner
    __args__['durationSeconds'] = duration_seconds
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:codeartifact/getAuthorizationToken:getAuthorizationToken', __args__, opts=opts, typ=GetAuthorizationTokenResult)
    return __ret__.apply(lambda __response__: GetAuthorizationTokenResult(
        authorization_token=pulumi.get(__response__, 'authorization_token'),
        domain=pulumi.get(__response__, 'domain'),
        domain_owner=pulumi.get(__response__, 'domain_owner'),
        duration_seconds=pulumi.get(__response__, 'duration_seconds'),
        expiration=pulumi.get(__response__, 'expiration'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
