# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFleetResult',
    'AwaitableGetFleetResult',
    'get_fleet',
    'get_fleet_output',
]

@pulumi.output_type
class GetFleetResult:
    """
    A collection of values returned by getFleet.
    """
    def __init__(__self__, arn=None, base_capacity=None, compute_configurations=None, compute_type=None, created=None, environment_type=None, fleet_service_role=None, id=None, image_id=None, last_modified=None, name=None, overflow_behavior=None, region=None, scaling_configurations=None, statuses=None, tags=None, vpc_configs=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if base_capacity and not isinstance(base_capacity, int):
            raise TypeError("Expected argument 'base_capacity' to be a int")
        pulumi.set(__self__, "base_capacity", base_capacity)
        if compute_configurations and not isinstance(compute_configurations, list):
            raise TypeError("Expected argument 'compute_configurations' to be a list")
        pulumi.set(__self__, "compute_configurations", compute_configurations)
        if compute_type and not isinstance(compute_type, str):
            raise TypeError("Expected argument 'compute_type' to be a str")
        pulumi.set(__self__, "compute_type", compute_type)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if environment_type and not isinstance(environment_type, str):
            raise TypeError("Expected argument 'environment_type' to be a str")
        pulumi.set(__self__, "environment_type", environment_type)
        if fleet_service_role and not isinstance(fleet_service_role, str):
            raise TypeError("Expected argument 'fleet_service_role' to be a str")
        pulumi.set(__self__, "fleet_service_role", fleet_service_role)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        pulumi.set(__self__, "last_modified", last_modified)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if overflow_behavior and not isinstance(overflow_behavior, str):
            raise TypeError("Expected argument 'overflow_behavior' to be a str")
        pulumi.set(__self__, "overflow_behavior", overflow_behavior)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if scaling_configurations and not isinstance(scaling_configurations, list):
            raise TypeError("Expected argument 'scaling_configurations' to be a list")
        pulumi.set(__self__, "scaling_configurations", scaling_configurations)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_configs and not isinstance(vpc_configs, list):
            raise TypeError("Expected argument 'vpc_configs' to be a list")
        pulumi.set(__self__, "vpc_configs", vpc_configs)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the Fleet.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> builtins.int:
        """
        Number of machines allocated to the ﬂeet.
        """
        return pulumi.get(self, "base_capacity")

    @property
    @pulumi.getter(name="computeConfigurations")
    def compute_configurations(self) -> Sequence['outputs.GetFleetComputeConfigurationResult']:
        """
        Compute configuration of the compute fleet.
        """
        return pulumi.get(self, "compute_configurations")

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> builtins.str:
        """
        Compute resources the compute fleet uses.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter
    def created(self) -> builtins.str:
        """
        Creation time of the fleet.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> builtins.str:
        """
        Environment type of the compute fleet.
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="fleetServiceRole")
    def fleet_service_role(self) -> builtins.str:
        """
        The service role associated with the compute fleet.
        """
        return pulumi.get(self, "fleet_service_role")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ARN of the Fleet.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        The Amazon Machine Image (AMI) of the compute fleet.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> builtins.str:
        """
        Last modification time of the fleet.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overflowBehavior")
    def overflow_behavior(self) -> builtins.str:
        """
        Overflow behavior for compute fleet.
        """
        return pulumi.get(self, "overflow_behavior")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="scalingConfigurations")
    def scaling_configurations(self) -> Sequence['outputs.GetFleetScalingConfigurationResult']:
        """
        Nested attribute containing information about the scaling configuration.
        """
        return pulumi.get(self, "scaling_configurations")

    @property
    @pulumi.getter
    def statuses(self) -> Sequence['outputs.GetFleetStatusResult']:
        """
        Nested attribute containing information about the current status of the fleet.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Mapping of Key-Value tags for the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcConfigs")
    def vpc_configs(self) -> Sequence['outputs.GetFleetVpcConfigResult']:
        """
        Nested attribute containing information about the VPC configuration.
        """
        return pulumi.get(self, "vpc_configs")


class AwaitableGetFleetResult(GetFleetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetResult(
            arn=self.arn,
            base_capacity=self.base_capacity,
            compute_configurations=self.compute_configurations,
            compute_type=self.compute_type,
            created=self.created,
            environment_type=self.environment_type,
            fleet_service_role=self.fleet_service_role,
            id=self.id,
            image_id=self.image_id,
            last_modified=self.last_modified,
            name=self.name,
            overflow_behavior=self.overflow_behavior,
            region=self.region,
            scaling_configurations=self.scaling_configurations,
            statuses=self.statuses,
            tags=self.tags,
            vpc_configs=self.vpc_configs)


def get_fleet(name: Optional[builtins.str] = None,
              region: Optional[builtins.str] = None,
              tags: Optional[Mapping[str, builtins.str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetResult:
    """
    Retrieve information about an CodeBuild Fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test_fleet = aws.codebuild.Fleet("test",
        base_capacity=2,
        compute_type="BUILD_GENERAL1_SMALL",
        environment_type="LINUX_CONTAINER",
        name="full-example-codebuild-fleet",
        overflow_behavior="QUEUE",
        scaling_configuration={
            "max_capacity": 5,
            "scaling_type": "TARGET_TRACKING_SCALING",
            "target_tracking_scaling_configs": [{
                "metric_type": "FLEET_UTILIZATION_RATE",
                "target_value": 97.5,
            }],
        })
    test = aws.codebuild.get_fleet_output(name=test_fleet.name)
    ```

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.codebuild.get_fleet(name="my-codebuild-fleet-name")
    ```


    :param builtins.str name: Fleet name.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Mapping of Key-Value tags for the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:codebuild/getFleet:getFleet', __args__, opts=opts, typ=GetFleetResult).value

    return AwaitableGetFleetResult(
        arn=pulumi.get(__ret__, 'arn'),
        base_capacity=pulumi.get(__ret__, 'base_capacity'),
        compute_configurations=pulumi.get(__ret__, 'compute_configurations'),
        compute_type=pulumi.get(__ret__, 'compute_type'),
        created=pulumi.get(__ret__, 'created'),
        environment_type=pulumi.get(__ret__, 'environment_type'),
        fleet_service_role=pulumi.get(__ret__, 'fleet_service_role'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        name=pulumi.get(__ret__, 'name'),
        overflow_behavior=pulumi.get(__ret__, 'overflow_behavior'),
        region=pulumi.get(__ret__, 'region'),
        scaling_configurations=pulumi.get(__ret__, 'scaling_configurations'),
        statuses=pulumi.get(__ret__, 'statuses'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_configs=pulumi.get(__ret__, 'vpc_configs'))
def get_fleet_output(name: Optional[pulumi.Input[builtins.str]] = None,
                     region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetResult]:
    """
    Retrieve information about an CodeBuild Fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test_fleet = aws.codebuild.Fleet("test",
        base_capacity=2,
        compute_type="BUILD_GENERAL1_SMALL",
        environment_type="LINUX_CONTAINER",
        name="full-example-codebuild-fleet",
        overflow_behavior="QUEUE",
        scaling_configuration={
            "max_capacity": 5,
            "scaling_type": "TARGET_TRACKING_SCALING",
            "target_tracking_scaling_configs": [{
                "metric_type": "FLEET_UTILIZATION_RATE",
                "target_value": 97.5,
            }],
        })
    test = aws.codebuild.get_fleet_output(name=test_fleet.name)
    ```

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.codebuild.get_fleet(name="my-codebuild-fleet-name")
    ```


    :param builtins.str name: Fleet name.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Mapping of Key-Value tags for the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:codebuild/getFleet:getFleet', __args__, opts=opts, typ=GetFleetResult)
    return __ret__.apply(lambda __response__: GetFleetResult(
        arn=pulumi.get(__response__, 'arn'),
        base_capacity=pulumi.get(__response__, 'base_capacity'),
        compute_configurations=pulumi.get(__response__, 'compute_configurations'),
        compute_type=pulumi.get(__response__, 'compute_type'),
        created=pulumi.get(__response__, 'created'),
        environment_type=pulumi.get(__response__, 'environment_type'),
        fleet_service_role=pulumi.get(__response__, 'fleet_service_role'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        name=pulumi.get(__response__, 'name'),
        overflow_behavior=pulumi.get(__response__, 'overflow_behavior'),
        region=pulumi.get(__response__, 'region'),
        scaling_configurations=pulumi.get(__response__, 'scaling_configurations'),
        statuses=pulumi.get(__response__, 'statuses'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_configs=pulumi.get(__response__, 'vpc_configs')))
