# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'TriggerTrigger',
]

@pulumi.output_type
class TriggerTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"
        elif key == "customData":
            suggest = "custom_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: builtins.str,
                 events: Sequence[builtins.str],
                 name: builtins.str,
                 branches: Optional[Sequence[builtins.str]] = None,
                 custom_data: Optional[builtins.str] = None):
        """
        :param builtins.str destination_arn: The ARN of the resource that is the target for a trigger. For example, the ARN of a topic in Amazon Simple Notification Service (SNS).
        :param Sequence[builtins.str] events: The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
        :param builtins.str name: The name of the trigger.
        :param Sequence[builtins.str] branches: The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
        :param builtins.str custom_data: Any custom data associated with the trigger that will be included in the information sent to the target of the trigger.
        """
        pulumi.set(__self__, "destination_arn", destination_arn)
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "name", name)
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> builtins.str:
        """
        The ARN of the resource that is the target for a trigger. For example, the ARN of a topic in Amazon Simple Notification Service (SNS).
        """
        return pulumi.get(self, "destination_arn")

    @property
    @pulumi.getter
    def events(self) -> Sequence[builtins.str]:
        """
        The repository events that will cause the trigger to run actions in another service, such as sending a notification through Amazon Simple Notification Service (SNS). If no events are specified, the trigger will run for all repository events. Event types include: `all`, `updateReference`, `createReference`, `deleteReference`.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def branches(self) -> Optional[Sequence[builtins.str]]:
        """
        The branches that will be included in the trigger configuration. If no branches   are specified, the trigger will apply to all branches.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[builtins.str]:
        """
        Any custom data associated with the trigger that will be included in the information sent to the target of the trigger.
        """
        return pulumi.get(self, "custom_data")


