# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CustomActionTypeConfigurationProperty',
    'CustomActionTypeInputArtifactDetails',
    'CustomActionTypeOutputArtifactDetails',
    'CustomActionTypeSettings',
    'PipelineArtifactStore',
    'PipelineArtifactStoreEncryptionKey',
    'PipelineStage',
    'PipelineStageAction',
    'PipelineStageBeforeEntry',
    'PipelineStageBeforeEntryCondition',
    'PipelineStageBeforeEntryConditionRule',
    'PipelineStageBeforeEntryConditionRuleRuleTypeId',
    'PipelineStageOnFailure',
    'PipelineStageOnFailureCondition',
    'PipelineStageOnFailureConditionRule',
    'PipelineStageOnFailureConditionRuleRuleTypeId',
    'PipelineStageOnFailureRetryConfiguration',
    'PipelineStageOnSuccess',
    'PipelineStageOnSuccessCondition',
    'PipelineStageOnSuccessConditionRule',
    'PipelineStageOnSuccessConditionRuleRuleTypeId',
    'PipelineTrigger',
    'PipelineTriggerAll',
    'PipelineTriggerAllGitConfiguration',
    'PipelineTriggerAllGitConfigurationPullRequest',
    'PipelineTriggerAllGitConfigurationPullRequestBranch',
    'PipelineTriggerAllGitConfigurationPullRequestFilePath',
    'PipelineTriggerAllGitConfigurationPush',
    'PipelineTriggerAllGitConfigurationPushBranch',
    'PipelineTriggerAllGitConfigurationPushFilePath',
    'PipelineTriggerAllGitConfigurationPushTag',
    'PipelineTriggerGitConfiguration',
    'PipelineTriggerGitConfigurationPullRequest',
    'PipelineTriggerGitConfigurationPullRequestBranches',
    'PipelineTriggerGitConfigurationPullRequestFilePaths',
    'PipelineTriggerGitConfigurationPush',
    'PipelineTriggerGitConfigurationPushBranches',
    'PipelineTriggerGitConfigurationPushFilePaths',
    'PipelineTriggerGitConfigurationPushTags',
    'PipelineVariable',
    'WebhookAuthenticationConfiguration',
    'WebhookFilter',
]

@pulumi.output_type
class CustomActionTypeConfigurationProperty(dict):
    def __init__(__self__, *,
                 key: builtins.bool,
                 name: builtins.str,
                 required: builtins.bool,
                 secret: builtins.bool,
                 description: Optional[builtins.str] = None,
                 queryable: Optional[builtins.bool] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.bool key: Whether the configuration property is a key.
        :param builtins.str name: The name of the action configuration property.
        :param builtins.bool required: Whether the configuration property is a required value.
        :param builtins.bool secret: Whether the configuration property is secret.
        :param builtins.str description: The description of the action configuration property.
        :param builtins.bool queryable: Indicates that the property will be used in conjunction with PollForJobs.
        :param builtins.str type: The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "secret", secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if queryable is not None:
            pulumi.set(__self__, "queryable", queryable)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> builtins.bool:
        """
        Whether the configuration property is a key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the action configuration property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        """
        Whether the configuration property is a required value.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def secret(self) -> builtins.bool:
        """
        Whether the configuration property is secret.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the action configuration property.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def queryable(self) -> Optional[builtins.bool]:
        """
        Indicates that the property will be used in conjunction with PollForJobs.
        """
        return pulumi.get(self, "queryable")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomActionTypeInputArtifactDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumCount":
            suggest = "maximum_count"
        elif key == "minimumCount":
            suggest = "minimum_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActionTypeInputArtifactDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActionTypeInputArtifactDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActionTypeInputArtifactDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_count: builtins.int,
                 minimum_count: builtins.int):
        """
        :param builtins.int maximum_count: The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        :param builtins.int minimum_count: The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        pulumi.set(__self__, "maximum_count", maximum_count)
        pulumi.set(__self__, "minimum_count", minimum_count)

    @property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> builtins.int:
        """
        The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "maximum_count")

    @property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> builtins.int:
        """
        The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "minimum_count")


@pulumi.output_type
class CustomActionTypeOutputArtifactDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumCount":
            suggest = "maximum_count"
        elif key == "minimumCount":
            suggest = "minimum_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActionTypeOutputArtifactDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActionTypeOutputArtifactDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActionTypeOutputArtifactDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_count: builtins.int,
                 minimum_count: builtins.int):
        """
        :param builtins.int maximum_count: The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        :param builtins.int minimum_count: The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        pulumi.set(__self__, "maximum_count", maximum_count)
        pulumi.set(__self__, "minimum_count", minimum_count)

    @property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> builtins.int:
        """
        The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "maximum_count")

    @property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> builtins.int:
        """
        The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "minimum_count")


@pulumi.output_type
class CustomActionTypeSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityUrlTemplate":
            suggest = "entity_url_template"
        elif key == "executionUrlTemplate":
            suggest = "execution_url_template"
        elif key == "revisionUrlTemplate":
            suggest = "revision_url_template"
        elif key == "thirdPartyConfigurationUrl":
            suggest = "third_party_configuration_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomActionTypeSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomActionTypeSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomActionTypeSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_url_template: Optional[builtins.str] = None,
                 execution_url_template: Optional[builtins.str] = None,
                 revision_url_template: Optional[builtins.str] = None,
                 third_party_configuration_url: Optional[builtins.str] = None):
        """
        :param builtins.str entity_url_template: The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
        :param builtins.str execution_url_template: The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
        :param builtins.str revision_url_template: The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
        :param builtins.str third_party_configuration_url: The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        if entity_url_template is not None:
            pulumi.set(__self__, "entity_url_template", entity_url_template)
        if execution_url_template is not None:
            pulumi.set(__self__, "execution_url_template", execution_url_template)
        if revision_url_template is not None:
            pulumi.set(__self__, "revision_url_template", revision_url_template)
        if third_party_configuration_url is not None:
            pulumi.set(__self__, "third_party_configuration_url", third_party_configuration_url)

    @property
    @pulumi.getter(name="entityUrlTemplate")
    def entity_url_template(self) -> Optional[builtins.str]:
        """
        The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
        """
        return pulumi.get(self, "entity_url_template")

    @property
    @pulumi.getter(name="executionUrlTemplate")
    def execution_url_template(self) -> Optional[builtins.str]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
        """
        return pulumi.get(self, "execution_url_template")

    @property
    @pulumi.getter(name="revisionUrlTemplate")
    def revision_url_template(self) -> Optional[builtins.str]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
        """
        return pulumi.get(self, "revision_url_template")

    @property
    @pulumi.getter(name="thirdPartyConfigurationUrl")
    def third_party_configuration_url(self) -> Optional[builtins.str]:
        """
        The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        return pulumi.get(self, "third_party_configuration_url")


@pulumi.output_type
class PipelineArtifactStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineArtifactStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineArtifactStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineArtifactStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 type: builtins.str,
                 encryption_key: Optional['outputs.PipelineArtifactStoreEncryptionKey'] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str location: The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
        :param builtins.str type: The type of the artifact store, such as Amazon S3
        :param 'PipelineArtifactStoreEncryptionKeyArgs' encryption_key: The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
        :param builtins.str region: The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "type", type)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the artifact store, such as Amazon S3
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional['outputs.PipelineArtifactStoreEncryptionKey']:
        """
        The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class PipelineArtifactStoreEncryptionKey(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str id: The KMS key ARN or ID
        :param builtins.str type: The type of key; currently only `KMS` is supported
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The KMS key ARN or ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of key; currently only `KMS` is supported
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipelineStage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "beforeEntry":
            suggest = "before_entry"
        elif key == "onFailure":
            suggest = "on_failure"
        elif key == "onSuccess":
            suggest = "on_success"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence['outputs.PipelineStageAction'],
                 name: builtins.str,
                 before_entry: Optional['outputs.PipelineStageBeforeEntry'] = None,
                 on_failure: Optional['outputs.PipelineStageOnFailure'] = None,
                 on_success: Optional['outputs.PipelineStageOnSuccess'] = None):
        """
        :param Sequence['PipelineStageActionArgs'] actions: The action(s) to include in the stage. Defined as an `action` block below
        :param builtins.str name: The name of the stage.
        :param 'PipelineStageBeforeEntryArgs' before_entry: The method to use when a stage allows entry. For example, configuring this field for conditions will allow entry to the stage when the conditions are met.
        :param 'PipelineStageOnFailureArgs' on_failure: The method to use when a stage has not completed successfully. For example, configuring this field for rollback will roll back a failed stage automatically to the last successful pipeline execution in the stage.
        :param 'PipelineStageOnSuccessArgs' on_success: The method to use when a stage has succeeded. For example, configuring this field for conditions will allow the stage to succeed when the conditions are met.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "name", name)
        if before_entry is not None:
            pulumi.set(__self__, "before_entry", before_entry)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.PipelineStageAction']:
        """
        The action(s) to include in the stage. Defined as an `action` block below
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the stage.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="beforeEntry")
    def before_entry(self) -> Optional['outputs.PipelineStageBeforeEntry']:
        """
        The method to use when a stage allows entry. For example, configuring this field for conditions will allow entry to the stage when the conditions are met.
        """
        return pulumi.get(self, "before_entry")

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.PipelineStageOnFailure']:
        """
        The method to use when a stage has not completed successfully. For example, configuring this field for rollback will roll back a failed stage automatically to the last successful pipeline execution in the stage.
        """
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional['outputs.PipelineStageOnSuccess']:
        """
        The method to use when a stage has succeeded. For example, configuring this field for conditions will allow the stage to succeed when the conditions are met.
        """
        return pulumi.get(self, "on_success")


@pulumi.output_type
class PipelineStageAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputArtifacts":
            suggest = "input_artifacts"
        elif key == "outputArtifacts":
            suggest = "output_artifacts"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "runOrder":
            suggest = "run_order"
        elif key == "timeoutInMinutes":
            suggest = "timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStageAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStageAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStageAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: builtins.str,
                 name: builtins.str,
                 owner: builtins.str,
                 provider: builtins.str,
                 version: builtins.str,
                 configuration: Optional[Mapping[str, builtins.str]] = None,
                 input_artifacts: Optional[Sequence[builtins.str]] = None,
                 namespace: Optional[builtins.str] = None,
                 output_artifacts: Optional[Sequence[builtins.str]] = None,
                 region: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None,
                 run_order: Optional[builtins.int] = None,
                 timeout_in_minutes: Optional[builtins.int] = None):
        """
        :param builtins.str category: A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
        :param builtins.str name: The action declaration's name.
        :param builtins.str owner: The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
        :param builtins.str provider: The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
        :param builtins.str version: A string that identifies the action type.
        :param Mapping[str, builtins.str] configuration: A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation. Note: The `DetectChanges` parameter (optional, default value is true) in the `configuration` section causes CodePipeline to automatically start your pipeline upon new commits. Please refer to AWS Documentation for more details: https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config.
        :param Sequence[builtins.str] input_artifacts: A list of artifact names to be worked on.
        :param builtins.str namespace: The namespace all output variables will be accessed from.
        :param Sequence[builtins.str] output_artifacts: A list of artifact names to output. Output artifact names must be unique within a pipeline.
        :param builtins.str region: The region in which to run the action.
        :param builtins.str role_arn: The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
        :param builtins.int run_order: The order in which actions are run.
        :param builtins.int timeout_in_minutes: The action timeout for the rule.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "version", version)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if output_artifacts is not None:
            pulumi.set(__self__, "output_artifacts", output_artifacts)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if run_order is not None:
            pulumi.set(__self__, "run_order", run_order)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter
    def category(self) -> builtins.str:
        """
        A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The action declaration's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> builtins.str:
        """
        The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def provider(self) -> builtins.str:
        """
        The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        A string that identifies the action type.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation. Note: The `DetectChanges` parameter (optional, default value is true) in the `configuration` section causes CodePipeline to automatically start your pipeline upon new commits. Please refer to AWS Documentation for more details: https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of artifact names to be worked on.
        """
        return pulumi.get(self, "input_artifacts")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace all output variables will be accessed from.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="outputArtifacts")
    def output_artifacts(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of artifact names to output. Output artifact names must be unique within a pipeline.
        """
        return pulumi.get(self, "output_artifacts")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region in which to run the action.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="runOrder")
    def run_order(self) -> Optional[builtins.int]:
        """
        The order in which actions are run.
        """
        return pulumi.get(self, "run_order")

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[builtins.int]:
        """
        The action timeout for the rule.
        """
        return pulumi.get(self, "timeout_in_minutes")


@pulumi.output_type
class PipelineStageBeforeEntry(dict):
    def __init__(__self__, *,
                 condition: 'outputs.PipelineStageBeforeEntryCondition'):
        """
        :param 'PipelineStageBeforeEntryConditionArgs' condition: The conditions that are configured as entry condition. Defined as a `condition` block below.
        """
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.PipelineStageBeforeEntryCondition':
        """
        The conditions that are configured as entry condition. Defined as a `condition` block below.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class PipelineStageBeforeEntryCondition(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.PipelineStageBeforeEntryConditionRule'],
                 result: Optional[builtins.str] = None):
        """
        :param Sequence['PipelineStageBeforeEntryConditionRuleArgs'] rules: The rules that make up the condition. Defined as a `rule` block below.
        :param builtins.str result: The action to be done when the condition is met. For example, rolling back an execution for a failure condition. Possible values are `ROLLBACK`, `FAIL`, `RETRY` and `SKIP`.
        """
        pulumi.set(__self__, "rules", rules)
        if result is not None:
            pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.PipelineStageBeforeEntryConditionRule']:
        """
        The rules that make up the condition. Defined as a `rule` block below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def result(self) -> Optional[builtins.str]:
        """
        The action to be done when the condition is met. For example, rolling back an execution for a failure condition. Possible values are `ROLLBACK`, `FAIL`, `RETRY` and `SKIP`.
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class PipelineStageBeforeEntryConditionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleTypeId":
            suggest = "rule_type_id"
        elif key == "inputArtifacts":
            suggest = "input_artifacts"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "timeoutInMinutes":
            suggest = "timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStageBeforeEntryConditionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStageBeforeEntryConditionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStageBeforeEntryConditionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 rule_type_id: 'outputs.PipelineStageBeforeEntryConditionRuleRuleTypeId',
                 commands: Optional[Sequence[builtins.str]] = None,
                 configuration: Optional[Mapping[str, builtins.str]] = None,
                 input_artifacts: Optional[Sequence[builtins.str]] = None,
                 region: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None,
                 timeout_in_minutes: Optional[builtins.int] = None):
        """
        :param builtins.str name: The name of the rule that is created for the condition, such as `VariableCheck`.
        :param 'PipelineStageBeforeEntryConditionRuleRuleTypeIdArgs' rule_type_id: The ID for the rule type, which is made up of the combined values for `category`, `owner`, `provider`, and `version`. Defined as an `rule_type_id` block below.
        :param Sequence[builtins.str] commands: The shell commands to run with your commands rule in CodePipeline. All commands are supported except multi-line formats.
        :param Mapping[str, builtins.str] configuration: The action configuration fields for the rule. Configurations options for rule types and providers can be found in the [Rule structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        :param Sequence[builtins.str] input_artifacts: The list of the input artifacts fields for the rule, such as specifying an input file for the rule.
        :param builtins.str region: The Region for the condition associated with the rule.
        :param builtins.str role_arn: The pipeline role ARN associated with the rule.
        :param builtins.int timeout_in_minutes: The action timeout for the rule.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rule_type_id", rule_type_id)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the rule that is created for the condition, such as `VariableCheck`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleTypeId")
    def rule_type_id(self) -> 'outputs.PipelineStageBeforeEntryConditionRuleRuleTypeId':
        """
        The ID for the rule type, which is made up of the combined values for `category`, `owner`, `provider`, and `version`. Defined as an `rule_type_id` block below.
        """
        return pulumi.get(self, "rule_type_id")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[builtins.str]]:
        """
        The shell commands to run with your commands rule in CodePipeline. All commands are supported except multi-line formats.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The action configuration fields for the rule. Configurations options for rule types and providers can be found in the [Rule structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of the input artifacts fields for the rule, such as specifying an input file for the rule.
        """
        return pulumi.get(self, "input_artifacts")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The Region for the condition associated with the rule.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The pipeline role ARN associated with the rule.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[builtins.int]:
        """
        The action timeout for the rule.
        """
        return pulumi.get(self, "timeout_in_minutes")


@pulumi.output_type
class PipelineStageBeforeEntryConditionRuleRuleTypeId(dict):
    def __init__(__self__, *,
                 category: builtins.str,
                 provider: builtins.str,
                 owner: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str category: A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule. The valid category is `Rule`.
        :param builtins.str provider: The rule provider, such as the DeploymentWindow rule. For a list of rule provider names, see the rules listed in the [AWS CodePipeline rule reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        :param builtins.str owner: The creator of the rule being called. The valid value for the Owner field in the rule category is `AWS`.
        :param builtins.str version: A string that describes the rule version.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "provider", provider)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def category(self) -> builtins.str:
        """
        A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule. The valid category is `Rule`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def provider(self) -> builtins.str:
        """
        The rule provider, such as the DeploymentWindow rule. For a list of rule provider names, see the rules listed in the [AWS CodePipeline rule reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def owner(self) -> Optional[builtins.str]:
        """
        The creator of the rule being called. The valid value for the Owner field in the rule category is `AWS`.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        A string that describes the rule version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PipelineStageOnFailure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retryConfiguration":
            suggest = "retry_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStageOnFailure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStageOnFailure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStageOnFailure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional['outputs.PipelineStageOnFailureCondition'] = None,
                 result: Optional[builtins.str] = None,
                 retry_configuration: Optional['outputs.PipelineStageOnFailureRetryConfiguration'] = None):
        """
        :param 'PipelineStageOnFailureConditionArgs' condition: The conditions that are failure conditions. Defined as a `condition` block below.
        :param builtins.str result: The conditions that are configured as failure conditions. Possible values are `ROLLBACK`,  `FAIL`, `RETRY` and `SKIP`.
        :param 'PipelineStageOnFailureRetryConfigurationArgs' retry_configuration: The retry configuration specifies automatic retry for a failed stage, along with the configured retry mode. Defined as a `retry_configuration` block below.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if result is not None:
            pulumi.set(__self__, "result", result)
        if retry_configuration is not None:
            pulumi.set(__self__, "retry_configuration", retry_configuration)

    @property
    @pulumi.getter
    def condition(self) -> Optional['outputs.PipelineStageOnFailureCondition']:
        """
        The conditions that are failure conditions. Defined as a `condition` block below.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def result(self) -> Optional[builtins.str]:
        """
        The conditions that are configured as failure conditions. Possible values are `ROLLBACK`,  `FAIL`, `RETRY` and `SKIP`.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="retryConfiguration")
    def retry_configuration(self) -> Optional['outputs.PipelineStageOnFailureRetryConfiguration']:
        """
        The retry configuration specifies automatic retry for a failed stage, along with the configured retry mode. Defined as a `retry_configuration` block below.
        """
        return pulumi.get(self, "retry_configuration")


@pulumi.output_type
class PipelineStageOnFailureCondition(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.PipelineStageOnFailureConditionRule'],
                 result: Optional[builtins.str] = None):
        """
        :param Sequence['PipelineStageOnFailureConditionRuleArgs'] rules: The rules that make up the condition. Defined as a `rule` block below.
        :param builtins.str result: The action to be done when the condition is met. For example, rolling back an execution for a failure condition. Possible values are `ROLLBACK`, `FAIL`, `RETRY` and `SKIP`.
        """
        pulumi.set(__self__, "rules", rules)
        if result is not None:
            pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.PipelineStageOnFailureConditionRule']:
        """
        The rules that make up the condition. Defined as a `rule` block below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def result(self) -> Optional[builtins.str]:
        """
        The action to be done when the condition is met. For example, rolling back an execution for a failure condition. Possible values are `ROLLBACK`, `FAIL`, `RETRY` and `SKIP`.
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class PipelineStageOnFailureConditionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleTypeId":
            suggest = "rule_type_id"
        elif key == "inputArtifacts":
            suggest = "input_artifacts"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "timeoutInMinutes":
            suggest = "timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStageOnFailureConditionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStageOnFailureConditionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStageOnFailureConditionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 rule_type_id: 'outputs.PipelineStageOnFailureConditionRuleRuleTypeId',
                 commands: Optional[Sequence[builtins.str]] = None,
                 configuration: Optional[Mapping[str, builtins.str]] = None,
                 input_artifacts: Optional[Sequence[builtins.str]] = None,
                 region: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None,
                 timeout_in_minutes: Optional[builtins.int] = None):
        """
        :param builtins.str name: The name of the rule that is created for the condition, such as `VariableCheck`.
        :param 'PipelineStageOnFailureConditionRuleRuleTypeIdArgs' rule_type_id: The ID for the rule type, which is made up of the combined values for `category`, `owner`, `provider`, and `version`. Defined as an `rule_type_id` block below.
        :param Sequence[builtins.str] commands: The shell commands to run with your commands rule in CodePipeline. All commands are supported except multi-line formats.
        :param Mapping[str, builtins.str] configuration: The action configuration fields for the rule. Configurations options for rule types and providers can be found in the [Rule structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        :param Sequence[builtins.str] input_artifacts: The list of the input artifacts fields for the rule, such as specifying an input file for the rule.
        :param builtins.str region: The Region for the condition associated with the rule.
        :param builtins.str role_arn: The pipeline role ARN associated with the rule.
        :param builtins.int timeout_in_minutes: The action timeout for the rule.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rule_type_id", rule_type_id)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the rule that is created for the condition, such as `VariableCheck`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleTypeId")
    def rule_type_id(self) -> 'outputs.PipelineStageOnFailureConditionRuleRuleTypeId':
        """
        The ID for the rule type, which is made up of the combined values for `category`, `owner`, `provider`, and `version`. Defined as an `rule_type_id` block below.
        """
        return pulumi.get(self, "rule_type_id")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[builtins.str]]:
        """
        The shell commands to run with your commands rule in CodePipeline. All commands are supported except multi-line formats.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The action configuration fields for the rule. Configurations options for rule types and providers can be found in the [Rule structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of the input artifacts fields for the rule, such as specifying an input file for the rule.
        """
        return pulumi.get(self, "input_artifacts")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The Region for the condition associated with the rule.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The pipeline role ARN associated with the rule.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[builtins.int]:
        """
        The action timeout for the rule.
        """
        return pulumi.get(self, "timeout_in_minutes")


@pulumi.output_type
class PipelineStageOnFailureConditionRuleRuleTypeId(dict):
    def __init__(__self__, *,
                 category: builtins.str,
                 provider: builtins.str,
                 owner: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str category: A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule. The valid category is `Rule`.
        :param builtins.str provider: The rule provider, such as the DeploymentWindow rule. For a list of rule provider names, see the rules listed in the [AWS CodePipeline rule reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        :param builtins.str owner: The creator of the rule being called. The valid value for the Owner field in the rule category is `AWS`.
        :param builtins.str version: A string that describes the rule version.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "provider", provider)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def category(self) -> builtins.str:
        """
        A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule. The valid category is `Rule`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def provider(self) -> builtins.str:
        """
        The rule provider, such as the DeploymentWindow rule. For a list of rule provider names, see the rules listed in the [AWS CodePipeline rule reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def owner(self) -> Optional[builtins.str]:
        """
        The creator of the rule being called. The valid value for the Owner field in the rule category is `AWS`.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        A string that describes the rule version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PipelineStageOnFailureRetryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retryMode":
            suggest = "retry_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStageOnFailureRetryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStageOnFailureRetryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStageOnFailureRetryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retry_mode: Optional[builtins.str] = None):
        """
        :param builtins.str retry_mode: The method that you want to configure for automatic stage retry on stage failure. You can specify to retry only failed action in the stage or all actions in the stage. Possible values are `FAILED_ACTIONS` and `ALL_ACTIONS`.
        """
        if retry_mode is not None:
            pulumi.set(__self__, "retry_mode", retry_mode)

    @property
    @pulumi.getter(name="retryMode")
    def retry_mode(self) -> Optional[builtins.str]:
        """
        The method that you want to configure for automatic stage retry on stage failure. You can specify to retry only failed action in the stage or all actions in the stage. Possible values are `FAILED_ACTIONS` and `ALL_ACTIONS`.
        """
        return pulumi.get(self, "retry_mode")


@pulumi.output_type
class PipelineStageOnSuccess(dict):
    def __init__(__self__, *,
                 condition: 'outputs.PipelineStageOnSuccessCondition'):
        """
        :param 'PipelineStageOnSuccessConditionArgs' condition: The conditions that are success conditions. Defined as a `condition` block below.
        """
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.PipelineStageOnSuccessCondition':
        """
        The conditions that are success conditions. Defined as a `condition` block below.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class PipelineStageOnSuccessCondition(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.PipelineStageOnSuccessConditionRule'],
                 result: Optional[builtins.str] = None):
        """
        :param Sequence['PipelineStageOnSuccessConditionRuleArgs'] rules: The rules that make up the condition. Defined as a `rule` block below.
        :param builtins.str result: The action to be done when the condition is met. For example, rolling back an execution for a failure condition. Possible values are `ROLLBACK`, `FAIL`, `RETRY` and `SKIP`.
        """
        pulumi.set(__self__, "rules", rules)
        if result is not None:
            pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.PipelineStageOnSuccessConditionRule']:
        """
        The rules that make up the condition. Defined as a `rule` block below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def result(self) -> Optional[builtins.str]:
        """
        The action to be done when the condition is met. For example, rolling back an execution for a failure condition. Possible values are `ROLLBACK`, `FAIL`, `RETRY` and `SKIP`.
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class PipelineStageOnSuccessConditionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleTypeId":
            suggest = "rule_type_id"
        elif key == "inputArtifacts":
            suggest = "input_artifacts"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "timeoutInMinutes":
            suggest = "timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineStageOnSuccessConditionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineStageOnSuccessConditionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineStageOnSuccessConditionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 rule_type_id: 'outputs.PipelineStageOnSuccessConditionRuleRuleTypeId',
                 commands: Optional[Sequence[builtins.str]] = None,
                 configuration: Optional[Mapping[str, builtins.str]] = None,
                 input_artifacts: Optional[Sequence[builtins.str]] = None,
                 region: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None,
                 timeout_in_minutes: Optional[builtins.int] = None):
        """
        :param builtins.str name: The name of the rule that is created for the condition, such as `VariableCheck`.
        :param 'PipelineStageOnSuccessConditionRuleRuleTypeIdArgs' rule_type_id: The ID for the rule type, which is made up of the combined values for `category`, `owner`, `provider`, and `version`. Defined as an `rule_type_id` block below.
        :param Sequence[builtins.str] commands: The shell commands to run with your commands rule in CodePipeline. All commands are supported except multi-line formats.
        :param Mapping[str, builtins.str] configuration: The action configuration fields for the rule. Configurations options for rule types and providers can be found in the [Rule structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        :param Sequence[builtins.str] input_artifacts: The list of the input artifacts fields for the rule, such as specifying an input file for the rule.
        :param builtins.str region: The Region for the condition associated with the rule.
        :param builtins.str role_arn: The pipeline role ARN associated with the rule.
        :param builtins.int timeout_in_minutes: The action timeout for the rule.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rule_type_id", rule_type_id)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the rule that is created for the condition, such as `VariableCheck`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleTypeId")
    def rule_type_id(self) -> 'outputs.PipelineStageOnSuccessConditionRuleRuleTypeId':
        """
        The ID for the rule type, which is made up of the combined values for `category`, `owner`, `provider`, and `version`. Defined as an `rule_type_id` block below.
        """
        return pulumi.get(self, "rule_type_id")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[builtins.str]]:
        """
        The shell commands to run with your commands rule in CodePipeline. All commands are supported except multi-line formats.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The action configuration fields for the rule. Configurations options for rule types and providers can be found in the [Rule structure reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of the input artifacts fields for the rule, such as specifying an input file for the rule.
        """
        return pulumi.get(self, "input_artifacts")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The Region for the condition associated with the rule.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The pipeline role ARN associated with the rule.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[builtins.int]:
        """
        The action timeout for the rule.
        """
        return pulumi.get(self, "timeout_in_minutes")


@pulumi.output_type
class PipelineStageOnSuccessConditionRuleRuleTypeId(dict):
    def __init__(__self__, *,
                 category: builtins.str,
                 provider: builtins.str,
                 owner: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str category: A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule. The valid category is `Rule`.
        :param builtins.str provider: The rule provider, such as the DeploymentWindow rule. For a list of rule provider names, see the rules listed in the [AWS CodePipeline rule reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        :param builtins.str owner: The creator of the rule being called. The valid value for the Owner field in the rule category is `AWS`.
        :param builtins.str version: A string that describes the rule version.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "provider", provider)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def category(self) -> builtins.str:
        """
        A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule. The valid category is `Rule`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def provider(self) -> builtins.str:
        """
        The rule provider, such as the DeploymentWindow rule. For a list of rule provider names, see the rules listed in the [AWS CodePipeline rule reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html).
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def owner(self) -> Optional[builtins.str]:
        """
        The creator of the rule being called. The valid value for the Owner field in the rule category is `AWS`.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        A string that describes the rule version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PipelineTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gitConfiguration":
            suggest = "git_configuration"
        elif key == "providerType":
            suggest = "provider_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 git_configuration: 'outputs.PipelineTriggerGitConfiguration',
                 provider_type: builtins.str):
        """
        :param 'PipelineTriggerGitConfigurationArgs' git_configuration: Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
        :param builtins.str provider_type: The source provider for the event. Possible value is `CodeStarSourceConnection`.
        """
        pulumi.set(__self__, "git_configuration", git_configuration)
        pulumi.set(__self__, "provider_type", provider_type)

    @property
    @pulumi.getter(name="gitConfiguration")
    def git_configuration(self) -> 'outputs.PipelineTriggerGitConfiguration':
        """
        Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
        """
        return pulumi.get(self, "git_configuration")

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> builtins.str:
        """
        The source provider for the event. Possible value is `CodeStarSourceConnection`.
        """
        return pulumi.get(self, "provider_type")


@pulumi.output_type
class PipelineTriggerAll(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gitConfigurations":
            suggest = "git_configurations"
        elif key == "providerType":
            suggest = "provider_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerAll. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerAll.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerAll.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 git_configurations: Optional[Sequence['outputs.PipelineTriggerAllGitConfiguration']] = None,
                 provider_type: Optional[builtins.str] = None):
        """
        :param Sequence['PipelineTriggerAllGitConfigurationArgs'] git_configurations: Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
        :param builtins.str provider_type: The source provider for the event. Possible value is `CodeStarSourceConnection`.
        """
        if git_configurations is not None:
            pulumi.set(__self__, "git_configurations", git_configurations)
        if provider_type is not None:
            pulumi.set(__self__, "provider_type", provider_type)

    @property
    @pulumi.getter(name="gitConfigurations")
    def git_configurations(self) -> Optional[Sequence['outputs.PipelineTriggerAllGitConfiguration']]:
        """
        Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
        """
        return pulumi.get(self, "git_configurations")

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> Optional[builtins.str]:
        """
        The source provider for the event. Possible value is `CodeStarSourceConnection`.
        """
        return pulumi.get(self, "provider_type")


@pulumi.output_type
class PipelineTriggerAllGitConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullRequests":
            suggest = "pull_requests"
        elif key == "sourceActionName":
            suggest = "source_action_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerAllGitConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerAllGitConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerAllGitConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pull_requests: Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPullRequest']] = None,
                 pushes: Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPush']] = None,
                 source_action_name: Optional[builtins.str] = None):
        """
        :param Sequence['PipelineTriggerAllGitConfigurationPullRequestArgs'] pull_requests: The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
        :param Sequence['PipelineTriggerAllGitConfigurationPushArgs'] pushes: The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
        :param builtins.str source_action_name: The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        """
        if pull_requests is not None:
            pulumi.set(__self__, "pull_requests", pull_requests)
        if pushes is not None:
            pulumi.set(__self__, "pushes", pushes)
        if source_action_name is not None:
            pulumi.set(__self__, "source_action_name", source_action_name)

    @property
    @pulumi.getter(name="pullRequests")
    def pull_requests(self) -> Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPullRequest']]:
        """
        The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
        """
        return pulumi.get(self, "pull_requests")

    @property
    @pulumi.getter
    def pushes(self) -> Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPush']]:
        """
        The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
        """
        return pulumi.get(self, "pushes")

    @property
    @pulumi.getter(name="sourceActionName")
    def source_action_name(self) -> Optional[builtins.str]:
        """
        The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        """
        return pulumi.get(self, "source_action_name")


@pulumi.output_type
class PipelineTriggerAllGitConfigurationPullRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePaths":
            suggest = "file_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerAllGitConfigurationPullRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerAllGitConfigurationPullRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerAllGitConfigurationPullRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branches: Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPullRequestBranch']] = None,
                 events: Optional[Sequence[builtins.str]] = None,
                 file_paths: Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPullRequestFilePath']] = None):
        """
        :param Sequence['PipelineTriggerAllGitConfigurationPullRequestBranchArgs'] branches: The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
        :param Sequence[builtins.str] events: A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
        :param Sequence['PipelineTriggerAllGitConfigurationPullRequestFilePathArgs'] file_paths: The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)

    @property
    @pulumi.getter
    def branches(self) -> Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPullRequestBranch']]:
        """
        The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence[builtins.str]]:
        """
        A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPullRequestFilePath']]:
        """
        The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
        """
        return pulumi.get(self, "file_paths")


@pulumi.output_type
class PipelineTriggerAllGitConfigurationPullRequestBranch(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerAllGitConfigurationPullRequestFilePath(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerAllGitConfigurationPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePaths":
            suggest = "file_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerAllGitConfigurationPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerAllGitConfigurationPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerAllGitConfigurationPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branches: Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPushBranch']] = None,
                 file_paths: Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPushFilePath']] = None,
                 tags: Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPushTag']] = None):
        """
        :param Sequence['PipelineTriggerAllGitConfigurationPushBranchArgs'] branches: The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
        :param Sequence['PipelineTriggerAllGitConfigurationPushFilePathArgs'] file_paths: The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
        :param Sequence['PipelineTriggerAllGitConfigurationPushTagArgs'] tags: The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def branches(self) -> Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPushBranch']]:
        """
        The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPushFilePath']]:
        """
        The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
        """
        return pulumi.get(self, "file_paths")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.PipelineTriggerAllGitConfigurationPushTag']]:
        """
        The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PipelineTriggerAllGitConfigurationPushBranch(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerAllGitConfigurationPushFilePath(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerAllGitConfigurationPushTag(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerGitConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceActionName":
            suggest = "source_action_name"
        elif key == "pullRequests":
            suggest = "pull_requests"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerGitConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerGitConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerGitConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_action_name: builtins.str,
                 pull_requests: Optional[Sequence['outputs.PipelineTriggerGitConfigurationPullRequest']] = None,
                 pushes: Optional[Sequence['outputs.PipelineTriggerGitConfigurationPush']] = None):
        """
        :param builtins.str source_action_name: The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        :param Sequence['PipelineTriggerGitConfigurationPullRequestArgs'] pull_requests: The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
        :param Sequence['PipelineTriggerGitConfigurationPushArgs'] pushes: The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
        """
        pulumi.set(__self__, "source_action_name", source_action_name)
        if pull_requests is not None:
            pulumi.set(__self__, "pull_requests", pull_requests)
        if pushes is not None:
            pulumi.set(__self__, "pushes", pushes)

    @property
    @pulumi.getter(name="sourceActionName")
    def source_action_name(self) -> builtins.str:
        """
        The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
        """
        return pulumi.get(self, "source_action_name")

    @property
    @pulumi.getter(name="pullRequests")
    def pull_requests(self) -> Optional[Sequence['outputs.PipelineTriggerGitConfigurationPullRequest']]:
        """
        The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
        """
        return pulumi.get(self, "pull_requests")

    @property
    @pulumi.getter
    def pushes(self) -> Optional[Sequence['outputs.PipelineTriggerGitConfigurationPush']]:
        """
        The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
        """
        return pulumi.get(self, "pushes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPullRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePaths":
            suggest = "file_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerGitConfigurationPullRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerGitConfigurationPullRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerGitConfigurationPullRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branches: Optional['outputs.PipelineTriggerGitConfigurationPullRequestBranches'] = None,
                 events: Optional[Sequence[builtins.str]] = None,
                 file_paths: Optional['outputs.PipelineTriggerGitConfigurationPullRequestFilePaths'] = None):
        """
        :param 'PipelineTriggerGitConfigurationPullRequestBranchesArgs' branches: The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
        :param Sequence[builtins.str] events: A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
        :param 'PipelineTriggerGitConfigurationPullRequestFilePathsArgs' file_paths: The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)

    @property
    @pulumi.getter
    def branches(self) -> Optional['outputs.PipelineTriggerGitConfigurationPullRequestBranches']:
        """
        The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence[builtins.str]]:
        """
        A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional['outputs.PipelineTriggerGitConfigurationPullRequestFilePaths']:
        """
        The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
        """
        return pulumi.get(self, "file_paths")


@pulumi.output_type
class PipelineTriggerGitConfigurationPullRequestBranches(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPullRequestFilePaths(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePaths":
            suggest = "file_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineTriggerGitConfigurationPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineTriggerGitConfigurationPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineTriggerGitConfigurationPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branches: Optional['outputs.PipelineTriggerGitConfigurationPushBranches'] = None,
                 file_paths: Optional['outputs.PipelineTriggerGitConfigurationPushFilePaths'] = None,
                 tags: Optional['outputs.PipelineTriggerGitConfigurationPushTags'] = None):
        """
        :param 'PipelineTriggerGitConfigurationPushBranchesArgs' branches: The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
        :param 'PipelineTriggerGitConfigurationPushFilePathsArgs' file_paths: The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
        :param 'PipelineTriggerGitConfigurationPushTagsArgs' tags: The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def branches(self) -> Optional['outputs.PipelineTriggerGitConfigurationPushBranches']:
        """
        The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional['outputs.PipelineTriggerGitConfigurationPushFilePaths']:
        """
        The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
        """
        return pulumi.get(self, "file_paths")

    @property
    @pulumi.getter
    def tags(self) -> Optional['outputs.PipelineTriggerGitConfigurationPushTags']:
        """
        The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PipelineTriggerGitConfigurationPushBranches(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPushFilePaths(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineTriggerGitConfigurationPushTags(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[builtins.str]] = None,
                 includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excludes: A list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        :param Sequence[builtins.str] includes: A list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class PipelineVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 default_value: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of a pipeline-level variable.
        :param builtins.str default_value: The default value of a pipeline-level variable.
        :param builtins.str description: The description of a pipeline-level variable.
        """
        pulumi.set(__self__, "name", name)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of a pipeline-level variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[builtins.str]:
        """
        The default value of a pipeline-level variable.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of a pipeline-level variable.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class WebhookAuthenticationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedIpRange":
            suggest = "allowed_ip_range"
        elif key == "secretToken":
            suggest = "secret_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookAuthenticationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookAuthenticationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookAuthenticationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_ip_range: Optional[builtins.str] = None,
                 secret_token: Optional[builtins.str] = None):
        """
        :param builtins.str allowed_ip_range: A valid CIDR block for `IP` filtering. Required for `IP`.
        :param builtins.str secret_token: The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
        """
        if allowed_ip_range is not None:
            pulumi.set(__self__, "allowed_ip_range", allowed_ip_range)
        if secret_token is not None:
            pulumi.set(__self__, "secret_token", secret_token)

    @property
    @pulumi.getter(name="allowedIpRange")
    def allowed_ip_range(self) -> Optional[builtins.str]:
        """
        A valid CIDR block for `IP` filtering. Required for `IP`.
        """
        return pulumi.get(self, "allowed_ip_range")

    @property
    @pulumi.getter(name="secretToken")
    def secret_token(self) -> Optional[builtins.str]:
        """
        The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
        """
        return pulumi.get(self, "secret_token")


@pulumi.output_type
class WebhookFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"
        elif key == "matchEquals":
            suggest = "match_equals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: builtins.str,
                 match_equals: builtins.str):
        """
        :param builtins.str json_path: The [JSON path](https://github.com/json-path/JsonPath) to filter on.
        :param builtins.str match_equals: The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
        """
        pulumi.set(__self__, "json_path", json_path)
        pulumi.set(__self__, "match_equals", match_equals)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> builtins.str:
        """
        The [JSON path](https://github.com/json-path/JsonPath) to filter on.
        """
        return pulumi.get(self, "json_path")

    @property
    @pulumi.getter(name="matchEquals")
    def match_equals(self) -> builtins.str:
        """
        The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
        """
        return pulumi.get(self, "match_equals")


