# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 artifact_stores: pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreArgs']]],
                 role_arn: pulumi.Input[builtins.str],
                 stages: pulumi.Input[Sequence[pulumi.Input['PipelineStageArgs']]],
                 execution_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerArgs']]]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineVariableArgs']]]] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreArgs']]] artifact_stores: One or more artifact_store blocks. Artifact stores are documented below.
        :param pulumi.Input[builtins.str] role_arn: A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineStageArgs']]] stages: A stage block. Stages are documented below.
        :param pulumi.Input[builtins.str] execution_mode: The method that the pipeline will use to handle multiple executions. The default mode is `SUPERSEDED`. For value values, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_PipelineDeclaration.html#CodePipeline-Type-PipelineDeclaration-executionMode).
        :param pulumi.Input[builtins.str] name: The name of the pipeline.
        :param pulumi.Input[builtins.str] pipeline_type: Type of the pipeline. Possible values are: `V1` and `V2`. Default value is `V1`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineTriggerArgs']]] triggers: A trigger block. Valid only when `pipeline_type` is `V2`. Triggers are documented below.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineVariableArgs']]] variables: A pipeline-level variable block. Valid only when `pipeline_type` is `V2`. Variable are documented below.
               
               **Note:** `QUEUED` or `PARALLEL` mode can only be used with V2 pipelines.
        """
        pulumi.set(__self__, "artifact_stores", artifact_stores)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stages", stages)
        if execution_mode is not None:
            pulumi.set(__self__, "execution_mode", execution_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_type is not None:
            pulumi.set(__self__, "pipeline_type", pipeline_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="artifactStores")
    def artifact_stores(self) -> pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreArgs']]]:
        """
        One or more artifact_store blocks. Artifact stores are documented below.
        """
        return pulumi.get(self, "artifact_stores")

    @artifact_stores.setter
    def artifact_stores(self, value: pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreArgs']]]):
        pulumi.set(self, "artifact_stores", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Input[Sequence[pulumi.Input['PipelineStageArgs']]]:
        """
        A stage block. Stages are documented below.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: pulumi.Input[Sequence[pulumi.Input['PipelineStageArgs']]]):
        pulumi.set(self, "stages", value)

    @property
    @pulumi.getter(name="executionMode")
    def execution_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The method that the pipeline will use to handle multiple executions. The default mode is `SUPERSEDED`. For value values, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_PipelineDeclaration.html#CodePipeline-Type-PipelineDeclaration-executionMode).
        """
        return pulumi.get(self, "execution_mode")

    @execution_mode.setter
    def execution_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineType")
    def pipeline_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the pipeline. Possible values are: `V1` and `V2`. Default value is `V1`.
        """
        return pulumi.get(self, "pipeline_type")

    @pipeline_type.setter
    def pipeline_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerArgs']]]]:
        """
        A trigger block. Valid only when `pipeline_type` is `V2`. Triggers are documented below.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerArgs']]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineVariableArgs']]]]:
        """
        A pipeline-level variable block. Valid only when `pipeline_type` is `V2`. Variable are documented below.

        **Note:** `QUEUED` or `PARALLEL` mode can only be used with V2 pipelines.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineVariableArgs']]]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 artifact_stores: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreArgs']]]] = None,
                 execution_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineStageArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 trigger_alls: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerAllArgs']]]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerArgs']]]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineVariableArgs']]]] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input[builtins.str] arn: Codepipeline ARN.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreArgs']]] artifact_stores: One or more artifact_store blocks. Artifact stores are documented below.
        :param pulumi.Input[builtins.str] execution_mode: The method that the pipeline will use to handle multiple executions. The default mode is `SUPERSEDED`. For value values, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_PipelineDeclaration.html#CodePipeline-Type-PipelineDeclaration-executionMode).
        :param pulumi.Input[builtins.str] name: The name of the pipeline.
        :param pulumi.Input[builtins.str] pipeline_type: Type of the pipeline. Possible values are: `V1` and `V2`. Default value is `V1`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineStageArgs']]] stages: A stage block. Stages are documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineTriggerAllArgs']]] trigger_alls: A list of all triggers present on the pipeline, including default triggers added by AWS for `V2` pipelines which omit an explicit `trigger` definition.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineTriggerArgs']]] triggers: A trigger block. Valid only when `pipeline_type` is `V2`. Triggers are documented below.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineVariableArgs']]] variables: A pipeline-level variable block. Valid only when `pipeline_type` is `V2`. Variable are documented below.
               
               **Note:** `QUEUED` or `PARALLEL` mode can only be used with V2 pipelines.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if artifact_stores is not None:
            pulumi.set(__self__, "artifact_stores", artifact_stores)
        if execution_mode is not None:
            pulumi.set(__self__, "execution_mode", execution_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_type is not None:
            pulumi.set(__self__, "pipeline_type", pipeline_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if stages is not None:
            pulumi.set(__self__, "stages", stages)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if trigger_alls is not None:
            pulumi.set(__self__, "trigger_alls", trigger_alls)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Codepipeline ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="artifactStores")
    def artifact_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreArgs']]]]:
        """
        One or more artifact_store blocks. Artifact stores are documented below.
        """
        return pulumi.get(self, "artifact_stores")

    @artifact_stores.setter
    def artifact_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineArtifactStoreArgs']]]]):
        pulumi.set(self, "artifact_stores", value)

    @property
    @pulumi.getter(name="executionMode")
    def execution_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The method that the pipeline will use to handle multiple executions. The default mode is `SUPERSEDED`. For value values, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_PipelineDeclaration.html#CodePipeline-Type-PipelineDeclaration-executionMode).
        """
        return pulumi.get(self, "execution_mode")

    @execution_mode.setter
    def execution_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineType")
    def pipeline_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the pipeline. Possible values are: `V1` and `V2`. Default value is `V1`.
        """
        return pulumi.get(self, "pipeline_type")

    @pipeline_type.setter
    def pipeline_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineStageArgs']]]]:
        """
        A stage block. Stages are documented below.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineStageArgs']]]]):
        pulumi.set(self, "stages", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="triggerAlls")
    def trigger_alls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerAllArgs']]]]:
        """
        A list of all triggers present on the pipeline, including default triggers added by AWS for `V2` pipelines which omit an explicit `trigger` definition.
        """
        return pulumi.get(self, "trigger_alls")

    @trigger_alls.setter
    def trigger_alls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerAllArgs']]]]):
        pulumi.set(self, "trigger_alls", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerArgs']]]]:
        """
        A trigger block. Valid only when `pipeline_type` is `V2`. Triggers are documented below.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerArgs']]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineVariableArgs']]]]:
        """
        A pipeline-level variable block. Valid only when `pipeline_type` is `V2`. Variable are documented below.

        **Note:** `QUEUED` or `PARALLEL` mode can only be used with V2 pipelines.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineVariableArgs']]]]):
        pulumi.set(self, "variables", value)


@pulumi.type_token("aws:codepipeline/pipeline:Pipeline")
class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineArtifactStoreArgs', 'PipelineArtifactStoreArgsDict']]]]] = None,
                 execution_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageArgs', 'PipelineStageArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerArgs', 'PipelineTriggerArgsDict']]]]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineVariableArgs', 'PipelineVariableArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a CodePipeline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codestarconnections.Connection("example",
            name="example-connection",
            provider_type="GitHub")
        codepipeline_bucket = aws.s3.Bucket("codepipeline_bucket", bucket="test-bucket")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["codepipeline.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        codepipeline_role = aws.iam.Role("codepipeline_role",
            name="test-role",
            assume_role_policy=assume_role.json)
        s3kmskey = aws.kms.get_alias(name="alias/myKmsKey")
        codepipeline = aws.codepipeline.Pipeline("codepipeline",
            name="tf-test-pipeline",
            role_arn=codepipeline_role.arn,
            artifact_stores=[{
                "location": codepipeline_bucket.bucket,
                "type": "S3",
                "encryption_key": {
                    "id": s3kmskey.arn,
                    "type": "KMS",
                },
            }],
            stages=[
                {
                    "name": "Source",
                    "actions": [{
                        "name": "Source",
                        "category": "Source",
                        "owner": "AWS",
                        "provider": "CodeStarSourceConnection",
                        "version": "1",
                        "output_artifacts": ["source_output"],
                        "configuration": {
                            "ConnectionArn": example.arn,
                            "FullRepositoryId": "my-organization/example",
                            "BranchName": "main",
                        },
                    }],
                },
                {
                    "name": "Build",
                    "actions": [{
                        "name": "Build",
                        "category": "Build",
                        "owner": "AWS",
                        "provider": "CodeBuild",
                        "input_artifacts": ["source_output"],
                        "output_artifacts": ["build_output"],
                        "version": "1",
                        "configuration": {
                            "ProjectName": "test",
                        },
                    }],
                },
                {
                    "name": "Deploy",
                    "actions": [{
                        "name": "Deploy",
                        "category": "Deploy",
                        "owner": "AWS",
                        "provider": "CloudFormation",
                        "input_artifacts": ["build_output"],
                        "version": "1",
                        "configuration": {
                            "ActionMode": "REPLACE_ON_FAILURE",
                            "Capabilities": "CAPABILITY_AUTO_EXPAND,CAPABILITY_IAM",
                            "OutputFileName": "CreateStackOutput.json",
                            "StackName": "MyStack",
                            "TemplatePath": "build_output::sam-templated.yaml",
                        },
                    }],
                },
            ])
        codepipeline_bucket_pab = aws.s3.BucketPublicAccessBlock("codepipeline_bucket_pab",
            bucket=codepipeline_bucket.id,
            block_public_acls=True,
            block_public_policy=True,
            ignore_public_acls=True,
            restrict_public_buckets=True)
        codepipeline_policy = aws.iam.get_policy_document_output(statements=[
            {
                "effect": "Allow",
                "actions": [
                    "s3:GetObject",
                    "s3:GetObjectVersion",
                    "s3:GetBucketVersioning",
                    "s3:PutObjectAcl",
                    "s3:PutObject",
                ],
                "resources": [
                    codepipeline_bucket.arn,
                    codepipeline_bucket.arn.apply(lambda arn: f"{arn}/*"),
                ],
            },
            {
                "effect": "Allow",
                "actions": ["codestar-connections:UseConnection"],
                "resources": [example.arn],
            },
            {
                "effect": "Allow",
                "actions": [
                    "codebuild:BatchGetBuilds",
                    "codebuild:StartBuild",
                ],
                "resources": ["*"],
            },
        ])
        codepipeline_policy_role_policy = aws.iam.RolePolicy("codepipeline_policy",
            name="codepipeline_policy",
            role=codepipeline_role.id,
            policy=codepipeline_policy.json)
        ```

        ## Import

        Using `pulumi import`, import CodePipelines using the `name`. For example:

        ```sh
        $ pulumi import aws:codepipeline/pipeline:Pipeline example example-pipeline
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineArtifactStoreArgs', 'PipelineArtifactStoreArgsDict']]]] artifact_stores: One or more artifact_store blocks. Artifact stores are documented below.
        :param pulumi.Input[builtins.str] execution_mode: The method that the pipeline will use to handle multiple executions. The default mode is `SUPERSEDED`. For value values, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_PipelineDeclaration.html#CodePipeline-Type-PipelineDeclaration-executionMode).
        :param pulumi.Input[builtins.str] name: The name of the pipeline.
        :param pulumi.Input[builtins.str] pipeline_type: Type of the pipeline. Possible values are: `V1` and `V2`. Default value is `V1`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageArgs', 'PipelineStageArgsDict']]]] stages: A stage block. Stages are documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerArgs', 'PipelineTriggerArgsDict']]]] triggers: A trigger block. Valid only when `pipeline_type` is `V2`. Triggers are documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineVariableArgs', 'PipelineVariableArgsDict']]]] variables: A pipeline-level variable block. Valid only when `pipeline_type` is `V2`. Variable are documented below.
               
               **Note:** `QUEUED` or `PARALLEL` mode can only be used with V2 pipelines.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CodePipeline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codestarconnections.Connection("example",
            name="example-connection",
            provider_type="GitHub")
        codepipeline_bucket = aws.s3.Bucket("codepipeline_bucket", bucket="test-bucket")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["codepipeline.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        codepipeline_role = aws.iam.Role("codepipeline_role",
            name="test-role",
            assume_role_policy=assume_role.json)
        s3kmskey = aws.kms.get_alias(name="alias/myKmsKey")
        codepipeline = aws.codepipeline.Pipeline("codepipeline",
            name="tf-test-pipeline",
            role_arn=codepipeline_role.arn,
            artifact_stores=[{
                "location": codepipeline_bucket.bucket,
                "type": "S3",
                "encryption_key": {
                    "id": s3kmskey.arn,
                    "type": "KMS",
                },
            }],
            stages=[
                {
                    "name": "Source",
                    "actions": [{
                        "name": "Source",
                        "category": "Source",
                        "owner": "AWS",
                        "provider": "CodeStarSourceConnection",
                        "version": "1",
                        "output_artifacts": ["source_output"],
                        "configuration": {
                            "ConnectionArn": example.arn,
                            "FullRepositoryId": "my-organization/example",
                            "BranchName": "main",
                        },
                    }],
                },
                {
                    "name": "Build",
                    "actions": [{
                        "name": "Build",
                        "category": "Build",
                        "owner": "AWS",
                        "provider": "CodeBuild",
                        "input_artifacts": ["source_output"],
                        "output_artifacts": ["build_output"],
                        "version": "1",
                        "configuration": {
                            "ProjectName": "test",
                        },
                    }],
                },
                {
                    "name": "Deploy",
                    "actions": [{
                        "name": "Deploy",
                        "category": "Deploy",
                        "owner": "AWS",
                        "provider": "CloudFormation",
                        "input_artifacts": ["build_output"],
                        "version": "1",
                        "configuration": {
                            "ActionMode": "REPLACE_ON_FAILURE",
                            "Capabilities": "CAPABILITY_AUTO_EXPAND,CAPABILITY_IAM",
                            "OutputFileName": "CreateStackOutput.json",
                            "StackName": "MyStack",
                            "TemplatePath": "build_output::sam-templated.yaml",
                        },
                    }],
                },
            ])
        codepipeline_bucket_pab = aws.s3.BucketPublicAccessBlock("codepipeline_bucket_pab",
            bucket=codepipeline_bucket.id,
            block_public_acls=True,
            block_public_policy=True,
            ignore_public_acls=True,
            restrict_public_buckets=True)
        codepipeline_policy = aws.iam.get_policy_document_output(statements=[
            {
                "effect": "Allow",
                "actions": [
                    "s3:GetObject",
                    "s3:GetObjectVersion",
                    "s3:GetBucketVersioning",
                    "s3:PutObjectAcl",
                    "s3:PutObject",
                ],
                "resources": [
                    codepipeline_bucket.arn,
                    codepipeline_bucket.arn.apply(lambda arn: f"{arn}/*"),
                ],
            },
            {
                "effect": "Allow",
                "actions": ["codestar-connections:UseConnection"],
                "resources": [example.arn],
            },
            {
                "effect": "Allow",
                "actions": [
                    "codebuild:BatchGetBuilds",
                    "codebuild:StartBuild",
                ],
                "resources": ["*"],
            },
        ])
        codepipeline_policy_role_policy = aws.iam.RolePolicy("codepipeline_policy",
            name="codepipeline_policy",
            role=codepipeline_role.id,
            policy=codepipeline_policy.json)
        ```

        ## Import

        Using `pulumi import`, import CodePipelines using the `name`. For example:

        ```sh
        $ pulumi import aws:codepipeline/pipeline:Pipeline example example-pipeline
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineArtifactStoreArgs', 'PipelineArtifactStoreArgsDict']]]]] = None,
                 execution_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageArgs', 'PipelineStageArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerArgs', 'PipelineTriggerArgsDict']]]]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineVariableArgs', 'PipelineVariableArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            if artifact_stores is None and not opts.urn:
                raise TypeError("Missing required property 'artifact_stores'")
            __props__.__dict__["artifact_stores"] = artifact_stores
            __props__.__dict__["execution_mode"] = execution_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["pipeline_type"] = pipeline_type
            __props__.__dict__["region"] = region
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if stages is None and not opts.urn:
                raise TypeError("Missing required property 'stages'")
            __props__.__dict__["stages"] = stages
            __props__.__dict__["tags"] = tags
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["variables"] = variables
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["trigger_alls"] = None
        super(Pipeline, __self__).__init__(
            'aws:codepipeline/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            artifact_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineArtifactStoreArgs', 'PipelineArtifactStoreArgsDict']]]]] = None,
            execution_mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pipeline_type: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            role_arn: Optional[pulumi.Input[builtins.str]] = None,
            stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageArgs', 'PipelineStageArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            trigger_alls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerAllArgs', 'PipelineTriggerAllArgsDict']]]]] = None,
            triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerArgs', 'PipelineTriggerArgsDict']]]]] = None,
            variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineVariableArgs', 'PipelineVariableArgsDict']]]]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: Codepipeline ARN.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineArtifactStoreArgs', 'PipelineArtifactStoreArgsDict']]]] artifact_stores: One or more artifact_store blocks. Artifact stores are documented below.
        :param pulumi.Input[builtins.str] execution_mode: The method that the pipeline will use to handle multiple executions. The default mode is `SUPERSEDED`. For value values, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_PipelineDeclaration.html#CodePipeline-Type-PipelineDeclaration-executionMode).
        :param pulumi.Input[builtins.str] name: The name of the pipeline.
        :param pulumi.Input[builtins.str] pipeline_type: Type of the pipeline. Possible values are: `V1` and `V2`. Default value is `V1`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineStageArgs', 'PipelineStageArgsDict']]]] stages: A stage block. Stages are documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerAllArgs', 'PipelineTriggerAllArgsDict']]]] trigger_alls: A list of all triggers present on the pipeline, including default triggers added by AWS for `V2` pipelines which omit an explicit `trigger` definition.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineTriggerArgs', 'PipelineTriggerArgsDict']]]] triggers: A trigger block. Valid only when `pipeline_type` is `V2`. Triggers are documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineVariableArgs', 'PipelineVariableArgsDict']]]] variables: A pipeline-level variable block. Valid only when `pipeline_type` is `V2`. Variable are documented below.
               
               **Note:** `QUEUED` or `PARALLEL` mode can only be used with V2 pipelines.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["artifact_stores"] = artifact_stores
        __props__.__dict__["execution_mode"] = execution_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["pipeline_type"] = pipeline_type
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["stages"] = stages
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["trigger_alls"] = trigger_alls
        __props__.__dict__["triggers"] = triggers
        __props__.__dict__["variables"] = variables
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Codepipeline ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="artifactStores")
    def artifact_stores(self) -> pulumi.Output[Sequence['outputs.PipelineArtifactStore']]:
        """
        One or more artifact_store blocks. Artifact stores are documented below.
        """
        return pulumi.get(self, "artifact_stores")

    @property
    @pulumi.getter(name="executionMode")
    def execution_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The method that the pipeline will use to handle multiple executions. The default mode is `SUPERSEDED`. For value values, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_PipelineDeclaration.html#CodePipeline-Type-PipelineDeclaration-executionMode).
        """
        return pulumi.get(self, "execution_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pipelineType")
    def pipeline_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of the pipeline. Possible values are: `V1` and `V2`. Default value is `V1`.
        """
        return pulumi.get(self, "pipeline_type")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        A service role Amazon Resource Name (ARN) that grants AWS CodePipeline permission to make calls to AWS services on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Output[Sequence['outputs.PipelineStage']]:
        """
        A stage block. Stages are documented below.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="triggerAlls")
    def trigger_alls(self) -> pulumi.Output[Sequence['outputs.PipelineTriggerAll']]:
        """
        A list of all triggers present on the pipeline, including default triggers added by AWS for `V2` pipelines which omit an explicit `trigger` definition.
        """
        return pulumi.get(self, "trigger_alls")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineTrigger']]]:
        """
        A trigger block. Valid only when `pipeline_type` is `V2`. Triggers are documented below.
        """
        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineVariable']]]:
        """
        A pipeline-level variable block. Valid only when `pipeline_type` is `V2`. Variable are documented below.

        **Note:** `QUEUED` or `PARALLEL` mode can only be used with V2 pipelines.
        """
        return pulumi.get(self, "variables")

