# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'NotificationRuleTargetArgs',
    'NotificationRuleTargetArgsDict',
]

MYPY = False

if not MYPY:
    class NotificationRuleTargetArgsDict(TypedDict):
        address: pulumi.Input[builtins.str]
        """
        The ARN of notification rule target. For example, a SNS Topic ARN.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of the notification target. Default value is `SNS`.
        """
elif False:
    NotificationRuleTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NotificationRuleTargetArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[builtins.str],
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] address: The ARN of notification rule target. For example, a SNS Topic ARN.
        :param pulumi.Input[builtins.str] status: The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
        :param pulumi.Input[builtins.str] type: The type of the notification target. Default value is `SNS`.
        """
        pulumi.set(__self__, "address", address)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of notification rule target. For example, a SNS Topic ARN.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the notification target. Default value is `SNS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


