# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedUserPoolClientArgs', 'ManagedUserPoolClient']

@pulumi.input_type
class ManagedUserPoolClientArgs:
    def __init__(__self__, *,
                 user_pool_id: pulumi.Input[builtins.str],
                 access_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 allowed_oauth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_oauth_flows_user_pool_client: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 analytics_configuration: Optional[pulumi.Input['ManagedUserPoolClientAnalyticsConfigurationArgs']] = None,
                 auth_session_validity: Optional[pulumi.Input[builtins.int]] = None,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_redirect_uri: Optional[pulumi.Input[builtins.str]] = None,
                 enable_propagate_additional_user_context_data: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_token_revocation: Optional[pulumi.Input[builtins.bool]] = None,
                 explicit_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 id_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 prevent_user_existence_errors: Optional[pulumi.Input[builtins.str]] = None,
                 read_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 refresh_token_rotation: Optional[pulumi.Input['ManagedUserPoolClientRefreshTokenRotationArgs']] = None,
                 refresh_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 supported_identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 token_validity_units: Optional[pulumi.Input['ManagedUserPoolClientTokenValidityUnitsArgs']] = None,
                 write_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ManagedUserPoolClient resource.
        :param pulumi.Input[builtins.str] user_pool_id: User pool that the client belongs to.
        :param pulumi.Input[builtins.int] access_token_validity: Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_oauth_flows: List of allowed OAuth flows, including `code`, `implicit`, and `client_credentials`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.bool] allowed_oauth_flows_user_pool_client: Whether the client is allowed to use OAuth 2.0 features. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure the following arguments: `callback_urls`, `logout_urls`, `allowed_oauth_scopes` and `allowed_oauth_flows`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_oauth_scopes: List of allowed OAuth scopes, including `phone`, `email`, `openid`, `profile`, and `aws.cognito.signin.user.admin`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input['ManagedUserPoolClientAnalyticsConfigurationArgs'] analytics_configuration: Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
        :param pulumi.Input[builtins.int] auth_session_validity: Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] callback_urls: List of allowed callback URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.str] default_redirect_uri: Default redirect URI and must be included in the list of callback URLs.
        :param pulumi.Input[builtins.bool] enable_propagate_additional_user_context_data: Enables the propagation of additional user context data.
        :param pulumi.Input[builtins.bool] enable_token_revocation: Enables or disables token revocation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] explicit_auth_flows: List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
        :param pulumi.Input[builtins.int] id_token_validity: Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] logout_urls: List of allowed logout URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.str] name_pattern: Regular expression that matches the name of the existing User Pool Client to be managed. It must only match one User Pool Client.
        :param pulumi.Input[builtins.str] name_prefix: String that matches the beginning of the name of the  existing User Pool Client to be managed. It must match only one User Pool Client.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] prevent_user_existence_errors: Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_attributes: List of user pool attributes that the application client can read from.
        :param pulumi.Input['ManagedUserPoolClientRefreshTokenRotationArgs'] refresh_token_rotation: A block that specifies the configuration of refresh token rotation. Detailed below.
        :param pulumi.Input[builtins.int] refresh_token_validity: Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supported_identity_providers: List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `cognito.IdentityProvider` resource(s), or the equivalent string(s).
        :param pulumi.Input['ManagedUserPoolClientTokenValidityUnitsArgs'] token_validity_units: Configuration block for representing the validity times in units. See details below. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] write_attributes: List of user pool attributes that the application client can write to.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if access_token_validity is not None:
            pulumi.set(__self__, "access_token_validity", access_token_validity)
        if allowed_oauth_flows is not None:
            pulumi.set(__self__, "allowed_oauth_flows", allowed_oauth_flows)
        if allowed_oauth_flows_user_pool_client is not None:
            pulumi.set(__self__, "allowed_oauth_flows_user_pool_client", allowed_oauth_flows_user_pool_client)
        if allowed_oauth_scopes is not None:
            pulumi.set(__self__, "allowed_oauth_scopes", allowed_oauth_scopes)
        if analytics_configuration is not None:
            pulumi.set(__self__, "analytics_configuration", analytics_configuration)
        if auth_session_validity is not None:
            pulumi.set(__self__, "auth_session_validity", auth_session_validity)
        if callback_urls is not None:
            pulumi.set(__self__, "callback_urls", callback_urls)
        if default_redirect_uri is not None:
            pulumi.set(__self__, "default_redirect_uri", default_redirect_uri)
        if enable_propagate_additional_user_context_data is not None:
            pulumi.set(__self__, "enable_propagate_additional_user_context_data", enable_propagate_additional_user_context_data)
        if enable_token_revocation is not None:
            pulumi.set(__self__, "enable_token_revocation", enable_token_revocation)
        if explicit_auth_flows is not None:
            pulumi.set(__self__, "explicit_auth_flows", explicit_auth_flows)
        if id_token_validity is not None:
            pulumi.set(__self__, "id_token_validity", id_token_validity)
        if logout_urls is not None:
            pulumi.set(__self__, "logout_urls", logout_urls)
        if name_pattern is not None:
            pulumi.set(__self__, "name_pattern", name_pattern)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if prevent_user_existence_errors is not None:
            pulumi.set(__self__, "prevent_user_existence_errors", prevent_user_existence_errors)
        if read_attributes is not None:
            pulumi.set(__self__, "read_attributes", read_attributes)
        if refresh_token_rotation is not None:
            pulumi.set(__self__, "refresh_token_rotation", refresh_token_rotation)
        if refresh_token_validity is not None:
            pulumi.set(__self__, "refresh_token_validity", refresh_token_validity)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if supported_identity_providers is not None:
            pulumi.set(__self__, "supported_identity_providers", supported_identity_providers)
        if token_validity_units is not None:
            pulumi.set(__self__, "token_validity_units", token_validity_units)
        if write_attributes is not None:
            pulumi.set(__self__, "write_attributes", write_attributes)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        User pool that the client belongs to.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="accessTokenValidity")
    def access_token_validity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
        """
        return pulumi.get(self, "access_token_validity")

    @access_token_validity.setter
    def access_token_validity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "access_token_validity", value)

    @property
    @pulumi.getter(name="allowedOauthFlows")
    def allowed_oauth_flows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of allowed OAuth flows, including `code`, `implicit`, and `client_credentials`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "allowed_oauth_flows")

    @allowed_oauth_flows.setter
    def allowed_oauth_flows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_oauth_flows", value)

    @property
    @pulumi.getter(name="allowedOauthFlowsUserPoolClient")
    def allowed_oauth_flows_user_pool_client(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the client is allowed to use OAuth 2.0 features. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure the following arguments: `callback_urls`, `logout_urls`, `allowed_oauth_scopes` and `allowed_oauth_flows`.
        """
        return pulumi.get(self, "allowed_oauth_flows_user_pool_client")

    @allowed_oauth_flows_user_pool_client.setter
    def allowed_oauth_flows_user_pool_client(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allowed_oauth_flows_user_pool_client", value)

    @property
    @pulumi.getter(name="allowedOauthScopes")
    def allowed_oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of allowed OAuth scopes, including `phone`, `email`, `openid`, `profile`, and `aws.cognito.signin.user.admin`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "allowed_oauth_scopes")

    @allowed_oauth_scopes.setter
    def allowed_oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_oauth_scopes", value)

    @property
    @pulumi.getter(name="analyticsConfiguration")
    def analytics_configuration(self) -> Optional[pulumi.Input['ManagedUserPoolClientAnalyticsConfigurationArgs']]:
        """
        Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
        """
        return pulumi.get(self, "analytics_configuration")

    @analytics_configuration.setter
    def analytics_configuration(self, value: Optional[pulumi.Input['ManagedUserPoolClientAnalyticsConfigurationArgs']]):
        pulumi.set(self, "analytics_configuration", value)

    @property
    @pulumi.getter(name="authSessionValidity")
    def auth_session_validity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
        """
        return pulumi.get(self, "auth_session_validity")

    @auth_session_validity.setter
    def auth_session_validity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "auth_session_validity", value)

    @property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of allowed callback URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "callback_urls")

    @callback_urls.setter
    def callback_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "callback_urls", value)

    @property
    @pulumi.getter(name="defaultRedirectUri")
    def default_redirect_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default redirect URI and must be included in the list of callback URLs.
        """
        return pulumi.get(self, "default_redirect_uri")

    @default_redirect_uri.setter
    def default_redirect_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_redirect_uri", value)

    @property
    @pulumi.getter(name="enablePropagateAdditionalUserContextData")
    def enable_propagate_additional_user_context_data(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the propagation of additional user context data.
        """
        return pulumi.get(self, "enable_propagate_additional_user_context_data")

    @enable_propagate_additional_user_context_data.setter
    def enable_propagate_additional_user_context_data(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_propagate_additional_user_context_data", value)

    @property
    @pulumi.getter(name="enableTokenRevocation")
    def enable_token_revocation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables or disables token revocation.
        """
        return pulumi.get(self, "enable_token_revocation")

    @enable_token_revocation.setter
    def enable_token_revocation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_token_revocation", value)

    @property
    @pulumi.getter(name="explicitAuthFlows")
    def explicit_auth_flows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
        """
        return pulumi.get(self, "explicit_auth_flows")

    @explicit_auth_flows.setter
    def explicit_auth_flows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "explicit_auth_flows", value)

    @property
    @pulumi.getter(name="idTokenValidity")
    def id_token_validity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
        """
        return pulumi.get(self, "id_token_validity")

    @id_token_validity.setter
    def id_token_validity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "id_token_validity", value)

    @property
    @pulumi.getter(name="logoutUrls")
    def logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of allowed logout URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "logout_urls")

    @logout_urls.setter
    def logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "logout_urls", value)

    @property
    @pulumi.getter(name="namePattern")
    def name_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regular expression that matches the name of the existing User Pool Client to be managed. It must only match one User Pool Client.
        """
        return pulumi.get(self, "name_pattern")

    @name_pattern.setter
    def name_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_pattern", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String that matches the beginning of the name of the  existing User Pool Client to be managed. It must match only one User Pool Client.

        The following arguments are optional:
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="preventUserExistenceErrors")
    def prevent_user_existence_errors(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
        """
        return pulumi.get(self, "prevent_user_existence_errors")

    @prevent_user_existence_errors.setter
    def prevent_user_existence_errors(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prevent_user_existence_errors", value)

    @property
    @pulumi.getter(name="readAttributes")
    def read_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of user pool attributes that the application client can read from.
        """
        return pulumi.get(self, "read_attributes")

    @read_attributes.setter
    def read_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "read_attributes", value)

    @property
    @pulumi.getter(name="refreshTokenRotation")
    def refresh_token_rotation(self) -> Optional[pulumi.Input['ManagedUserPoolClientRefreshTokenRotationArgs']]:
        """
        A block that specifies the configuration of refresh token rotation. Detailed below.
        """
        return pulumi.get(self, "refresh_token_rotation")

    @refresh_token_rotation.setter
    def refresh_token_rotation(self, value: Optional[pulumi.Input['ManagedUserPoolClientRefreshTokenRotationArgs']]):
        pulumi.set(self, "refresh_token_rotation", value)

    @property
    @pulumi.getter(name="refreshTokenValidity")
    def refresh_token_validity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
        """
        return pulumi.get(self, "refresh_token_validity")

    @refresh_token_validity.setter
    def refresh_token_validity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_token_validity", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="supportedIdentityProviders")
    def supported_identity_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `cognito.IdentityProvider` resource(s), or the equivalent string(s).
        """
        return pulumi.get(self, "supported_identity_providers")

    @supported_identity_providers.setter
    def supported_identity_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "supported_identity_providers", value)

    @property
    @pulumi.getter(name="tokenValidityUnits")
    def token_validity_units(self) -> Optional[pulumi.Input['ManagedUserPoolClientTokenValidityUnitsArgs']]:
        """
        Configuration block for representing the validity times in units. See details below. Detailed below.
        """
        return pulumi.get(self, "token_validity_units")

    @token_validity_units.setter
    def token_validity_units(self, value: Optional[pulumi.Input['ManagedUserPoolClientTokenValidityUnitsArgs']]):
        pulumi.set(self, "token_validity_units", value)

    @property
    @pulumi.getter(name="writeAttributes")
    def write_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of user pool attributes that the application client can write to.
        """
        return pulumi.get(self, "write_attributes")

    @write_attributes.setter
    def write_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "write_attributes", value)


@pulumi.input_type
class _ManagedUserPoolClientState:
    def __init__(__self__, *,
                 access_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 allowed_oauth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_oauth_flows_user_pool_client: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 analytics_configuration: Optional[pulumi.Input['ManagedUserPoolClientAnalyticsConfigurationArgs']] = None,
                 auth_session_validity: Optional[pulumi.Input[builtins.int]] = None,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 default_redirect_uri: Optional[pulumi.Input[builtins.str]] = None,
                 enable_propagate_additional_user_context_data: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_token_revocation: Optional[pulumi.Input[builtins.bool]] = None,
                 explicit_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 id_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 prevent_user_existence_errors: Optional[pulumi.Input[builtins.str]] = None,
                 read_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 refresh_token_rotation: Optional[pulumi.Input['ManagedUserPoolClientRefreshTokenRotationArgs']] = None,
                 refresh_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 supported_identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 token_validity_units: Optional[pulumi.Input['ManagedUserPoolClientTokenValidityUnitsArgs']] = None,
                 user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 write_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ManagedUserPoolClient resources.
        :param pulumi.Input[builtins.int] access_token_validity: Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_oauth_flows: List of allowed OAuth flows, including `code`, `implicit`, and `client_credentials`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.bool] allowed_oauth_flows_user_pool_client: Whether the client is allowed to use OAuth 2.0 features. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure the following arguments: `callback_urls`, `logout_urls`, `allowed_oauth_scopes` and `allowed_oauth_flows`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_oauth_scopes: List of allowed OAuth scopes, including `phone`, `email`, `openid`, `profile`, and `aws.cognito.signin.user.admin`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input['ManagedUserPoolClientAnalyticsConfigurationArgs'] analytics_configuration: Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
        :param pulumi.Input[builtins.int] auth_session_validity: Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] callback_urls: List of allowed callback URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.str] client_secret: Client secret of the user pool client.
        :param pulumi.Input[builtins.str] default_redirect_uri: Default redirect URI and must be included in the list of callback URLs.
        :param pulumi.Input[builtins.bool] enable_propagate_additional_user_context_data: Enables the propagation of additional user context data.
        :param pulumi.Input[builtins.bool] enable_token_revocation: Enables or disables token revocation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] explicit_auth_flows: List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
        :param pulumi.Input[builtins.int] id_token_validity: Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] logout_urls: List of allowed logout URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.str] name: Name of the user pool client.
        :param pulumi.Input[builtins.str] name_pattern: Regular expression that matches the name of the existing User Pool Client to be managed. It must only match one User Pool Client.
        :param pulumi.Input[builtins.str] name_prefix: String that matches the beginning of the name of the  existing User Pool Client to be managed. It must match only one User Pool Client.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] prevent_user_existence_errors: Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_attributes: List of user pool attributes that the application client can read from.
        :param pulumi.Input['ManagedUserPoolClientRefreshTokenRotationArgs'] refresh_token_rotation: A block that specifies the configuration of refresh token rotation. Detailed below.
        :param pulumi.Input[builtins.int] refresh_token_validity: Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supported_identity_providers: List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `cognito.IdentityProvider` resource(s), or the equivalent string(s).
        :param pulumi.Input['ManagedUserPoolClientTokenValidityUnitsArgs'] token_validity_units: Configuration block for representing the validity times in units. See details below. Detailed below.
        :param pulumi.Input[builtins.str] user_pool_id: User pool that the client belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] write_attributes: List of user pool attributes that the application client can write to.
        """
        if access_token_validity is not None:
            pulumi.set(__self__, "access_token_validity", access_token_validity)
        if allowed_oauth_flows is not None:
            pulumi.set(__self__, "allowed_oauth_flows", allowed_oauth_flows)
        if allowed_oauth_flows_user_pool_client is not None:
            pulumi.set(__self__, "allowed_oauth_flows_user_pool_client", allowed_oauth_flows_user_pool_client)
        if allowed_oauth_scopes is not None:
            pulumi.set(__self__, "allowed_oauth_scopes", allowed_oauth_scopes)
        if analytics_configuration is not None:
            pulumi.set(__self__, "analytics_configuration", analytics_configuration)
        if auth_session_validity is not None:
            pulumi.set(__self__, "auth_session_validity", auth_session_validity)
        if callback_urls is not None:
            pulumi.set(__self__, "callback_urls", callback_urls)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if default_redirect_uri is not None:
            pulumi.set(__self__, "default_redirect_uri", default_redirect_uri)
        if enable_propagate_additional_user_context_data is not None:
            pulumi.set(__self__, "enable_propagate_additional_user_context_data", enable_propagate_additional_user_context_data)
        if enable_token_revocation is not None:
            pulumi.set(__self__, "enable_token_revocation", enable_token_revocation)
        if explicit_auth_flows is not None:
            pulumi.set(__self__, "explicit_auth_flows", explicit_auth_flows)
        if id_token_validity is not None:
            pulumi.set(__self__, "id_token_validity", id_token_validity)
        if logout_urls is not None:
            pulumi.set(__self__, "logout_urls", logout_urls)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_pattern is not None:
            pulumi.set(__self__, "name_pattern", name_pattern)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if prevent_user_existence_errors is not None:
            pulumi.set(__self__, "prevent_user_existence_errors", prevent_user_existence_errors)
        if read_attributes is not None:
            pulumi.set(__self__, "read_attributes", read_attributes)
        if refresh_token_rotation is not None:
            pulumi.set(__self__, "refresh_token_rotation", refresh_token_rotation)
        if refresh_token_validity is not None:
            pulumi.set(__self__, "refresh_token_validity", refresh_token_validity)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if supported_identity_providers is not None:
            pulumi.set(__self__, "supported_identity_providers", supported_identity_providers)
        if token_validity_units is not None:
            pulumi.set(__self__, "token_validity_units", token_validity_units)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)
        if write_attributes is not None:
            pulumi.set(__self__, "write_attributes", write_attributes)

    @property
    @pulumi.getter(name="accessTokenValidity")
    def access_token_validity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
        """
        return pulumi.get(self, "access_token_validity")

    @access_token_validity.setter
    def access_token_validity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "access_token_validity", value)

    @property
    @pulumi.getter(name="allowedOauthFlows")
    def allowed_oauth_flows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of allowed OAuth flows, including `code`, `implicit`, and `client_credentials`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "allowed_oauth_flows")

    @allowed_oauth_flows.setter
    def allowed_oauth_flows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_oauth_flows", value)

    @property
    @pulumi.getter(name="allowedOauthFlowsUserPoolClient")
    def allowed_oauth_flows_user_pool_client(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the client is allowed to use OAuth 2.0 features. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure the following arguments: `callback_urls`, `logout_urls`, `allowed_oauth_scopes` and `allowed_oauth_flows`.
        """
        return pulumi.get(self, "allowed_oauth_flows_user_pool_client")

    @allowed_oauth_flows_user_pool_client.setter
    def allowed_oauth_flows_user_pool_client(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allowed_oauth_flows_user_pool_client", value)

    @property
    @pulumi.getter(name="allowedOauthScopes")
    def allowed_oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of allowed OAuth scopes, including `phone`, `email`, `openid`, `profile`, and `aws.cognito.signin.user.admin`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "allowed_oauth_scopes")

    @allowed_oauth_scopes.setter
    def allowed_oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_oauth_scopes", value)

    @property
    @pulumi.getter(name="analyticsConfiguration")
    def analytics_configuration(self) -> Optional[pulumi.Input['ManagedUserPoolClientAnalyticsConfigurationArgs']]:
        """
        Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
        """
        return pulumi.get(self, "analytics_configuration")

    @analytics_configuration.setter
    def analytics_configuration(self, value: Optional[pulumi.Input['ManagedUserPoolClientAnalyticsConfigurationArgs']]):
        pulumi.set(self, "analytics_configuration", value)

    @property
    @pulumi.getter(name="authSessionValidity")
    def auth_session_validity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
        """
        return pulumi.get(self, "auth_session_validity")

    @auth_session_validity.setter
    def auth_session_validity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "auth_session_validity", value)

    @property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of allowed callback URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "callback_urls")

    @callback_urls.setter
    def callback_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "callback_urls", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Client secret of the user pool client.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="defaultRedirectUri")
    def default_redirect_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default redirect URI and must be included in the list of callback URLs.
        """
        return pulumi.get(self, "default_redirect_uri")

    @default_redirect_uri.setter
    def default_redirect_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_redirect_uri", value)

    @property
    @pulumi.getter(name="enablePropagateAdditionalUserContextData")
    def enable_propagate_additional_user_context_data(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the propagation of additional user context data.
        """
        return pulumi.get(self, "enable_propagate_additional_user_context_data")

    @enable_propagate_additional_user_context_data.setter
    def enable_propagate_additional_user_context_data(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_propagate_additional_user_context_data", value)

    @property
    @pulumi.getter(name="enableTokenRevocation")
    def enable_token_revocation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables or disables token revocation.
        """
        return pulumi.get(self, "enable_token_revocation")

    @enable_token_revocation.setter
    def enable_token_revocation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_token_revocation", value)

    @property
    @pulumi.getter(name="explicitAuthFlows")
    def explicit_auth_flows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
        """
        return pulumi.get(self, "explicit_auth_flows")

    @explicit_auth_flows.setter
    def explicit_auth_flows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "explicit_auth_flows", value)

    @property
    @pulumi.getter(name="idTokenValidity")
    def id_token_validity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
        """
        return pulumi.get(self, "id_token_validity")

    @id_token_validity.setter
    def id_token_validity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "id_token_validity", value)

    @property
    @pulumi.getter(name="logoutUrls")
    def logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of allowed logout URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "logout_urls")

    @logout_urls.setter
    def logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "logout_urls", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the user pool client.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePattern")
    def name_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regular expression that matches the name of the existing User Pool Client to be managed. It must only match one User Pool Client.
        """
        return pulumi.get(self, "name_pattern")

    @name_pattern.setter
    def name_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_pattern", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String that matches the beginning of the name of the  existing User Pool Client to be managed. It must match only one User Pool Client.

        The following arguments are optional:
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="preventUserExistenceErrors")
    def prevent_user_existence_errors(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
        """
        return pulumi.get(self, "prevent_user_existence_errors")

    @prevent_user_existence_errors.setter
    def prevent_user_existence_errors(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prevent_user_existence_errors", value)

    @property
    @pulumi.getter(name="readAttributes")
    def read_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of user pool attributes that the application client can read from.
        """
        return pulumi.get(self, "read_attributes")

    @read_attributes.setter
    def read_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "read_attributes", value)

    @property
    @pulumi.getter(name="refreshTokenRotation")
    def refresh_token_rotation(self) -> Optional[pulumi.Input['ManagedUserPoolClientRefreshTokenRotationArgs']]:
        """
        A block that specifies the configuration of refresh token rotation. Detailed below.
        """
        return pulumi.get(self, "refresh_token_rotation")

    @refresh_token_rotation.setter
    def refresh_token_rotation(self, value: Optional[pulumi.Input['ManagedUserPoolClientRefreshTokenRotationArgs']]):
        pulumi.set(self, "refresh_token_rotation", value)

    @property
    @pulumi.getter(name="refreshTokenValidity")
    def refresh_token_validity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
        """
        return pulumi.get(self, "refresh_token_validity")

    @refresh_token_validity.setter
    def refresh_token_validity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "refresh_token_validity", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="supportedIdentityProviders")
    def supported_identity_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `cognito.IdentityProvider` resource(s), or the equivalent string(s).
        """
        return pulumi.get(self, "supported_identity_providers")

    @supported_identity_providers.setter
    def supported_identity_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "supported_identity_providers", value)

    @property
    @pulumi.getter(name="tokenValidityUnits")
    def token_validity_units(self) -> Optional[pulumi.Input['ManagedUserPoolClientTokenValidityUnitsArgs']]:
        """
        Configuration block for representing the validity times in units. See details below. Detailed below.
        """
        return pulumi.get(self, "token_validity_units")

    @token_validity_units.setter
    def token_validity_units(self, value: Optional[pulumi.Input['ManagedUserPoolClientTokenValidityUnitsArgs']]):
        pulumi.set(self, "token_validity_units", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User pool that the client belongs to.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="writeAttributes")
    def write_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of user pool attributes that the application client can write to.
        """
        return pulumi.get(self, "write_attributes")

    @write_attributes.setter
    def write_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "write_attributes", value)


@pulumi.type_token("aws:cognito/managedUserPoolClient:ManagedUserPoolClient")
class ManagedUserPoolClient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 allowed_oauth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_oauth_flows_user_pool_client: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 analytics_configuration: Optional[pulumi.Input[Union['ManagedUserPoolClientAnalyticsConfigurationArgs', 'ManagedUserPoolClientAnalyticsConfigurationArgsDict']]] = None,
                 auth_session_validity: Optional[pulumi.Input[builtins.int]] = None,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_redirect_uri: Optional[pulumi.Input[builtins.str]] = None,
                 enable_propagate_additional_user_context_data: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_token_revocation: Optional[pulumi.Input[builtins.bool]] = None,
                 explicit_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 id_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 prevent_user_existence_errors: Optional[pulumi.Input[builtins.str]] = None,
                 read_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 refresh_token_rotation: Optional[pulumi.Input[Union['ManagedUserPoolClientRefreshTokenRotationArgs', 'ManagedUserPoolClientRefreshTokenRotationArgsDict']]] = None,
                 refresh_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 supported_identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 token_validity_units: Optional[pulumi.Input[Union['ManagedUserPoolClientTokenValidityUnitsArgs', 'ManagedUserPoolClientTokenValidityUnitsArgsDict']]] = None,
                 user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 write_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Use the `cognito.UserPoolClient` resource to manage a Cognito User Pool Client.

        **This resource is advanced** and has special caveats to consider before use. Please read this document completely before using the resource.

        Use the `cognito.ManagedUserPoolClient` resource to manage a Cognito User Pool Client that is automatically created by an AWS service. For instance, when [configuring an OpenSearch Domain to use Cognito authentication](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html), the OpenSearch service creates the User Pool Client during setup and removes it when it is no longer required. As a result, the `cognito.ManagedUserPoolClient` resource does not create or delete this resource, but instead assumes management of it.

        Use the `cognito.UserPoolClient` resource to manage Cognito User Pool Clients for normal use cases.

        ## Example Usage

        ### Using Name Pattern

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.ManagedUserPoolClient("example",
            name_pattern="^AmazonOpenSearchService-example-(\\\\w+)$",
            user_pool_id=example_aws_cognito_user_pool["id"])
        ```

        ## Import

        Using `pulumi import`, import Cognito User Pool Clients using the `id` of the Cognito User Pool and the `id` of the Cognito User Pool Client. For example:

        ```sh
        $ pulumi import aws:cognito/managedUserPoolClient:ManagedUserPoolClient client us-west-2_abc123/3ho4ek12345678909nh3fmhpko
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] access_token_validity: Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_oauth_flows: List of allowed OAuth flows, including `code`, `implicit`, and `client_credentials`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.bool] allowed_oauth_flows_user_pool_client: Whether the client is allowed to use OAuth 2.0 features. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure the following arguments: `callback_urls`, `logout_urls`, `allowed_oauth_scopes` and `allowed_oauth_flows`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_oauth_scopes: List of allowed OAuth scopes, including `phone`, `email`, `openid`, `profile`, and `aws.cognito.signin.user.admin`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[Union['ManagedUserPoolClientAnalyticsConfigurationArgs', 'ManagedUserPoolClientAnalyticsConfigurationArgsDict']] analytics_configuration: Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
        :param pulumi.Input[builtins.int] auth_session_validity: Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] callback_urls: List of allowed callback URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.str] default_redirect_uri: Default redirect URI and must be included in the list of callback URLs.
        :param pulumi.Input[builtins.bool] enable_propagate_additional_user_context_data: Enables the propagation of additional user context data.
        :param pulumi.Input[builtins.bool] enable_token_revocation: Enables or disables token revocation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] explicit_auth_flows: List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
        :param pulumi.Input[builtins.int] id_token_validity: Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] logout_urls: List of allowed logout URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.str] name_pattern: Regular expression that matches the name of the existing User Pool Client to be managed. It must only match one User Pool Client.
        :param pulumi.Input[builtins.str] name_prefix: String that matches the beginning of the name of the  existing User Pool Client to be managed. It must match only one User Pool Client.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] prevent_user_existence_errors: Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_attributes: List of user pool attributes that the application client can read from.
        :param pulumi.Input[Union['ManagedUserPoolClientRefreshTokenRotationArgs', 'ManagedUserPoolClientRefreshTokenRotationArgsDict']] refresh_token_rotation: A block that specifies the configuration of refresh token rotation. Detailed below.
        :param pulumi.Input[builtins.int] refresh_token_validity: Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supported_identity_providers: List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `cognito.IdentityProvider` resource(s), or the equivalent string(s).
        :param pulumi.Input[Union['ManagedUserPoolClientTokenValidityUnitsArgs', 'ManagedUserPoolClientTokenValidityUnitsArgsDict']] token_validity_units: Configuration block for representing the validity times in units. See details below. Detailed below.
        :param pulumi.Input[builtins.str] user_pool_id: User pool that the client belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] write_attributes: List of user pool attributes that the application client can write to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedUserPoolClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use the `cognito.UserPoolClient` resource to manage a Cognito User Pool Client.

        **This resource is advanced** and has special caveats to consider before use. Please read this document completely before using the resource.

        Use the `cognito.ManagedUserPoolClient` resource to manage a Cognito User Pool Client that is automatically created by an AWS service. For instance, when [configuring an OpenSearch Domain to use Cognito authentication](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html), the OpenSearch service creates the User Pool Client during setup and removes it when it is no longer required. As a result, the `cognito.ManagedUserPoolClient` resource does not create or delete this resource, but instead assumes management of it.

        Use the `cognito.UserPoolClient` resource to manage Cognito User Pool Clients for normal use cases.

        ## Example Usage

        ### Using Name Pattern

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.ManagedUserPoolClient("example",
            name_pattern="^AmazonOpenSearchService-example-(\\\\w+)$",
            user_pool_id=example_aws_cognito_user_pool["id"])
        ```

        ## Import

        Using `pulumi import`, import Cognito User Pool Clients using the `id` of the Cognito User Pool and the `id` of the Cognito User Pool Client. For example:

        ```sh
        $ pulumi import aws:cognito/managedUserPoolClient:ManagedUserPoolClient client us-west-2_abc123/3ho4ek12345678909nh3fmhpko
        ```

        :param str resource_name: The name of the resource.
        :param ManagedUserPoolClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedUserPoolClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 allowed_oauth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allowed_oauth_flows_user_pool_client: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 analytics_configuration: Optional[pulumi.Input[Union['ManagedUserPoolClientAnalyticsConfigurationArgs', 'ManagedUserPoolClientAnalyticsConfigurationArgsDict']]] = None,
                 auth_session_validity: Optional[pulumi.Input[builtins.int]] = None,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_redirect_uri: Optional[pulumi.Input[builtins.str]] = None,
                 enable_propagate_additional_user_context_data: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_token_revocation: Optional[pulumi.Input[builtins.bool]] = None,
                 explicit_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 id_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 prevent_user_existence_errors: Optional[pulumi.Input[builtins.str]] = None,
                 read_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 refresh_token_rotation: Optional[pulumi.Input[Union['ManagedUserPoolClientRefreshTokenRotationArgs', 'ManagedUserPoolClientRefreshTokenRotationArgsDict']]] = None,
                 refresh_token_validity: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 supported_identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 token_validity_units: Optional[pulumi.Input[Union['ManagedUserPoolClientTokenValidityUnitsArgs', 'ManagedUserPoolClientTokenValidityUnitsArgsDict']]] = None,
                 user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 write_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedUserPoolClientArgs.__new__(ManagedUserPoolClientArgs)

            __props__.__dict__["access_token_validity"] = access_token_validity
            __props__.__dict__["allowed_oauth_flows"] = allowed_oauth_flows
            __props__.__dict__["allowed_oauth_flows_user_pool_client"] = allowed_oauth_flows_user_pool_client
            __props__.__dict__["allowed_oauth_scopes"] = allowed_oauth_scopes
            __props__.__dict__["analytics_configuration"] = analytics_configuration
            __props__.__dict__["auth_session_validity"] = auth_session_validity
            __props__.__dict__["callback_urls"] = callback_urls
            __props__.__dict__["default_redirect_uri"] = default_redirect_uri
            __props__.__dict__["enable_propagate_additional_user_context_data"] = enable_propagate_additional_user_context_data
            __props__.__dict__["enable_token_revocation"] = enable_token_revocation
            __props__.__dict__["explicit_auth_flows"] = explicit_auth_flows
            __props__.__dict__["id_token_validity"] = id_token_validity
            __props__.__dict__["logout_urls"] = logout_urls
            __props__.__dict__["name_pattern"] = name_pattern
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["prevent_user_existence_errors"] = prevent_user_existence_errors
            __props__.__dict__["read_attributes"] = read_attributes
            __props__.__dict__["refresh_token_rotation"] = refresh_token_rotation
            __props__.__dict__["refresh_token_validity"] = refresh_token_validity
            __props__.__dict__["region"] = region
            __props__.__dict__["supported_identity_providers"] = supported_identity_providers
            __props__.__dict__["token_validity_units"] = token_validity_units
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
            __props__.__dict__["write_attributes"] = write_attributes
            __props__.__dict__["client_secret"] = None
            __props__.__dict__["name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedUserPoolClient, __self__).__init__(
            'aws:cognito/managedUserPoolClient:ManagedUserPoolClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token_validity: Optional[pulumi.Input[builtins.int]] = None,
            allowed_oauth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            allowed_oauth_flows_user_pool_client: Optional[pulumi.Input[builtins.bool]] = None,
            allowed_oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            analytics_configuration: Optional[pulumi.Input[Union['ManagedUserPoolClientAnalyticsConfigurationArgs', 'ManagedUserPoolClientAnalyticsConfigurationArgsDict']]] = None,
            auth_session_validity: Optional[pulumi.Input[builtins.int]] = None,
            callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            default_redirect_uri: Optional[pulumi.Input[builtins.str]] = None,
            enable_propagate_additional_user_context_data: Optional[pulumi.Input[builtins.bool]] = None,
            enable_token_revocation: Optional[pulumi.Input[builtins.bool]] = None,
            explicit_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            id_token_validity: Optional[pulumi.Input[builtins.int]] = None,
            logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            name_pattern: Optional[pulumi.Input[builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[builtins.str]] = None,
            prevent_user_existence_errors: Optional[pulumi.Input[builtins.str]] = None,
            read_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            refresh_token_rotation: Optional[pulumi.Input[Union['ManagedUserPoolClientRefreshTokenRotationArgs', 'ManagedUserPoolClientRefreshTokenRotationArgsDict']]] = None,
            refresh_token_validity: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            supported_identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            token_validity_units: Optional[pulumi.Input[Union['ManagedUserPoolClientTokenValidityUnitsArgs', 'ManagedUserPoolClientTokenValidityUnitsArgsDict']]] = None,
            user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            write_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'ManagedUserPoolClient':
        """
        Get an existing ManagedUserPoolClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] access_token_validity: Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_oauth_flows: List of allowed OAuth flows, including `code`, `implicit`, and `client_credentials`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.bool] allowed_oauth_flows_user_pool_client: Whether the client is allowed to use OAuth 2.0 features. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure the following arguments: `callback_urls`, `logout_urls`, `allowed_oauth_scopes` and `allowed_oauth_flows`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_oauth_scopes: List of allowed OAuth scopes, including `phone`, `email`, `openid`, `profile`, and `aws.cognito.signin.user.admin`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[Union['ManagedUserPoolClientAnalyticsConfigurationArgs', 'ManagedUserPoolClientAnalyticsConfigurationArgsDict']] analytics_configuration: Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
        :param pulumi.Input[builtins.int] auth_session_validity: Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] callback_urls: List of allowed callback URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.str] client_secret: Client secret of the user pool client.
        :param pulumi.Input[builtins.str] default_redirect_uri: Default redirect URI and must be included in the list of callback URLs.
        :param pulumi.Input[builtins.bool] enable_propagate_additional_user_context_data: Enables the propagation of additional user context data.
        :param pulumi.Input[builtins.bool] enable_token_revocation: Enables or disables token revocation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] explicit_auth_flows: List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
        :param pulumi.Input[builtins.int] id_token_validity: Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] logout_urls: List of allowed logout URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        :param pulumi.Input[builtins.str] name: Name of the user pool client.
        :param pulumi.Input[builtins.str] name_pattern: Regular expression that matches the name of the existing User Pool Client to be managed. It must only match one User Pool Client.
        :param pulumi.Input[builtins.str] name_prefix: String that matches the beginning of the name of the  existing User Pool Client to be managed. It must match only one User Pool Client.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] prevent_user_existence_errors: Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_attributes: List of user pool attributes that the application client can read from.
        :param pulumi.Input[Union['ManagedUserPoolClientRefreshTokenRotationArgs', 'ManagedUserPoolClientRefreshTokenRotationArgsDict']] refresh_token_rotation: A block that specifies the configuration of refresh token rotation. Detailed below.
        :param pulumi.Input[builtins.int] refresh_token_validity: Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supported_identity_providers: List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `cognito.IdentityProvider` resource(s), or the equivalent string(s).
        :param pulumi.Input[Union['ManagedUserPoolClientTokenValidityUnitsArgs', 'ManagedUserPoolClientTokenValidityUnitsArgsDict']] token_validity_units: Configuration block for representing the validity times in units. See details below. Detailed below.
        :param pulumi.Input[builtins.str] user_pool_id: User pool that the client belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] write_attributes: List of user pool attributes that the application client can write to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedUserPoolClientState.__new__(_ManagedUserPoolClientState)

        __props__.__dict__["access_token_validity"] = access_token_validity
        __props__.__dict__["allowed_oauth_flows"] = allowed_oauth_flows
        __props__.__dict__["allowed_oauth_flows_user_pool_client"] = allowed_oauth_flows_user_pool_client
        __props__.__dict__["allowed_oauth_scopes"] = allowed_oauth_scopes
        __props__.__dict__["analytics_configuration"] = analytics_configuration
        __props__.__dict__["auth_session_validity"] = auth_session_validity
        __props__.__dict__["callback_urls"] = callback_urls
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["default_redirect_uri"] = default_redirect_uri
        __props__.__dict__["enable_propagate_additional_user_context_data"] = enable_propagate_additional_user_context_data
        __props__.__dict__["enable_token_revocation"] = enable_token_revocation
        __props__.__dict__["explicit_auth_flows"] = explicit_auth_flows
        __props__.__dict__["id_token_validity"] = id_token_validity
        __props__.__dict__["logout_urls"] = logout_urls
        __props__.__dict__["name"] = name
        __props__.__dict__["name_pattern"] = name_pattern
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["prevent_user_existence_errors"] = prevent_user_existence_errors
        __props__.__dict__["read_attributes"] = read_attributes
        __props__.__dict__["refresh_token_rotation"] = refresh_token_rotation
        __props__.__dict__["refresh_token_validity"] = refresh_token_validity
        __props__.__dict__["region"] = region
        __props__.__dict__["supported_identity_providers"] = supported_identity_providers
        __props__.__dict__["token_validity_units"] = token_validity_units
        __props__.__dict__["user_pool_id"] = user_pool_id
        __props__.__dict__["write_attributes"] = write_attributes
        return ManagedUserPoolClient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessTokenValidity")
    def access_token_validity(self) -> pulumi.Output[builtins.int]:
        """
        Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
        """
        return pulumi.get(self, "access_token_validity")

    @property
    @pulumi.getter(name="allowedOauthFlows")
    def allowed_oauth_flows(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of allowed OAuth flows, including `code`, `implicit`, and `client_credentials`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "allowed_oauth_flows")

    @property
    @pulumi.getter(name="allowedOauthFlowsUserPoolClient")
    def allowed_oauth_flows_user_pool_client(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the client is allowed to use OAuth 2.0 features. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure the following arguments: `callback_urls`, `logout_urls`, `allowed_oauth_scopes` and `allowed_oauth_flows`.
        """
        return pulumi.get(self, "allowed_oauth_flows_user_pool_client")

    @property
    @pulumi.getter(name="allowedOauthScopes")
    def allowed_oauth_scopes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of allowed OAuth scopes, including `phone`, `email`, `openid`, `profile`, and `aws.cognito.signin.user.admin`. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "allowed_oauth_scopes")

    @property
    @pulumi.getter(name="analyticsConfiguration")
    def analytics_configuration(self) -> pulumi.Output[Optional['outputs.ManagedUserPoolClientAnalyticsConfiguration']]:
        """
        Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
        """
        return pulumi.get(self, "analytics_configuration")

    @property
    @pulumi.getter(name="authSessionValidity")
    def auth_session_validity(self) -> pulumi.Output[builtins.int]:
        """
        Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
        """
        return pulumi.get(self, "auth_session_validity")

    @property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of allowed callback URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "callback_urls")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[builtins.str]:
        """
        Client secret of the user pool client.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="defaultRedirectUri")
    def default_redirect_uri(self) -> pulumi.Output[builtins.str]:
        """
        Default redirect URI and must be included in the list of callback URLs.
        """
        return pulumi.get(self, "default_redirect_uri")

    @property
    @pulumi.getter(name="enablePropagateAdditionalUserContextData")
    def enable_propagate_additional_user_context_data(self) -> pulumi.Output[builtins.bool]:
        """
        Enables the propagation of additional user context data.
        """
        return pulumi.get(self, "enable_propagate_additional_user_context_data")

    @property
    @pulumi.getter(name="enableTokenRevocation")
    def enable_token_revocation(self) -> pulumi.Output[builtins.bool]:
        """
        Enables or disables token revocation.
        """
        return pulumi.get(self, "enable_token_revocation")

    @property
    @pulumi.getter(name="explicitAuthFlows")
    def explicit_auth_flows(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
        """
        return pulumi.get(self, "explicit_auth_flows")

    @property
    @pulumi.getter(name="idTokenValidity")
    def id_token_validity(self) -> pulumi.Output[builtins.int]:
        """
        Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
        """
        return pulumi.get(self, "id_token_validity")

    @property
    @pulumi.getter(name="logoutUrls")
    def logout_urls(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of allowed logout URLs for the identity providers. `allowed_oauth_flows_user_pool_client` must be set to `true` before you can configure this option.
        """
        return pulumi.get(self, "logout_urls")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the user pool client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePattern")
    def name_pattern(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Regular expression that matches the name of the existing User Pool Client to be managed. It must only match one User Pool Client.
        """
        return pulumi.get(self, "name_pattern")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        String that matches the beginning of the name of the  existing User Pool Client to be managed. It must match only one User Pool Client.

        The following arguments are optional:
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="preventUserExistenceErrors")
    def prevent_user_existence_errors(self) -> pulumi.Output[builtins.str]:
        """
        Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
        """
        return pulumi.get(self, "prevent_user_existence_errors")

    @property
    @pulumi.getter(name="readAttributes")
    def read_attributes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of user pool attributes that the application client can read from.
        """
        return pulumi.get(self, "read_attributes")

    @property
    @pulumi.getter(name="refreshTokenRotation")
    def refresh_token_rotation(self) -> pulumi.Output[Optional['outputs.ManagedUserPoolClientRefreshTokenRotation']]:
        """
        A block that specifies the configuration of refresh token rotation. Detailed below.
        """
        return pulumi.get(self, "refresh_token_rotation")

    @property
    @pulumi.getter(name="refreshTokenValidity")
    def refresh_token_validity(self) -> pulumi.Output[builtins.int]:
        """
        Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
        """
        return pulumi.get(self, "refresh_token_validity")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="supportedIdentityProviders")
    def supported_identity_providers(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `cognito.IdentityProvider` resource(s), or the equivalent string(s).
        """
        return pulumi.get(self, "supported_identity_providers")

    @property
    @pulumi.getter(name="tokenValidityUnits")
    def token_validity_units(self) -> pulumi.Output[Optional['outputs.ManagedUserPoolClientTokenValidityUnits']]:
        """
        Configuration block for representing the validity times in units. See details below. Detailed below.
        """
        return pulumi.get(self, "token_validity_units")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        User pool that the client belongs to.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="writeAttributes")
    def write_attributes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of user pool attributes that the application client can write to.
        """
        return pulumi.get(self, "write_attributes")

