# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecommendationPreferencesArgs', 'RecommendationPreferences']

@pulumi.input_type
class RecommendationPreferencesArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[builtins.str],
                 enhanced_infrastructure_metrics: Optional[pulumi.Input[builtins.str]] = None,
                 external_metrics_preference: Optional[pulumi.Input['RecommendationPreferencesExternalMetricsPreferenceArgs']] = None,
                 inferred_workload_types: Optional[pulumi.Input[builtins.str]] = None,
                 look_back_period: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_resources: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesPreferredResourceArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 savings_estimation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input['RecommendationPreferencesScopeArgs']] = None,
                 utilization_preferences: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesUtilizationPreferenceArgs']]]] = None):
        """
        The set of arguments for constructing a RecommendationPreferences resource.
        :param pulumi.Input[builtins.str] resource_type: The target resource type of the recommendation preferences. Valid values: `Ec2Instance`, `AutoScalingGroup`, `RdsDBInstance`.
        :param pulumi.Input[builtins.str] enhanced_infrastructure_metrics: The status of the enhanced infrastructure metrics recommendation preference. Valid values: `Active`, `Inactive`.
        :param pulumi.Input['RecommendationPreferencesExternalMetricsPreferenceArgs'] external_metrics_preference: The provider of the external metrics recommendation preference. See External Metrics Preference below.
        :param pulumi.Input[builtins.str] inferred_workload_types: The status of the inferred workload types recommendation preference. Valid values: `Active`, `Inactive`.
        :param pulumi.Input[builtins.str] look_back_period: The preference to control the number of days the utilization metrics of the AWS resource are analyzed. Valid values: `DAYS_14`, `DAYS_32`, `DAYS_93`.
        :param pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesPreferredResourceArgs']]] preferred_resources: The preference to control which resource type values are considered when generating rightsizing recommendations. See Preferred Resources below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] savings_estimation_mode: The status of the savings estimation mode preference. Valid values: `AfterDiscounts`, `BeforeDiscounts`.
        :param pulumi.Input['RecommendationPreferencesScopeArgs'] scope: The scope of the recommendation preferences. See Scope below.
        :param pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesUtilizationPreferenceArgs']]] utilization_preferences: The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. See Utilization Preferences below.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        if enhanced_infrastructure_metrics is not None:
            pulumi.set(__self__, "enhanced_infrastructure_metrics", enhanced_infrastructure_metrics)
        if external_metrics_preference is not None:
            pulumi.set(__self__, "external_metrics_preference", external_metrics_preference)
        if inferred_workload_types is not None:
            pulumi.set(__self__, "inferred_workload_types", inferred_workload_types)
        if look_back_period is not None:
            pulumi.set(__self__, "look_back_period", look_back_period)
        if preferred_resources is not None:
            pulumi.set(__self__, "preferred_resources", preferred_resources)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if savings_estimation_mode is not None:
            pulumi.set(__self__, "savings_estimation_mode", savings_estimation_mode)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if utilization_preferences is not None:
            pulumi.set(__self__, "utilization_preferences", utilization_preferences)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[builtins.str]:
        """
        The target resource type of the recommendation preferences. Valid values: `Ec2Instance`, `AutoScalingGroup`, `RdsDBInstance`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="enhancedInfrastructureMetrics")
    def enhanced_infrastructure_metrics(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the enhanced infrastructure metrics recommendation preference. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "enhanced_infrastructure_metrics")

    @enhanced_infrastructure_metrics.setter
    def enhanced_infrastructure_metrics(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enhanced_infrastructure_metrics", value)

    @property
    @pulumi.getter(name="externalMetricsPreference")
    def external_metrics_preference(self) -> Optional[pulumi.Input['RecommendationPreferencesExternalMetricsPreferenceArgs']]:
        """
        The provider of the external metrics recommendation preference. See External Metrics Preference below.
        """
        return pulumi.get(self, "external_metrics_preference")

    @external_metrics_preference.setter
    def external_metrics_preference(self, value: Optional[pulumi.Input['RecommendationPreferencesExternalMetricsPreferenceArgs']]):
        pulumi.set(self, "external_metrics_preference", value)

    @property
    @pulumi.getter(name="inferredWorkloadTypes")
    def inferred_workload_types(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the inferred workload types recommendation preference. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "inferred_workload_types")

    @inferred_workload_types.setter
    def inferred_workload_types(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "inferred_workload_types", value)

    @property
    @pulumi.getter(name="lookBackPeriod")
    def look_back_period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The preference to control the number of days the utilization metrics of the AWS resource are analyzed. Valid values: `DAYS_14`, `DAYS_32`, `DAYS_93`.
        """
        return pulumi.get(self, "look_back_period")

    @look_back_period.setter
    def look_back_period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "look_back_period", value)

    @property
    @pulumi.getter(name="preferredResources")
    def preferred_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesPreferredResourceArgs']]]]:
        """
        The preference to control which resource type values are considered when generating rightsizing recommendations. See Preferred Resources below.
        """
        return pulumi.get(self, "preferred_resources")

    @preferred_resources.setter
    def preferred_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesPreferredResourceArgs']]]]):
        pulumi.set(self, "preferred_resources", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="savingsEstimationMode")
    def savings_estimation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the savings estimation mode preference. Valid values: `AfterDiscounts`, `BeforeDiscounts`.
        """
        return pulumi.get(self, "savings_estimation_mode")

    @savings_estimation_mode.setter
    def savings_estimation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "savings_estimation_mode", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['RecommendationPreferencesScopeArgs']]:
        """
        The scope of the recommendation preferences. See Scope below.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['RecommendationPreferencesScopeArgs']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="utilizationPreferences")
    def utilization_preferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesUtilizationPreferenceArgs']]]]:
        """
        The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. See Utilization Preferences below.
        """
        return pulumi.get(self, "utilization_preferences")

    @utilization_preferences.setter
    def utilization_preferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesUtilizationPreferenceArgs']]]]):
        pulumi.set(self, "utilization_preferences", value)


@pulumi.input_type
class _RecommendationPreferencesState:
    def __init__(__self__, *,
                 enhanced_infrastructure_metrics: Optional[pulumi.Input[builtins.str]] = None,
                 external_metrics_preference: Optional[pulumi.Input['RecommendationPreferencesExternalMetricsPreferenceArgs']] = None,
                 inferred_workload_types: Optional[pulumi.Input[builtins.str]] = None,
                 look_back_period: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_resources: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesPreferredResourceArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 savings_estimation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input['RecommendationPreferencesScopeArgs']] = None,
                 utilization_preferences: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesUtilizationPreferenceArgs']]]] = None):
        """
        Input properties used for looking up and filtering RecommendationPreferences resources.
        :param pulumi.Input[builtins.str] enhanced_infrastructure_metrics: The status of the enhanced infrastructure metrics recommendation preference. Valid values: `Active`, `Inactive`.
        :param pulumi.Input['RecommendationPreferencesExternalMetricsPreferenceArgs'] external_metrics_preference: The provider of the external metrics recommendation preference. See External Metrics Preference below.
        :param pulumi.Input[builtins.str] inferred_workload_types: The status of the inferred workload types recommendation preference. Valid values: `Active`, `Inactive`.
        :param pulumi.Input[builtins.str] look_back_period: The preference to control the number of days the utilization metrics of the AWS resource are analyzed. Valid values: `DAYS_14`, `DAYS_32`, `DAYS_93`.
        :param pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesPreferredResourceArgs']]] preferred_resources: The preference to control which resource type values are considered when generating rightsizing recommendations. See Preferred Resources below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_type: The target resource type of the recommendation preferences. Valid values: `Ec2Instance`, `AutoScalingGroup`, `RdsDBInstance`.
        :param pulumi.Input[builtins.str] savings_estimation_mode: The status of the savings estimation mode preference. Valid values: `AfterDiscounts`, `BeforeDiscounts`.
        :param pulumi.Input['RecommendationPreferencesScopeArgs'] scope: The scope of the recommendation preferences. See Scope below.
        :param pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesUtilizationPreferenceArgs']]] utilization_preferences: The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. See Utilization Preferences below.
        """
        if enhanced_infrastructure_metrics is not None:
            pulumi.set(__self__, "enhanced_infrastructure_metrics", enhanced_infrastructure_metrics)
        if external_metrics_preference is not None:
            pulumi.set(__self__, "external_metrics_preference", external_metrics_preference)
        if inferred_workload_types is not None:
            pulumi.set(__self__, "inferred_workload_types", inferred_workload_types)
        if look_back_period is not None:
            pulumi.set(__self__, "look_back_period", look_back_period)
        if preferred_resources is not None:
            pulumi.set(__self__, "preferred_resources", preferred_resources)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if savings_estimation_mode is not None:
            pulumi.set(__self__, "savings_estimation_mode", savings_estimation_mode)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if utilization_preferences is not None:
            pulumi.set(__self__, "utilization_preferences", utilization_preferences)

    @property
    @pulumi.getter(name="enhancedInfrastructureMetrics")
    def enhanced_infrastructure_metrics(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the enhanced infrastructure metrics recommendation preference. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "enhanced_infrastructure_metrics")

    @enhanced_infrastructure_metrics.setter
    def enhanced_infrastructure_metrics(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enhanced_infrastructure_metrics", value)

    @property
    @pulumi.getter(name="externalMetricsPreference")
    def external_metrics_preference(self) -> Optional[pulumi.Input['RecommendationPreferencesExternalMetricsPreferenceArgs']]:
        """
        The provider of the external metrics recommendation preference. See External Metrics Preference below.
        """
        return pulumi.get(self, "external_metrics_preference")

    @external_metrics_preference.setter
    def external_metrics_preference(self, value: Optional[pulumi.Input['RecommendationPreferencesExternalMetricsPreferenceArgs']]):
        pulumi.set(self, "external_metrics_preference", value)

    @property
    @pulumi.getter(name="inferredWorkloadTypes")
    def inferred_workload_types(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the inferred workload types recommendation preference. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "inferred_workload_types")

    @inferred_workload_types.setter
    def inferred_workload_types(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "inferred_workload_types", value)

    @property
    @pulumi.getter(name="lookBackPeriod")
    def look_back_period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The preference to control the number of days the utilization metrics of the AWS resource are analyzed. Valid values: `DAYS_14`, `DAYS_32`, `DAYS_93`.
        """
        return pulumi.get(self, "look_back_period")

    @look_back_period.setter
    def look_back_period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "look_back_period", value)

    @property
    @pulumi.getter(name="preferredResources")
    def preferred_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesPreferredResourceArgs']]]]:
        """
        The preference to control which resource type values are considered when generating rightsizing recommendations. See Preferred Resources below.
        """
        return pulumi.get(self, "preferred_resources")

    @preferred_resources.setter
    def preferred_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesPreferredResourceArgs']]]]):
        pulumi.set(self, "preferred_resources", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The target resource type of the recommendation preferences. Valid values: `Ec2Instance`, `AutoScalingGroup`, `RdsDBInstance`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="savingsEstimationMode")
    def savings_estimation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the savings estimation mode preference. Valid values: `AfterDiscounts`, `BeforeDiscounts`.
        """
        return pulumi.get(self, "savings_estimation_mode")

    @savings_estimation_mode.setter
    def savings_estimation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "savings_estimation_mode", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['RecommendationPreferencesScopeArgs']]:
        """
        The scope of the recommendation preferences. See Scope below.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['RecommendationPreferencesScopeArgs']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="utilizationPreferences")
    def utilization_preferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesUtilizationPreferenceArgs']]]]:
        """
        The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. See Utilization Preferences below.
        """
        return pulumi.get(self, "utilization_preferences")

    @utilization_preferences.setter
    def utilization_preferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecommendationPreferencesUtilizationPreferenceArgs']]]]):
        pulumi.set(self, "utilization_preferences", value)


@pulumi.type_token("aws:computeoptimizer/recommendationPreferences:RecommendationPreferences")
class RecommendationPreferences(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enhanced_infrastructure_metrics: Optional[pulumi.Input[builtins.str]] = None,
                 external_metrics_preference: Optional[pulumi.Input[Union['RecommendationPreferencesExternalMetricsPreferenceArgs', 'RecommendationPreferencesExternalMetricsPreferenceArgsDict']]] = None,
                 inferred_workload_types: Optional[pulumi.Input[builtins.str]] = None,
                 look_back_period: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesPreferredResourceArgs', 'RecommendationPreferencesPreferredResourceArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 savings_estimation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[Union['RecommendationPreferencesScopeArgs', 'RecommendationPreferencesScopeArgsDict']]] = None,
                 utilization_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesUtilizationPreferenceArgs', 'RecommendationPreferencesUtilizationPreferenceArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages AWS Compute Optimizer recommendation preferences.

        ## Example Usage

        ### Lookback Period Preference

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.computeoptimizer.RecommendationPreferences("example",
            resource_type="Ec2Instance",
            scope={
                "name": "AccountId",
                "value": "123456789012",
            },
            look_back_period="DAYS_32")
        ```

        ### Multiple Preferences

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.computeoptimizer.RecommendationPreferences("example",
            resource_type="Ec2Instance",
            scope={
                "name": "AccountId",
                "value": "123456789012",
            },
            enhanced_infrastructure_metrics="Active",
            external_metrics_preference={
                "source": "Datadog",
            },
            preferred_resources=[{
                "include_lists": [
                    "m5.xlarge",
                    "r5",
                ],
                "name": "Ec2InstanceTypes",
            }])
        ```

        ## Import

        Using `pulumi import`, import recommendation preferences using the resource type, scope name and scope value. For example:

        ```sh
        $ pulumi import aws:computeoptimizer/recommendationPreferences:RecommendationPreferences example Ec2Instance,AccountId,123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] enhanced_infrastructure_metrics: The status of the enhanced infrastructure metrics recommendation preference. Valid values: `Active`, `Inactive`.
        :param pulumi.Input[Union['RecommendationPreferencesExternalMetricsPreferenceArgs', 'RecommendationPreferencesExternalMetricsPreferenceArgsDict']] external_metrics_preference: The provider of the external metrics recommendation preference. See External Metrics Preference below.
        :param pulumi.Input[builtins.str] inferred_workload_types: The status of the inferred workload types recommendation preference. Valid values: `Active`, `Inactive`.
        :param pulumi.Input[builtins.str] look_back_period: The preference to control the number of days the utilization metrics of the AWS resource are analyzed. Valid values: `DAYS_14`, `DAYS_32`, `DAYS_93`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesPreferredResourceArgs', 'RecommendationPreferencesPreferredResourceArgsDict']]]] preferred_resources: The preference to control which resource type values are considered when generating rightsizing recommendations. See Preferred Resources below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_type: The target resource type of the recommendation preferences. Valid values: `Ec2Instance`, `AutoScalingGroup`, `RdsDBInstance`.
        :param pulumi.Input[builtins.str] savings_estimation_mode: The status of the savings estimation mode preference. Valid values: `AfterDiscounts`, `BeforeDiscounts`.
        :param pulumi.Input[Union['RecommendationPreferencesScopeArgs', 'RecommendationPreferencesScopeArgsDict']] scope: The scope of the recommendation preferences. See Scope below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesUtilizationPreferenceArgs', 'RecommendationPreferencesUtilizationPreferenceArgsDict']]]] utilization_preferences: The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. See Utilization Preferences below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecommendationPreferencesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages AWS Compute Optimizer recommendation preferences.

        ## Example Usage

        ### Lookback Period Preference

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.computeoptimizer.RecommendationPreferences("example",
            resource_type="Ec2Instance",
            scope={
                "name": "AccountId",
                "value": "123456789012",
            },
            look_back_period="DAYS_32")
        ```

        ### Multiple Preferences

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.computeoptimizer.RecommendationPreferences("example",
            resource_type="Ec2Instance",
            scope={
                "name": "AccountId",
                "value": "123456789012",
            },
            enhanced_infrastructure_metrics="Active",
            external_metrics_preference={
                "source": "Datadog",
            },
            preferred_resources=[{
                "include_lists": [
                    "m5.xlarge",
                    "r5",
                ],
                "name": "Ec2InstanceTypes",
            }])
        ```

        ## Import

        Using `pulumi import`, import recommendation preferences using the resource type, scope name and scope value. For example:

        ```sh
        $ pulumi import aws:computeoptimizer/recommendationPreferences:RecommendationPreferences example Ec2Instance,AccountId,123456789012
        ```

        :param str resource_name: The name of the resource.
        :param RecommendationPreferencesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecommendationPreferencesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enhanced_infrastructure_metrics: Optional[pulumi.Input[builtins.str]] = None,
                 external_metrics_preference: Optional[pulumi.Input[Union['RecommendationPreferencesExternalMetricsPreferenceArgs', 'RecommendationPreferencesExternalMetricsPreferenceArgsDict']]] = None,
                 inferred_workload_types: Optional[pulumi.Input[builtins.str]] = None,
                 look_back_period: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesPreferredResourceArgs', 'RecommendationPreferencesPreferredResourceArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 savings_estimation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[Union['RecommendationPreferencesScopeArgs', 'RecommendationPreferencesScopeArgsDict']]] = None,
                 utilization_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesUtilizationPreferenceArgs', 'RecommendationPreferencesUtilizationPreferenceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecommendationPreferencesArgs.__new__(RecommendationPreferencesArgs)

            __props__.__dict__["enhanced_infrastructure_metrics"] = enhanced_infrastructure_metrics
            __props__.__dict__["external_metrics_preference"] = external_metrics_preference
            __props__.__dict__["inferred_workload_types"] = inferred_workload_types
            __props__.__dict__["look_back_period"] = look_back_period
            __props__.__dict__["preferred_resources"] = preferred_resources
            __props__.__dict__["region"] = region
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["savings_estimation_mode"] = savings_estimation_mode
            __props__.__dict__["scope"] = scope
            __props__.__dict__["utilization_preferences"] = utilization_preferences
        super(RecommendationPreferences, __self__).__init__(
            'aws:computeoptimizer/recommendationPreferences:RecommendationPreferences',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enhanced_infrastructure_metrics: Optional[pulumi.Input[builtins.str]] = None,
            external_metrics_preference: Optional[pulumi.Input[Union['RecommendationPreferencesExternalMetricsPreferenceArgs', 'RecommendationPreferencesExternalMetricsPreferenceArgsDict']]] = None,
            inferred_workload_types: Optional[pulumi.Input[builtins.str]] = None,
            look_back_period: Optional[pulumi.Input[builtins.str]] = None,
            preferred_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesPreferredResourceArgs', 'RecommendationPreferencesPreferredResourceArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            savings_estimation_mode: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[Union['RecommendationPreferencesScopeArgs', 'RecommendationPreferencesScopeArgsDict']]] = None,
            utilization_preferences: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesUtilizationPreferenceArgs', 'RecommendationPreferencesUtilizationPreferenceArgsDict']]]]] = None) -> 'RecommendationPreferences':
        """
        Get an existing RecommendationPreferences resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] enhanced_infrastructure_metrics: The status of the enhanced infrastructure metrics recommendation preference. Valid values: `Active`, `Inactive`.
        :param pulumi.Input[Union['RecommendationPreferencesExternalMetricsPreferenceArgs', 'RecommendationPreferencesExternalMetricsPreferenceArgsDict']] external_metrics_preference: The provider of the external metrics recommendation preference. See External Metrics Preference below.
        :param pulumi.Input[builtins.str] inferred_workload_types: The status of the inferred workload types recommendation preference. Valid values: `Active`, `Inactive`.
        :param pulumi.Input[builtins.str] look_back_period: The preference to control the number of days the utilization metrics of the AWS resource are analyzed. Valid values: `DAYS_14`, `DAYS_32`, `DAYS_93`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesPreferredResourceArgs', 'RecommendationPreferencesPreferredResourceArgsDict']]]] preferred_resources: The preference to control which resource type values are considered when generating rightsizing recommendations. See Preferred Resources below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_type: The target resource type of the recommendation preferences. Valid values: `Ec2Instance`, `AutoScalingGroup`, `RdsDBInstance`.
        :param pulumi.Input[builtins.str] savings_estimation_mode: The status of the savings estimation mode preference. Valid values: `AfterDiscounts`, `BeforeDiscounts`.
        :param pulumi.Input[Union['RecommendationPreferencesScopeArgs', 'RecommendationPreferencesScopeArgsDict']] scope: The scope of the recommendation preferences. See Scope below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecommendationPreferencesUtilizationPreferenceArgs', 'RecommendationPreferencesUtilizationPreferenceArgsDict']]]] utilization_preferences: The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. See Utilization Preferences below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecommendationPreferencesState.__new__(_RecommendationPreferencesState)

        __props__.__dict__["enhanced_infrastructure_metrics"] = enhanced_infrastructure_metrics
        __props__.__dict__["external_metrics_preference"] = external_metrics_preference
        __props__.__dict__["inferred_workload_types"] = inferred_workload_types
        __props__.__dict__["look_back_period"] = look_back_period
        __props__.__dict__["preferred_resources"] = preferred_resources
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["savings_estimation_mode"] = savings_estimation_mode
        __props__.__dict__["scope"] = scope
        __props__.__dict__["utilization_preferences"] = utilization_preferences
        return RecommendationPreferences(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enhancedInfrastructureMetrics")
    def enhanced_infrastructure_metrics(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The status of the enhanced infrastructure metrics recommendation preference. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "enhanced_infrastructure_metrics")

    @property
    @pulumi.getter(name="externalMetricsPreference")
    def external_metrics_preference(self) -> pulumi.Output[Optional['outputs.RecommendationPreferencesExternalMetricsPreference']]:
        """
        The provider of the external metrics recommendation preference. See External Metrics Preference below.
        """
        return pulumi.get(self, "external_metrics_preference")

    @property
    @pulumi.getter(name="inferredWorkloadTypes")
    def inferred_workload_types(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The status of the inferred workload types recommendation preference. Valid values: `Active`, `Inactive`.
        """
        return pulumi.get(self, "inferred_workload_types")

    @property
    @pulumi.getter(name="lookBackPeriod")
    def look_back_period(self) -> pulumi.Output[builtins.str]:
        """
        The preference to control the number of days the utilization metrics of the AWS resource are analyzed. Valid values: `DAYS_14`, `DAYS_32`, `DAYS_93`.
        """
        return pulumi.get(self, "look_back_period")

    @property
    @pulumi.getter(name="preferredResources")
    def preferred_resources(self) -> pulumi.Output[Optional[Sequence['outputs.RecommendationPreferencesPreferredResource']]]:
        """
        The preference to control which resource type values are considered when generating rightsizing recommendations. See Preferred Resources below.
        """
        return pulumi.get(self, "preferred_resources")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The target resource type of the recommendation preferences. Valid values: `Ec2Instance`, `AutoScalingGroup`, `RdsDBInstance`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="savingsEstimationMode")
    def savings_estimation_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The status of the savings estimation mode preference. Valid values: `AfterDiscounts`, `BeforeDiscounts`.
        """
        return pulumi.get(self, "savings_estimation_mode")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional['outputs.RecommendationPreferencesScope']]:
        """
        The scope of the recommendation preferences. See Scope below.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="utilizationPreferences")
    def utilization_preferences(self) -> pulumi.Output[Optional[Sequence['outputs.RecommendationPreferencesUtilizationPreference']]]:
        """
        The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. See Utilization Preferences below.
        """
        return pulumi.get(self, "utilization_preferences")

