# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AssumeRoleWithWebIdentity',
    'AssumeRoles',
    'DefaultTags',
    'Endpoints',
    'IgnoreTags',
]

@pulumi.output_type
class AssumeRoleWithWebIdentity(dict):
    def __init__(__self__, *,
                 duration: Optional[builtins.str] = None,
                 policy: Optional[builtins.str] = None,
                 policy_arns: Optional[Sequence[builtins.str]] = None,
                 role_arn: Optional[builtins.str] = None,
                 session_name: Optional[builtins.str] = None,
                 web_identity_token: Optional[builtins.str] = None,
                 web_identity_token_file: Optional[builtins.str] = None):
        """
        :param builtins.str duration: The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
        :param builtins.str policy: IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param Sequence[builtins.str] policy_arns: Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        :param builtins.str role_arn: Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
        :param builtins.str session_name: An identifier for the assumed role session.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)
        if web_identity_token is not None:
            pulumi.set(__self__, "web_identity_token", web_identity_token)
        if web_identity_token_file is not None:
            pulumi.set(__self__, "web_identity_token_file", web_identity_token_file)

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def policy(self) -> Optional[builtins.str]:
        """
        IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy_arns")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[builtins.str]:
        """
        An identifier for the assumed role session.
        """
        return pulumi.get(self, "session_name")

    @property
    @pulumi.getter(name="webIdentityToken")
    def web_identity_token(self) -> Optional[builtins.str]:
        return pulumi.get(self, "web_identity_token")

    @property
    @pulumi.getter(name="webIdentityTokenFile")
    def web_identity_token_file(self) -> Optional[builtins.str]:
        return pulumi.get(self, "web_identity_token_file")


@pulumi.output_type
class AssumeRoles(dict):
    def __init__(__self__, *,
                 duration: Optional[builtins.str] = None,
                 external_id: Optional[builtins.str] = None,
                 policy: Optional[builtins.str] = None,
                 policy_arns: Optional[Sequence[builtins.str]] = None,
                 role_arn: Optional[builtins.str] = None,
                 session_name: Optional[builtins.str] = None,
                 source_identity: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 transitive_tag_keys: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str duration: The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
        :param builtins.str external_id: A unique identifier that might be required when you assume a role in another account.
        :param builtins.str policy: IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param Sequence[builtins.str] policy_arns: Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        :param builtins.str role_arn: Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
        :param builtins.str session_name: An identifier for the assumed role session.
        :param builtins.str source_identity: Source identity specified by the principal assuming the role.
        :param Mapping[str, builtins.str] tags: Assume role session tags.
        :param Sequence[builtins.str] transitive_tag_keys: Assume role session tag keys to pass to any subsequent sessions.
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)
        if source_identity is not None:
            pulumi.set(__self__, "source_identity", source_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitive_tag_keys is not None:
            pulumi.set(__self__, "transitive_tag_keys", transitive_tag_keys)

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        A unique identifier that might be required when you assume a role in another account.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def policy(self) -> Optional[builtins.str]:
        """
        IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy_arns")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[builtins.str]:
        """
        An identifier for the assumed role session.
        """
        return pulumi.get(self, "session_name")

    @property
    @pulumi.getter(name="sourceIdentity")
    def source_identity(self) -> Optional[builtins.str]:
        """
        Source identity specified by the principal assuming the role.
        """
        return pulumi.get(self, "source_identity")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Assume role session tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transitiveTagKeys")
    def transitive_tag_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        Assume role session tag keys to pass to any subsequent sessions.
        """
        return pulumi.get(self, "transitive_tag_keys")


@pulumi.output_type
class DefaultTags(dict):
    def __init__(__self__, *,
                 tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] tags: Resource tags to default across all resources. Can also be configured with environment variables like `TF_AWS_DEFAULT_TAGS_<tag_name>`.
        """
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Resource tags to default across all resources. Can also be configured with environment variables like `TF_AWS_DEFAULT_TAGS_<tag_name>`.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class Endpoints(dict):
    def __init__(__self__, *,
                 accessanalyzer: Optional[builtins.str] = None,
                 account: Optional[builtins.str] = None,
                 acm: Optional[builtins.str] = None,
                 acmpca: Optional[builtins.str] = None,
                 amg: Optional[builtins.str] = None,
                 amp: Optional[builtins.str] = None,
                 amplify: Optional[builtins.str] = None,
                 apigateway: Optional[builtins.str] = None,
                 apigatewayv2: Optional[builtins.str] = None,
                 appautoscaling: Optional[builtins.str] = None,
                 appconfig: Optional[builtins.str] = None,
                 appfabric: Optional[builtins.str] = None,
                 appflow: Optional[builtins.str] = None,
                 appintegrations: Optional[builtins.str] = None,
                 appintegrationsservice: Optional[builtins.str] = None,
                 applicationautoscaling: Optional[builtins.str] = None,
                 applicationinsights: Optional[builtins.str] = None,
                 applicationsignals: Optional[builtins.str] = None,
                 appmesh: Optional[builtins.str] = None,
                 appregistry: Optional[builtins.str] = None,
                 apprunner: Optional[builtins.str] = None,
                 appstream: Optional[builtins.str] = None,
                 appsync: Optional[builtins.str] = None,
                 athena: Optional[builtins.str] = None,
                 auditmanager: Optional[builtins.str] = None,
                 autoscaling: Optional[builtins.str] = None,
                 autoscalingplans: Optional[builtins.str] = None,
                 backup: Optional[builtins.str] = None,
                 batch: Optional[builtins.str] = None,
                 bcmdataexports: Optional[builtins.str] = None,
                 beanstalk: Optional[builtins.str] = None,
                 bedrock: Optional[builtins.str] = None,
                 bedrockagent: Optional[builtins.str] = None,
                 billing: Optional[builtins.str] = None,
                 budgets: Optional[builtins.str] = None,
                 ce: Optional[builtins.str] = None,
                 chatbot: Optional[builtins.str] = None,
                 chime: Optional[builtins.str] = None,
                 chimesdkmediapipelines: Optional[builtins.str] = None,
                 chimesdkvoice: Optional[builtins.str] = None,
                 cleanrooms: Optional[builtins.str] = None,
                 cloud9: Optional[builtins.str] = None,
                 cloudcontrol: Optional[builtins.str] = None,
                 cloudcontrolapi: Optional[builtins.str] = None,
                 cloudformation: Optional[builtins.str] = None,
                 cloudfront: Optional[builtins.str] = None,
                 cloudfrontkeyvaluestore: Optional[builtins.str] = None,
                 cloudhsm: Optional[builtins.str] = None,
                 cloudhsmv2: Optional[builtins.str] = None,
                 cloudsearch: Optional[builtins.str] = None,
                 cloudtrail: Optional[builtins.str] = None,
                 cloudwatch: Optional[builtins.str] = None,
                 cloudwatchevents: Optional[builtins.str] = None,
                 cloudwatchevidently: Optional[builtins.str] = None,
                 cloudwatchlog: Optional[builtins.str] = None,
                 cloudwatchlogs: Optional[builtins.str] = None,
                 cloudwatchobservabilityaccessmanager: Optional[builtins.str] = None,
                 cloudwatchrum: Optional[builtins.str] = None,
                 codeartifact: Optional[builtins.str] = None,
                 codebuild: Optional[builtins.str] = None,
                 codecatalyst: Optional[builtins.str] = None,
                 codecommit: Optional[builtins.str] = None,
                 codeconnections: Optional[builtins.str] = None,
                 codedeploy: Optional[builtins.str] = None,
                 codeguruprofiler: Optional[builtins.str] = None,
                 codegurureviewer: Optional[builtins.str] = None,
                 codepipeline: Optional[builtins.str] = None,
                 codestarconnections: Optional[builtins.str] = None,
                 codestarnotifications: Optional[builtins.str] = None,
                 cognitoidentity: Optional[builtins.str] = None,
                 cognitoidentityprovider: Optional[builtins.str] = None,
                 cognitoidp: Optional[builtins.str] = None,
                 comprehend: Optional[builtins.str] = None,
                 computeoptimizer: Optional[builtins.str] = None,
                 config: Optional[builtins.str] = None,
                 configservice: Optional[builtins.str] = None,
                 connect: Optional[builtins.str] = None,
                 connectcases: Optional[builtins.str] = None,
                 controltower: Optional[builtins.str] = None,
                 costandusagereportservice: Optional[builtins.str] = None,
                 costexplorer: Optional[builtins.str] = None,
                 costoptimizationhub: Optional[builtins.str] = None,
                 cur: Optional[builtins.str] = None,
                 customerprofiles: Optional[builtins.str] = None,
                 databasemigration: Optional[builtins.str] = None,
                 databasemigrationservice: Optional[builtins.str] = None,
                 databrew: Optional[builtins.str] = None,
                 dataexchange: Optional[builtins.str] = None,
                 datapipeline: Optional[builtins.str] = None,
                 datasync: Optional[builtins.str] = None,
                 datazone: Optional[builtins.str] = None,
                 dax: Optional[builtins.str] = None,
                 deploy: Optional[builtins.str] = None,
                 detective: Optional[builtins.str] = None,
                 devicefarm: Optional[builtins.str] = None,
                 devopsguru: Optional[builtins.str] = None,
                 directconnect: Optional[builtins.str] = None,
                 directoryservice: Optional[builtins.str] = None,
                 dlm: Optional[builtins.str] = None,
                 dms: Optional[builtins.str] = None,
                 docdb: Optional[builtins.str] = None,
                 docdbelastic: Optional[builtins.str] = None,
                 drs: Optional[builtins.str] = None,
                 ds: Optional[builtins.str] = None,
                 dsql: Optional[builtins.str] = None,
                 dynamodb: Optional[builtins.str] = None,
                 ec2: Optional[builtins.str] = None,
                 ecr: Optional[builtins.str] = None,
                 ecrpublic: Optional[builtins.str] = None,
                 ecs: Optional[builtins.str] = None,
                 efs: Optional[builtins.str] = None,
                 eks: Optional[builtins.str] = None,
                 elasticache: Optional[builtins.str] = None,
                 elasticbeanstalk: Optional[builtins.str] = None,
                 elasticloadbalancing: Optional[builtins.str] = None,
                 elasticloadbalancingv2: Optional[builtins.str] = None,
                 elasticsearch: Optional[builtins.str] = None,
                 elasticsearchservice: Optional[builtins.str] = None,
                 elastictranscoder: Optional[builtins.str] = None,
                 elb: Optional[builtins.str] = None,
                 elbv2: Optional[builtins.str] = None,
                 emr: Optional[builtins.str] = None,
                 emrcontainers: Optional[builtins.str] = None,
                 emrserverless: Optional[builtins.str] = None,
                 es: Optional[builtins.str] = None,
                 eventbridge: Optional[builtins.str] = None,
                 events: Optional[builtins.str] = None,
                 evidently: Optional[builtins.str] = None,
                 evs: Optional[builtins.str] = None,
                 finspace: Optional[builtins.str] = None,
                 firehose: Optional[builtins.str] = None,
                 fis: Optional[builtins.str] = None,
                 fms: Optional[builtins.str] = None,
                 fsx: Optional[builtins.str] = None,
                 gamelift: Optional[builtins.str] = None,
                 glacier: Optional[builtins.str] = None,
                 globalaccelerator: Optional[builtins.str] = None,
                 glue: Optional[builtins.str] = None,
                 gluedatabrew: Optional[builtins.str] = None,
                 grafana: Optional[builtins.str] = None,
                 greengrass: Optional[builtins.str] = None,
                 groundstation: Optional[builtins.str] = None,
                 guardduty: Optional[builtins.str] = None,
                 healthlake: Optional[builtins.str] = None,
                 iam: Optional[builtins.str] = None,
                 identitystore: Optional[builtins.str] = None,
                 imagebuilder: Optional[builtins.str] = None,
                 inspector: Optional[builtins.str] = None,
                 inspector2: Optional[builtins.str] = None,
                 inspectorv2: Optional[builtins.str] = None,
                 internetmonitor: Optional[builtins.str] = None,
                 invoicing: Optional[builtins.str] = None,
                 iot: Optional[builtins.str] = None,
                 ivs: Optional[builtins.str] = None,
                 ivschat: Optional[builtins.str] = None,
                 kafka: Optional[builtins.str] = None,
                 kafkaconnect: Optional[builtins.str] = None,
                 kendra: Optional[builtins.str] = None,
                 keyspaces: Optional[builtins.str] = None,
                 kinesis: Optional[builtins.str] = None,
                 kinesisanalytics: Optional[builtins.str] = None,
                 kinesisanalyticsv2: Optional[builtins.str] = None,
                 kinesisvideo: Optional[builtins.str] = None,
                 kms: Optional[builtins.str] = None,
                 lakeformation: Optional[builtins.str] = None,
                 lambda_: Optional[builtins.str] = None,
                 launchwizard: Optional[builtins.str] = None,
                 lex: Optional[builtins.str] = None,
                 lexmodelbuilding: Optional[builtins.str] = None,
                 lexmodelbuildingservice: Optional[builtins.str] = None,
                 lexmodels: Optional[builtins.str] = None,
                 lexmodelsv2: Optional[builtins.str] = None,
                 lexv2models: Optional[builtins.str] = None,
                 licensemanager: Optional[builtins.str] = None,
                 lightsail: Optional[builtins.str] = None,
                 location: Optional[builtins.str] = None,
                 locationservice: Optional[builtins.str] = None,
                 logs: Optional[builtins.str] = None,
                 lookoutmetrics: Optional[builtins.str] = None,
                 m2: Optional[builtins.str] = None,
                 macie2: Optional[builtins.str] = None,
                 managedgrafana: Optional[builtins.str] = None,
                 mediaconnect: Optional[builtins.str] = None,
                 mediaconvert: Optional[builtins.str] = None,
                 medialive: Optional[builtins.str] = None,
                 mediapackage: Optional[builtins.str] = None,
                 mediapackagev2: Optional[builtins.str] = None,
                 mediapackagevod: Optional[builtins.str] = None,
                 mediastore: Optional[builtins.str] = None,
                 memorydb: Optional[builtins.str] = None,
                 mgn: Optional[builtins.str] = None,
                 mq: Optional[builtins.str] = None,
                 msk: Optional[builtins.str] = None,
                 mwaa: Optional[builtins.str] = None,
                 neptune: Optional[builtins.str] = None,
                 neptunegraph: Optional[builtins.str] = None,
                 networkfirewall: Optional[builtins.str] = None,
                 networkmanager: Optional[builtins.str] = None,
                 networkmonitor: Optional[builtins.str] = None,
                 notifications: Optional[builtins.str] = None,
                 notificationscontacts: Optional[builtins.str] = None,
                 oam: Optional[builtins.str] = None,
                 opensearch: Optional[builtins.str] = None,
                 opensearchingestion: Optional[builtins.str] = None,
                 opensearchserverless: Optional[builtins.str] = None,
                 opensearchservice: Optional[builtins.str] = None,
                 organizations: Optional[builtins.str] = None,
                 osis: Optional[builtins.str] = None,
                 outposts: Optional[builtins.str] = None,
                 paymentcryptography: Optional[builtins.str] = None,
                 pcaconnectorad: Optional[builtins.str] = None,
                 pcs: Optional[builtins.str] = None,
                 pinpoint: Optional[builtins.str] = None,
                 pinpointsmsvoicev2: Optional[builtins.str] = None,
                 pipes: Optional[builtins.str] = None,
                 polly: Optional[builtins.str] = None,
                 pricing: Optional[builtins.str] = None,
                 prometheus: Optional[builtins.str] = None,
                 prometheusservice: Optional[builtins.str] = None,
                 qbusiness: Optional[builtins.str] = None,
                 qldb: Optional[builtins.str] = None,
                 quicksight: Optional[builtins.str] = None,
                 ram: Optional[builtins.str] = None,
                 rbin: Optional[builtins.str] = None,
                 rds: Optional[builtins.str] = None,
                 recyclebin: Optional[builtins.str] = None,
                 redshift: Optional[builtins.str] = None,
                 redshiftdata: Optional[builtins.str] = None,
                 redshiftdataapiservice: Optional[builtins.str] = None,
                 redshiftserverless: Optional[builtins.str] = None,
                 rekognition: Optional[builtins.str] = None,
                 resiliencehub: Optional[builtins.str] = None,
                 resourceexplorer2: Optional[builtins.str] = None,
                 resourcegroups: Optional[builtins.str] = None,
                 resourcegroupstagging: Optional[builtins.str] = None,
                 resourcegroupstaggingapi: Optional[builtins.str] = None,
                 rolesanywhere: Optional[builtins.str] = None,
                 route53: Optional[builtins.str] = None,
                 route53domains: Optional[builtins.str] = None,
                 route53profiles: Optional[builtins.str] = None,
                 route53recoverycontrolconfig: Optional[builtins.str] = None,
                 route53recoveryreadiness: Optional[builtins.str] = None,
                 route53resolver: Optional[builtins.str] = None,
                 rum: Optional[builtins.str] = None,
                 s3: Optional[builtins.str] = None,
                 s3api: Optional[builtins.str] = None,
                 s3control: Optional[builtins.str] = None,
                 s3outposts: Optional[builtins.str] = None,
                 s3tables: Optional[builtins.str] = None,
                 sagemaker: Optional[builtins.str] = None,
                 scheduler: Optional[builtins.str] = None,
                 schemas: Optional[builtins.str] = None,
                 secretsmanager: Optional[builtins.str] = None,
                 securityhub: Optional[builtins.str] = None,
                 securitylake: Optional[builtins.str] = None,
                 serverlessapplicationrepository: Optional[builtins.str] = None,
                 serverlessapprepo: Optional[builtins.str] = None,
                 serverlessrepo: Optional[builtins.str] = None,
                 servicecatalog: Optional[builtins.str] = None,
                 servicecatalogappregistry: Optional[builtins.str] = None,
                 servicediscovery: Optional[builtins.str] = None,
                 servicequotas: Optional[builtins.str] = None,
                 ses: Optional[builtins.str] = None,
                 sesv2: Optional[builtins.str] = None,
                 sfn: Optional[builtins.str] = None,
                 shield: Optional[builtins.str] = None,
                 signer: Optional[builtins.str] = None,
                 sns: Optional[builtins.str] = None,
                 sqs: Optional[builtins.str] = None,
                 ssm: Optional[builtins.str] = None,
                 ssmcontacts: Optional[builtins.str] = None,
                 ssmincidents: Optional[builtins.str] = None,
                 ssmquicksetup: Optional[builtins.str] = None,
                 ssmsap: Optional[builtins.str] = None,
                 sso: Optional[builtins.str] = None,
                 ssoadmin: Optional[builtins.str] = None,
                 stepfunctions: Optional[builtins.str] = None,
                 storagegateway: Optional[builtins.str] = None,
                 sts: Optional[builtins.str] = None,
                 swf: Optional[builtins.str] = None,
                 synthetics: Optional[builtins.str] = None,
                 taxsettings: Optional[builtins.str] = None,
                 timestreaminfluxdb: Optional[builtins.str] = None,
                 timestreamquery: Optional[builtins.str] = None,
                 timestreamwrite: Optional[builtins.str] = None,
                 transcribe: Optional[builtins.str] = None,
                 transcribeservice: Optional[builtins.str] = None,
                 transfer: Optional[builtins.str] = None,
                 verifiedpermissions: Optional[builtins.str] = None,
                 vpclattice: Optional[builtins.str] = None,
                 waf: Optional[builtins.str] = None,
                 wafregional: Optional[builtins.str] = None,
                 wafv2: Optional[builtins.str] = None,
                 wellarchitected: Optional[builtins.str] = None,
                 workspaces: Optional[builtins.str] = None,
                 workspacesweb: Optional[builtins.str] = None,
                 xray: Optional[builtins.str] = None):
        """
        :param builtins.str accessanalyzer: Use this to override the default service endpoint URL
        :param builtins.str account: Use this to override the default service endpoint URL
        :param builtins.str acm: Use this to override the default service endpoint URL
        :param builtins.str acmpca: Use this to override the default service endpoint URL
        :param builtins.str amg: Use this to override the default service endpoint URL
        :param builtins.str amp: Use this to override the default service endpoint URL
        :param builtins.str amplify: Use this to override the default service endpoint URL
        :param builtins.str apigateway: Use this to override the default service endpoint URL
        :param builtins.str apigatewayv2: Use this to override the default service endpoint URL
        :param builtins.str appautoscaling: Use this to override the default service endpoint URL
        :param builtins.str appconfig: Use this to override the default service endpoint URL
        :param builtins.str appfabric: Use this to override the default service endpoint URL
        :param builtins.str appflow: Use this to override the default service endpoint URL
        :param builtins.str appintegrations: Use this to override the default service endpoint URL
        :param builtins.str appintegrationsservice: Use this to override the default service endpoint URL
        :param builtins.str applicationautoscaling: Use this to override the default service endpoint URL
        :param builtins.str applicationinsights: Use this to override the default service endpoint URL
        :param builtins.str applicationsignals: Use this to override the default service endpoint URL
        :param builtins.str appmesh: Use this to override the default service endpoint URL
        :param builtins.str appregistry: Use this to override the default service endpoint URL
        :param builtins.str apprunner: Use this to override the default service endpoint URL
        :param builtins.str appstream: Use this to override the default service endpoint URL
        :param builtins.str appsync: Use this to override the default service endpoint URL
        :param builtins.str athena: Use this to override the default service endpoint URL
        :param builtins.str auditmanager: Use this to override the default service endpoint URL
        :param builtins.str autoscaling: Use this to override the default service endpoint URL
        :param builtins.str autoscalingplans: Use this to override the default service endpoint URL
        :param builtins.str backup: Use this to override the default service endpoint URL
        :param builtins.str batch: Use this to override the default service endpoint URL
        :param builtins.str bcmdataexports: Use this to override the default service endpoint URL
        :param builtins.str beanstalk: Use this to override the default service endpoint URL
        :param builtins.str bedrock: Use this to override the default service endpoint URL
        :param builtins.str bedrockagent: Use this to override the default service endpoint URL
        :param builtins.str billing: Use this to override the default service endpoint URL
        :param builtins.str budgets: Use this to override the default service endpoint URL
        :param builtins.str ce: Use this to override the default service endpoint URL
        :param builtins.str chatbot: Use this to override the default service endpoint URL
        :param builtins.str chime: Use this to override the default service endpoint URL
        :param builtins.str chimesdkmediapipelines: Use this to override the default service endpoint URL
        :param builtins.str chimesdkvoice: Use this to override the default service endpoint URL
        :param builtins.str cleanrooms: Use this to override the default service endpoint URL
        :param builtins.str cloud9: Use this to override the default service endpoint URL
        :param builtins.str cloudcontrol: Use this to override the default service endpoint URL
        :param builtins.str cloudcontrolapi: Use this to override the default service endpoint URL
        :param builtins.str cloudformation: Use this to override the default service endpoint URL
        :param builtins.str cloudfront: Use this to override the default service endpoint URL
        :param builtins.str cloudfrontkeyvaluestore: Use this to override the default service endpoint URL
        :param builtins.str cloudhsm: Use this to override the default service endpoint URL
        :param builtins.str cloudhsmv2: Use this to override the default service endpoint URL
        :param builtins.str cloudsearch: Use this to override the default service endpoint URL
        :param builtins.str cloudtrail: Use this to override the default service endpoint URL
        :param builtins.str cloudwatch: Use this to override the default service endpoint URL
        :param builtins.str cloudwatchevents: Use this to override the default service endpoint URL
        :param builtins.str cloudwatchevidently: Use this to override the default service endpoint URL
        :param builtins.str cloudwatchlog: Use this to override the default service endpoint URL
        :param builtins.str cloudwatchlogs: Use this to override the default service endpoint URL
        :param builtins.str cloudwatchobservabilityaccessmanager: Use this to override the default service endpoint URL
        :param builtins.str cloudwatchrum: Use this to override the default service endpoint URL
        :param builtins.str codeartifact: Use this to override the default service endpoint URL
        :param builtins.str codebuild: Use this to override the default service endpoint URL
        :param builtins.str codecatalyst: Use this to override the default service endpoint URL
        :param builtins.str codecommit: Use this to override the default service endpoint URL
        :param builtins.str codeconnections: Use this to override the default service endpoint URL
        :param builtins.str codedeploy: Use this to override the default service endpoint URL
        :param builtins.str codeguruprofiler: Use this to override the default service endpoint URL
        :param builtins.str codegurureviewer: Use this to override the default service endpoint URL
        :param builtins.str codepipeline: Use this to override the default service endpoint URL
        :param builtins.str codestarconnections: Use this to override the default service endpoint URL
        :param builtins.str codestarnotifications: Use this to override the default service endpoint URL
        :param builtins.str cognitoidentity: Use this to override the default service endpoint URL
        :param builtins.str cognitoidentityprovider: Use this to override the default service endpoint URL
        :param builtins.str cognitoidp: Use this to override the default service endpoint URL
        :param builtins.str comprehend: Use this to override the default service endpoint URL
        :param builtins.str computeoptimizer: Use this to override the default service endpoint URL
        :param builtins.str config: Use this to override the default service endpoint URL
        :param builtins.str configservice: Use this to override the default service endpoint URL
        :param builtins.str connect: Use this to override the default service endpoint URL
        :param builtins.str connectcases: Use this to override the default service endpoint URL
        :param builtins.str controltower: Use this to override the default service endpoint URL
        :param builtins.str costandusagereportservice: Use this to override the default service endpoint URL
        :param builtins.str costexplorer: Use this to override the default service endpoint URL
        :param builtins.str costoptimizationhub: Use this to override the default service endpoint URL
        :param builtins.str cur: Use this to override the default service endpoint URL
        :param builtins.str customerprofiles: Use this to override the default service endpoint URL
        :param builtins.str databasemigration: Use this to override the default service endpoint URL
        :param builtins.str databasemigrationservice: Use this to override the default service endpoint URL
        :param builtins.str databrew: Use this to override the default service endpoint URL
        :param builtins.str dataexchange: Use this to override the default service endpoint URL
        :param builtins.str datapipeline: Use this to override the default service endpoint URL
        :param builtins.str datasync: Use this to override the default service endpoint URL
        :param builtins.str datazone: Use this to override the default service endpoint URL
        :param builtins.str dax: Use this to override the default service endpoint URL
        :param builtins.str deploy: Use this to override the default service endpoint URL
        :param builtins.str detective: Use this to override the default service endpoint URL
        :param builtins.str devicefarm: Use this to override the default service endpoint URL
        :param builtins.str devopsguru: Use this to override the default service endpoint URL
        :param builtins.str directconnect: Use this to override the default service endpoint URL
        :param builtins.str directoryservice: Use this to override the default service endpoint URL
        :param builtins.str dlm: Use this to override the default service endpoint URL
        :param builtins.str dms: Use this to override the default service endpoint URL
        :param builtins.str docdb: Use this to override the default service endpoint URL
        :param builtins.str docdbelastic: Use this to override the default service endpoint URL
        :param builtins.str drs: Use this to override the default service endpoint URL
        :param builtins.str ds: Use this to override the default service endpoint URL
        :param builtins.str dsql: Use this to override the default service endpoint URL
        :param builtins.str dynamodb: Use this to override the default service endpoint URL
        :param builtins.str ec2: Use this to override the default service endpoint URL
        :param builtins.str ecr: Use this to override the default service endpoint URL
        :param builtins.str ecrpublic: Use this to override the default service endpoint URL
        :param builtins.str ecs: Use this to override the default service endpoint URL
        :param builtins.str efs: Use this to override the default service endpoint URL
        :param builtins.str eks: Use this to override the default service endpoint URL
        :param builtins.str elasticache: Use this to override the default service endpoint URL
        :param builtins.str elasticbeanstalk: Use this to override the default service endpoint URL
        :param builtins.str elasticloadbalancing: Use this to override the default service endpoint URL
        :param builtins.str elasticloadbalancingv2: Use this to override the default service endpoint URL
        :param builtins.str elasticsearch: Use this to override the default service endpoint URL
        :param builtins.str elasticsearchservice: Use this to override the default service endpoint URL
        :param builtins.str elastictranscoder: Use this to override the default service endpoint URL
        :param builtins.str elb: Use this to override the default service endpoint URL
        :param builtins.str elbv2: Use this to override the default service endpoint URL
        :param builtins.str emr: Use this to override the default service endpoint URL
        :param builtins.str emrcontainers: Use this to override the default service endpoint URL
        :param builtins.str emrserverless: Use this to override the default service endpoint URL
        :param builtins.str es: Use this to override the default service endpoint URL
        :param builtins.str eventbridge: Use this to override the default service endpoint URL
        :param builtins.str events: Use this to override the default service endpoint URL
        :param builtins.str evidently: Use this to override the default service endpoint URL
        :param builtins.str evs: Use this to override the default service endpoint URL
        :param builtins.str finspace: Use this to override the default service endpoint URL
        :param builtins.str firehose: Use this to override the default service endpoint URL
        :param builtins.str fis: Use this to override the default service endpoint URL
        :param builtins.str fms: Use this to override the default service endpoint URL
        :param builtins.str fsx: Use this to override the default service endpoint URL
        :param builtins.str gamelift: Use this to override the default service endpoint URL
        :param builtins.str glacier: Use this to override the default service endpoint URL
        :param builtins.str globalaccelerator: Use this to override the default service endpoint URL
        :param builtins.str glue: Use this to override the default service endpoint URL
        :param builtins.str gluedatabrew: Use this to override the default service endpoint URL
        :param builtins.str grafana: Use this to override the default service endpoint URL
        :param builtins.str greengrass: Use this to override the default service endpoint URL
        :param builtins.str groundstation: Use this to override the default service endpoint URL
        :param builtins.str guardduty: Use this to override the default service endpoint URL
        :param builtins.str healthlake: Use this to override the default service endpoint URL
        :param builtins.str iam: Use this to override the default service endpoint URL
        :param builtins.str identitystore: Use this to override the default service endpoint URL
        :param builtins.str imagebuilder: Use this to override the default service endpoint URL
        :param builtins.str inspector: Use this to override the default service endpoint URL
        :param builtins.str inspector2: Use this to override the default service endpoint URL
        :param builtins.str inspectorv2: Use this to override the default service endpoint URL
        :param builtins.str internetmonitor: Use this to override the default service endpoint URL
        :param builtins.str invoicing: Use this to override the default service endpoint URL
        :param builtins.str iot: Use this to override the default service endpoint URL
        :param builtins.str ivs: Use this to override the default service endpoint URL
        :param builtins.str ivschat: Use this to override the default service endpoint URL
        :param builtins.str kafka: Use this to override the default service endpoint URL
        :param builtins.str kafkaconnect: Use this to override the default service endpoint URL
        :param builtins.str kendra: Use this to override the default service endpoint URL
        :param builtins.str keyspaces: Use this to override the default service endpoint URL
        :param builtins.str kinesis: Use this to override the default service endpoint URL
        :param builtins.str kinesisanalytics: Use this to override the default service endpoint URL
        :param builtins.str kinesisanalyticsv2: Use this to override the default service endpoint URL
        :param builtins.str kinesisvideo: Use this to override the default service endpoint URL
        :param builtins.str kms: Use this to override the default service endpoint URL
        :param builtins.str lakeformation: Use this to override the default service endpoint URL
        :param builtins.str lambda_: Use this to override the default service endpoint URL
        :param builtins.str launchwizard: Use this to override the default service endpoint URL
        :param builtins.str lex: Use this to override the default service endpoint URL
        :param builtins.str lexmodelbuilding: Use this to override the default service endpoint URL
        :param builtins.str lexmodelbuildingservice: Use this to override the default service endpoint URL
        :param builtins.str lexmodels: Use this to override the default service endpoint URL
        :param builtins.str lexmodelsv2: Use this to override the default service endpoint URL
        :param builtins.str lexv2models: Use this to override the default service endpoint URL
        :param builtins.str licensemanager: Use this to override the default service endpoint URL
        :param builtins.str lightsail: Use this to override the default service endpoint URL
        :param builtins.str location: Use this to override the default service endpoint URL
        :param builtins.str locationservice: Use this to override the default service endpoint URL
        :param builtins.str logs: Use this to override the default service endpoint URL
        :param builtins.str lookoutmetrics: Use this to override the default service endpoint URL
        :param builtins.str m2: Use this to override the default service endpoint URL
        :param builtins.str macie2: Use this to override the default service endpoint URL
        :param builtins.str managedgrafana: Use this to override the default service endpoint URL
        :param builtins.str mediaconnect: Use this to override the default service endpoint URL
        :param builtins.str mediaconvert: Use this to override the default service endpoint URL
        :param builtins.str medialive: Use this to override the default service endpoint URL
        :param builtins.str mediapackage: Use this to override the default service endpoint URL
        :param builtins.str mediapackagev2: Use this to override the default service endpoint URL
        :param builtins.str mediapackagevod: Use this to override the default service endpoint URL
        :param builtins.str mediastore: Use this to override the default service endpoint URL
        :param builtins.str memorydb: Use this to override the default service endpoint URL
        :param builtins.str mgn: Use this to override the default service endpoint URL
        :param builtins.str mq: Use this to override the default service endpoint URL
        :param builtins.str msk: Use this to override the default service endpoint URL
        :param builtins.str mwaa: Use this to override the default service endpoint URL
        :param builtins.str neptune: Use this to override the default service endpoint URL
        :param builtins.str neptunegraph: Use this to override the default service endpoint URL
        :param builtins.str networkfirewall: Use this to override the default service endpoint URL
        :param builtins.str networkmanager: Use this to override the default service endpoint URL
        :param builtins.str networkmonitor: Use this to override the default service endpoint URL
        :param builtins.str notifications: Use this to override the default service endpoint URL
        :param builtins.str notificationscontacts: Use this to override the default service endpoint URL
        :param builtins.str oam: Use this to override the default service endpoint URL
        :param builtins.str opensearch: Use this to override the default service endpoint URL
        :param builtins.str opensearchingestion: Use this to override the default service endpoint URL
        :param builtins.str opensearchserverless: Use this to override the default service endpoint URL
        :param builtins.str opensearchservice: Use this to override the default service endpoint URL
        :param builtins.str organizations: Use this to override the default service endpoint URL
        :param builtins.str osis: Use this to override the default service endpoint URL
        :param builtins.str outposts: Use this to override the default service endpoint URL
        :param builtins.str paymentcryptography: Use this to override the default service endpoint URL
        :param builtins.str pcaconnectorad: Use this to override the default service endpoint URL
        :param builtins.str pcs: Use this to override the default service endpoint URL
        :param builtins.str pinpoint: Use this to override the default service endpoint URL
        :param builtins.str pinpointsmsvoicev2: Use this to override the default service endpoint URL
        :param builtins.str pipes: Use this to override the default service endpoint URL
        :param builtins.str polly: Use this to override the default service endpoint URL
        :param builtins.str pricing: Use this to override the default service endpoint URL
        :param builtins.str prometheus: Use this to override the default service endpoint URL
        :param builtins.str prometheusservice: Use this to override the default service endpoint URL
        :param builtins.str qbusiness: Use this to override the default service endpoint URL
        :param builtins.str qldb: Use this to override the default service endpoint URL
        :param builtins.str quicksight: Use this to override the default service endpoint URL
        :param builtins.str ram: Use this to override the default service endpoint URL
        :param builtins.str rbin: Use this to override the default service endpoint URL
        :param builtins.str rds: Use this to override the default service endpoint URL
        :param builtins.str recyclebin: Use this to override the default service endpoint URL
        :param builtins.str redshift: Use this to override the default service endpoint URL
        :param builtins.str redshiftdata: Use this to override the default service endpoint URL
        :param builtins.str redshiftdataapiservice: Use this to override the default service endpoint URL
        :param builtins.str redshiftserverless: Use this to override the default service endpoint URL
        :param builtins.str rekognition: Use this to override the default service endpoint URL
        :param builtins.str resiliencehub: Use this to override the default service endpoint URL
        :param builtins.str resourceexplorer2: Use this to override the default service endpoint URL
        :param builtins.str resourcegroups: Use this to override the default service endpoint URL
        :param builtins.str resourcegroupstagging: Use this to override the default service endpoint URL
        :param builtins.str resourcegroupstaggingapi: Use this to override the default service endpoint URL
        :param builtins.str rolesanywhere: Use this to override the default service endpoint URL
        :param builtins.str route53: Use this to override the default service endpoint URL
        :param builtins.str route53domains: Use this to override the default service endpoint URL
        :param builtins.str route53profiles: Use this to override the default service endpoint URL
        :param builtins.str route53recoverycontrolconfig: Use this to override the default service endpoint URL
        :param builtins.str route53recoveryreadiness: Use this to override the default service endpoint URL
        :param builtins.str route53resolver: Use this to override the default service endpoint URL
        :param builtins.str rum: Use this to override the default service endpoint URL
        :param builtins.str s3: Use this to override the default service endpoint URL
        :param builtins.str s3api: Use this to override the default service endpoint URL
        :param builtins.str s3control: Use this to override the default service endpoint URL
        :param builtins.str s3outposts: Use this to override the default service endpoint URL
        :param builtins.str s3tables: Use this to override the default service endpoint URL
        :param builtins.str sagemaker: Use this to override the default service endpoint URL
        :param builtins.str scheduler: Use this to override the default service endpoint URL
        :param builtins.str schemas: Use this to override the default service endpoint URL
        :param builtins.str secretsmanager: Use this to override the default service endpoint URL
        :param builtins.str securityhub: Use this to override the default service endpoint URL
        :param builtins.str securitylake: Use this to override the default service endpoint URL
        :param builtins.str serverlessapplicationrepository: Use this to override the default service endpoint URL
        :param builtins.str serverlessapprepo: Use this to override the default service endpoint URL
        :param builtins.str serverlessrepo: Use this to override the default service endpoint URL
        :param builtins.str servicecatalog: Use this to override the default service endpoint URL
        :param builtins.str servicecatalogappregistry: Use this to override the default service endpoint URL
        :param builtins.str servicediscovery: Use this to override the default service endpoint URL
        :param builtins.str servicequotas: Use this to override the default service endpoint URL
        :param builtins.str ses: Use this to override the default service endpoint URL
        :param builtins.str sesv2: Use this to override the default service endpoint URL
        :param builtins.str sfn: Use this to override the default service endpoint URL
        :param builtins.str shield: Use this to override the default service endpoint URL
        :param builtins.str signer: Use this to override the default service endpoint URL
        :param builtins.str sns: Use this to override the default service endpoint URL
        :param builtins.str sqs: Use this to override the default service endpoint URL
        :param builtins.str ssm: Use this to override the default service endpoint URL
        :param builtins.str ssmcontacts: Use this to override the default service endpoint URL
        :param builtins.str ssmincidents: Use this to override the default service endpoint URL
        :param builtins.str ssmquicksetup: Use this to override the default service endpoint URL
        :param builtins.str ssmsap: Use this to override the default service endpoint URL
        :param builtins.str sso: Use this to override the default service endpoint URL
        :param builtins.str ssoadmin: Use this to override the default service endpoint URL
        :param builtins.str stepfunctions: Use this to override the default service endpoint URL
        :param builtins.str storagegateway: Use this to override the default service endpoint URL
        :param builtins.str sts: Use this to override the default service endpoint URL
        :param builtins.str swf: Use this to override the default service endpoint URL
        :param builtins.str synthetics: Use this to override the default service endpoint URL
        :param builtins.str taxsettings: Use this to override the default service endpoint URL
        :param builtins.str timestreaminfluxdb: Use this to override the default service endpoint URL
        :param builtins.str timestreamquery: Use this to override the default service endpoint URL
        :param builtins.str timestreamwrite: Use this to override the default service endpoint URL
        :param builtins.str transcribe: Use this to override the default service endpoint URL
        :param builtins.str transcribeservice: Use this to override the default service endpoint URL
        :param builtins.str transfer: Use this to override the default service endpoint URL
        :param builtins.str verifiedpermissions: Use this to override the default service endpoint URL
        :param builtins.str vpclattice: Use this to override the default service endpoint URL
        :param builtins.str waf: Use this to override the default service endpoint URL
        :param builtins.str wafregional: Use this to override the default service endpoint URL
        :param builtins.str wafv2: Use this to override the default service endpoint URL
        :param builtins.str wellarchitected: Use this to override the default service endpoint URL
        :param builtins.str workspaces: Use this to override the default service endpoint URL
        :param builtins.str workspacesweb: Use this to override the default service endpoint URL
        :param builtins.str xray: Use this to override the default service endpoint URL
        """
        if accessanalyzer is not None:
            pulumi.set(__self__, "accessanalyzer", accessanalyzer)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if acm is not None:
            pulumi.set(__self__, "acm", acm)
        if acmpca is not None:
            pulumi.set(__self__, "acmpca", acmpca)
        if amg is not None:
            pulumi.set(__self__, "amg", amg)
        if amp is not None:
            pulumi.set(__self__, "amp", amp)
        if amplify is not None:
            pulumi.set(__self__, "amplify", amplify)
        if apigateway is not None:
            pulumi.set(__self__, "apigateway", apigateway)
        if apigatewayv2 is not None:
            pulumi.set(__self__, "apigatewayv2", apigatewayv2)
        if appautoscaling is not None:
            pulumi.set(__self__, "appautoscaling", appautoscaling)
        if appconfig is not None:
            pulumi.set(__self__, "appconfig", appconfig)
        if appfabric is not None:
            pulumi.set(__self__, "appfabric", appfabric)
        if appflow is not None:
            pulumi.set(__self__, "appflow", appflow)
        if appintegrations is not None:
            pulumi.set(__self__, "appintegrations", appintegrations)
        if appintegrationsservice is not None:
            pulumi.set(__self__, "appintegrationsservice", appintegrationsservice)
        if applicationautoscaling is not None:
            pulumi.set(__self__, "applicationautoscaling", applicationautoscaling)
        if applicationinsights is not None:
            pulumi.set(__self__, "applicationinsights", applicationinsights)
        if applicationsignals is not None:
            pulumi.set(__self__, "applicationsignals", applicationsignals)
        if appmesh is not None:
            pulumi.set(__self__, "appmesh", appmesh)
        if appregistry is not None:
            pulumi.set(__self__, "appregistry", appregistry)
        if apprunner is not None:
            pulumi.set(__self__, "apprunner", apprunner)
        if appstream is not None:
            pulumi.set(__self__, "appstream", appstream)
        if appsync is not None:
            pulumi.set(__self__, "appsync", appsync)
        if athena is not None:
            pulumi.set(__self__, "athena", athena)
        if auditmanager is not None:
            pulumi.set(__self__, "auditmanager", auditmanager)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if autoscalingplans is not None:
            pulumi.set(__self__, "autoscalingplans", autoscalingplans)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if batch is not None:
            pulumi.set(__self__, "batch", batch)
        if bcmdataexports is not None:
            pulumi.set(__self__, "bcmdataexports", bcmdataexports)
        if beanstalk is not None:
            pulumi.set(__self__, "beanstalk", beanstalk)
        if bedrock is not None:
            pulumi.set(__self__, "bedrock", bedrock)
        if bedrockagent is not None:
            pulumi.set(__self__, "bedrockagent", bedrockagent)
        if billing is not None:
            pulumi.set(__self__, "billing", billing)
        if budgets is not None:
            pulumi.set(__self__, "budgets", budgets)
        if ce is not None:
            pulumi.set(__self__, "ce", ce)
        if chatbot is not None:
            pulumi.set(__self__, "chatbot", chatbot)
        if chime is not None:
            pulumi.set(__self__, "chime", chime)
        if chimesdkmediapipelines is not None:
            pulumi.set(__self__, "chimesdkmediapipelines", chimesdkmediapipelines)
        if chimesdkvoice is not None:
            pulumi.set(__self__, "chimesdkvoice", chimesdkvoice)
        if cleanrooms is not None:
            pulumi.set(__self__, "cleanrooms", cleanrooms)
        if cloud9 is not None:
            pulumi.set(__self__, "cloud9", cloud9)
        if cloudcontrol is not None:
            pulumi.set(__self__, "cloudcontrol", cloudcontrol)
        if cloudcontrolapi is not None:
            pulumi.set(__self__, "cloudcontrolapi", cloudcontrolapi)
        if cloudformation is not None:
            pulumi.set(__self__, "cloudformation", cloudformation)
        if cloudfront is not None:
            pulumi.set(__self__, "cloudfront", cloudfront)
        if cloudfrontkeyvaluestore is not None:
            pulumi.set(__self__, "cloudfrontkeyvaluestore", cloudfrontkeyvaluestore)
        if cloudhsm is not None:
            pulumi.set(__self__, "cloudhsm", cloudhsm)
        if cloudhsmv2 is not None:
            pulumi.set(__self__, "cloudhsmv2", cloudhsmv2)
        if cloudsearch is not None:
            pulumi.set(__self__, "cloudsearch", cloudsearch)
        if cloudtrail is not None:
            pulumi.set(__self__, "cloudtrail", cloudtrail)
        if cloudwatch is not None:
            pulumi.set(__self__, "cloudwatch", cloudwatch)
        if cloudwatchevents is not None:
            pulumi.set(__self__, "cloudwatchevents", cloudwatchevents)
        if cloudwatchevidently is not None:
            pulumi.set(__self__, "cloudwatchevidently", cloudwatchevidently)
        if cloudwatchlog is not None:
            pulumi.set(__self__, "cloudwatchlog", cloudwatchlog)
        if cloudwatchlogs is not None:
            pulumi.set(__self__, "cloudwatchlogs", cloudwatchlogs)
        if cloudwatchobservabilityaccessmanager is not None:
            pulumi.set(__self__, "cloudwatchobservabilityaccessmanager", cloudwatchobservabilityaccessmanager)
        if cloudwatchrum is not None:
            pulumi.set(__self__, "cloudwatchrum", cloudwatchrum)
        if codeartifact is not None:
            pulumi.set(__self__, "codeartifact", codeartifact)
        if codebuild is not None:
            pulumi.set(__self__, "codebuild", codebuild)
        if codecatalyst is not None:
            pulumi.set(__self__, "codecatalyst", codecatalyst)
        if codecommit is not None:
            pulumi.set(__self__, "codecommit", codecommit)
        if codeconnections is not None:
            pulumi.set(__self__, "codeconnections", codeconnections)
        if codedeploy is not None:
            pulumi.set(__self__, "codedeploy", codedeploy)
        if codeguruprofiler is not None:
            pulumi.set(__self__, "codeguruprofiler", codeguruprofiler)
        if codegurureviewer is not None:
            pulumi.set(__self__, "codegurureviewer", codegurureviewer)
        if codepipeline is not None:
            pulumi.set(__self__, "codepipeline", codepipeline)
        if codestarconnections is not None:
            pulumi.set(__self__, "codestarconnections", codestarconnections)
        if codestarnotifications is not None:
            pulumi.set(__self__, "codestarnotifications", codestarnotifications)
        if cognitoidentity is not None:
            pulumi.set(__self__, "cognitoidentity", cognitoidentity)
        if cognitoidentityprovider is not None:
            pulumi.set(__self__, "cognitoidentityprovider", cognitoidentityprovider)
        if cognitoidp is not None:
            pulumi.set(__self__, "cognitoidp", cognitoidp)
        if comprehend is not None:
            pulumi.set(__self__, "comprehend", comprehend)
        if computeoptimizer is not None:
            pulumi.set(__self__, "computeoptimizer", computeoptimizer)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if configservice is not None:
            pulumi.set(__self__, "configservice", configservice)
        if connect is not None:
            pulumi.set(__self__, "connect", connect)
        if connectcases is not None:
            pulumi.set(__self__, "connectcases", connectcases)
        if controltower is not None:
            pulumi.set(__self__, "controltower", controltower)
        if costandusagereportservice is not None:
            pulumi.set(__self__, "costandusagereportservice", costandusagereportservice)
        if costexplorer is not None:
            pulumi.set(__self__, "costexplorer", costexplorer)
        if costoptimizationhub is not None:
            pulumi.set(__self__, "costoptimizationhub", costoptimizationhub)
        if cur is not None:
            pulumi.set(__self__, "cur", cur)
        if customerprofiles is not None:
            pulumi.set(__self__, "customerprofiles", customerprofiles)
        if databasemigration is not None:
            pulumi.set(__self__, "databasemigration", databasemigration)
        if databasemigrationservice is not None:
            pulumi.set(__self__, "databasemigrationservice", databasemigrationservice)
        if databrew is not None:
            pulumi.set(__self__, "databrew", databrew)
        if dataexchange is not None:
            pulumi.set(__self__, "dataexchange", dataexchange)
        if datapipeline is not None:
            pulumi.set(__self__, "datapipeline", datapipeline)
        if datasync is not None:
            pulumi.set(__self__, "datasync", datasync)
        if datazone is not None:
            pulumi.set(__self__, "datazone", datazone)
        if dax is not None:
            pulumi.set(__self__, "dax", dax)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if detective is not None:
            pulumi.set(__self__, "detective", detective)
        if devicefarm is not None:
            pulumi.set(__self__, "devicefarm", devicefarm)
        if devopsguru is not None:
            pulumi.set(__self__, "devopsguru", devopsguru)
        if directconnect is not None:
            pulumi.set(__self__, "directconnect", directconnect)
        if directoryservice is not None:
            pulumi.set(__self__, "directoryservice", directoryservice)
        if dlm is not None:
            pulumi.set(__self__, "dlm", dlm)
        if dms is not None:
            pulumi.set(__self__, "dms", dms)
        if docdb is not None:
            pulumi.set(__self__, "docdb", docdb)
        if docdbelastic is not None:
            pulumi.set(__self__, "docdbelastic", docdbelastic)
        if drs is not None:
            pulumi.set(__self__, "drs", drs)
        if ds is not None:
            pulumi.set(__self__, "ds", ds)
        if dsql is not None:
            pulumi.set(__self__, "dsql", dsql)
        if dynamodb is not None:
            pulumi.set(__self__, "dynamodb", dynamodb)
        if ec2 is not None:
            pulumi.set(__self__, "ec2", ec2)
        if ecr is not None:
            pulumi.set(__self__, "ecr", ecr)
        if ecrpublic is not None:
            pulumi.set(__self__, "ecrpublic", ecrpublic)
        if ecs is not None:
            pulumi.set(__self__, "ecs", ecs)
        if efs is not None:
            pulumi.set(__self__, "efs", efs)
        if eks is not None:
            pulumi.set(__self__, "eks", eks)
        if elasticache is not None:
            pulumi.set(__self__, "elasticache", elasticache)
        if elasticbeanstalk is not None:
            pulumi.set(__self__, "elasticbeanstalk", elasticbeanstalk)
        if elasticloadbalancing is not None:
            pulumi.set(__self__, "elasticloadbalancing", elasticloadbalancing)
        if elasticloadbalancingv2 is not None:
            pulumi.set(__self__, "elasticloadbalancingv2", elasticloadbalancingv2)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if elasticsearchservice is not None:
            pulumi.set(__self__, "elasticsearchservice", elasticsearchservice)
        if elastictranscoder is not None:
            pulumi.set(__self__, "elastictranscoder", elastictranscoder)
        if elb is not None:
            pulumi.set(__self__, "elb", elb)
        if elbv2 is not None:
            pulumi.set(__self__, "elbv2", elbv2)
        if emr is not None:
            pulumi.set(__self__, "emr", emr)
        if emrcontainers is not None:
            pulumi.set(__self__, "emrcontainers", emrcontainers)
        if emrserverless is not None:
            pulumi.set(__self__, "emrserverless", emrserverless)
        if es is not None:
            pulumi.set(__self__, "es", es)
        if eventbridge is not None:
            pulumi.set(__self__, "eventbridge", eventbridge)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if evidently is not None:
            pulumi.set(__self__, "evidently", evidently)
        if evs is not None:
            pulumi.set(__self__, "evs", evs)
        if finspace is not None:
            pulumi.set(__self__, "finspace", finspace)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if fis is not None:
            pulumi.set(__self__, "fis", fis)
        if fms is not None:
            pulumi.set(__self__, "fms", fms)
        if fsx is not None:
            pulumi.set(__self__, "fsx", fsx)
        if gamelift is not None:
            pulumi.set(__self__, "gamelift", gamelift)
        if glacier is not None:
            pulumi.set(__self__, "glacier", glacier)
        if globalaccelerator is not None:
            pulumi.set(__self__, "globalaccelerator", globalaccelerator)
        if glue is not None:
            pulumi.set(__self__, "glue", glue)
        if gluedatabrew is not None:
            pulumi.set(__self__, "gluedatabrew", gluedatabrew)
        if grafana is not None:
            pulumi.set(__self__, "grafana", grafana)
        if greengrass is not None:
            pulumi.set(__self__, "greengrass", greengrass)
        if groundstation is not None:
            pulumi.set(__self__, "groundstation", groundstation)
        if guardduty is not None:
            pulumi.set(__self__, "guardduty", guardduty)
        if healthlake is not None:
            pulumi.set(__self__, "healthlake", healthlake)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if identitystore is not None:
            pulumi.set(__self__, "identitystore", identitystore)
        if imagebuilder is not None:
            pulumi.set(__self__, "imagebuilder", imagebuilder)
        if inspector is not None:
            pulumi.set(__self__, "inspector", inspector)
        if inspector2 is not None:
            pulumi.set(__self__, "inspector2", inspector2)
        if inspectorv2 is not None:
            pulumi.set(__self__, "inspectorv2", inspectorv2)
        if internetmonitor is not None:
            pulumi.set(__self__, "internetmonitor", internetmonitor)
        if invoicing is not None:
            pulumi.set(__self__, "invoicing", invoicing)
        if iot is not None:
            pulumi.set(__self__, "iot", iot)
        if ivs is not None:
            pulumi.set(__self__, "ivs", ivs)
        if ivschat is not None:
            pulumi.set(__self__, "ivschat", ivschat)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if kafkaconnect is not None:
            pulumi.set(__self__, "kafkaconnect", kafkaconnect)
        if kendra is not None:
            pulumi.set(__self__, "kendra", kendra)
        if keyspaces is not None:
            pulumi.set(__self__, "keyspaces", keyspaces)
        if kinesis is not None:
            pulumi.set(__self__, "kinesis", kinesis)
        if kinesisanalytics is not None:
            pulumi.set(__self__, "kinesisanalytics", kinesisanalytics)
        if kinesisanalyticsv2 is not None:
            pulumi.set(__self__, "kinesisanalyticsv2", kinesisanalyticsv2)
        if kinesisvideo is not None:
            pulumi.set(__self__, "kinesisvideo", kinesisvideo)
        if kms is not None:
            pulumi.set(__self__, "kms", kms)
        if lakeformation is not None:
            pulumi.set(__self__, "lakeformation", lakeformation)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if launchwizard is not None:
            pulumi.set(__self__, "launchwizard", launchwizard)
        if lex is not None:
            pulumi.set(__self__, "lex", lex)
        if lexmodelbuilding is not None:
            pulumi.set(__self__, "lexmodelbuilding", lexmodelbuilding)
        if lexmodelbuildingservice is not None:
            pulumi.set(__self__, "lexmodelbuildingservice", lexmodelbuildingservice)
        if lexmodels is not None:
            pulumi.set(__self__, "lexmodels", lexmodels)
        if lexmodelsv2 is not None:
            pulumi.set(__self__, "lexmodelsv2", lexmodelsv2)
        if lexv2models is not None:
            pulumi.set(__self__, "lexv2models", lexv2models)
        if licensemanager is not None:
            pulumi.set(__self__, "licensemanager", licensemanager)
        if lightsail is not None:
            pulumi.set(__self__, "lightsail", lightsail)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if locationservice is not None:
            pulumi.set(__self__, "locationservice", locationservice)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if lookoutmetrics is not None:
            pulumi.set(__self__, "lookoutmetrics", lookoutmetrics)
        if m2 is not None:
            pulumi.set(__self__, "m2", m2)
        if macie2 is not None:
            pulumi.set(__self__, "macie2", macie2)
        if managedgrafana is not None:
            pulumi.set(__self__, "managedgrafana", managedgrafana)
        if mediaconnect is not None:
            pulumi.set(__self__, "mediaconnect", mediaconnect)
        if mediaconvert is not None:
            pulumi.set(__self__, "mediaconvert", mediaconvert)
        if medialive is not None:
            pulumi.set(__self__, "medialive", medialive)
        if mediapackage is not None:
            pulumi.set(__self__, "mediapackage", mediapackage)
        if mediapackagev2 is not None:
            pulumi.set(__self__, "mediapackagev2", mediapackagev2)
        if mediapackagevod is not None:
            pulumi.set(__self__, "mediapackagevod", mediapackagevod)
        if mediastore is not None:
            pulumi.set(__self__, "mediastore", mediastore)
        if memorydb is not None:
            pulumi.set(__self__, "memorydb", memorydb)
        if mgn is not None:
            pulumi.set(__self__, "mgn", mgn)
        if mq is not None:
            pulumi.set(__self__, "mq", mq)
        if msk is not None:
            pulumi.set(__self__, "msk", msk)
        if mwaa is not None:
            pulumi.set(__self__, "mwaa", mwaa)
        if neptune is not None:
            pulumi.set(__self__, "neptune", neptune)
        if neptunegraph is not None:
            pulumi.set(__self__, "neptunegraph", neptunegraph)
        if networkfirewall is not None:
            pulumi.set(__self__, "networkfirewall", networkfirewall)
        if networkmanager is not None:
            pulumi.set(__self__, "networkmanager", networkmanager)
        if networkmonitor is not None:
            pulumi.set(__self__, "networkmonitor", networkmonitor)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if notificationscontacts is not None:
            pulumi.set(__self__, "notificationscontacts", notificationscontacts)
        if oam is not None:
            pulumi.set(__self__, "oam", oam)
        if opensearch is not None:
            pulumi.set(__self__, "opensearch", opensearch)
        if opensearchingestion is not None:
            pulumi.set(__self__, "opensearchingestion", opensearchingestion)
        if opensearchserverless is not None:
            pulumi.set(__self__, "opensearchserverless", opensearchserverless)
        if opensearchservice is not None:
            pulumi.set(__self__, "opensearchservice", opensearchservice)
        if organizations is not None:
            pulumi.set(__self__, "organizations", organizations)
        if osis is not None:
            pulumi.set(__self__, "osis", osis)
        if outposts is not None:
            pulumi.set(__self__, "outposts", outposts)
        if paymentcryptography is not None:
            pulumi.set(__self__, "paymentcryptography", paymentcryptography)
        if pcaconnectorad is not None:
            pulumi.set(__self__, "pcaconnectorad", pcaconnectorad)
        if pcs is not None:
            pulumi.set(__self__, "pcs", pcs)
        if pinpoint is not None:
            pulumi.set(__self__, "pinpoint", pinpoint)
        if pinpointsmsvoicev2 is not None:
            pulumi.set(__self__, "pinpointsmsvoicev2", pinpointsmsvoicev2)
        if pipes is not None:
            pulumi.set(__self__, "pipes", pipes)
        if polly is not None:
            pulumi.set(__self__, "polly", polly)
        if pricing is not None:
            pulumi.set(__self__, "pricing", pricing)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)
        if prometheusservice is not None:
            pulumi.set(__self__, "prometheusservice", prometheusservice)
        if qbusiness is not None:
            pulumi.set(__self__, "qbusiness", qbusiness)
        if qldb is not None:
            pulumi.set(__self__, "qldb", qldb)
        if quicksight is not None:
            pulumi.set(__self__, "quicksight", quicksight)
        if ram is not None:
            pulumi.set(__self__, "ram", ram)
        if rbin is not None:
            pulumi.set(__self__, "rbin", rbin)
        if rds is not None:
            pulumi.set(__self__, "rds", rds)
        if recyclebin is not None:
            pulumi.set(__self__, "recyclebin", recyclebin)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if redshiftdata is not None:
            pulumi.set(__self__, "redshiftdata", redshiftdata)
        if redshiftdataapiservice is not None:
            pulumi.set(__self__, "redshiftdataapiservice", redshiftdataapiservice)
        if redshiftserverless is not None:
            pulumi.set(__self__, "redshiftserverless", redshiftserverless)
        if rekognition is not None:
            pulumi.set(__self__, "rekognition", rekognition)
        if resiliencehub is not None:
            pulumi.set(__self__, "resiliencehub", resiliencehub)
        if resourceexplorer2 is not None:
            pulumi.set(__self__, "resourceexplorer2", resourceexplorer2)
        if resourcegroups is not None:
            pulumi.set(__self__, "resourcegroups", resourcegroups)
        if resourcegroupstagging is not None:
            pulumi.set(__self__, "resourcegroupstagging", resourcegroupstagging)
        if resourcegroupstaggingapi is not None:
            pulumi.set(__self__, "resourcegroupstaggingapi", resourcegroupstaggingapi)
        if rolesanywhere is not None:
            pulumi.set(__self__, "rolesanywhere", rolesanywhere)
        if route53 is not None:
            pulumi.set(__self__, "route53", route53)
        if route53domains is not None:
            pulumi.set(__self__, "route53domains", route53domains)
        if route53profiles is not None:
            pulumi.set(__self__, "route53profiles", route53profiles)
        if route53recoverycontrolconfig is not None:
            pulumi.set(__self__, "route53recoverycontrolconfig", route53recoverycontrolconfig)
        if route53recoveryreadiness is not None:
            pulumi.set(__self__, "route53recoveryreadiness", route53recoveryreadiness)
        if route53resolver is not None:
            pulumi.set(__self__, "route53resolver", route53resolver)
        if rum is not None:
            pulumi.set(__self__, "rum", rum)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if s3api is not None:
            pulumi.set(__self__, "s3api", s3api)
        if s3control is not None:
            pulumi.set(__self__, "s3control", s3control)
        if s3outposts is not None:
            pulumi.set(__self__, "s3outposts", s3outposts)
        if s3tables is not None:
            pulumi.set(__self__, "s3tables", s3tables)
        if sagemaker is not None:
            pulumi.set(__self__, "sagemaker", sagemaker)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if secretsmanager is not None:
            pulumi.set(__self__, "secretsmanager", secretsmanager)
        if securityhub is not None:
            pulumi.set(__self__, "securityhub", securityhub)
        if securitylake is not None:
            pulumi.set(__self__, "securitylake", securitylake)
        if serverlessapplicationrepository is not None:
            pulumi.set(__self__, "serverlessapplicationrepository", serverlessapplicationrepository)
        if serverlessapprepo is not None:
            pulumi.set(__self__, "serverlessapprepo", serverlessapprepo)
        if serverlessrepo is not None:
            pulumi.set(__self__, "serverlessrepo", serverlessrepo)
        if servicecatalog is not None:
            pulumi.set(__self__, "servicecatalog", servicecatalog)
        if servicecatalogappregistry is not None:
            pulumi.set(__self__, "servicecatalogappregistry", servicecatalogappregistry)
        if servicediscovery is not None:
            pulumi.set(__self__, "servicediscovery", servicediscovery)
        if servicequotas is not None:
            pulumi.set(__self__, "servicequotas", servicequotas)
        if ses is not None:
            pulumi.set(__self__, "ses", ses)
        if sesv2 is not None:
            pulumi.set(__self__, "sesv2", sesv2)
        if sfn is not None:
            pulumi.set(__self__, "sfn", sfn)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if signer is not None:
            pulumi.set(__self__, "signer", signer)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)
        if ssm is not None:
            pulumi.set(__self__, "ssm", ssm)
        if ssmcontacts is not None:
            pulumi.set(__self__, "ssmcontacts", ssmcontacts)
        if ssmincidents is not None:
            pulumi.set(__self__, "ssmincidents", ssmincidents)
        if ssmquicksetup is not None:
            pulumi.set(__self__, "ssmquicksetup", ssmquicksetup)
        if ssmsap is not None:
            pulumi.set(__self__, "ssmsap", ssmsap)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if ssoadmin is not None:
            pulumi.set(__self__, "ssoadmin", ssoadmin)
        if stepfunctions is not None:
            pulumi.set(__self__, "stepfunctions", stepfunctions)
        if storagegateway is not None:
            pulumi.set(__self__, "storagegateway", storagegateway)
        if sts is not None:
            pulumi.set(__self__, "sts", sts)
        if swf is not None:
            pulumi.set(__self__, "swf", swf)
        if synthetics is not None:
            pulumi.set(__self__, "synthetics", synthetics)
        if taxsettings is not None:
            pulumi.set(__self__, "taxsettings", taxsettings)
        if timestreaminfluxdb is not None:
            pulumi.set(__self__, "timestreaminfluxdb", timestreaminfluxdb)
        if timestreamquery is not None:
            pulumi.set(__self__, "timestreamquery", timestreamquery)
        if timestreamwrite is not None:
            pulumi.set(__self__, "timestreamwrite", timestreamwrite)
        if transcribe is not None:
            pulumi.set(__self__, "transcribe", transcribe)
        if transcribeservice is not None:
            pulumi.set(__self__, "transcribeservice", transcribeservice)
        if transfer is not None:
            pulumi.set(__self__, "transfer", transfer)
        if verifiedpermissions is not None:
            pulumi.set(__self__, "verifiedpermissions", verifiedpermissions)
        if vpclattice is not None:
            pulumi.set(__self__, "vpclattice", vpclattice)
        if waf is not None:
            pulumi.set(__self__, "waf", waf)
        if wafregional is not None:
            pulumi.set(__self__, "wafregional", wafregional)
        if wafv2 is not None:
            pulumi.set(__self__, "wafv2", wafv2)
        if wellarchitected is not None:
            pulumi.set(__self__, "wellarchitected", wellarchitected)
        if workspaces is not None:
            pulumi.set(__self__, "workspaces", workspaces)
        if workspacesweb is not None:
            pulumi.set(__self__, "workspacesweb", workspacesweb)
        if xray is not None:
            pulumi.set(__self__, "xray", xray)

    @property
    @pulumi.getter
    def accessanalyzer(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "accessanalyzer")

    @property
    @pulumi.getter
    def account(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter
    def acm(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "acm")

    @property
    @pulumi.getter
    def acmpca(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "acmpca")

    @property
    @pulumi.getter
    def amg(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "amg")

    @property
    @pulumi.getter
    def amp(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "amp")

    @property
    @pulumi.getter
    def amplify(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "amplify")

    @property
    @pulumi.getter
    def apigateway(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "apigateway")

    @property
    @pulumi.getter
    def apigatewayv2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "apigatewayv2")

    @property
    @pulumi.getter
    def appautoscaling(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appautoscaling")

    @property
    @pulumi.getter
    def appconfig(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appconfig")

    @property
    @pulumi.getter
    def appfabric(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appfabric")

    @property
    @pulumi.getter
    def appflow(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appflow")

    @property
    @pulumi.getter
    def appintegrations(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appintegrations")

    @property
    @pulumi.getter
    def appintegrationsservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appintegrationsservice")

    @property
    @pulumi.getter
    def applicationautoscaling(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "applicationautoscaling")

    @property
    @pulumi.getter
    def applicationinsights(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "applicationinsights")

    @property
    @pulumi.getter
    def applicationsignals(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "applicationsignals")

    @property
    @pulumi.getter
    def appmesh(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appmesh")

    @property
    @pulumi.getter
    def appregistry(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appregistry")

    @property
    @pulumi.getter
    def apprunner(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "apprunner")

    @property
    @pulumi.getter
    def appstream(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appstream")

    @property
    @pulumi.getter
    def appsync(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "appsync")

    @property
    @pulumi.getter
    def athena(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "athena")

    @property
    @pulumi.getter
    def auditmanager(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "auditmanager")

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter
    def autoscalingplans(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "autoscalingplans")

    @property
    @pulumi.getter
    def backup(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter
    def batch(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "batch")

    @property
    @pulumi.getter
    def bcmdataexports(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "bcmdataexports")

    @property
    @pulumi.getter
    def beanstalk(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "beanstalk")

    @property
    @pulumi.getter
    def bedrock(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "bedrock")

    @property
    @pulumi.getter
    def bedrockagent(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "bedrockagent")

    @property
    @pulumi.getter
    def billing(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "billing")

    @property
    @pulumi.getter
    def budgets(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "budgets")

    @property
    @pulumi.getter
    def ce(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ce")

    @property
    @pulumi.getter
    def chatbot(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "chatbot")

    @property
    @pulumi.getter
    def chime(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "chime")

    @property
    @pulumi.getter
    def chimesdkmediapipelines(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "chimesdkmediapipelines")

    @property
    @pulumi.getter
    def chimesdkvoice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "chimesdkvoice")

    @property
    @pulumi.getter
    def cleanrooms(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cleanrooms")

    @property
    @pulumi.getter
    def cloud9(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloud9")

    @property
    @pulumi.getter
    def cloudcontrol(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudcontrol")

    @property
    @pulumi.getter
    def cloudcontrolapi(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudcontrolapi")

    @property
    @pulumi.getter
    def cloudformation(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudformation")

    @property
    @pulumi.getter
    def cloudfront(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudfront")

    @property
    @pulumi.getter
    def cloudfrontkeyvaluestore(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudfrontkeyvaluestore")

    @property
    @pulumi.getter
    def cloudhsm(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudhsm")

    @property
    @pulumi.getter
    def cloudhsmv2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudhsmv2")

    @property
    @pulumi.getter
    def cloudsearch(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudsearch")

    @property
    @pulumi.getter
    def cloudtrail(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudtrail")

    @property
    @pulumi.getter
    def cloudwatch(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatch")

    @property
    @pulumi.getter
    def cloudwatchevents(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchevents")

    @property
    @pulumi.getter
    def cloudwatchevidently(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchevidently")

    @property
    @pulumi.getter
    def cloudwatchlog(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchlog")

    @property
    @pulumi.getter
    def cloudwatchlogs(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchlogs")

    @property
    @pulumi.getter
    def cloudwatchobservabilityaccessmanager(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchobservabilityaccessmanager")

    @property
    @pulumi.getter
    def cloudwatchrum(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cloudwatchrum")

    @property
    @pulumi.getter
    def codeartifact(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codeartifact")

    @property
    @pulumi.getter
    def codebuild(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codebuild")

    @property
    @pulumi.getter
    def codecatalyst(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codecatalyst")

    @property
    @pulumi.getter
    def codecommit(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codecommit")

    @property
    @pulumi.getter
    def codeconnections(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codeconnections")

    @property
    @pulumi.getter
    def codedeploy(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codedeploy")

    @property
    @pulumi.getter
    def codeguruprofiler(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codeguruprofiler")

    @property
    @pulumi.getter
    def codegurureviewer(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codegurureviewer")

    @property
    @pulumi.getter
    def codepipeline(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codepipeline")

    @property
    @pulumi.getter
    def codestarconnections(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codestarconnections")

    @property
    @pulumi.getter
    def codestarnotifications(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "codestarnotifications")

    @property
    @pulumi.getter
    def cognitoidentity(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cognitoidentity")

    @property
    @pulumi.getter
    def cognitoidentityprovider(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cognitoidentityprovider")

    @property
    @pulumi.getter
    def cognitoidp(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cognitoidp")

    @property
    @pulumi.getter
    def comprehend(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "comprehend")

    @property
    @pulumi.getter
    def computeoptimizer(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "computeoptimizer")

    @property
    @pulumi.getter
    def config(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def configservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "configservice")

    @property
    @pulumi.getter
    def connect(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "connect")

    @property
    @pulumi.getter
    def connectcases(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "connectcases")

    @property
    @pulumi.getter
    def controltower(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "controltower")

    @property
    @pulumi.getter
    def costandusagereportservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "costandusagereportservice")

    @property
    @pulumi.getter
    def costexplorer(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "costexplorer")

    @property
    @pulumi.getter
    def costoptimizationhub(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "costoptimizationhub")

    @property
    @pulumi.getter
    def cur(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "cur")

    @property
    @pulumi.getter
    def customerprofiles(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "customerprofiles")

    @property
    @pulumi.getter
    def databasemigration(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "databasemigration")

    @property
    @pulumi.getter
    def databasemigrationservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "databasemigrationservice")

    @property
    @pulumi.getter
    def databrew(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "databrew")

    @property
    @pulumi.getter
    def dataexchange(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dataexchange")

    @property
    @pulumi.getter
    def datapipeline(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "datapipeline")

    @property
    @pulumi.getter
    def datasync(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "datasync")

    @property
    @pulumi.getter
    def datazone(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "datazone")

    @property
    @pulumi.getter
    def dax(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dax")

    @property
    @pulumi.getter
    def deploy(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "deploy")

    @property
    @pulumi.getter
    def detective(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "detective")

    @property
    @pulumi.getter
    def devicefarm(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "devicefarm")

    @property
    @pulumi.getter
    def devopsguru(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "devopsguru")

    @property
    @pulumi.getter
    def directconnect(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "directconnect")

    @property
    @pulumi.getter
    def directoryservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "directoryservice")

    @property
    @pulumi.getter
    def dlm(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dlm")

    @property
    @pulumi.getter
    def dms(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dms")

    @property
    @pulumi.getter
    def docdb(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "docdb")

    @property
    @pulumi.getter
    def docdbelastic(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "docdbelastic")

    @property
    @pulumi.getter
    def drs(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "drs")

    @property
    @pulumi.getter
    def ds(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ds")

    @property
    @pulumi.getter
    def dsql(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dsql")

    @property
    @pulumi.getter
    def dynamodb(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "dynamodb")

    @property
    @pulumi.getter
    def ec2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ec2")

    @property
    @pulumi.getter
    def ecr(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ecr")

    @property
    @pulumi.getter
    def ecrpublic(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ecrpublic")

    @property
    @pulumi.getter
    def ecs(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ecs")

    @property
    @pulumi.getter
    def efs(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "efs")

    @property
    @pulumi.getter
    def eks(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "eks")

    @property
    @pulumi.getter
    def elasticache(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticache")

    @property
    @pulumi.getter
    def elasticbeanstalk(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticbeanstalk")

    @property
    @pulumi.getter
    def elasticloadbalancing(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticloadbalancing")

    @property
    @pulumi.getter
    def elasticloadbalancingv2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticloadbalancingv2")

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticsearch")

    @property
    @pulumi.getter
    def elasticsearchservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elasticsearchservice")

    @property
    @pulumi.getter
    def elastictranscoder(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elastictranscoder")

    @property
    @pulumi.getter
    def elb(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elb")

    @property
    @pulumi.getter
    def elbv2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "elbv2")

    @property
    @pulumi.getter
    def emr(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "emr")

    @property
    @pulumi.getter
    def emrcontainers(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "emrcontainers")

    @property
    @pulumi.getter
    def emrserverless(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "emrserverless")

    @property
    @pulumi.getter
    def es(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "es")

    @property
    @pulumi.getter
    def eventbridge(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "eventbridge")

    @property
    @pulumi.getter
    def events(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter
    def evidently(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "evidently")

    @property
    @pulumi.getter
    def evs(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "evs")

    @property
    @pulumi.getter
    def finspace(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "finspace")

    @property
    @pulumi.getter
    def firehose(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "firehose")

    @property
    @pulumi.getter
    def fis(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "fis")

    @property
    @pulumi.getter
    def fms(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "fms")

    @property
    @pulumi.getter
    def fsx(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "fsx")

    @property
    @pulumi.getter
    def gamelift(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "gamelift")

    @property
    @pulumi.getter
    def glacier(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "glacier")

    @property
    @pulumi.getter
    def globalaccelerator(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "globalaccelerator")

    @property
    @pulumi.getter
    def glue(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "glue")

    @property
    @pulumi.getter
    def gluedatabrew(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "gluedatabrew")

    @property
    @pulumi.getter
    def grafana(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "grafana")

    @property
    @pulumi.getter
    def greengrass(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "greengrass")

    @property
    @pulumi.getter
    def groundstation(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "groundstation")

    @property
    @pulumi.getter
    def guardduty(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "guardduty")

    @property
    @pulumi.getter
    def healthlake(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "healthlake")

    @property
    @pulumi.getter
    def iam(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def identitystore(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "identitystore")

    @property
    @pulumi.getter
    def imagebuilder(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "imagebuilder")

    @property
    @pulumi.getter
    def inspector(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "inspector")

    @property
    @pulumi.getter
    def inspector2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "inspector2")

    @property
    @pulumi.getter
    def inspectorv2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "inspectorv2")

    @property
    @pulumi.getter
    def internetmonitor(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "internetmonitor")

    @property
    @pulumi.getter
    def invoicing(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "invoicing")

    @property
    @pulumi.getter
    def iot(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "iot")

    @property
    @pulumi.getter
    def ivs(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ivs")

    @property
    @pulumi.getter
    def ivschat(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ivschat")

    @property
    @pulumi.getter
    def kafka(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kafka")

    @property
    @pulumi.getter
    def kafkaconnect(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kafkaconnect")

    @property
    @pulumi.getter
    def kendra(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kendra")

    @property
    @pulumi.getter
    def keyspaces(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "keyspaces")

    @property
    @pulumi.getter
    def kinesis(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kinesis")

    @property
    @pulumi.getter
    def kinesisanalytics(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kinesisanalytics")

    @property
    @pulumi.getter
    def kinesisanalyticsv2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kinesisanalyticsv2")

    @property
    @pulumi.getter
    def kinesisvideo(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kinesisvideo")

    @property
    @pulumi.getter
    def kms(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "kms")

    @property
    @pulumi.getter
    def lakeformation(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lakeformation")

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lambda_")

    @property
    @pulumi.getter
    def launchwizard(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "launchwizard")

    @property
    @pulumi.getter
    def lex(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lex")

    @property
    @pulumi.getter
    def lexmodelbuilding(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexmodelbuilding")

    @property
    @pulumi.getter
    def lexmodelbuildingservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexmodelbuildingservice")

    @property
    @pulumi.getter
    def lexmodels(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexmodels")

    @property
    @pulumi.getter
    def lexmodelsv2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexmodelsv2")

    @property
    @pulumi.getter
    def lexv2models(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lexv2models")

    @property
    @pulumi.getter
    def licensemanager(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "licensemanager")

    @property
    @pulumi.getter
    def lightsail(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lightsail")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def locationservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "locationservice")

    @property
    @pulumi.getter
    def logs(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def lookoutmetrics(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "lookoutmetrics")

    @property
    @pulumi.getter
    def m2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "m2")

    @property
    @pulumi.getter
    def macie2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "macie2")

    @property
    @pulumi.getter
    def managedgrafana(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "managedgrafana")

    @property
    @pulumi.getter
    def mediaconnect(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediaconnect")

    @property
    @pulumi.getter
    def mediaconvert(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediaconvert")

    @property
    @pulumi.getter
    def medialive(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "medialive")

    @property
    @pulumi.getter
    def mediapackage(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediapackage")

    @property
    @pulumi.getter
    def mediapackagev2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediapackagev2")

    @property
    @pulumi.getter
    def mediapackagevod(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediapackagevod")

    @property
    @pulumi.getter
    def mediastore(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mediastore")

    @property
    @pulumi.getter
    def memorydb(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "memorydb")

    @property
    @pulumi.getter
    def mgn(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mgn")

    @property
    @pulumi.getter
    def mq(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mq")

    @property
    @pulumi.getter
    def msk(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "msk")

    @property
    @pulumi.getter
    def mwaa(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "mwaa")

    @property
    @pulumi.getter
    def neptune(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "neptune")

    @property
    @pulumi.getter
    def neptunegraph(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "neptunegraph")

    @property
    @pulumi.getter
    def networkfirewall(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "networkfirewall")

    @property
    @pulumi.getter
    def networkmanager(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "networkmanager")

    @property
    @pulumi.getter
    def networkmonitor(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "networkmonitor")

    @property
    @pulumi.getter
    def notifications(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter
    def notificationscontacts(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "notificationscontacts")

    @property
    @pulumi.getter
    def oam(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "oam")

    @property
    @pulumi.getter
    def opensearch(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "opensearch")

    @property
    @pulumi.getter
    def opensearchingestion(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "opensearchingestion")

    @property
    @pulumi.getter
    def opensearchserverless(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "opensearchserverless")

    @property
    @pulumi.getter
    def opensearchservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "opensearchservice")

    @property
    @pulumi.getter
    def organizations(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "organizations")

    @property
    @pulumi.getter
    def osis(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "osis")

    @property
    @pulumi.getter
    def outposts(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "outposts")

    @property
    @pulumi.getter
    def paymentcryptography(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "paymentcryptography")

    @property
    @pulumi.getter
    def pcaconnectorad(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pcaconnectorad")

    @property
    @pulumi.getter
    def pcs(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pcs")

    @property
    @pulumi.getter
    def pinpoint(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pinpoint")

    @property
    @pulumi.getter
    def pinpointsmsvoicev2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pinpointsmsvoicev2")

    @property
    @pulumi.getter
    def pipes(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pipes")

    @property
    @pulumi.getter
    def polly(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "polly")

    @property
    @pulumi.getter
    def pricing(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "pricing")

    @property
    @pulumi.getter
    def prometheus(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "prometheus")

    @property
    @pulumi.getter
    def prometheusservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "prometheusservice")

    @property
    @pulumi.getter
    def qbusiness(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "qbusiness")

    @property
    @pulumi.getter
    def qldb(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "qldb")

    @property
    @pulumi.getter
    def quicksight(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "quicksight")

    @property
    @pulumi.getter
    def ram(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ram")

    @property
    @pulumi.getter
    def rbin(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rbin")

    @property
    @pulumi.getter
    def rds(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rds")

    @property
    @pulumi.getter
    def recyclebin(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "recyclebin")

    @property
    @pulumi.getter
    def redshift(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "redshift")

    @property
    @pulumi.getter
    def redshiftdata(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "redshiftdata")

    @property
    @pulumi.getter
    def redshiftdataapiservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "redshiftdataapiservice")

    @property
    @pulumi.getter
    def redshiftserverless(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "redshiftserverless")

    @property
    @pulumi.getter
    def rekognition(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rekognition")

    @property
    @pulumi.getter
    def resiliencehub(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resiliencehub")

    @property
    @pulumi.getter
    def resourceexplorer2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resourceexplorer2")

    @property
    @pulumi.getter
    def resourcegroups(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resourcegroups")

    @property
    @pulumi.getter
    def resourcegroupstagging(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resourcegroupstagging")

    @property
    @pulumi.getter
    def resourcegroupstaggingapi(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "resourcegroupstaggingapi")

    @property
    @pulumi.getter
    def rolesanywhere(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rolesanywhere")

    @property
    @pulumi.getter
    def route53(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53")

    @property
    @pulumi.getter
    def route53domains(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53domains")

    @property
    @pulumi.getter
    def route53profiles(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53profiles")

    @property
    @pulumi.getter
    def route53recoverycontrolconfig(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53recoverycontrolconfig")

    @property
    @pulumi.getter
    def route53recoveryreadiness(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53recoveryreadiness")

    @property
    @pulumi.getter
    def route53resolver(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "route53resolver")

    @property
    @pulumi.getter
    def rum(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "rum")

    @property
    @pulumi.getter
    def s3(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def s3api(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3api")

    @property
    @pulumi.getter
    def s3control(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3control")

    @property
    @pulumi.getter
    def s3outposts(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3outposts")

    @property
    @pulumi.getter
    def s3tables(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "s3tables")

    @property
    @pulumi.getter
    def sagemaker(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sagemaker")

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "scheduler")

    @property
    @pulumi.getter
    def schemas(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def secretsmanager(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "secretsmanager")

    @property
    @pulumi.getter
    def securityhub(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "securityhub")

    @property
    @pulumi.getter
    def securitylake(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "securitylake")

    @property
    @pulumi.getter
    def serverlessapplicationrepository(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "serverlessapplicationrepository")

    @property
    @pulumi.getter
    def serverlessapprepo(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "serverlessapprepo")

    @property
    @pulumi.getter
    def serverlessrepo(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "serverlessrepo")

    @property
    @pulumi.getter
    def servicecatalog(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "servicecatalog")

    @property
    @pulumi.getter
    def servicecatalogappregistry(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "servicecatalogappregistry")

    @property
    @pulumi.getter
    def servicediscovery(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "servicediscovery")

    @property
    @pulumi.getter
    def servicequotas(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "servicequotas")

    @property
    @pulumi.getter
    def ses(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ses")

    @property
    @pulumi.getter
    def sesv2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sesv2")

    @property
    @pulumi.getter
    def sfn(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sfn")

    @property
    @pulumi.getter
    def shield(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter
    def signer(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "signer")

    @property
    @pulumi.getter
    def sns(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sns")

    @property
    @pulumi.getter
    def sqs(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sqs")

    @property
    @pulumi.getter
    def ssm(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssm")

    @property
    @pulumi.getter
    def ssmcontacts(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssmcontacts")

    @property
    @pulumi.getter
    def ssmincidents(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssmincidents")

    @property
    @pulumi.getter
    def ssmquicksetup(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssmquicksetup")

    @property
    @pulumi.getter
    def ssmsap(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssmsap")

    @property
    @pulumi.getter
    def sso(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sso")

    @property
    @pulumi.getter
    def ssoadmin(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "ssoadmin")

    @property
    @pulumi.getter
    def stepfunctions(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "stepfunctions")

    @property
    @pulumi.getter
    def storagegateway(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "storagegateway")

    @property
    @pulumi.getter
    def sts(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "sts")

    @property
    @pulumi.getter
    def swf(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "swf")

    @property
    @pulumi.getter
    def synthetics(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "synthetics")

    @property
    @pulumi.getter
    def taxsettings(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "taxsettings")

    @property
    @pulumi.getter
    def timestreaminfluxdb(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "timestreaminfluxdb")

    @property
    @pulumi.getter
    def timestreamquery(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "timestreamquery")

    @property
    @pulumi.getter
    def timestreamwrite(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "timestreamwrite")

    @property
    @pulumi.getter
    def transcribe(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "transcribe")

    @property
    @pulumi.getter
    def transcribeservice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "transcribeservice")

    @property
    @pulumi.getter
    def transfer(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "transfer")

    @property
    @pulumi.getter
    def verifiedpermissions(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "verifiedpermissions")

    @property
    @pulumi.getter
    def vpclattice(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "vpclattice")

    @property
    @pulumi.getter
    def waf(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "waf")

    @property
    @pulumi.getter
    def wafregional(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "wafregional")

    @property
    @pulumi.getter
    def wafv2(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "wafv2")

    @property
    @pulumi.getter
    def wellarchitected(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "wellarchitected")

    @property
    @pulumi.getter
    def workspaces(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "workspaces")

    @property
    @pulumi.getter
    def workspacesweb(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "workspacesweb")

    @property
    @pulumi.getter
    def xray(self) -> Optional[builtins.str]:
        """
        Use this to override the default service endpoint URL
        """
        return pulumi.get(self, "xray")


@pulumi.output_type
class IgnoreTags(dict):
    def __init__(__self__, *,
                 key_prefixes: Optional[Sequence[builtins.str]] = None,
                 keys: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] key_prefixes: Resource tag key prefixes to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEY_PREFIXES environment variable.
        :param Sequence[builtins.str] keys: Resource tag keys to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEYS environment variable.
        """
        if key_prefixes is not None:
            pulumi.set(__self__, "key_prefixes", key_prefixes)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter(name="keyPrefixes")
    def key_prefixes(self) -> Optional[Sequence[builtins.str]]:
        """
        Resource tag key prefixes to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEY_PREFIXES environment variable.
        """
        return pulumi.get(self, "key_prefixes")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[builtins.str]]:
        """
        Resource tag keys to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEYS environment variable.
        """
        return pulumi.get(self, "keys")


