# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRoutingProfileResult',
    'AwaitableGetRoutingProfileResult',
    'get_routing_profile',
    'get_routing_profile_output',
]

@pulumi.output_type
class GetRoutingProfileResult:
    """
    A collection of values returned by getRoutingProfile.
    """
    def __init__(__self__, arn=None, default_outbound_queue_id=None, description=None, id=None, instance_id=None, media_concurrencies=None, name=None, queue_configs=None, region=None, routing_profile_id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if default_outbound_queue_id and not isinstance(default_outbound_queue_id, str):
            raise TypeError("Expected argument 'default_outbound_queue_id' to be a str")
        pulumi.set(__self__, "default_outbound_queue_id", default_outbound_queue_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if media_concurrencies and not isinstance(media_concurrencies, list):
            raise TypeError("Expected argument 'media_concurrencies' to be a list")
        pulumi.set(__self__, "media_concurrencies", media_concurrencies)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if queue_configs and not isinstance(queue_configs, list):
            raise TypeError("Expected argument 'queue_configs' to be a list")
        pulumi.set(__self__, "queue_configs", queue_configs)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routing_profile_id and not isinstance(routing_profile_id, str):
            raise TypeError("Expected argument 'routing_profile_id' to be a str")
        pulumi.set(__self__, "routing_profile_id", routing_profile_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the Routing Profile.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultOutboundQueueId")
    def default_outbound_queue_id(self) -> builtins.str:
        """
        Specifies the default outbound queue for the Routing Profile.
        """
        return pulumi.get(self, "default_outbound_queue_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the Routing Profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="mediaConcurrencies")
    def media_concurrencies(self) -> Sequence['outputs.GetRoutingProfileMediaConcurrencyResult']:
        """
        One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
        """
        return pulumi.get(self, "media_concurrencies")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queueConfigs")
    def queue_configs(self) -> Sequence['outputs.GetRoutingProfileQueueConfigResult']:
        """
        One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
        """
        return pulumi.get(self, "queue_configs")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routingProfileId")
    def routing_profile_id(self) -> builtins.str:
        return pulumi.get(self, "routing_profile_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of tags to assign to the Routing Profile.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRoutingProfileResult(GetRoutingProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoutingProfileResult(
            arn=self.arn,
            default_outbound_queue_id=self.default_outbound_queue_id,
            description=self.description,
            id=self.id,
            instance_id=self.instance_id,
            media_concurrencies=self.media_concurrencies,
            name=self.name,
            queue_configs=self.queue_configs,
            region=self.region,
            routing_profile_id=self.routing_profile_id,
            tags=self.tags)


def get_routing_profile(instance_id: Optional[builtins.str] = None,
                        name: Optional[builtins.str] = None,
                        region: Optional[builtins.str] = None,
                        routing_profile_id: Optional[builtins.str] = None,
                        tags: Optional[Mapping[str, builtins.str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoutingProfileResult:
    """
    Provides details about a specific Amazon Connect Routing Profile.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_routing_profile(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `routing_profile_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_routing_profile(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        routing_profile_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param builtins.str name: Returns information on a specific Routing Profile by name
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str routing_profile_id: Returns information on a specific Routing Profile by Routing Profile id
           
           > **NOTE:** `instance_id` and one of either `name` or `routing_profile_id` is required.
    :param Mapping[str, builtins.str] tags: Map of tags to assign to the Routing Profile.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['routingProfileId'] = routing_profile_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getRoutingProfile:getRoutingProfile', __args__, opts=opts, typ=GetRoutingProfileResult).value

    return AwaitableGetRoutingProfileResult(
        arn=pulumi.get(__ret__, 'arn'),
        default_outbound_queue_id=pulumi.get(__ret__, 'default_outbound_queue_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        media_concurrencies=pulumi.get(__ret__, 'media_concurrencies'),
        name=pulumi.get(__ret__, 'name'),
        queue_configs=pulumi.get(__ret__, 'queue_configs'),
        region=pulumi.get(__ret__, 'region'),
        routing_profile_id=pulumi.get(__ret__, 'routing_profile_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_routing_profile_output(instance_id: Optional[pulumi.Input[builtins.str]] = None,
                               name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               routing_profile_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoutingProfileResult]:
    """
    Provides details about a specific Amazon Connect Routing Profile.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_routing_profile(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `routing_profile_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_routing_profile(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        routing_profile_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param builtins.str name: Returns information on a specific Routing Profile by name
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str routing_profile_id: Returns information on a specific Routing Profile by Routing Profile id
           
           > **NOTE:** `instance_id` and one of either `name` or `routing_profile_id` is required.
    :param Mapping[str, builtins.str] tags: Map of tags to assign to the Routing Profile.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['routingProfileId'] = routing_profile_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:connect/getRoutingProfile:getRoutingProfile', __args__, opts=opts, typ=GetRoutingProfileResult)
    return __ret__.apply(lambda __response__: GetRoutingProfileResult(
        arn=pulumi.get(__response__, 'arn'),
        default_outbound_queue_id=pulumi.get(__response__, 'default_outbound_queue_id'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        media_concurrencies=pulumi.get(__response__, 'media_concurrencies'),
        name=pulumi.get(__response__, 'name'),
        queue_configs=pulumi.get(__response__, 'queue_configs'),
        region=pulumi.get(__response__, 'region'),
        routing_profile_id=pulumi.get(__response__, 'routing_profile_id'),
        tags=pulumi.get(__response__, 'tags')))
