# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, arn=None, directory_user_id=None, hierarchy_group_id=None, id=None, identity_infos=None, instance_id=None, name=None, phone_configs=None, region=None, routing_profile_id=None, security_profile_ids=None, tags=None, user_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if directory_user_id and not isinstance(directory_user_id, str):
            raise TypeError("Expected argument 'directory_user_id' to be a str")
        pulumi.set(__self__, "directory_user_id", directory_user_id)
        if hierarchy_group_id and not isinstance(hierarchy_group_id, str):
            raise TypeError("Expected argument 'hierarchy_group_id' to be a str")
        pulumi.set(__self__, "hierarchy_group_id", hierarchy_group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_infos and not isinstance(identity_infos, list):
            raise TypeError("Expected argument 'identity_infos' to be a list")
        pulumi.set(__self__, "identity_infos", identity_infos)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if phone_configs and not isinstance(phone_configs, list):
            raise TypeError("Expected argument 'phone_configs' to be a list")
        pulumi.set(__self__, "phone_configs", phone_configs)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routing_profile_id and not isinstance(routing_profile_id, str):
            raise TypeError("Expected argument 'routing_profile_id' to be a str")
        pulumi.set(__self__, "routing_profile_id", routing_profile_id)
        if security_profile_ids and not isinstance(security_profile_ids, list):
            raise TypeError("Expected argument 'security_profile_ids' to be a list")
        pulumi.set(__self__, "security_profile_ids", security_profile_ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the User.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="directoryUserId")
    def directory_user_id(self) -> builtins.str:
        """
        The identifier of the user account in the directory used for identity management.
        """
        return pulumi.get(self, "directory_user_id")

    @property
    @pulumi.getter(name="hierarchyGroupId")
    def hierarchy_group_id(self) -> builtins.str:
        """
        The identifier of the hierarchy group for the user.
        """
        return pulumi.get(self, "hierarchy_group_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityInfos")
    def identity_infos(self) -> Sequence['outputs.GetUserIdentityInfoResult']:
        """
        A block that contains information about the identity of the user. Documented below.
        """
        return pulumi.get(self, "identity_infos")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        """
        Specifies the identifier of the hosting Amazon Connect Instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phoneConfigs")
    def phone_configs(self) -> Sequence['outputs.GetUserPhoneConfigResult']:
        """
        A block that contains information about the phone settings for the user. Documented below.
        """
        return pulumi.get(self, "phone_configs")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routingProfileId")
    def routing_profile_id(self) -> builtins.str:
        """
        The identifier of the routing profile for the user.
        """
        return pulumi.get(self, "routing_profile_id")

    @property
    @pulumi.getter(name="securityProfileIds")
    def security_profile_ids(self) -> Sequence[builtins.str]:
        """
        A list of identifiers for the security profiles for the user.
        """
        return pulumi.get(self, "security_profile_ids")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A map of tags to assign to the User.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> builtins.str:
        return pulumi.get(self, "user_id")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            arn=self.arn,
            directory_user_id=self.directory_user_id,
            hierarchy_group_id=self.hierarchy_group_id,
            id=self.id,
            identity_infos=self.identity_infos,
            instance_id=self.instance_id,
            name=self.name,
            phone_configs=self.phone_configs,
            region=self.region,
            routing_profile_id=self.routing_profile_id,
            security_profile_ids=self.security_profile_ids,
            tags=self.tags,
            user_id=self.user_id)


def get_user(instance_id: Optional[builtins.str] = None,
             name: Optional[builtins.str] = None,
             region: Optional[builtins.str] = None,
             tags: Optional[Mapping[str, builtins.str]] = None,
             user_id: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Provides details about a specific Amazon Connect User.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_user(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `user_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_user(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        user_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param builtins.str name: Returns information on a specific User by name
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: A map of tags to assign to the User.
    :param builtins.str user_id: Returns information on a specific User by User id
           
           > **NOTE:** `instance_id` and one of either `name` or `user_id` is required.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        arn=pulumi.get(__ret__, 'arn'),
        directory_user_id=pulumi.get(__ret__, 'directory_user_id'),
        hierarchy_group_id=pulumi.get(__ret__, 'hierarchy_group_id'),
        id=pulumi.get(__ret__, 'id'),
        identity_infos=pulumi.get(__ret__, 'identity_infos'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        phone_configs=pulumi.get(__ret__, 'phone_configs'),
        region=pulumi.get(__ret__, 'region'),
        routing_profile_id=pulumi.get(__ret__, 'routing_profile_id'),
        security_profile_ids=pulumi.get(__ret__, 'security_profile_ids'),
        tags=pulumi.get(__ret__, 'tags'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_user_output(instance_id: Optional[pulumi.Input[builtins.str]] = None,
                    name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                    user_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    Provides details about a specific Amazon Connect User.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_user(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `user_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_user(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        user_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param builtins.str name: Returns information on a specific User by name
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: A map of tags to assign to the User.
    :param builtins.str user_id: Returns information on a specific User by User id
           
           > **NOTE:** `instance_id` and one of either `name` or `user_id` is required.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:connect/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        arn=pulumi.get(__response__, 'arn'),
        directory_user_id=pulumi.get(__response__, 'directory_user_id'),
        hierarchy_group_id=pulumi.get(__response__, 'hierarchy_group_id'),
        id=pulumi.get(__response__, 'id'),
        identity_infos=pulumi.get(__response__, 'identity_infos'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        phone_configs=pulumi.get(__response__, 'phone_configs'),
        region=pulumi.get(__response__, 'region'),
        routing_profile_id=pulumi.get(__response__, 'routing_profile_id'),
        security_profile_ids=pulumi.get(__response__, 'security_profile_ids'),
        tags=pulumi.get(__response__, 'tags'),
        user_id=pulumi.get(__response__, 'user_id')))
