# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserHierarchyGroupResult',
    'AwaitableGetUserHierarchyGroupResult',
    'get_user_hierarchy_group',
    'get_user_hierarchy_group_output',
]

@pulumi.output_type
class GetUserHierarchyGroupResult:
    """
    A collection of values returned by getUserHierarchyGroup.
    """
    def __init__(__self__, arn=None, hierarchy_group_id=None, hierarchy_paths=None, id=None, instance_id=None, level_id=None, name=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if hierarchy_group_id and not isinstance(hierarchy_group_id, str):
            raise TypeError("Expected argument 'hierarchy_group_id' to be a str")
        pulumi.set(__self__, "hierarchy_group_id", hierarchy_group_id)
        if hierarchy_paths and not isinstance(hierarchy_paths, list):
            raise TypeError("Expected argument 'hierarchy_paths' to be a list")
        pulumi.set(__self__, "hierarchy_paths", hierarchy_paths)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if level_id and not isinstance(level_id, str):
            raise TypeError("Expected argument 'level_id' to be a str")
        pulumi.set(__self__, "level_id", level_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the hierarchy group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="hierarchyGroupId")
    def hierarchy_group_id(self) -> builtins.str:
        return pulumi.get(self, "hierarchy_group_id")

    @property
    @pulumi.getter(name="hierarchyPaths")
    def hierarchy_paths(self) -> Sequence['outputs.GetUserHierarchyGroupHierarchyPathResult']:
        """
        Block that contains information about the levels in the hierarchy group. The `hierarchy_path` block is documented below.
        """
        return pulumi.get(self, "hierarchy_paths")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="levelId")
    def level_id(self) -> builtins.str:
        """
        Identifier of the level in the hierarchy group.
        """
        return pulumi.get(self, "level_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the hierarchy group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of tags to assign to the hierarchy group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetUserHierarchyGroupResult(GetUserHierarchyGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserHierarchyGroupResult(
            arn=self.arn,
            hierarchy_group_id=self.hierarchy_group_id,
            hierarchy_paths=self.hierarchy_paths,
            id=self.id,
            instance_id=self.instance_id,
            level_id=self.level_id,
            name=self.name,
            region=self.region,
            tags=self.tags)


def get_user_hierarchy_group(hierarchy_group_id: Optional[builtins.str] = None,
                             instance_id: Optional[builtins.str] = None,
                             name: Optional[builtins.str] = None,
                             region: Optional[builtins.str] = None,
                             tags: Optional[Mapping[str, builtins.str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserHierarchyGroupResult:
    """
    Provides details about a specific Amazon Connect User Hierarchy Group.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_user_hierarchy_group(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `hierarchy_group_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_user_hierarchy_group(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        hierarchy_group_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param builtins.str hierarchy_group_id: Returns information on a specific hierarchy group by hierarchy group id
    :param builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param builtins.str name: Returns information on a specific hierarchy group by name
           
           > **NOTE:** `instance_id` and one of either `name` or `hierarchy_group_id` is required.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags to assign to the hierarchy group.
    """
    __args__ = dict()
    __args__['hierarchyGroupId'] = hierarchy_group_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getUserHierarchyGroup:getUserHierarchyGroup', __args__, opts=opts, typ=GetUserHierarchyGroupResult).value

    return AwaitableGetUserHierarchyGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        hierarchy_group_id=pulumi.get(__ret__, 'hierarchy_group_id'),
        hierarchy_paths=pulumi.get(__ret__, 'hierarchy_paths'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        level_id=pulumi.get(__ret__, 'level_id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_user_hierarchy_group_output(hierarchy_group_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                    name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserHierarchyGroupResult]:
    """
    Provides details about a specific Amazon Connect User Hierarchy Group.

    ## Example Usage

    By `name`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_user_hierarchy_group(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        name="Example")
    ```

    By `hierarchy_group_id`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_user_hierarchy_group(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        hierarchy_group_id="cccccccc-bbbb-cccc-dddd-111111111111")
    ```


    :param builtins.str hierarchy_group_id: Returns information on a specific hierarchy group by hierarchy group id
    :param builtins.str instance_id: Reference to the hosting Amazon Connect Instance
    :param builtins.str name: Returns information on a specific hierarchy group by name
           
           > **NOTE:** `instance_id` and one of either `name` or `hierarchy_group_id` is required.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags to assign to the hierarchy group.
    """
    __args__ = dict()
    __args__['hierarchyGroupId'] = hierarchy_group_id
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:connect/getUserHierarchyGroup:getUserHierarchyGroup', __args__, opts=opts, typ=GetUserHierarchyGroupResult)
    return __ret__.apply(lambda __response__: GetUserHierarchyGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        hierarchy_group_id=pulumi.get(__response__, 'hierarchy_group_id'),
        hierarchy_paths=pulumi.get(__response__, 'hierarchy_paths'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        level_id=pulumi.get(__response__, 'level_id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
