# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'EventActionActionArgs',
    'EventActionActionArgsDict',
    'EventActionActionExportRevisionToS3Args',
    'EventActionActionExportRevisionToS3ArgsDict',
    'EventActionActionExportRevisionToS3EncryptionArgs',
    'EventActionActionExportRevisionToS3EncryptionArgsDict',
    'EventActionActionExportRevisionToS3RevisionDestinationArgs',
    'EventActionActionExportRevisionToS3RevisionDestinationArgsDict',
    'EventActionEventArgs',
    'EventActionEventArgsDict',
    'EventActionEventRevisionPublishedArgs',
    'EventActionEventRevisionPublishedArgsDict',
    'RevisionAssetsAssetArgs',
    'RevisionAssetsAssetArgsDict',
    'RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgs',
    'RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgsDict',
    'RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgs',
    'RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgsDict',
    'RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceKmsKeysToGrantArgs',
    'RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceKmsKeysToGrantArgsDict',
    'RevisionAssetsAssetImportAssetsFromS3Args',
    'RevisionAssetsAssetImportAssetsFromS3ArgsDict',
    'RevisionAssetsAssetImportAssetsFromS3AssetSourceArgs',
    'RevisionAssetsAssetImportAssetsFromS3AssetSourceArgsDict',
    'RevisionAssetsAssetImportAssetsFromSignedUrlArgs',
    'RevisionAssetsAssetImportAssetsFromSignedUrlArgsDict',
    'RevisionAssetsTimeoutsArgs',
    'RevisionAssetsTimeoutsArgsDict',
]

MYPY = False

if not MYPY:
    class EventActionActionArgsDict(TypedDict):
        export_revision_to_s3: NotRequired[pulumi.Input['EventActionActionExportRevisionToS3ArgsDict']]
        """
        Configuration for an Export Revision to S3 action.
        Described in `export_revision_to_s3` Configuration Block
        """
elif False:
    EventActionActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventActionActionArgs:
    def __init__(__self__, *,
                 export_revision_to_s3: Optional[pulumi.Input['EventActionActionExportRevisionToS3Args']] = None):
        """
        :param pulumi.Input['EventActionActionExportRevisionToS3Args'] export_revision_to_s3: Configuration for an Export Revision to S3 action.
               Described in `export_revision_to_s3` Configuration Block
        """
        if export_revision_to_s3 is not None:
            pulumi.set(__self__, "export_revision_to_s3", export_revision_to_s3)

    @property
    @pulumi.getter(name="exportRevisionToS3")
    def export_revision_to_s3(self) -> Optional[pulumi.Input['EventActionActionExportRevisionToS3Args']]:
        """
        Configuration for an Export Revision to S3 action.
        Described in `export_revision_to_s3` Configuration Block
        """
        return pulumi.get(self, "export_revision_to_s3")

    @export_revision_to_s3.setter
    def export_revision_to_s3(self, value: Optional[pulumi.Input['EventActionActionExportRevisionToS3Args']]):
        pulumi.set(self, "export_revision_to_s3", value)


if not MYPY:
    class EventActionActionExportRevisionToS3ArgsDict(TypedDict):
        encryption: NotRequired[pulumi.Input['EventActionActionExportRevisionToS3EncryptionArgsDict']]
        """
        Configures server-side encryption of the exported revision.
        Described in `encryption` Configuration Block below.
        """
        revision_destination: NotRequired[pulumi.Input['EventActionActionExportRevisionToS3RevisionDestinationArgsDict']]
        """
        Configures the S3 destination of the exported revision.
        Described in `revision_destination` Configuration Block below.
        """
elif False:
    EventActionActionExportRevisionToS3ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventActionActionExportRevisionToS3Args:
    def __init__(__self__, *,
                 encryption: Optional[pulumi.Input['EventActionActionExportRevisionToS3EncryptionArgs']] = None,
                 revision_destination: Optional[pulumi.Input['EventActionActionExportRevisionToS3RevisionDestinationArgs']] = None):
        """
        :param pulumi.Input['EventActionActionExportRevisionToS3EncryptionArgs'] encryption: Configures server-side encryption of the exported revision.
               Described in `encryption` Configuration Block below.
        :param pulumi.Input['EventActionActionExportRevisionToS3RevisionDestinationArgs'] revision_destination: Configures the S3 destination of the exported revision.
               Described in `revision_destination` Configuration Block below.
        """
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if revision_destination is not None:
            pulumi.set(__self__, "revision_destination", revision_destination)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['EventActionActionExportRevisionToS3EncryptionArgs']]:
        """
        Configures server-side encryption of the exported revision.
        Described in `encryption` Configuration Block below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['EventActionActionExportRevisionToS3EncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="revisionDestination")
    def revision_destination(self) -> Optional[pulumi.Input['EventActionActionExportRevisionToS3RevisionDestinationArgs']]:
        """
        Configures the S3 destination of the exported revision.
        Described in `revision_destination` Configuration Block below.
        """
        return pulumi.get(self, "revision_destination")

    @revision_destination.setter
    def revision_destination(self, value: Optional[pulumi.Input['EventActionActionExportRevisionToS3RevisionDestinationArgs']]):
        pulumi.set(self, "revision_destination", value)


if not MYPY:
    class EventActionActionExportRevisionToS3EncryptionArgsDict(TypedDict):
        kms_key_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN of the KMS key used for encryption.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of server-side encryption.
        Valid values are `aws:kms` or `aws:s3`.
        """
elif False:
    EventActionActionExportRevisionToS3EncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventActionActionExportRevisionToS3EncryptionArgs:
    def __init__(__self__, *,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the KMS key used for encryption.
        :param pulumi.Input[builtins.str] type: Type of server-side encryption.
               Valid values are `aws:kms` or `aws:s3`.
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the KMS key used for encryption.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of server-side encryption.
        Valid values are `aws:kms` or `aws:s3`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class EventActionActionExportRevisionToS3RevisionDestinationArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        The S3 bucket where the revision will be exported.
        """
        key_pattern: NotRequired[pulumi.Input[builtins.str]]
        """
        Pattern for naming revisions in the S3 bucket.
        Defaults to `${Revision.CreatedAt}/${Asset.Name}`.
        """
elif False:
    EventActionActionExportRevisionToS3RevisionDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventActionActionExportRevisionToS3RevisionDestinationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 key_pattern: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: The S3 bucket where the revision will be exported.
        :param pulumi.Input[builtins.str] key_pattern: Pattern for naming revisions in the S3 bucket.
               Defaults to `${Revision.CreatedAt}/${Asset.Name}`.
        """
        pulumi.set(__self__, "bucket", bucket)
        if key_pattern is not None:
            pulumi.set(__self__, "key_pattern", key_pattern)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The S3 bucket where the revision will be exported.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="keyPattern")
    def key_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Pattern for naming revisions in the S3 bucket.
        Defaults to `${Revision.CreatedAt}/${Asset.Name}`.
        """
        return pulumi.get(self, "key_pattern")

    @key_pattern.setter
    def key_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_pattern", value)


if not MYPY:
    class EventActionEventArgsDict(TypedDict):
        revision_published: NotRequired[pulumi.Input['EventActionEventRevisionPublishedArgsDict']]
        """
        Configuration for a Revision Published event.
        Described in `revision_published` Configuration Block below.
        """
elif False:
    EventActionEventArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventActionEventArgs:
    def __init__(__self__, *,
                 revision_published: Optional[pulumi.Input['EventActionEventRevisionPublishedArgs']] = None):
        """
        :param pulumi.Input['EventActionEventRevisionPublishedArgs'] revision_published: Configuration for a Revision Published event.
               Described in `revision_published` Configuration Block below.
        """
        if revision_published is not None:
            pulumi.set(__self__, "revision_published", revision_published)

    @property
    @pulumi.getter(name="revisionPublished")
    def revision_published(self) -> Optional[pulumi.Input['EventActionEventRevisionPublishedArgs']]:
        """
        Configuration for a Revision Published event.
        Described in `revision_published` Configuration Block below.
        """
        return pulumi.get(self, "revision_published")

    @revision_published.setter
    def revision_published(self, value: Optional[pulumi.Input['EventActionEventRevisionPublishedArgs']]):
        pulumi.set(self, "revision_published", value)


if not MYPY:
    class EventActionEventRevisionPublishedArgsDict(TypedDict):
        data_set_id: pulumi.Input[builtins.str]
        """
        The ID of the data set to monitor for revision publications.
        Changing this value will recreate the resource.
        """
elif False:
    EventActionEventRevisionPublishedArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventActionEventRevisionPublishedArgs:
    def __init__(__self__, *,
                 data_set_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] data_set_id: The ID of the data set to monitor for revision publications.
               Changing this value will recreate the resource.
        """
        pulumi.set(__self__, "data_set_id", data_set_id)

    @property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the data set to monitor for revision publications.
        Changing this value will recreate the resource.
        """
        return pulumi.get(self, "data_set_id")

    @data_set_id.setter
    def data_set_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_set_id", value)


if not MYPY:
    class RevisionAssetsAssetArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the Data Exchange Revision Assets.
        """
        create_s3_data_access_from_s3_bucket: NotRequired[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgsDict']]
        """
        A block to create S3 data access from an S3 bucket. See Create S3 Data Access from S3 Bucket for more details.
        """
        created_at: NotRequired[pulumi.Input[builtins.str]]
        """
        The timestamp when the revision was created, in RFC3339 format.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier for the revision.
        """
        import_assets_from_s3: NotRequired[pulumi.Input['RevisionAssetsAssetImportAssetsFromS3ArgsDict']]
        """
        A block to import assets from S3. See Import Assets from S3 for more details.
        """
        import_assets_from_signed_url: NotRequired[pulumi.Input['RevisionAssetsAssetImportAssetsFromSignedUrlArgsDict']]
        """
        A block to import assets from a signed URL. See Import Assets from Signed URL for more details.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        updated_at: NotRequired[pulumi.Input[builtins.str]]
        """
        The timestamp when the revision was last updated, in RFC3339 format.
        """
elif False:
    RevisionAssetsAssetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RevisionAssetsAssetArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 create_s3_data_access_from_s3_bucket: Optional[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgs']] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 import_assets_from_s3: Optional[pulumi.Input['RevisionAssetsAssetImportAssetsFromS3Args']] = None,
                 import_assets_from_signed_url: Optional[pulumi.Input['RevisionAssetsAssetImportAssetsFromSignedUrlArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] arn: The ARN of the Data Exchange Revision Assets.
        :param pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgs'] create_s3_data_access_from_s3_bucket: A block to create S3 data access from an S3 bucket. See Create S3 Data Access from S3 Bucket for more details.
        :param pulumi.Input[builtins.str] created_at: The timestamp when the revision was created, in RFC3339 format.
        :param pulumi.Input[builtins.str] id: The unique identifier for the revision.
        :param pulumi.Input['RevisionAssetsAssetImportAssetsFromS3Args'] import_assets_from_s3: A block to import assets from S3. See Import Assets from S3 for more details.
        :param pulumi.Input['RevisionAssetsAssetImportAssetsFromSignedUrlArgs'] import_assets_from_signed_url: A block to import assets from a signed URL. See Import Assets from Signed URL for more details.
        :param pulumi.Input[builtins.str] updated_at: The timestamp when the revision was last updated, in RFC3339 format.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if create_s3_data_access_from_s3_bucket is not None:
            pulumi.set(__self__, "create_s3_data_access_from_s3_bucket", create_s3_data_access_from_s3_bucket)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if import_assets_from_s3 is not None:
            pulumi.set(__self__, "import_assets_from_s3", import_assets_from_s3)
        if import_assets_from_signed_url is not None:
            pulumi.set(__self__, "import_assets_from_signed_url", import_assets_from_signed_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the Data Exchange Revision Assets.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createS3DataAccessFromS3Bucket")
    def create_s3_data_access_from_s3_bucket(self) -> Optional[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgs']]:
        """
        A block to create S3 data access from an S3 bucket. See Create S3 Data Access from S3 Bucket for more details.
        """
        return pulumi.get(self, "create_s3_data_access_from_s3_bucket")

    @create_s3_data_access_from_s3_bucket.setter
    def create_s3_data_access_from_s3_bucket(self, value: Optional[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgs']]):
        pulumi.set(self, "create_s3_data_access_from_s3_bucket", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the revision was created, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the revision.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="importAssetsFromS3")
    def import_assets_from_s3(self) -> Optional[pulumi.Input['RevisionAssetsAssetImportAssetsFromS3Args']]:
        """
        A block to import assets from S3. See Import Assets from S3 for more details.
        """
        return pulumi.get(self, "import_assets_from_s3")

    @import_assets_from_s3.setter
    def import_assets_from_s3(self, value: Optional[pulumi.Input['RevisionAssetsAssetImportAssetsFromS3Args']]):
        pulumi.set(self, "import_assets_from_s3", value)

    @property
    @pulumi.getter(name="importAssetsFromSignedUrl")
    def import_assets_from_signed_url(self) -> Optional[pulumi.Input['RevisionAssetsAssetImportAssetsFromSignedUrlArgs']]:
        """
        A block to import assets from a signed URL. See Import Assets from Signed URL for more details.
        """
        return pulumi.get(self, "import_assets_from_signed_url")

    @import_assets_from_signed_url.setter
    def import_assets_from_signed_url(self, value: Optional[pulumi.Input['RevisionAssetsAssetImportAssetsFromSignedUrlArgs']]):
        pulumi.set(self, "import_assets_from_signed_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the revision was last updated, in RFC3339 format.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


if not MYPY:
    class RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgsDict(TypedDict):
        access_point_alias: NotRequired[pulumi.Input[builtins.str]]
        access_point_arn: NotRequired[pulumi.Input[builtins.str]]
        asset_source: NotRequired[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgsDict']]
        """
        A block specifying the source bucket for the asset. This block supports the following:
        """
elif False:
    RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RevisionAssetsAssetCreateS3DataAccessFromS3BucketArgs:
    def __init__(__self__, *,
                 access_point_alias: Optional[pulumi.Input[builtins.str]] = None,
                 access_point_arn: Optional[pulumi.Input[builtins.str]] = None,
                 asset_source: Optional[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgs']] = None):
        """
        :param pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgs'] asset_source: A block specifying the source bucket for the asset. This block supports the following:
        """
        if access_point_alias is not None:
            pulumi.set(__self__, "access_point_alias", access_point_alias)
        if access_point_arn is not None:
            pulumi.set(__self__, "access_point_arn", access_point_arn)
        if asset_source is not None:
            pulumi.set(__self__, "asset_source", asset_source)

    @property
    @pulumi.getter(name="accessPointAlias")
    def access_point_alias(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "access_point_alias")

    @access_point_alias.setter
    def access_point_alias(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_point_alias", value)

    @property
    @pulumi.getter(name="accessPointArn")
    def access_point_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "access_point_arn")

    @access_point_arn.setter
    def access_point_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_point_arn", value)

    @property
    @pulumi.getter(name="assetSource")
    def asset_source(self) -> Optional[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgs']]:
        """
        A block specifying the source bucket for the asset. This block supports the following:
        """
        return pulumi.get(self, "asset_source")

    @asset_source.setter
    def asset_source(self, value: Optional[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgs']]):
        pulumi.set(self, "asset_source", value)


if not MYPY:
    class RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        The name of the S3 bucket.
        """
        key_prefixes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of key prefixes in the S3 bucket.
        """
        keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of object keys in the S3 bucket.
        """
        kms_keys_to_grants: NotRequired[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceKmsKeysToGrantArgsDict']]]]
elif False:
    RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 key_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kms_keys_to_grants: Optional[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceKmsKeysToGrantArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: The name of the S3 bucket.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] key_prefixes: List of key prefixes in the S3 bucket.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] keys: List of object keys in the S3 bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        if key_prefixes is not None:
            pulumi.set(__self__, "key_prefixes", key_prefixes)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if kms_keys_to_grants is not None:
            pulumi.set(__self__, "kms_keys_to_grants", kms_keys_to_grants)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="keyPrefixes")
    def key_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of key prefixes in the S3 bucket.
        """
        return pulumi.get(self, "key_prefixes")

    @key_prefixes.setter
    def key_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "key_prefixes", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of object keys in the S3 bucket.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="kmsKeysToGrants")
    def kms_keys_to_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceKmsKeysToGrantArgs']]]]:
        return pulumi.get(self, "kms_keys_to_grants")

    @kms_keys_to_grants.setter
    def kms_keys_to_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceKmsKeysToGrantArgs']]]]):
        pulumi.set(self, "kms_keys_to_grants", value)


if not MYPY:
    class RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceKmsKeysToGrantArgsDict(TypedDict):
        kms_key_arn: pulumi.Input[builtins.str]
        """
        The ARN of the KMS key.
        """
elif False:
    RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceKmsKeysToGrantArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RevisionAssetsAssetCreateS3DataAccessFromS3BucketAssetSourceKmsKeysToGrantArgs:
    def __init__(__self__, *,
                 kms_key_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] kms_key_arn: The ARN of the KMS key.
        """
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the KMS key.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kms_key_arn", value)


if not MYPY:
    class RevisionAssetsAssetImportAssetsFromS3ArgsDict(TypedDict):
        asset_source: NotRequired[pulumi.Input['RevisionAssetsAssetImportAssetsFromS3AssetSourceArgsDict']]
        """
        A block specifying the source bucket and key for the asset. This block supports the following:
        """
elif False:
    RevisionAssetsAssetImportAssetsFromS3ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RevisionAssetsAssetImportAssetsFromS3Args:
    def __init__(__self__, *,
                 asset_source: Optional[pulumi.Input['RevisionAssetsAssetImportAssetsFromS3AssetSourceArgs']] = None):
        """
        :param pulumi.Input['RevisionAssetsAssetImportAssetsFromS3AssetSourceArgs'] asset_source: A block specifying the source bucket and key for the asset. This block supports the following:
        """
        if asset_source is not None:
            pulumi.set(__self__, "asset_source", asset_source)

    @property
    @pulumi.getter(name="assetSource")
    def asset_source(self) -> Optional[pulumi.Input['RevisionAssetsAssetImportAssetsFromS3AssetSourceArgs']]:
        """
        A block specifying the source bucket and key for the asset. This block supports the following:
        """
        return pulumi.get(self, "asset_source")

    @asset_source.setter
    def asset_source(self, value: Optional[pulumi.Input['RevisionAssetsAssetImportAssetsFromS3AssetSourceArgs']]):
        pulumi.set(self, "asset_source", value)


if not MYPY:
    class RevisionAssetsAssetImportAssetsFromS3AssetSourceArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        The name of the S3 bucket.
        """
        key: pulumi.Input[builtins.str]
        """
        The key of the object in the S3 bucket.
        """
elif False:
    RevisionAssetsAssetImportAssetsFromS3AssetSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RevisionAssetsAssetImportAssetsFromS3AssetSourceArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] bucket: The name of the S3 bucket.
        :param pulumi.Input[builtins.str] key: The key of the object in the S3 bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The key of the object in the S3 bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)


if not MYPY:
    class RevisionAssetsAssetImportAssetsFromSignedUrlArgsDict(TypedDict):
        filename: pulumi.Input[builtins.str]
        """
        The name of the file to import.
        """
elif False:
    RevisionAssetsAssetImportAssetsFromSignedUrlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RevisionAssetsAssetImportAssetsFromSignedUrlArgs:
    def __init__(__self__, *,
                 filename: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] filename: The name of the file to import.
        """
        pulumi.set(__self__, "filename", filename)

    @property
    @pulumi.getter
    def filename(self) -> pulumi.Input[builtins.str]:
        """
        The name of the file to import.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filename", value)


if not MYPY:
    class RevisionAssetsTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    RevisionAssetsTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RevisionAssetsTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)


