# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventActionArgs', 'EventAction']

@pulumi.input_type
class EventActionArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['EventActionActionArgs']] = None,
                 event: Optional[pulumi.Input['EventActionEventArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EventAction resource.
        :param pulumi.Input['EventActionActionArgs'] action: Describes the action to take.
               Described in `action` Configuration Block below.
        :param pulumi.Input['EventActionEventArgs'] event: Describes the event that triggers the `action`.
               Described in `event` Configuration Block below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if event is not None:
            pulumi.set(__self__, "event", event)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['EventActionActionArgs']]:
        """
        Describes the action to take.
        Described in `action` Configuration Block below.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['EventActionActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def event(self) -> Optional[pulumi.Input['EventActionEventArgs']]:
        """
        Describes the event that triggers the `action`.
        Described in `event` Configuration Block below.
        """
        return pulumi.get(self, "event")

    @event.setter
    def event(self, value: Optional[pulumi.Input['EventActionEventArgs']]):
        pulumi.set(self, "event", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EventActionState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['EventActionActionArgs']] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 event: Optional[pulumi.Input['EventActionEventArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EventAction resources.
        :param pulumi.Input['EventActionActionArgs'] action: Describes the action to take.
               Described in `action` Configuration Block below.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the event action.
        :param pulumi.Input[builtins.str] created_at: Date and time when the resource was created.
        :param pulumi.Input['EventActionEventArgs'] event: Describes the event that triggers the `action`.
               Described in `event` Configuration Block below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] updated_at: Data and time when the resource was last updated.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if event is not None:
            pulumi.set(__self__, "event", event)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['EventActionActionArgs']]:
        """
        Describes the action to take.
        Described in `action` Configuration Block below.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['EventActionActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the event action.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time when the resource was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def event(self) -> Optional[pulumi.Input['EventActionEventArgs']]:
        """
        Describes the event that triggers the `action`.
        Described in `event` Configuration Block below.
        """
        return pulumi.get(self, "event")

    @event.setter
    def event(self, value: Optional[pulumi.Input['EventActionEventArgs']]):
        pulumi.set(self, "event", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Data and time when the resource was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("aws:dataexchange/eventAction:EventAction")
class EventAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['EventActionActionArgs', 'EventActionActionArgsDict']]] = None,
                 event: Optional[pulumi.Input[Union['EventActionEventArgs', 'EventActionEventArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Data Exchange Event Action.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dataexchange.EventAction("example",
            event={
                "revision_published": {
                    "data_set_id": example_aws_dataexchange_data_set["id"],
                },
            },
            action={
                "export_revision_to_s3": {
                    "revision_destination": {
                        "bucket": example_aws_s3_bucket["bucket"],
                        "key_pattern": "${Revision.CreatedAt}/${Asset.Name}",
                    },
                    "encryption": {
                        "type": "aws:kms",
                        "kms_key_arn": example_aws_kms_key["arn"],
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Data Exchange Event Action using the id. For example:

        ```sh
        $ pulumi import aws:dataexchange/eventAction:EventAction example example-event-action-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EventActionActionArgs', 'EventActionActionArgsDict']] action: Describes the action to take.
               Described in `action` Configuration Block below.
        :param pulumi.Input[Union['EventActionEventArgs', 'EventActionEventArgsDict']] event: Describes the event that triggers the `action`.
               Described in `event` Configuration Block below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EventActionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Data Exchange Event Action.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dataexchange.EventAction("example",
            event={
                "revision_published": {
                    "data_set_id": example_aws_dataexchange_data_set["id"],
                },
            },
            action={
                "export_revision_to_s3": {
                    "revision_destination": {
                        "bucket": example_aws_s3_bucket["bucket"],
                        "key_pattern": "${Revision.CreatedAt}/${Asset.Name}",
                    },
                    "encryption": {
                        "type": "aws:kms",
                        "kms_key_arn": example_aws_kms_key["arn"],
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Data Exchange Event Action using the id. For example:

        ```sh
        $ pulumi import aws:dataexchange/eventAction:EventAction example example-event-action-id
        ```

        :param str resource_name: The name of the resource.
        :param EventActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['EventActionActionArgs', 'EventActionActionArgsDict']]] = None,
                 event: Optional[pulumi.Input[Union['EventActionEventArgs', 'EventActionEventArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventActionArgs.__new__(EventActionArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["event"] = event
            __props__.__dict__["region"] = region
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(EventAction, __self__).__init__(
            'aws:dataexchange/eventAction:EventAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['EventActionActionArgs', 'EventActionActionArgsDict']]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            event: Optional[pulumi.Input[Union['EventActionEventArgs', 'EventActionEventArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'EventAction':
        """
        Get an existing EventAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EventActionActionArgs', 'EventActionActionArgsDict']] action: Describes the action to take.
               Described in `action` Configuration Block below.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the event action.
        :param pulumi.Input[builtins.str] created_at: Date and time when the resource was created.
        :param pulumi.Input[Union['EventActionEventArgs', 'EventActionEventArgsDict']] event: Describes the event that triggers the `action`.
               Described in `event` Configuration Block below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] updated_at: Data and time when the resource was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventActionState.__new__(_EventActionState)

        __props__.__dict__["action"] = action
        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["event"] = event
        __props__.__dict__["region"] = region
        __props__.__dict__["updated_at"] = updated_at
        return EventAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional['outputs.EventActionAction']]:
        """
        Describes the action to take.
        Described in `action` Configuration Block below.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the event action.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Date and time when the resource was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def event(self) -> pulumi.Output[Optional['outputs.EventActionEvent']]:
        """
        Describes the event that triggers the `action`.
        Described in `event` Configuration Block below.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Data and time when the resource was last updated.
        """
        return pulumi.get(self, "updated_at")

