# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RevisionAssetsArgs', 'RevisionAssets']

@pulumi.input_type
class RevisionAssetsArgs:
    def __init__(__self__, *,
                 data_set_id: pulumi.Input[builtins.str],
                 assets: Optional[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetArgs']]]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 finalized: Optional[pulumi.Input[builtins.bool]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['RevisionAssetsTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a RevisionAssets resource.
        :param pulumi.Input[builtins.str] data_set_id: Unique identifier for the data set associated with the revision.
        :param pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetArgs']]] assets: A block to define the asset associated with the revision. See Asset for more details.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] comment: A comment for the revision. Maximum length is 16,348 characters.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "data_set_id", data_set_id)
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if finalized is not None:
            pulumi.set(__self__, "finalized", finalized)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier for the data set associated with the revision.
        """
        return pulumi.get(self, "data_set_id")

    @data_set_id.setter
    def data_set_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_set_id", value)

    @property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetArgs']]]]:
        """
        A block to define the asset associated with the revision. See Asset for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetArgs']]]]):
        pulumi.set(self, "assets", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comment for the revision. Maximum length is 16,348 characters.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def finalized(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "finalized")

    @finalized.setter
    def finalized(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "finalized", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RevisionAssetsTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RevisionAssetsTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _RevisionAssetsState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 assets: Optional[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetArgs']]]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 data_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 finalized: Optional[pulumi.Input[builtins.bool]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['RevisionAssetsTimeoutsArgs']] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RevisionAssets resources.
        :param pulumi.Input[builtins.str] arn: The ARN of the Data Exchange Revision Assets.
        :param pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetArgs']]] assets: A block to define the asset associated with the revision. See Asset for more details.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] comment: A comment for the revision. Maximum length is 16,348 characters.
        :param pulumi.Input[builtins.str] created_at: The timestamp when the revision was created, in RFC3339 format.
        :param pulumi.Input[builtins.str] data_set_id: Unique identifier for the data set associated with the revision.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] updated_at: The timestamp when the revision was last updated, in RFC3339 format.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data_set_id is not None:
            pulumi.set(__self__, "data_set_id", data_set_id)
        if finalized is not None:
            pulumi.set(__self__, "finalized", finalized)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the Data Exchange Revision Assets.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetArgs']]]]:
        """
        A block to define the asset associated with the revision. See Asset for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RevisionAssetsAssetArgs']]]]):
        pulumi.set(self, "assets", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comment for the revision. Maximum length is 16,348 characters.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the revision was created, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier for the data set associated with the revision.
        """
        return pulumi.get(self, "data_set_id")

    @data_set_id.setter
    def data_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_set_id", value)

    @property
    @pulumi.getter
    def finalized(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "finalized")

    @finalized.setter
    def finalized(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "finalized", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RevisionAssetsTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RevisionAssetsTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the revision was last updated, in RFC3339 format.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("aws:dataexchange/revisionAssets:RevisionAssets")
class RevisionAssets(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RevisionAssetsAssetArgs', 'RevisionAssetsAssetArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 data_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 finalized: Optional[pulumi.Input[builtins.bool]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RevisionAssetsTimeoutsArgs', 'RevisionAssetsTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing AWS Data Exchange Revision Assets.

        > Note: This resource creates a new revision and adds associated assets. Destroying this resource will delete the revision and all associated assets.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dataexchange.RevisionAssets("example",
            data_set_id="example-data-set-id",
            assets=[{
                "create_s3_data_access_from_s3_bucket": {
                    "asset_source": {
                        "bucket": "example-bucket",
                    },
                },
            }],
            tags={
                "Environment": "Production",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RevisionAssetsAssetArgs', 'RevisionAssetsAssetArgsDict']]]] assets: A block to define the asset associated with the revision. See Asset for more details.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] comment: A comment for the revision. Maximum length is 16,348 characters.
        :param pulumi.Input[builtins.str] data_set_id: Unique identifier for the data set associated with the revision.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RevisionAssetsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing AWS Data Exchange Revision Assets.

        > Note: This resource creates a new revision and adds associated assets. Destroying this resource will delete the revision and all associated assets.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dataexchange.RevisionAssets("example",
            data_set_id="example-data-set-id",
            assets=[{
                "create_s3_data_access_from_s3_bucket": {
                    "asset_source": {
                        "bucket": "example-bucket",
                    },
                },
            }],
            tags={
                "Environment": "Production",
            })
        ```

        :param str resource_name: The name of the resource.
        :param RevisionAssetsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RevisionAssetsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RevisionAssetsAssetArgs', 'RevisionAssetsAssetArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 data_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 finalized: Optional[pulumi.Input[builtins.bool]] = None,
                 force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RevisionAssetsTimeoutsArgs', 'RevisionAssetsTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RevisionAssetsArgs.__new__(RevisionAssetsArgs)

            __props__.__dict__["assets"] = assets
            __props__.__dict__["comment"] = comment
            if data_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_set_id'")
            __props__.__dict__["data_set_id"] = data_set_id
            __props__.__dict__["finalized"] = finalized
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["updated_at"] = None
        super(RevisionAssets, __self__).__init__(
            'aws:dataexchange/revisionAssets:RevisionAssets',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RevisionAssetsAssetArgs', 'RevisionAssetsAssetArgsDict']]]]] = None,
            comment: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            data_set_id: Optional[pulumi.Input[builtins.str]] = None,
            finalized: Optional[pulumi.Input[builtins.bool]] = None,
            force_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['RevisionAssetsTimeoutsArgs', 'RevisionAssetsTimeoutsArgsDict']]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'RevisionAssets':
        """
        Get an existing RevisionAssets resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The ARN of the Data Exchange Revision Assets.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RevisionAssetsAssetArgs', 'RevisionAssetsAssetArgsDict']]]] assets: A block to define the asset associated with the revision. See Asset for more details.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] comment: A comment for the revision. Maximum length is 16,348 characters.
        :param pulumi.Input[builtins.str] created_at: The timestamp when the revision was created, in RFC3339 format.
        :param pulumi.Input[builtins.str] data_set_id: Unique identifier for the data set associated with the revision.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] updated_at: The timestamp when the revision was last updated, in RFC3339 format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RevisionAssetsState.__new__(_RevisionAssetsState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["assets"] = assets
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["data_set_id"] = data_set_id
        __props__.__dict__["finalized"] = finalized
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["updated_at"] = updated_at
        return RevisionAssets(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the Data Exchange Revision Assets.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def assets(self) -> pulumi.Output[Optional[Sequence['outputs.RevisionAssetsAsset']]]:
        """
        A block to define the asset associated with the revision. See Asset for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "assets")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A comment for the revision. Maximum length is 16,348 characters.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the revision was created, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier for the data set associated with the revision.
        """
        return pulumi.get(self, "data_set_id")

    @property
    @pulumi.getter
    def finalized(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "finalized")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.RevisionAssetsTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the revision was last updated, in RFC3339 format.
        """
        return pulumi.get(self, "updated_at")

