# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'EfsLocationEc2ConfigArgs',
    'EfsLocationEc2ConfigArgsDict',
    'FsxOpenZfsFileSystemProtocolArgs',
    'FsxOpenZfsFileSystemProtocolArgsDict',
    'FsxOpenZfsFileSystemProtocolNfsArgs',
    'FsxOpenZfsFileSystemProtocolNfsArgsDict',
    'FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs',
    'FsxOpenZfsFileSystemProtocolNfsMountOptionsArgsDict',
    'LocationAzureBlobSasConfigurationArgs',
    'LocationAzureBlobSasConfigurationArgsDict',
    'LocationFsxOntapFileSystemProtocolArgs',
    'LocationFsxOntapFileSystemProtocolArgsDict',
    'LocationFsxOntapFileSystemProtocolNfsArgs',
    'LocationFsxOntapFileSystemProtocolNfsArgsDict',
    'LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs',
    'LocationFsxOntapFileSystemProtocolNfsMountOptionsArgsDict',
    'LocationFsxOntapFileSystemProtocolSmbArgs',
    'LocationFsxOntapFileSystemProtocolSmbArgsDict',
    'LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs',
    'LocationFsxOntapFileSystemProtocolSmbMountOptionsArgsDict',
    'LocationHdfsNameNodeArgs',
    'LocationHdfsNameNodeArgsDict',
    'LocationHdfsQopConfigurationArgs',
    'LocationHdfsQopConfigurationArgsDict',
    'LocationSmbMountOptionsArgs',
    'LocationSmbMountOptionsArgsDict',
    'NfsLocationMountOptionsArgs',
    'NfsLocationMountOptionsArgsDict',
    'NfsLocationOnPremConfigArgs',
    'NfsLocationOnPremConfigArgsDict',
    'S3LocationS3ConfigArgs',
    'S3LocationS3ConfigArgsDict',
    'TaskExcludesArgs',
    'TaskExcludesArgsDict',
    'TaskIncludesArgs',
    'TaskIncludesArgsDict',
    'TaskOptionsArgs',
    'TaskOptionsArgsDict',
    'TaskScheduleArgs',
    'TaskScheduleArgsDict',
    'TaskTaskReportConfigArgs',
    'TaskTaskReportConfigArgsDict',
    'TaskTaskReportConfigReportOverridesArgs',
    'TaskTaskReportConfigReportOverridesArgsDict',
    'TaskTaskReportConfigS3DestinationArgs',
    'TaskTaskReportConfigS3DestinationArgsDict',
]

MYPY = False

if not MYPY:
    class EfsLocationEc2ConfigArgsDict(TypedDict):
        security_group_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
        """
        subnet_arn: pulumi.Input[builtins.str]
        """
        Amazon Resource Name (ARN) of the EC2 Subnet that is associated with the EFS Mount Target.
        """
elif False:
    EfsLocationEc2ConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EfsLocationEc2ConfigArgs:
    def __init__(__self__, *,
                 security_group_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 subnet_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_arns: List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
        :param pulumi.Input[builtins.str] subnet_arn: Amazon Resource Name (ARN) of the EC2 Subnet that is associated with the EFS Mount Target.
        """
        pulumi.set(__self__, "security_group_arns", security_group_arns)
        pulumi.set(__self__, "subnet_arn", subnet_arn)

    @property
    @pulumi.getter(name="securityGroupArns")
    def security_group_arns(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
        """
        return pulumi.get(self, "security_group_arns")

    @security_group_arns.setter
    def security_group_arns(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "security_group_arns", value)

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> pulumi.Input[builtins.str]:
        """
        Amazon Resource Name (ARN) of the EC2 Subnet that is associated with the EFS Mount Target.
        """
        return pulumi.get(self, "subnet_arn")

    @subnet_arn.setter
    def subnet_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_arn", value)


if not MYPY:
    class FsxOpenZfsFileSystemProtocolArgsDict(TypedDict):
        nfs: pulumi.Input['FsxOpenZfsFileSystemProtocolNfsArgsDict']
        """
        Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system. See below.
        """
elif False:
    FsxOpenZfsFileSystemProtocolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FsxOpenZfsFileSystemProtocolArgs:
    def __init__(__self__, *,
                 nfs: pulumi.Input['FsxOpenZfsFileSystemProtocolNfsArgs']):
        """
        :param pulumi.Input['FsxOpenZfsFileSystemProtocolNfsArgs'] nfs: Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system. See below.
        """
        pulumi.set(__self__, "nfs", nfs)

    @property
    @pulumi.getter
    def nfs(self) -> pulumi.Input['FsxOpenZfsFileSystemProtocolNfsArgs']:
        """
        Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system. See below.
        """
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: pulumi.Input['FsxOpenZfsFileSystemProtocolNfsArgs']):
        pulumi.set(self, "nfs", value)


if not MYPY:
    class FsxOpenZfsFileSystemProtocolNfsArgsDict(TypedDict):
        mount_options: pulumi.Input['FsxOpenZfsFileSystemProtocolNfsMountOptionsArgsDict']
        """
        Represents the mount options that are available for DataSync to access an NFS location. See below.
        """
elif False:
    FsxOpenZfsFileSystemProtocolNfsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FsxOpenZfsFileSystemProtocolNfsArgs:
    def __init__(__self__, *,
                 mount_options: pulumi.Input['FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs']):
        """
        :param pulumi.Input['FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs'] mount_options: Represents the mount options that are available for DataSync to access an NFS location. See below.
        """
        pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Input['FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs']:
        """
        Represents the mount options that are available for DataSync to access an NFS location. See below.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: pulumi.Input['FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs']):
        pulumi.set(self, "mount_options", value)


if not MYPY:
    class FsxOpenZfsFileSystemProtocolNfsMountOptionsArgsDict(TypedDict):
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
elif False:
    FsxOpenZfsFileSystemProtocolNfsMountOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] version: The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class LocationAzureBlobSasConfigurationArgsDict(TypedDict):
        token: pulumi.Input[builtins.str]
        """
        A SAS token that provides permissions to access your Azure Blob Storage.
        """
elif False:
    LocationAzureBlobSasConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LocationAzureBlobSasConfigurationArgs:
    def __init__(__self__, *,
                 token: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] token: A SAS token that provides permissions to access your Azure Blob Storage.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[builtins.str]:
        """
        A SAS token that provides permissions to access your Azure Blob Storage.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token", value)


if not MYPY:
    class LocationFsxOntapFileSystemProtocolArgsDict(TypedDict):
        nfs: NotRequired[pulumi.Input['LocationFsxOntapFileSystemProtocolNfsArgsDict']]
        """
        Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
        """
        smb: NotRequired[pulumi.Input['LocationFsxOntapFileSystemProtocolSmbArgsDict']]
        """
        Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
        """
elif False:
    LocationFsxOntapFileSystemProtocolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LocationFsxOntapFileSystemProtocolArgs:
    def __init__(__self__, *,
                 nfs: Optional[pulumi.Input['LocationFsxOntapFileSystemProtocolNfsArgs']] = None,
                 smb: Optional[pulumi.Input['LocationFsxOntapFileSystemProtocolSmbArgs']] = None):
        """
        :param pulumi.Input['LocationFsxOntapFileSystemProtocolNfsArgs'] nfs: Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
        :param pulumi.Input['LocationFsxOntapFileSystemProtocolSmbArgs'] smb: Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
        """
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if smb is not None:
            pulumi.set(__self__, "smb", smb)

    @property
    @pulumi.getter
    def nfs(self) -> Optional[pulumi.Input['LocationFsxOntapFileSystemProtocolNfsArgs']]:
        """
        Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
        """
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: Optional[pulumi.Input['LocationFsxOntapFileSystemProtocolNfsArgs']]):
        pulumi.set(self, "nfs", value)

    @property
    @pulumi.getter
    def smb(self) -> Optional[pulumi.Input['LocationFsxOntapFileSystemProtocolSmbArgs']]:
        """
        Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
        """
        return pulumi.get(self, "smb")

    @smb.setter
    def smb(self, value: Optional[pulumi.Input['LocationFsxOntapFileSystemProtocolSmbArgs']]):
        pulumi.set(self, "smb", value)


if not MYPY:
    class LocationFsxOntapFileSystemProtocolNfsArgsDict(TypedDict):
        mount_options: pulumi.Input['LocationFsxOntapFileSystemProtocolNfsMountOptionsArgsDict']
        """
        Mount options that are available for DataSync to access an NFS location. See NFS Mount Options below.
        """
elif False:
    LocationFsxOntapFileSystemProtocolNfsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LocationFsxOntapFileSystemProtocolNfsArgs:
    def __init__(__self__, *,
                 mount_options: pulumi.Input['LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs']):
        """
        :param pulumi.Input['LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs'] mount_options: Mount options that are available for DataSync to access an NFS location. See NFS Mount Options below.
        """
        pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Input['LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs']:
        """
        Mount options that are available for DataSync to access an NFS location. See NFS Mount Options below.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: pulumi.Input['LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs']):
        pulumi.set(self, "mount_options", value)


if not MYPY:
    class LocationFsxOntapFileSystemProtocolNfsMountOptionsArgsDict(TypedDict):
        version: NotRequired[pulumi.Input[builtins.str]]
elif False:
    LocationFsxOntapFileSystemProtocolNfsMountOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class LocationFsxOntapFileSystemProtocolSmbArgsDict(TypedDict):
        mount_options: pulumi.Input['LocationFsxOntapFileSystemProtocolSmbMountOptionsArgsDict']
        """
        Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
        """
        password: pulumi.Input[builtins.str]
        """
        Password of a user who has permission to access your SVM.
        """
        user: pulumi.Input[builtins.str]
        """
        Username that can mount the location and access the files, folders, and metadata that you need in the SVM.
        """
        domain: NotRequired[pulumi.Input[builtins.str]]
        """
        Fully qualified domain name of the Microsoft Active Directory (AD) that your storage virtual machine belongs to.
        """
elif False:
    LocationFsxOntapFileSystemProtocolSmbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LocationFsxOntapFileSystemProtocolSmbArgs:
    def __init__(__self__, *,
                 mount_options: pulumi.Input['LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs'],
                 password: pulumi.Input[builtins.str],
                 user: pulumi.Input[builtins.str],
                 domain: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs'] mount_options: Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
        :param pulumi.Input[builtins.str] password: Password of a user who has permission to access your SVM.
        :param pulumi.Input[builtins.str] user: Username that can mount the location and access the files, folders, and metadata that you need in the SVM.
        :param pulumi.Input[builtins.str] domain: Fully qualified domain name of the Microsoft Active Directory (AD) that your storage virtual machine belongs to.
        """
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Input['LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs']:
        """
        Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: pulumi.Input['LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs']):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        Password of a user who has permission to access your SVM.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[builtins.str]:
        """
        Username that can mount the location and access the files, folders, and metadata that you need in the SVM.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified domain name of the Microsoft Active Directory (AD) that your storage virtual machine belongs to.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)


if not MYPY:
    class LocationFsxOntapFileSystemProtocolSmbMountOptionsArgsDict(TypedDict):
        version: NotRequired[pulumi.Input[builtins.str]]
elif False:
    LocationFsxOntapFileSystemProtocolSmbMountOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class LocationHdfsNameNodeArgsDict(TypedDict):
        hostname: pulumi.Input[builtins.str]
        """
        The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
        """
        port: pulumi.Input[builtins.int]
        """
        The port that the NameNode uses to listen to client requests.
        """
elif False:
    LocationHdfsNameNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LocationHdfsNameNodeArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[builtins.str],
                 port: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] hostname: The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
        :param pulumi.Input[builtins.int] port: The port that the NameNode uses to listen to client requests.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        The port that the NameNode uses to listen to client requests.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)


if not MYPY:
    class LocationHdfsQopConfigurationArgsDict(TypedDict):
        data_transfer_protection: NotRequired[pulumi.Input[builtins.str]]
        """
        The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        """
        rpc_protection: NotRequired[pulumi.Input[builtins.str]]
        """
        The RPC protection setting configured on the HDFS cluster. This setting corresponds to your hadoop.rpc.protection setting in your core-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        """
elif False:
    LocationHdfsQopConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LocationHdfsQopConfigurationArgs:
    def __init__(__self__, *,
                 data_transfer_protection: Optional[pulumi.Input[builtins.str]] = None,
                 rpc_protection: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] data_transfer_protection: The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        :param pulumi.Input[builtins.str] rpc_protection: The RPC protection setting configured on the HDFS cluster. This setting corresponds to your hadoop.rpc.protection setting in your core-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        """
        if data_transfer_protection is not None:
            pulumi.set(__self__, "data_transfer_protection", data_transfer_protection)
        if rpc_protection is not None:
            pulumi.set(__self__, "rpc_protection", rpc_protection)

    @property
    @pulumi.getter(name="dataTransferProtection")
    def data_transfer_protection(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        """
        return pulumi.get(self, "data_transfer_protection")

    @data_transfer_protection.setter
    def data_transfer_protection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_transfer_protection", value)

    @property
    @pulumi.getter(name="rpcProtection")
    def rpc_protection(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The RPC protection setting configured on the HDFS cluster. This setting corresponds to your hadoop.rpc.protection setting in your core-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        """
        return pulumi.get(self, "rpc_protection")

    @rpc_protection.setter
    def rpc_protection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rpc_protection", value)


if not MYPY:
    class LocationSmbMountOptionsArgsDict(TypedDict):
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        The specific SMB version that you want DataSync to use for mounting your SMB share. Valid values: `AUTOMATIC`, `SMB2`, and `SMB3`. Default: `AUTOMATIC`
        """
elif False:
    LocationSmbMountOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LocationSmbMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] version: The specific SMB version that you want DataSync to use for mounting your SMB share. Valid values: `AUTOMATIC`, `SMB2`, and `SMB3`. Default: `AUTOMATIC`
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The specific SMB version that you want DataSync to use for mounting your SMB share. Valid values: `AUTOMATIC`, `SMB2`, and `SMB3`. Default: `AUTOMATIC`
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class NfsLocationMountOptionsArgsDict(TypedDict):
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
elif False:
    NfsLocationMountOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NfsLocationMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] version: The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class NfsLocationOnPremConfigArgsDict(TypedDict):
        agent_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
        """
elif False:
    NfsLocationOnPremConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NfsLocationOnPremConfigArgs:
    def __init__(__self__, *,
                 agent_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] agent_arns: List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
        """
        pulumi.set(__self__, "agent_arns", agent_arns)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
        """
        return pulumi.get(self, "agent_arns")

    @agent_arns.setter
    def agent_arns(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "agent_arns", value)


if not MYPY:
    class S3LocationS3ConfigArgsDict(TypedDict):
        bucket_access_role_arn: pulumi.Input[builtins.str]
        """
        ARN of the IAM Role used to connect to the S3 Bucket.
        """
elif False:
    S3LocationS3ConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class S3LocationS3ConfigArgs:
    def __init__(__self__, *,
                 bucket_access_role_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] bucket_access_role_arn: ARN of the IAM Role used to connect to the S3 Bucket.
        """
        pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the IAM Role used to connect to the S3 Bucket.
        """
        return pulumi.get(self, "bucket_access_role_arn")

    @bucket_access_role_arn.setter
    def bucket_access_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_access_role_arn", value)


if not MYPY:
    class TaskExcludesArgsDict(TypedDict):
        filter_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        A single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
elif False:
    TaskExcludesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskExcludesArgs:
    def __init__(__self__, *,
                 filter_type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] filter_type: The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        :param pulumi.Input[builtins.str] value: A single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class TaskIncludesArgsDict(TypedDict):
        filter_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        A single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
elif False:
    TaskIncludesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskIncludesArgs:
    def __init__(__self__, *,
                 filter_type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] filter_type: The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        :param pulumi.Input[builtins.str] value: A single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class TaskOptionsArgsDict(TypedDict):
        atime: NotRequired[pulumi.Input[builtins.str]]
        """
        A file metadata that shows the last time a file was accessed (that is when the file was read or written to). If set to `BEST_EFFORT`, the DataSync Task attempts to preserve the original (that is, the version before sync `PREPARING` phase) `atime` attribute on all source files. Valid values: `BEST_EFFORT`, `NONE`. Default: `BEST_EFFORT`.
        """
        bytes_per_second: NotRequired[pulumi.Input[builtins.int]]
        """
        Limits the bandwidth utilized. For example, to set a maximum of 1 MB, set this value to `1048576`. Value values: `-1` or greater. Default: `-1` (unlimited).
        """
        gid: NotRequired[pulumi.Input[builtins.str]]
        """
        Group identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        """
        log_level: NotRequired[pulumi.Input[builtins.str]]
        """
        Determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. Valid values: `OFF`, `BASIC`, `TRANSFER`. Default: `OFF`.
        """
        mtime: NotRequired[pulumi.Input[builtins.str]]
        """
        A file metadata that indicates the last time a file was modified (written to) before the sync `PREPARING` phase. Value values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        """
        object_tags: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the NONE value. Valid values: `PRESERVE`, `NONE`. Default value: `PRESERVE`.
        """
        overwrite_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        Determines whether files at the destination should be overwritten or preserved when copying files. Valid values: `ALWAYS`, `NEVER`. Default: `ALWAYS`.
        """
        posix_permissions: NotRequired[pulumi.Input[builtins.str]]
        """
        Determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. Valid values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        """
        preserve_deleted_files: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether files deleted in the source should be removed or preserved in the destination file system. Valid values: `PRESERVE`, `REMOVE`. Default: `PRESERVE`.
        """
        preserve_devices: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether the DataSync Task should preserve the metadata of block and character devices in the source files system, and recreate the files with that device name and metadata on the destination. The DataSync Task can’t sync the actual contents of such devices, because many of the devices are non-terminal and don’t return an end of file (EOF) marker. Valid values: `NONE`, `PRESERVE`. Default: `NONE` (ignore special devices).
        """
        security_descriptor_copy_flags: NotRequired[pulumi.Input[builtins.str]]
        """
        Determines which components of the SMB security descriptor are copied from source to destination objects. This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. Valid values: `NONE`, `OWNER_DACL`, `OWNER_DACL_SACL`. Default: `OWNER_DACL`.
        """
        task_queueing: NotRequired[pulumi.Input[builtins.str]]
        """
        Determines whether tasks should be queued before executing the tasks. Valid values: `ENABLED`, `DISABLED`. Default `ENABLED`.
        """
        transfer_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. Valid values: `CHANGED`, `ALL`. Default: `CHANGED`
        """
        uid: NotRequired[pulumi.Input[builtins.str]]
        """
        User identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        """
        verify_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. Valid values: `NONE`, `POINT_IN_TIME_CONSISTENT`, `ONLY_FILES_TRANSFERRED`. Default: `POINT_IN_TIME_CONSISTENT`.
        """
elif False:
    TaskOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskOptionsArgs:
    def __init__(__self__, *,
                 atime: Optional[pulumi.Input[builtins.str]] = None,
                 bytes_per_second: Optional[pulumi.Input[builtins.int]] = None,
                 gid: Optional[pulumi.Input[builtins.str]] = None,
                 log_level: Optional[pulumi.Input[builtins.str]] = None,
                 mtime: Optional[pulumi.Input[builtins.str]] = None,
                 object_tags: Optional[pulumi.Input[builtins.str]] = None,
                 overwrite_mode: Optional[pulumi.Input[builtins.str]] = None,
                 posix_permissions: Optional[pulumi.Input[builtins.str]] = None,
                 preserve_deleted_files: Optional[pulumi.Input[builtins.str]] = None,
                 preserve_devices: Optional[pulumi.Input[builtins.str]] = None,
                 security_descriptor_copy_flags: Optional[pulumi.Input[builtins.str]] = None,
                 task_queueing: Optional[pulumi.Input[builtins.str]] = None,
                 transfer_mode: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 verify_mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] atime: A file metadata that shows the last time a file was accessed (that is when the file was read or written to). If set to `BEST_EFFORT`, the DataSync Task attempts to preserve the original (that is, the version before sync `PREPARING` phase) `atime` attribute on all source files. Valid values: `BEST_EFFORT`, `NONE`. Default: `BEST_EFFORT`.
        :param pulumi.Input[builtins.int] bytes_per_second: Limits the bandwidth utilized. For example, to set a maximum of 1 MB, set this value to `1048576`. Value values: `-1` or greater. Default: `-1` (unlimited).
        :param pulumi.Input[builtins.str] gid: Group identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        :param pulumi.Input[builtins.str] log_level: Determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. Valid values: `OFF`, `BASIC`, `TRANSFER`. Default: `OFF`.
        :param pulumi.Input[builtins.str] mtime: A file metadata that indicates the last time a file was modified (written to) before the sync `PREPARING` phase. Value values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        :param pulumi.Input[builtins.str] object_tags: Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the NONE value. Valid values: `PRESERVE`, `NONE`. Default value: `PRESERVE`.
        :param pulumi.Input[builtins.str] overwrite_mode: Determines whether files at the destination should be overwritten or preserved when copying files. Valid values: `ALWAYS`, `NEVER`. Default: `ALWAYS`.
        :param pulumi.Input[builtins.str] posix_permissions: Determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. Valid values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        :param pulumi.Input[builtins.str] preserve_deleted_files: Whether files deleted in the source should be removed or preserved in the destination file system. Valid values: `PRESERVE`, `REMOVE`. Default: `PRESERVE`.
        :param pulumi.Input[builtins.str] preserve_devices: Whether the DataSync Task should preserve the metadata of block and character devices in the source files system, and recreate the files with that device name and metadata on the destination. The DataSync Task can’t sync the actual contents of such devices, because many of the devices are non-terminal and don’t return an end of file (EOF) marker. Valid values: `NONE`, `PRESERVE`. Default: `NONE` (ignore special devices).
        :param pulumi.Input[builtins.str] security_descriptor_copy_flags: Determines which components of the SMB security descriptor are copied from source to destination objects. This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. Valid values: `NONE`, `OWNER_DACL`, `OWNER_DACL_SACL`. Default: `OWNER_DACL`.
        :param pulumi.Input[builtins.str] task_queueing: Determines whether tasks should be queued before executing the tasks. Valid values: `ENABLED`, `DISABLED`. Default `ENABLED`.
        :param pulumi.Input[builtins.str] transfer_mode: Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. Valid values: `CHANGED`, `ALL`. Default: `CHANGED`
        :param pulumi.Input[builtins.str] uid: User identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        :param pulumi.Input[builtins.str] verify_mode: Whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. Valid values: `NONE`, `POINT_IN_TIME_CONSISTENT`, `ONLY_FILES_TRANSFERRED`. Default: `POINT_IN_TIME_CONSISTENT`.
        """
        if atime is not None:
            pulumi.set(__self__, "atime", atime)
        if bytes_per_second is not None:
            pulumi.set(__self__, "bytes_per_second", bytes_per_second)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if mtime is not None:
            pulumi.set(__self__, "mtime", mtime)
        if object_tags is not None:
            pulumi.set(__self__, "object_tags", object_tags)
        if overwrite_mode is not None:
            pulumi.set(__self__, "overwrite_mode", overwrite_mode)
        if posix_permissions is not None:
            pulumi.set(__self__, "posix_permissions", posix_permissions)
        if preserve_deleted_files is not None:
            pulumi.set(__self__, "preserve_deleted_files", preserve_deleted_files)
        if preserve_devices is not None:
            pulumi.set(__self__, "preserve_devices", preserve_devices)
        if security_descriptor_copy_flags is not None:
            pulumi.set(__self__, "security_descriptor_copy_flags", security_descriptor_copy_flags)
        if task_queueing is not None:
            pulumi.set(__self__, "task_queueing", task_queueing)
        if transfer_mode is not None:
            pulumi.set(__self__, "transfer_mode", transfer_mode)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if verify_mode is not None:
            pulumi.set(__self__, "verify_mode", verify_mode)

    @property
    @pulumi.getter
    def atime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A file metadata that shows the last time a file was accessed (that is when the file was read or written to). If set to `BEST_EFFORT`, the DataSync Task attempts to preserve the original (that is, the version before sync `PREPARING` phase) `atime` attribute on all source files. Valid values: `BEST_EFFORT`, `NONE`. Default: `BEST_EFFORT`.
        """
        return pulumi.get(self, "atime")

    @atime.setter
    def atime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "atime", value)

    @property
    @pulumi.getter(name="bytesPerSecond")
    def bytes_per_second(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Limits the bandwidth utilized. For example, to set a maximum of 1 MB, set this value to `1048576`. Value values: `-1` or greater. Default: `-1` (unlimited).
        """
        return pulumi.get(self, "bytes_per_second")

    @bytes_per_second.setter
    def bytes_per_second(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "bytes_per_second", value)

    @property
    @pulumi.getter
    def gid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Group identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. Valid values: `OFF`, `BASIC`, `TRANSFER`. Default: `OFF`.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter
    def mtime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A file metadata that indicates the last time a file was modified (written to) before the sync `PREPARING` phase. Value values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        """
        return pulumi.get(self, "mtime")

    @mtime.setter
    def mtime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mtime", value)

    @property
    @pulumi.getter(name="objectTags")
    def object_tags(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the NONE value. Valid values: `PRESERVE`, `NONE`. Default value: `PRESERVE`.
        """
        return pulumi.get(self, "object_tags")

    @object_tags.setter
    def object_tags(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_tags", value)

    @property
    @pulumi.getter(name="overwriteMode")
    def overwrite_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines whether files at the destination should be overwritten or preserved when copying files. Valid values: `ALWAYS`, `NEVER`. Default: `ALWAYS`.
        """
        return pulumi.get(self, "overwrite_mode")

    @overwrite_mode.setter
    def overwrite_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "overwrite_mode", value)

    @property
    @pulumi.getter(name="posixPermissions")
    def posix_permissions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. Valid values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        """
        return pulumi.get(self, "posix_permissions")

    @posix_permissions.setter
    def posix_permissions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "posix_permissions", value)

    @property
    @pulumi.getter(name="preserveDeletedFiles")
    def preserve_deleted_files(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether files deleted in the source should be removed or preserved in the destination file system. Valid values: `PRESERVE`, `REMOVE`. Default: `PRESERVE`.
        """
        return pulumi.get(self, "preserve_deleted_files")

    @preserve_deleted_files.setter
    def preserve_deleted_files(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preserve_deleted_files", value)

    @property
    @pulumi.getter(name="preserveDevices")
    def preserve_devices(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the DataSync Task should preserve the metadata of block and character devices in the source files system, and recreate the files with that device name and metadata on the destination. The DataSync Task can’t sync the actual contents of such devices, because many of the devices are non-terminal and don’t return an end of file (EOF) marker. Valid values: `NONE`, `PRESERVE`. Default: `NONE` (ignore special devices).
        """
        return pulumi.get(self, "preserve_devices")

    @preserve_devices.setter
    def preserve_devices(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preserve_devices", value)

    @property
    @pulumi.getter(name="securityDescriptorCopyFlags")
    def security_descriptor_copy_flags(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines which components of the SMB security descriptor are copied from source to destination objects. This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. Valid values: `NONE`, `OWNER_DACL`, `OWNER_DACL_SACL`. Default: `OWNER_DACL`.
        """
        return pulumi.get(self, "security_descriptor_copy_flags")

    @security_descriptor_copy_flags.setter
    def security_descriptor_copy_flags(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_descriptor_copy_flags", value)

    @property
    @pulumi.getter(name="taskQueueing")
    def task_queueing(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines whether tasks should be queued before executing the tasks. Valid values: `ENABLED`, `DISABLED`. Default `ENABLED`.
        """
        return pulumi.get(self, "task_queueing")

    @task_queueing.setter
    def task_queueing(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_queueing", value)

    @property
    @pulumi.getter(name="transferMode")
    def transfer_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. Valid values: `CHANGED`, `ALL`. Default: `CHANGED`
        """
        return pulumi.get(self, "transfer_mode")

    @transfer_mode.setter
    def transfer_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transfer_mode", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="verifyMode")
    def verify_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. Valid values: `NONE`, `POINT_IN_TIME_CONSISTENT`, `ONLY_FILES_TRANSFERRED`. Default: `POINT_IN_TIME_CONSISTENT`.
        """
        return pulumi.get(self, "verify_mode")

    @verify_mode.setter
    def verify_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "verify_mode", value)


if not MYPY:
    class TaskScheduleArgsDict(TypedDict):
        schedule_expression: pulumi.Input[builtins.str]
        """
        Specifies the schedule you want your task to use for repeated executions. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
        """
elif False:
    TaskScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskScheduleArgs:
    def __init__(__self__, *,
                 schedule_expression: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] schedule_expression: Specifies the schedule you want your task to use for repeated executions. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the schedule you want your task to use for repeated executions. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schedule_expression", value)


if not MYPY:
    class TaskTaskReportConfigArgsDict(TypedDict):
        s3_destination: pulumi.Input['TaskTaskReportConfigS3DestinationArgsDict']
        """
        Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
        """
        output_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the type of task report you'd like. Valid values: `SUMMARY_ONLY` and `STANDARD`.
        """
        report_level: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        report_overrides: NotRequired[pulumi.Input['TaskTaskReportConfigReportOverridesArgsDict']]
        """
        Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
        """
        s3_object_versioning: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you enable versioning on your bucket. Keep in mind that setting this to INCLUDE can increase the duration of your task execution. Valid values: `INCLUDE` and `NONE`.
        """
elif False:
    TaskTaskReportConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskTaskReportConfigArgs:
    def __init__(__self__, *,
                 s3_destination: pulumi.Input['TaskTaskReportConfigS3DestinationArgs'],
                 output_type: Optional[pulumi.Input[builtins.str]] = None,
                 report_level: Optional[pulumi.Input[builtins.str]] = None,
                 report_overrides: Optional[pulumi.Input['TaskTaskReportConfigReportOverridesArgs']] = None,
                 s3_object_versioning: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['TaskTaskReportConfigS3DestinationArgs'] s3_destination: Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
        :param pulumi.Input[builtins.str] output_type: Specifies the type of task report you'd like. Valid values: `SUMMARY_ONLY` and `STANDARD`.
        :param pulumi.Input[builtins.str] report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        :param pulumi.Input['TaskTaskReportConfigReportOverridesArgs'] report_overrides: Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
        :param pulumi.Input[builtins.str] s3_object_versioning: Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you enable versioning on your bucket. Keep in mind that setting this to INCLUDE can increase the duration of your task execution. Valid values: `INCLUDE` and `NONE`.
        """
        pulumi.set(__self__, "s3_destination", s3_destination)
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)
        if report_overrides is not None:
            pulumi.set(__self__, "report_overrides", report_overrides)
        if s3_object_versioning is not None:
            pulumi.set(__self__, "s3_object_versioning", s3_object_versioning)

    @property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> pulumi.Input['TaskTaskReportConfigS3DestinationArgs']:
        """
        Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
        """
        return pulumi.get(self, "s3_destination")

    @s3_destination.setter
    def s3_destination(self, value: pulumi.Input['TaskTaskReportConfigS3DestinationArgs']):
        pulumi.set(self, "s3_destination", value)

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of task report you'd like. Valid values: `SUMMARY_ONLY` and `STANDARD`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "output_type", value)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        return pulumi.get(self, "report_level")

    @report_level.setter
    def report_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "report_level", value)

    @property
    @pulumi.getter(name="reportOverrides")
    def report_overrides(self) -> Optional[pulumi.Input['TaskTaskReportConfigReportOverridesArgs']]:
        """
        Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
        """
        return pulumi.get(self, "report_overrides")

    @report_overrides.setter
    def report_overrides(self, value: Optional[pulumi.Input['TaskTaskReportConfigReportOverridesArgs']]):
        pulumi.set(self, "report_overrides", value)

    @property
    @pulumi.getter(name="s3ObjectVersioning")
    def s3_object_versioning(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you enable versioning on your bucket. Keep in mind that setting this to INCLUDE can increase the duration of your task execution. Valid values: `INCLUDE` and `NONE`.
        """
        return pulumi.get(self, "s3_object_versioning")

    @s3_object_versioning.setter
    def s3_object_versioning(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_object_versioning", value)


if not MYPY:
    class TaskTaskReportConfigReportOverridesArgsDict(TypedDict):
        deleted_override: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        skipped_override: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        transferred_override: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        verified_override: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.

        > **NOTE:** If any `report_overrides` are set to the same value as `task_report_config.report_level`, they will always be flagged as changed. Only set overrides to a value that differs from `task_report_config.report_level`.
        """
elif False:
    TaskTaskReportConfigReportOverridesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskTaskReportConfigReportOverridesArgs:
    def __init__(__self__, *,
                 deleted_override: Optional[pulumi.Input[builtins.str]] = None,
                 skipped_override: Optional[pulumi.Input[builtins.str]] = None,
                 transferred_override: Optional[pulumi.Input[builtins.str]] = None,
                 verified_override: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] deleted_override: Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        :param pulumi.Input[builtins.str] skipped_override: Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        :param pulumi.Input[builtins.str] transferred_override: Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        :param pulumi.Input[builtins.str] verified_override: Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
               
               > **NOTE:** If any `report_overrides` are set to the same value as `task_report_config.report_level`, they will always be flagged as changed. Only set overrides to a value that differs from `task_report_config.report_level`.
        """
        if deleted_override is not None:
            pulumi.set(__self__, "deleted_override", deleted_override)
        if skipped_override is not None:
            pulumi.set(__self__, "skipped_override", skipped_override)
        if transferred_override is not None:
            pulumi.set(__self__, "transferred_override", transferred_override)
        if verified_override is not None:
            pulumi.set(__self__, "verified_override", verified_override)

    @property
    @pulumi.getter(name="deletedOverride")
    def deleted_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        return pulumi.get(self, "deleted_override")

    @deleted_override.setter
    def deleted_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deleted_override", value)

    @property
    @pulumi.getter(name="skippedOverride")
    def skipped_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        return pulumi.get(self, "skipped_override")

    @skipped_override.setter
    def skipped_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "skipped_override", value)

    @property
    @pulumi.getter(name="transferredOverride")
    def transferred_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        return pulumi.get(self, "transferred_override")

    @transferred_override.setter
    def transferred_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transferred_override", value)

    @property
    @pulumi.getter(name="verifiedOverride")
    def verified_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.

        > **NOTE:** If any `report_overrides` are set to the same value as `task_report_config.report_level`, they will always be flagged as changed. Only set overrides to a value that differs from `task_report_config.report_level`.
        """
        return pulumi.get(self, "verified_override")

    @verified_override.setter
    def verified_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "verified_override", value)


if not MYPY:
    class TaskTaskReportConfigS3DestinationArgsDict(TypedDict):
        bucket_access_role_arn: pulumi.Input[builtins.str]
        """
        Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket.
        """
        s3_bucket_arn: pulumi.Input[builtins.str]
        """
        Specifies the ARN of the S3 bucket where DataSync uploads your report.
        """
        subdirectory: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies a bucket prefix for your report.
        """
elif False:
    TaskTaskReportConfigS3DestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaskTaskReportConfigS3DestinationArgs:
    def __init__(__self__, *,
                 bucket_access_role_arn: pulumi.Input[builtins.str],
                 s3_bucket_arn: pulumi.Input[builtins.str],
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket_access_role_arn: Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket.
        :param pulumi.Input[builtins.str] s3_bucket_arn: Specifies the ARN of the S3 bucket where DataSync uploads your report.
        :param pulumi.Input[builtins.str] subdirectory: Specifies a bucket prefix for your report.
        """
        pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)
        pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket.
        """
        return pulumi.get(self, "bucket_access_role_arn")

    @bucket_access_role_arn.setter
    def bucket_access_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_access_role_arn", value)

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ARN of the S3 bucket where DataSync uploads your report.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @s3_bucket_arn.setter
    def s3_bucket_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_bucket_arn", value)

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a bucket prefix for your report.
        """
        return pulumi.get(self, "subdirectory")

    @subdirectory.setter
    def subdirectory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subdirectory", value)


