# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LocationHdfsArgs', 'LocationHdfs']

@pulumi.input_type
class LocationHdfsArgs:
    def __init__(__self__, *,
                 agent_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 name_nodes: pulumi.Input[Sequence[pulumi.Input['LocationHdfsNameNodeArgs']]],
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 block_size: Optional[pulumi.Input[builtins.int]] = None,
                 kerberos_keytab: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_keytab_base64: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf_base64: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_principal: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_provider_uri: Optional[pulumi.Input[builtins.str]] = None,
                 qop_configuration: Optional[pulumi.Input['LocationHdfsQopConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 simple_user: Optional[pulumi.Input[builtins.str]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a LocationHdfs resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] agent_arns: A list of DataSync Agent ARNs with which this location will be associated.
        :param pulumi.Input[Sequence[pulumi.Input['LocationHdfsNameNodeArgs']]] name_nodes: The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
        :param pulumi.Input[builtins.str] authentication_type: The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
        :param pulumi.Input[builtins.int] block_size: The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
        :param pulumi.Input[builtins.str] kerberos_keytab: The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. Use `kerberos_keytab_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab_base64`) is required.
        :param pulumi.Input[builtins.str] kerberos_keytab_base64: Use instead of `kerberos_keytab` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab`) is required.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf: The krb5.conf file that contains the Kerberos configuration information. Use `kerberos_krb5_conf_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf_base64`) is required.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf_base64: Use instead of `kerberos_krb5_conf` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf`) is required.
        :param pulumi.Input[builtins.str] kerberos_principal: The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
        :param pulumi.Input[builtins.str] kms_key_provider_uri: The URI of the HDFS cluster's Key Management Server (KMS).
        :param pulumi.Input['LocationHdfsQopConfigurationArgs'] qop_configuration: The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] replication_factor: The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
        :param pulumi.Input[builtins.str] simple_user: The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
        :param pulumi.Input[builtins.str] subdirectory: A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "agent_arns", agent_arns)
        pulumi.set(__self__, "name_nodes", name_nodes)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if block_size is not None:
            pulumi.set(__self__, "block_size", block_size)
        if kerberos_keytab is not None:
            pulumi.set(__self__, "kerberos_keytab", kerberos_keytab)
        if kerberos_keytab_base64 is not None:
            pulumi.set(__self__, "kerberos_keytab_base64", kerberos_keytab_base64)
        if kerberos_krb5_conf is not None:
            pulumi.set(__self__, "kerberos_krb5_conf", kerberos_krb5_conf)
        if kerberos_krb5_conf_base64 is not None:
            pulumi.set(__self__, "kerberos_krb5_conf_base64", kerberos_krb5_conf_base64)
        if kerberos_principal is not None:
            pulumi.set(__self__, "kerberos_principal", kerberos_principal)
        if kms_key_provider_uri is not None:
            pulumi.set(__self__, "kms_key_provider_uri", kms_key_provider_uri)
        if qop_configuration is not None:
            pulumi.set(__self__, "qop_configuration", qop_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if simple_user is not None:
            pulumi.set(__self__, "simple_user", simple_user)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of DataSync Agent ARNs with which this location will be associated.
        """
        return pulumi.get(self, "agent_arns")

    @agent_arns.setter
    def agent_arns(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "agent_arns", value)

    @property
    @pulumi.getter(name="nameNodes")
    def name_nodes(self) -> pulumi.Input[Sequence[pulumi.Input['LocationHdfsNameNodeArgs']]]:
        """
        The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
        """
        return pulumi.get(self, "name_nodes")

    @name_nodes.setter
    def name_nodes(self, value: pulumi.Input[Sequence[pulumi.Input['LocationHdfsNameNodeArgs']]]):
        pulumi.set(self, "name_nodes", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="blockSize")
    def block_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
        """
        return pulumi.get(self, "block_size")

    @block_size.setter
    def block_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "block_size", value)

    @property
    @pulumi.getter(name="kerberosKeytab")
    def kerberos_keytab(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. Use `kerberos_keytab_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab_base64`) is required.
        """
        return pulumi.get(self, "kerberos_keytab")

    @kerberos_keytab.setter
    def kerberos_keytab(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_keytab", value)

    @property
    @pulumi.getter(name="kerberosKeytabBase64")
    def kerberos_keytab_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use instead of `kerberos_keytab` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab`) is required.
        """
        return pulumi.get(self, "kerberos_keytab_base64")

    @kerberos_keytab_base64.setter
    def kerberos_keytab_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_keytab_base64", value)

    @property
    @pulumi.getter(name="kerberosKrb5Conf")
    def kerberos_krb5_conf(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The krb5.conf file that contains the Kerberos configuration information. Use `kerberos_krb5_conf_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf_base64`) is required.
        """
        return pulumi.get(self, "kerberos_krb5_conf")

    @kerberos_krb5_conf.setter
    def kerberos_krb5_conf(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_krb5_conf", value)

    @property
    @pulumi.getter(name="kerberosKrb5ConfBase64")
    def kerberos_krb5_conf_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use instead of `kerberos_krb5_conf` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf`) is required.
        """
        return pulumi.get(self, "kerberos_krb5_conf_base64")

    @kerberos_krb5_conf_base64.setter
    def kerberos_krb5_conf_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_krb5_conf_base64", value)

    @property
    @pulumi.getter(name="kerberosPrincipal")
    def kerberos_principal(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
        """
        return pulumi.get(self, "kerberos_principal")

    @kerberos_principal.setter
    def kerberos_principal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_principal", value)

    @property
    @pulumi.getter(name="kmsKeyProviderUri")
    def kms_key_provider_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the HDFS cluster's Key Management Server (KMS).
        """
        return pulumi.get(self, "kms_key_provider_uri")

    @kms_key_provider_uri.setter
    def kms_key_provider_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_provider_uri", value)

    @property
    @pulumi.getter(name="qopConfiguration")
    def qop_configuration(self) -> Optional[pulumi.Input['LocationHdfsQopConfigurationArgs']]:
        """
        The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
        """
        return pulumi.get(self, "qop_configuration")

    @qop_configuration.setter
    def qop_configuration(self, value: Optional[pulumi.Input['LocationHdfsQopConfigurationArgs']]):
        pulumi.set(self, "qop_configuration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @property
    @pulumi.getter(name="simpleUser")
    def simple_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
        """
        return pulumi.get(self, "simple_user")

    @simple_user.setter
    def simple_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "simple_user", value)

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
        """
        return pulumi.get(self, "subdirectory")

    @subdirectory.setter
    def subdirectory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subdirectory", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LocationHdfsState:
    def __init__(__self__, *,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 block_size: Optional[pulumi.Input[builtins.int]] = None,
                 kerberos_keytab: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_keytab_base64: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf_base64: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_principal: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_provider_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['LocationHdfsNameNodeArgs']]]] = None,
                 qop_configuration: Optional[pulumi.Input['LocationHdfsQopConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 simple_user: Optional[pulumi.Input[builtins.str]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LocationHdfs resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] agent_arns: A list of DataSync Agent ARNs with which this location will be associated.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the DataSync Location.
        :param pulumi.Input[builtins.str] authentication_type: The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
        :param pulumi.Input[builtins.int] block_size: The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
        :param pulumi.Input[builtins.str] kerberos_keytab: The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. Use `kerberos_keytab_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab_base64`) is required.
        :param pulumi.Input[builtins.str] kerberos_keytab_base64: Use instead of `kerberos_keytab` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab`) is required.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf: The krb5.conf file that contains the Kerberos configuration information. Use `kerberos_krb5_conf_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf_base64`) is required.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf_base64: Use instead of `kerberos_krb5_conf` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf`) is required.
        :param pulumi.Input[builtins.str] kerberos_principal: The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
        :param pulumi.Input[builtins.str] kms_key_provider_uri: The URI of the HDFS cluster's Key Management Server (KMS).
        :param pulumi.Input[Sequence[pulumi.Input['LocationHdfsNameNodeArgs']]] name_nodes: The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
        :param pulumi.Input['LocationHdfsQopConfigurationArgs'] qop_configuration: The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] replication_factor: The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
        :param pulumi.Input[builtins.str] simple_user: The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
        :param pulumi.Input[builtins.str] subdirectory: A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if agent_arns is not None:
            pulumi.set(__self__, "agent_arns", agent_arns)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if block_size is not None:
            pulumi.set(__self__, "block_size", block_size)
        if kerberos_keytab is not None:
            pulumi.set(__self__, "kerberos_keytab", kerberos_keytab)
        if kerberos_keytab_base64 is not None:
            pulumi.set(__self__, "kerberos_keytab_base64", kerberos_keytab_base64)
        if kerberos_krb5_conf is not None:
            pulumi.set(__self__, "kerberos_krb5_conf", kerberos_krb5_conf)
        if kerberos_krb5_conf_base64 is not None:
            pulumi.set(__self__, "kerberos_krb5_conf_base64", kerberos_krb5_conf_base64)
        if kerberos_principal is not None:
            pulumi.set(__self__, "kerberos_principal", kerberos_principal)
        if kms_key_provider_uri is not None:
            pulumi.set(__self__, "kms_key_provider_uri", kms_key_provider_uri)
        if name_nodes is not None:
            pulumi.set(__self__, "name_nodes", name_nodes)
        if qop_configuration is not None:
            pulumi.set(__self__, "qop_configuration", qop_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if simple_user is not None:
            pulumi.set(__self__, "simple_user", simple_user)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of DataSync Agent ARNs with which this location will be associated.
        """
        return pulumi.get(self, "agent_arns")

    @agent_arns.setter
    def agent_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "agent_arns", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the DataSync Location.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="blockSize")
    def block_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
        """
        return pulumi.get(self, "block_size")

    @block_size.setter
    def block_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "block_size", value)

    @property
    @pulumi.getter(name="kerberosKeytab")
    def kerberos_keytab(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. Use `kerberos_keytab_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab_base64`) is required.
        """
        return pulumi.get(self, "kerberos_keytab")

    @kerberos_keytab.setter
    def kerberos_keytab(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_keytab", value)

    @property
    @pulumi.getter(name="kerberosKeytabBase64")
    def kerberos_keytab_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use instead of `kerberos_keytab` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab`) is required.
        """
        return pulumi.get(self, "kerberos_keytab_base64")

    @kerberos_keytab_base64.setter
    def kerberos_keytab_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_keytab_base64", value)

    @property
    @pulumi.getter(name="kerberosKrb5Conf")
    def kerberos_krb5_conf(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The krb5.conf file that contains the Kerberos configuration information. Use `kerberos_krb5_conf_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf_base64`) is required.
        """
        return pulumi.get(self, "kerberos_krb5_conf")

    @kerberos_krb5_conf.setter
    def kerberos_krb5_conf(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_krb5_conf", value)

    @property
    @pulumi.getter(name="kerberosKrb5ConfBase64")
    def kerberos_krb5_conf_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use instead of `kerberos_krb5_conf` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf`) is required.
        """
        return pulumi.get(self, "kerberos_krb5_conf_base64")

    @kerberos_krb5_conf_base64.setter
    def kerberos_krb5_conf_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_krb5_conf_base64", value)

    @property
    @pulumi.getter(name="kerberosPrincipal")
    def kerberos_principal(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
        """
        return pulumi.get(self, "kerberos_principal")

    @kerberos_principal.setter
    def kerberos_principal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_principal", value)

    @property
    @pulumi.getter(name="kmsKeyProviderUri")
    def kms_key_provider_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the HDFS cluster's Key Management Server (KMS).
        """
        return pulumi.get(self, "kms_key_provider_uri")

    @kms_key_provider_uri.setter
    def kms_key_provider_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_provider_uri", value)

    @property
    @pulumi.getter(name="nameNodes")
    def name_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocationHdfsNameNodeArgs']]]]:
        """
        The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
        """
        return pulumi.get(self, "name_nodes")

    @name_nodes.setter
    def name_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocationHdfsNameNodeArgs']]]]):
        pulumi.set(self, "name_nodes", value)

    @property
    @pulumi.getter(name="qopConfiguration")
    def qop_configuration(self) -> Optional[pulumi.Input['LocationHdfsQopConfigurationArgs']]:
        """
        The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
        """
        return pulumi.get(self, "qop_configuration")

    @qop_configuration.setter
    def qop_configuration(self, value: Optional[pulumi.Input['LocationHdfsQopConfigurationArgs']]):
        pulumi.set(self, "qop_configuration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @property
    @pulumi.getter(name="simpleUser")
    def simple_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
        """
        return pulumi.get(self, "simple_user")

    @simple_user.setter
    def simple_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "simple_user", value)

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
        """
        return pulumi.get(self, "subdirectory")

    @subdirectory.setter
    def subdirectory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subdirectory", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.type_token("aws:datasync/locationHdfs:LocationHdfs")
class LocationHdfs(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 block_size: Optional[pulumi.Input[builtins.int]] = None,
                 kerberos_keytab: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_keytab_base64: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf_base64: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_principal: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_provider_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LocationHdfsNameNodeArgs', 'LocationHdfsNameNodeArgsDict']]]]] = None,
                 qop_configuration: Optional[pulumi.Input[Union['LocationHdfsQopConfigurationArgs', 'LocationHdfsQopConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 simple_user: Optional[pulumi.Input[builtins.str]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an HDFS Location within AWS DataSync.

        > **NOTE:** The DataSync Agents must be available before creating this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.LocationHdfs("example",
            agent_arns=[example_aws_datasync_agent["arn"]],
            authentication_type="SIMPLE",
            simple_user="example",
            name_nodes=[{
                "hostname": example_aws_instance["privateDns"],
                "port": 80,
            }])
        ```

        ### Kerberos Authentication

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.datasync.LocationHdfs("example",
            agent_arns=[example_aws_datasync_agent["arn"]],
            authentication_type="KERBEROS",
            name_nodes=[{
                "hostname": example_aws_instance["privateDns"],
                "port": 80,
            }],
            kerberos_principal="user@example.com",
            kerberos_keytab_base64=std.filebase64(input="user.keytab").result,
            kerberos_krb5_conf=std.file(input="krb5.conf").result)
        ```

        ## Import

        Using `pulumi import`, import `aws_datasync_location_hdfs` using the Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:datasync/locationHdfs:LocationHdfs example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] agent_arns: A list of DataSync Agent ARNs with which this location will be associated.
        :param pulumi.Input[builtins.str] authentication_type: The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
        :param pulumi.Input[builtins.int] block_size: The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
        :param pulumi.Input[builtins.str] kerberos_keytab: The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. Use `kerberos_keytab_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab_base64`) is required.
        :param pulumi.Input[builtins.str] kerberos_keytab_base64: Use instead of `kerberos_keytab` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab`) is required.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf: The krb5.conf file that contains the Kerberos configuration information. Use `kerberos_krb5_conf_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf_base64`) is required.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf_base64: Use instead of `kerberos_krb5_conf` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf`) is required.
        :param pulumi.Input[builtins.str] kerberos_principal: The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
        :param pulumi.Input[builtins.str] kms_key_provider_uri: The URI of the HDFS cluster's Key Management Server (KMS).
        :param pulumi.Input[Sequence[pulumi.Input[Union['LocationHdfsNameNodeArgs', 'LocationHdfsNameNodeArgsDict']]]] name_nodes: The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
        :param pulumi.Input[Union['LocationHdfsQopConfigurationArgs', 'LocationHdfsQopConfigurationArgsDict']] qop_configuration: The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] replication_factor: The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
        :param pulumi.Input[builtins.str] simple_user: The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
        :param pulumi.Input[builtins.str] subdirectory: A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocationHdfsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an HDFS Location within AWS DataSync.

        > **NOTE:** The DataSync Agents must be available before creating this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.LocationHdfs("example",
            agent_arns=[example_aws_datasync_agent["arn"]],
            authentication_type="SIMPLE",
            simple_user="example",
            name_nodes=[{
                "hostname": example_aws_instance["privateDns"],
                "port": 80,
            }])
        ```

        ### Kerberos Authentication

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.datasync.LocationHdfs("example",
            agent_arns=[example_aws_datasync_agent["arn"]],
            authentication_type="KERBEROS",
            name_nodes=[{
                "hostname": example_aws_instance["privateDns"],
                "port": 80,
            }],
            kerberos_principal="user@example.com",
            kerberos_keytab_base64=std.filebase64(input="user.keytab").result,
            kerberos_krb5_conf=std.file(input="krb5.conf").result)
        ```

        ## Import

        Using `pulumi import`, import `aws_datasync_location_hdfs` using the Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:datasync/locationHdfs:LocationHdfs example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
        ```

        :param str resource_name: The name of the resource.
        :param LocationHdfsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocationHdfsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 block_size: Optional[pulumi.Input[builtins.int]] = None,
                 kerberos_keytab: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_keytab_base64: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf_base64: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_principal: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_provider_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LocationHdfsNameNodeArgs', 'LocationHdfsNameNodeArgsDict']]]]] = None,
                 qop_configuration: Optional[pulumi.Input[Union['LocationHdfsQopConfigurationArgs', 'LocationHdfsQopConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 simple_user: Optional[pulumi.Input[builtins.str]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocationHdfsArgs.__new__(LocationHdfsArgs)

            if agent_arns is None and not opts.urn:
                raise TypeError("Missing required property 'agent_arns'")
            __props__.__dict__["agent_arns"] = agent_arns
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["block_size"] = block_size
            __props__.__dict__["kerberos_keytab"] = kerberos_keytab
            __props__.__dict__["kerberos_keytab_base64"] = kerberos_keytab_base64
            __props__.__dict__["kerberos_krb5_conf"] = kerberos_krb5_conf
            __props__.__dict__["kerberos_krb5_conf_base64"] = kerberos_krb5_conf_base64
            __props__.__dict__["kerberos_principal"] = kerberos_principal
            __props__.__dict__["kms_key_provider_uri"] = kms_key_provider_uri
            if name_nodes is None and not opts.urn:
                raise TypeError("Missing required property 'name_nodes'")
            __props__.__dict__["name_nodes"] = name_nodes
            __props__.__dict__["qop_configuration"] = qop_configuration
            __props__.__dict__["region"] = region
            __props__.__dict__["replication_factor"] = replication_factor
            __props__.__dict__["simple_user"] = simple_user
            __props__.__dict__["subdirectory"] = subdirectory
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["uri"] = None
        super(LocationHdfs, __self__).__init__(
            'aws:datasync/locationHdfs:LocationHdfs',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            authentication_type: Optional[pulumi.Input[builtins.str]] = None,
            block_size: Optional[pulumi.Input[builtins.int]] = None,
            kerberos_keytab: Optional[pulumi.Input[builtins.str]] = None,
            kerberos_keytab_base64: Optional[pulumi.Input[builtins.str]] = None,
            kerberos_krb5_conf: Optional[pulumi.Input[builtins.str]] = None,
            kerberos_krb5_conf_base64: Optional[pulumi.Input[builtins.str]] = None,
            kerberos_principal: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_provider_uri: Optional[pulumi.Input[builtins.str]] = None,
            name_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LocationHdfsNameNodeArgs', 'LocationHdfsNameNodeArgsDict']]]]] = None,
            qop_configuration: Optional[pulumi.Input[Union['LocationHdfsQopConfigurationArgs', 'LocationHdfsQopConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            replication_factor: Optional[pulumi.Input[builtins.int]] = None,
            simple_user: Optional[pulumi.Input[builtins.str]] = None,
            subdirectory: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            uri: Optional[pulumi.Input[builtins.str]] = None) -> 'LocationHdfs':
        """
        Get an existing LocationHdfs resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] agent_arns: A list of DataSync Agent ARNs with which this location will be associated.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the DataSync Location.
        :param pulumi.Input[builtins.str] authentication_type: The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
        :param pulumi.Input[builtins.int] block_size: The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
        :param pulumi.Input[builtins.str] kerberos_keytab: The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. Use `kerberos_keytab_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab_base64`) is required.
        :param pulumi.Input[builtins.str] kerberos_keytab_base64: Use instead of `kerberos_keytab` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab`) is required.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf: The krb5.conf file that contains the Kerberos configuration information. Use `kerberos_krb5_conf_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf_base64`) is required.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf_base64: Use instead of `kerberos_krb5_conf` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf`) is required.
        :param pulumi.Input[builtins.str] kerberos_principal: The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
        :param pulumi.Input[builtins.str] kms_key_provider_uri: The URI of the HDFS cluster's Key Management Server (KMS).
        :param pulumi.Input[Sequence[pulumi.Input[Union['LocationHdfsNameNodeArgs', 'LocationHdfsNameNodeArgsDict']]]] name_nodes: The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
        :param pulumi.Input[Union['LocationHdfsQopConfigurationArgs', 'LocationHdfsQopConfigurationArgsDict']] qop_configuration: The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] replication_factor: The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
        :param pulumi.Input[builtins.str] simple_user: The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
        :param pulumi.Input[builtins.str] subdirectory: A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LocationHdfsState.__new__(_LocationHdfsState)

        __props__.__dict__["agent_arns"] = agent_arns
        __props__.__dict__["arn"] = arn
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["block_size"] = block_size
        __props__.__dict__["kerberos_keytab"] = kerberos_keytab
        __props__.__dict__["kerberos_keytab_base64"] = kerberos_keytab_base64
        __props__.__dict__["kerberos_krb5_conf"] = kerberos_krb5_conf
        __props__.__dict__["kerberos_krb5_conf_base64"] = kerberos_krb5_conf_base64
        __props__.__dict__["kerberos_principal"] = kerberos_principal
        __props__.__dict__["kms_key_provider_uri"] = kms_key_provider_uri
        __props__.__dict__["name_nodes"] = name_nodes
        __props__.__dict__["qop_configuration"] = qop_configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_factor"] = replication_factor
        __props__.__dict__["simple_user"] = simple_user
        __props__.__dict__["subdirectory"] = subdirectory
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["uri"] = uri
        return LocationHdfs(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of DataSync Agent ARNs with which this location will be associated.
        """
        return pulumi.get(self, "agent_arns")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the DataSync Location.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="blockSize")
    def block_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
        """
        return pulumi.get(self, "block_size")

    @property
    @pulumi.getter(name="kerberosKeytab")
    def kerberos_keytab(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. Use `kerberos_keytab_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab_base64`) is required.
        """
        return pulumi.get(self, "kerberos_keytab")

    @property
    @pulumi.getter(name="kerberosKeytabBase64")
    def kerberos_keytab_base64(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Use instead of `kerberos_keytab` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab`) is required.
        """
        return pulumi.get(self, "kerberos_keytab_base64")

    @property
    @pulumi.getter(name="kerberosKrb5Conf")
    def kerberos_krb5_conf(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The krb5.conf file that contains the Kerberos configuration information. Use `kerberos_krb5_conf_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf_base64`) is required.
        """
        return pulumi.get(self, "kerberos_krb5_conf")

    @property
    @pulumi.getter(name="kerberosKrb5ConfBase64")
    def kerberos_krb5_conf_base64(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Use instead of `kerberos_krb5_conf` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf`) is required.
        """
        return pulumi.get(self, "kerberos_krb5_conf_base64")

    @property
    @pulumi.getter(name="kerberosPrincipal")
    def kerberos_principal(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
        """
        return pulumi.get(self, "kerberos_principal")

    @property
    @pulumi.getter(name="kmsKeyProviderUri")
    def kms_key_provider_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URI of the HDFS cluster's Key Management Server (KMS).
        """
        return pulumi.get(self, "kms_key_provider_uri")

    @property
    @pulumi.getter(name="nameNodes")
    def name_nodes(self) -> pulumi.Output[Sequence['outputs.LocationHdfsNameNode']]:
        """
        The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
        """
        return pulumi.get(self, "name_nodes")

    @property
    @pulumi.getter(name="qopConfiguration")
    def qop_configuration(self) -> pulumi.Output['outputs.LocationHdfsQopConfiguration']:
        """
        The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
        """
        return pulumi.get(self, "qop_configuration")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
        """
        return pulumi.get(self, "replication_factor")

    @property
    @pulumi.getter(name="simpleUser")
    def simple_user(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
        """
        return pulumi.get(self, "simple_user")

    @property
    @pulumi.getter
    def subdirectory(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
        """
        return pulumi.get(self, "subdirectory")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "uri")

