# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'EfsLocationEc2Config',
    'FsxOpenZfsFileSystemProtocol',
    'FsxOpenZfsFileSystemProtocolNfs',
    'FsxOpenZfsFileSystemProtocolNfsMountOptions',
    'LocationAzureBlobSasConfiguration',
    'LocationFsxOntapFileSystemProtocol',
    'LocationFsxOntapFileSystemProtocolNfs',
    'LocationFsxOntapFileSystemProtocolNfsMountOptions',
    'LocationFsxOntapFileSystemProtocolSmb',
    'LocationFsxOntapFileSystemProtocolSmbMountOptions',
    'LocationHdfsNameNode',
    'LocationHdfsQopConfiguration',
    'LocationSmbMountOptions',
    'NfsLocationMountOptions',
    'NfsLocationOnPremConfig',
    'S3LocationS3Config',
    'TaskExcludes',
    'TaskIncludes',
    'TaskOptions',
    'TaskSchedule',
    'TaskTaskReportConfig',
    'TaskTaskReportConfigReportOverrides',
    'TaskTaskReportConfigS3Destination',
]

@pulumi.output_type
class EfsLocationEc2Config(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupArns":
            suggest = "security_group_arns"
        elif key == "subnetArn":
            suggest = "subnet_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EfsLocationEc2Config. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EfsLocationEc2Config.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EfsLocationEc2Config.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_arns: Sequence[builtins.str],
                 subnet_arn: builtins.str):
        """
        :param Sequence[builtins.str] security_group_arns: List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
        :param builtins.str subnet_arn: Amazon Resource Name (ARN) of the EC2 Subnet that is associated with the EFS Mount Target.
        """
        pulumi.set(__self__, "security_group_arns", security_group_arns)
        pulumi.set(__self__, "subnet_arn", subnet_arn)

    @property
    @pulumi.getter(name="securityGroupArns")
    def security_group_arns(self) -> Sequence[builtins.str]:
        """
        List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
        """
        return pulumi.get(self, "security_group_arns")

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> builtins.str:
        """
        Amazon Resource Name (ARN) of the EC2 Subnet that is associated with the EFS Mount Target.
        """
        return pulumi.get(self, "subnet_arn")


@pulumi.output_type
class FsxOpenZfsFileSystemProtocol(dict):
    def __init__(__self__, *,
                 nfs: 'outputs.FsxOpenZfsFileSystemProtocolNfs'):
        """
        :param 'FsxOpenZfsFileSystemProtocolNfsArgs' nfs: Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system. See below.
        """
        pulumi.set(__self__, "nfs", nfs)

    @property
    @pulumi.getter
    def nfs(self) -> 'outputs.FsxOpenZfsFileSystemProtocolNfs':
        """
        Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system. See below.
        """
        return pulumi.get(self, "nfs")


@pulumi.output_type
class FsxOpenZfsFileSystemProtocolNfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsxOpenZfsFileSystemProtocolNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsxOpenZfsFileSystemProtocolNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsxOpenZfsFileSystemProtocolNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_options: 'outputs.FsxOpenZfsFileSystemProtocolNfsMountOptions'):
        """
        :param 'FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs' mount_options: Represents the mount options that are available for DataSync to access an NFS location. See below.
        """
        pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> 'outputs.FsxOpenZfsFileSystemProtocolNfsMountOptions':
        """
        Represents the mount options that are available for DataSync to access an NFS location. See below.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class FsxOpenZfsFileSystemProtocolNfsMountOptions(dict):
    def __init__(__self__, *,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str version: The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LocationAzureBlobSasConfiguration(dict):
    def __init__(__self__, *,
                 token: builtins.str):
        """
        :param builtins.str token: A SAS token that provides permissions to access your Azure Blob Storage.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> builtins.str:
        """
        A SAS token that provides permissions to access your Azure Blob Storage.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class LocationFsxOntapFileSystemProtocol(dict):
    def __init__(__self__, *,
                 nfs: Optional['outputs.LocationFsxOntapFileSystemProtocolNfs'] = None,
                 smb: Optional['outputs.LocationFsxOntapFileSystemProtocolSmb'] = None):
        """
        :param 'LocationFsxOntapFileSystemProtocolNfsArgs' nfs: Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
        :param 'LocationFsxOntapFileSystemProtocolSmbArgs' smb: Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
        """
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if smb is not None:
            pulumi.set(__self__, "smb", smb)

    @property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.LocationFsxOntapFileSystemProtocolNfs']:
        """
        Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter
    def smb(self) -> Optional['outputs.LocationFsxOntapFileSystemProtocolSmb']:
        """
        Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
        """
        return pulumi.get(self, "smb")


@pulumi.output_type
class LocationFsxOntapFileSystemProtocolNfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationFsxOntapFileSystemProtocolNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationFsxOntapFileSystemProtocolNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationFsxOntapFileSystemProtocolNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_options: 'outputs.LocationFsxOntapFileSystemProtocolNfsMountOptions'):
        """
        :param 'LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs' mount_options: Mount options that are available for DataSync to access an NFS location. See NFS Mount Options below.
        """
        pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> 'outputs.LocationFsxOntapFileSystemProtocolNfsMountOptions':
        """
        Mount options that are available for DataSync to access an NFS location. See NFS Mount Options below.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class LocationFsxOntapFileSystemProtocolNfsMountOptions(dict):
    def __init__(__self__, *,
                 version: Optional[builtins.str] = None):
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class LocationFsxOntapFileSystemProtocolSmb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationFsxOntapFileSystemProtocolSmb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationFsxOntapFileSystemProtocolSmb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationFsxOntapFileSystemProtocolSmb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_options: 'outputs.LocationFsxOntapFileSystemProtocolSmbMountOptions',
                 password: builtins.str,
                 user: builtins.str,
                 domain: Optional[builtins.str] = None):
        """
        :param 'LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs' mount_options: Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
        :param builtins.str password: Password of a user who has permission to access your SVM.
        :param builtins.str user: Username that can mount the location and access the files, folders, and metadata that you need in the SVM.
        :param builtins.str domain: Fully qualified domain name of the Microsoft Active Directory (AD) that your storage virtual machine belongs to.
        """
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> 'outputs.LocationFsxOntapFileSystemProtocolSmbMountOptions':
        """
        Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Password of a user who has permission to access your SVM.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> builtins.str:
        """
        Username that can mount the location and access the files, folders, and metadata that you need in the SVM.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        Fully qualified domain name of the Microsoft Active Directory (AD) that your storage virtual machine belongs to.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class LocationFsxOntapFileSystemProtocolSmbMountOptions(dict):
    def __init__(__self__, *,
                 version: Optional[builtins.str] = None):
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class LocationHdfsNameNode(dict):
    def __init__(__self__, *,
                 hostname: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str hostname: The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
        :param builtins.int port: The port that the NameNode uses to listen to client requests.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port that the NameNode uses to listen to client requests.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class LocationHdfsQopConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataTransferProtection":
            suggest = "data_transfer_protection"
        elif key == "rpcProtection":
            suggest = "rpc_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationHdfsQopConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationHdfsQopConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationHdfsQopConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_transfer_protection: Optional[builtins.str] = None,
                 rpc_protection: Optional[builtins.str] = None):
        """
        :param builtins.str data_transfer_protection: The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        :param builtins.str rpc_protection: The RPC protection setting configured on the HDFS cluster. This setting corresponds to your hadoop.rpc.protection setting in your core-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        """
        if data_transfer_protection is not None:
            pulumi.set(__self__, "data_transfer_protection", data_transfer_protection)
        if rpc_protection is not None:
            pulumi.set(__self__, "rpc_protection", rpc_protection)

    @property
    @pulumi.getter(name="dataTransferProtection")
    def data_transfer_protection(self) -> Optional[builtins.str]:
        """
        The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        """
        return pulumi.get(self, "data_transfer_protection")

    @property
    @pulumi.getter(name="rpcProtection")
    def rpc_protection(self) -> Optional[builtins.str]:
        """
        The RPC protection setting configured on the HDFS cluster. This setting corresponds to your hadoop.rpc.protection setting in your core-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
        """
        return pulumi.get(self, "rpc_protection")


@pulumi.output_type
class LocationSmbMountOptions(dict):
    def __init__(__self__, *,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str version: The specific SMB version that you want DataSync to use for mounting your SMB share. Valid values: `AUTOMATIC`, `SMB2`, and `SMB3`. Default: `AUTOMATIC`
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The specific SMB version that you want DataSync to use for mounting your SMB share. Valid values: `AUTOMATIC`, `SMB2`, and `SMB3`. Default: `AUTOMATIC`
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class NfsLocationMountOptions(dict):
    def __init__(__self__, *,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str version: The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class NfsLocationOnPremConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentArns":
            suggest = "agent_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NfsLocationOnPremConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NfsLocationOnPremConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NfsLocationOnPremConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_arns: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] agent_arns: List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
        """
        pulumi.set(__self__, "agent_arns", agent_arns)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> Sequence[builtins.str]:
        """
        List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
        """
        return pulumi.get(self, "agent_arns")


@pulumi.output_type
class S3LocationS3Config(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketAccessRoleArn":
            suggest = "bucket_access_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in S3LocationS3Config. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        S3LocationS3Config.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        S3LocationS3Config.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_access_role_arn: builtins.str):
        """
        :param builtins.str bucket_access_role_arn: ARN of the IAM Role used to connect to the S3 Bucket.
        """
        pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> builtins.str:
        """
        ARN of the IAM Role used to connect to the S3 Bucket.
        """
        return pulumi.get(self, "bucket_access_role_arn")


@pulumi.output_type
class TaskExcludes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskExcludes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskExcludes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskExcludes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_type: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str filter_type: The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        :param builtins.str value: A single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[builtins.str]:
        """
        The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        A single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskIncludes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskIncludes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskIncludes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskIncludes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_type: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str filter_type: The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        :param builtins.str value: A single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[builtins.str]:
        """
        The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        A single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bytesPerSecond":
            suggest = "bytes_per_second"
        elif key == "logLevel":
            suggest = "log_level"
        elif key == "objectTags":
            suggest = "object_tags"
        elif key == "overwriteMode":
            suggest = "overwrite_mode"
        elif key == "posixPermissions":
            suggest = "posix_permissions"
        elif key == "preserveDeletedFiles":
            suggest = "preserve_deleted_files"
        elif key == "preserveDevices":
            suggest = "preserve_devices"
        elif key == "securityDescriptorCopyFlags":
            suggest = "security_descriptor_copy_flags"
        elif key == "taskQueueing":
            suggest = "task_queueing"
        elif key == "transferMode":
            suggest = "transfer_mode"
        elif key == "verifyMode":
            suggest = "verify_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 atime: Optional[builtins.str] = None,
                 bytes_per_second: Optional[builtins.int] = None,
                 gid: Optional[builtins.str] = None,
                 log_level: Optional[builtins.str] = None,
                 mtime: Optional[builtins.str] = None,
                 object_tags: Optional[builtins.str] = None,
                 overwrite_mode: Optional[builtins.str] = None,
                 posix_permissions: Optional[builtins.str] = None,
                 preserve_deleted_files: Optional[builtins.str] = None,
                 preserve_devices: Optional[builtins.str] = None,
                 security_descriptor_copy_flags: Optional[builtins.str] = None,
                 task_queueing: Optional[builtins.str] = None,
                 transfer_mode: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None,
                 verify_mode: Optional[builtins.str] = None):
        """
        :param builtins.str atime: A file metadata that shows the last time a file was accessed (that is when the file was read or written to). If set to `BEST_EFFORT`, the DataSync Task attempts to preserve the original (that is, the version before sync `PREPARING` phase) `atime` attribute on all source files. Valid values: `BEST_EFFORT`, `NONE`. Default: `BEST_EFFORT`.
        :param builtins.int bytes_per_second: Limits the bandwidth utilized. For example, to set a maximum of 1 MB, set this value to `1048576`. Value values: `-1` or greater. Default: `-1` (unlimited).
        :param builtins.str gid: Group identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        :param builtins.str log_level: Determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. Valid values: `OFF`, `BASIC`, `TRANSFER`. Default: `OFF`.
        :param builtins.str mtime: A file metadata that indicates the last time a file was modified (written to) before the sync `PREPARING` phase. Value values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        :param builtins.str object_tags: Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the NONE value. Valid values: `PRESERVE`, `NONE`. Default value: `PRESERVE`.
        :param builtins.str overwrite_mode: Determines whether files at the destination should be overwritten or preserved when copying files. Valid values: `ALWAYS`, `NEVER`. Default: `ALWAYS`.
        :param builtins.str posix_permissions: Determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. Valid values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        :param builtins.str preserve_deleted_files: Whether files deleted in the source should be removed or preserved in the destination file system. Valid values: `PRESERVE`, `REMOVE`. Default: `PRESERVE`.
        :param builtins.str preserve_devices: Whether the DataSync Task should preserve the metadata of block and character devices in the source files system, and recreate the files with that device name and metadata on the destination. The DataSync Task can’t sync the actual contents of such devices, because many of the devices are non-terminal and don’t return an end of file (EOF) marker. Valid values: `NONE`, `PRESERVE`. Default: `NONE` (ignore special devices).
        :param builtins.str security_descriptor_copy_flags: Determines which components of the SMB security descriptor are copied from source to destination objects. This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. Valid values: `NONE`, `OWNER_DACL`, `OWNER_DACL_SACL`. Default: `OWNER_DACL`.
        :param builtins.str task_queueing: Determines whether tasks should be queued before executing the tasks. Valid values: `ENABLED`, `DISABLED`. Default `ENABLED`.
        :param builtins.str transfer_mode: Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. Valid values: `CHANGED`, `ALL`. Default: `CHANGED`
        :param builtins.str uid: User identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        :param builtins.str verify_mode: Whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. Valid values: `NONE`, `POINT_IN_TIME_CONSISTENT`, `ONLY_FILES_TRANSFERRED`. Default: `POINT_IN_TIME_CONSISTENT`.
        """
        if atime is not None:
            pulumi.set(__self__, "atime", atime)
        if bytes_per_second is not None:
            pulumi.set(__self__, "bytes_per_second", bytes_per_second)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if mtime is not None:
            pulumi.set(__self__, "mtime", mtime)
        if object_tags is not None:
            pulumi.set(__self__, "object_tags", object_tags)
        if overwrite_mode is not None:
            pulumi.set(__self__, "overwrite_mode", overwrite_mode)
        if posix_permissions is not None:
            pulumi.set(__self__, "posix_permissions", posix_permissions)
        if preserve_deleted_files is not None:
            pulumi.set(__self__, "preserve_deleted_files", preserve_deleted_files)
        if preserve_devices is not None:
            pulumi.set(__self__, "preserve_devices", preserve_devices)
        if security_descriptor_copy_flags is not None:
            pulumi.set(__self__, "security_descriptor_copy_flags", security_descriptor_copy_flags)
        if task_queueing is not None:
            pulumi.set(__self__, "task_queueing", task_queueing)
        if transfer_mode is not None:
            pulumi.set(__self__, "transfer_mode", transfer_mode)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if verify_mode is not None:
            pulumi.set(__self__, "verify_mode", verify_mode)

    @property
    @pulumi.getter
    def atime(self) -> Optional[builtins.str]:
        """
        A file metadata that shows the last time a file was accessed (that is when the file was read or written to). If set to `BEST_EFFORT`, the DataSync Task attempts to preserve the original (that is, the version before sync `PREPARING` phase) `atime` attribute on all source files. Valid values: `BEST_EFFORT`, `NONE`. Default: `BEST_EFFORT`.
        """
        return pulumi.get(self, "atime")

    @property
    @pulumi.getter(name="bytesPerSecond")
    def bytes_per_second(self) -> Optional[builtins.int]:
        """
        Limits the bandwidth utilized. For example, to set a maximum of 1 MB, set this value to `1048576`. Value values: `-1` or greater. Default: `-1` (unlimited).
        """
        return pulumi.get(self, "bytes_per_second")

    @property
    @pulumi.getter
    def gid(self) -> Optional[builtins.str]:
        """
        Group identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[builtins.str]:
        """
        Determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. Valid values: `OFF`, `BASIC`, `TRANSFER`. Default: `OFF`.
        """
        return pulumi.get(self, "log_level")

    @property
    @pulumi.getter
    def mtime(self) -> Optional[builtins.str]:
        """
        A file metadata that indicates the last time a file was modified (written to) before the sync `PREPARING` phase. Value values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        """
        return pulumi.get(self, "mtime")

    @property
    @pulumi.getter(name="objectTags")
    def object_tags(self) -> Optional[builtins.str]:
        """
        Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the NONE value. Valid values: `PRESERVE`, `NONE`. Default value: `PRESERVE`.
        """
        return pulumi.get(self, "object_tags")

    @property
    @pulumi.getter(name="overwriteMode")
    def overwrite_mode(self) -> Optional[builtins.str]:
        """
        Determines whether files at the destination should be overwritten or preserved when copying files. Valid values: `ALWAYS`, `NEVER`. Default: `ALWAYS`.
        """
        return pulumi.get(self, "overwrite_mode")

    @property
    @pulumi.getter(name="posixPermissions")
    def posix_permissions(self) -> Optional[builtins.str]:
        """
        Determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. Valid values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
        """
        return pulumi.get(self, "posix_permissions")

    @property
    @pulumi.getter(name="preserveDeletedFiles")
    def preserve_deleted_files(self) -> Optional[builtins.str]:
        """
        Whether files deleted in the source should be removed or preserved in the destination file system. Valid values: `PRESERVE`, `REMOVE`. Default: `PRESERVE`.
        """
        return pulumi.get(self, "preserve_deleted_files")

    @property
    @pulumi.getter(name="preserveDevices")
    def preserve_devices(self) -> Optional[builtins.str]:
        """
        Whether the DataSync Task should preserve the metadata of block and character devices in the source files system, and recreate the files with that device name and metadata on the destination. The DataSync Task can’t sync the actual contents of such devices, because many of the devices are non-terminal and don’t return an end of file (EOF) marker. Valid values: `NONE`, `PRESERVE`. Default: `NONE` (ignore special devices).
        """
        return pulumi.get(self, "preserve_devices")

    @property
    @pulumi.getter(name="securityDescriptorCopyFlags")
    def security_descriptor_copy_flags(self) -> Optional[builtins.str]:
        """
        Determines which components of the SMB security descriptor are copied from source to destination objects. This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. Valid values: `NONE`, `OWNER_DACL`, `OWNER_DACL_SACL`. Default: `OWNER_DACL`.
        """
        return pulumi.get(self, "security_descriptor_copy_flags")

    @property
    @pulumi.getter(name="taskQueueing")
    def task_queueing(self) -> Optional[builtins.str]:
        """
        Determines whether tasks should be queued before executing the tasks. Valid values: `ENABLED`, `DISABLED`. Default `ENABLED`.
        """
        return pulumi.get(self, "task_queueing")

    @property
    @pulumi.getter(name="transferMode")
    def transfer_mode(self) -> Optional[builtins.str]:
        """
        Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. Valid values: `CHANGED`, `ALL`. Default: `CHANGED`
        """
        return pulumi.get(self, "transfer_mode")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        User identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="verifyMode")
    def verify_mode(self) -> Optional[builtins.str]:
        """
        Whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. Valid values: `NONE`, `POINT_IN_TIME_CONSISTENT`, `ONLY_FILES_TRANSFERRED`. Default: `POINT_IN_TIME_CONSISTENT`.
        """
        return pulumi.get(self, "verify_mode")


@pulumi.output_type
class TaskSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: builtins.str):
        """
        :param builtins.str schedule_expression: Specifies the schedule you want your task to use for repeated executions. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> builtins.str:
        """
        Specifies the schedule you want your task to use for repeated executions. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class TaskTaskReportConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Destination":
            suggest = "s3_destination"
        elif key == "outputType":
            suggest = "output_type"
        elif key == "reportLevel":
            suggest = "report_level"
        elif key == "reportOverrides":
            suggest = "report_overrides"
        elif key == "s3ObjectVersioning":
            suggest = "s3_object_versioning"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskTaskReportConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskTaskReportConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskTaskReportConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_destination: 'outputs.TaskTaskReportConfigS3Destination',
                 output_type: Optional[builtins.str] = None,
                 report_level: Optional[builtins.str] = None,
                 report_overrides: Optional['outputs.TaskTaskReportConfigReportOverrides'] = None,
                 s3_object_versioning: Optional[builtins.str] = None):
        """
        :param 'TaskTaskReportConfigS3DestinationArgs' s3_destination: Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
        :param builtins.str output_type: Specifies the type of task report you'd like. Valid values: `SUMMARY_ONLY` and `STANDARD`.
        :param builtins.str report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        :param 'TaskTaskReportConfigReportOverridesArgs' report_overrides: Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
        :param builtins.str s3_object_versioning: Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you enable versioning on your bucket. Keep in mind that setting this to INCLUDE can increase the duration of your task execution. Valid values: `INCLUDE` and `NONE`.
        """
        pulumi.set(__self__, "s3_destination", s3_destination)
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)
        if report_overrides is not None:
            pulumi.set(__self__, "report_overrides", report_overrides)
        if s3_object_versioning is not None:
            pulumi.set(__self__, "s3_object_versioning", s3_object_versioning)

    @property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> 'outputs.TaskTaskReportConfigS3Destination':
        """
        Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
        """
        return pulumi.get(self, "s3_destination")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[builtins.str]:
        """
        Specifies the type of task report you'd like. Valid values: `SUMMARY_ONLY` and `STANDARD`.
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional[builtins.str]:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        return pulumi.get(self, "report_level")

    @property
    @pulumi.getter(name="reportOverrides")
    def report_overrides(self) -> Optional['outputs.TaskTaskReportConfigReportOverrides']:
        """
        Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
        """
        return pulumi.get(self, "report_overrides")

    @property
    @pulumi.getter(name="s3ObjectVersioning")
    def s3_object_versioning(self) -> Optional[builtins.str]:
        """
        Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you enable versioning on your bucket. Keep in mind that setting this to INCLUDE can increase the duration of your task execution. Valid values: `INCLUDE` and `NONE`.
        """
        return pulumi.get(self, "s3_object_versioning")


@pulumi.output_type
class TaskTaskReportConfigReportOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deletedOverride":
            suggest = "deleted_override"
        elif key == "skippedOverride":
            suggest = "skipped_override"
        elif key == "transferredOverride":
            suggest = "transferred_override"
        elif key == "verifiedOverride":
            suggest = "verified_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskTaskReportConfigReportOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskTaskReportConfigReportOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskTaskReportConfigReportOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deleted_override: Optional[builtins.str] = None,
                 skipped_override: Optional[builtins.str] = None,
                 transferred_override: Optional[builtins.str] = None,
                 verified_override: Optional[builtins.str] = None):
        """
        :param builtins.str deleted_override: Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        :param builtins.str skipped_override: Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        :param builtins.str transferred_override: Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        :param builtins.str verified_override: Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
               
               > **NOTE:** If any `report_overrides` are set to the same value as `task_report_config.report_level`, they will always be flagged as changed. Only set overrides to a value that differs from `task_report_config.report_level`.
        """
        if deleted_override is not None:
            pulumi.set(__self__, "deleted_override", deleted_override)
        if skipped_override is not None:
            pulumi.set(__self__, "skipped_override", skipped_override)
        if transferred_override is not None:
            pulumi.set(__self__, "transferred_override", transferred_override)
        if verified_override is not None:
            pulumi.set(__self__, "verified_override", verified_override)

    @property
    @pulumi.getter(name="deletedOverride")
    def deleted_override(self) -> Optional[builtins.str]:
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        return pulumi.get(self, "deleted_override")

    @property
    @pulumi.getter(name="skippedOverride")
    def skipped_override(self) -> Optional[builtins.str]:
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        return pulumi.get(self, "skipped_override")

    @property
    @pulumi.getter(name="transferredOverride")
    def transferred_override(self) -> Optional[builtins.str]:
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
        """
        return pulumi.get(self, "transferred_override")

    @property
    @pulumi.getter(name="verifiedOverride")
    def verified_override(self) -> Optional[builtins.str]:
        """
        Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.

        > **NOTE:** If any `report_overrides` are set to the same value as `task_report_config.report_level`, they will always be flagged as changed. Only set overrides to a value that differs from `task_report_config.report_level`.
        """
        return pulumi.get(self, "verified_override")


@pulumi.output_type
class TaskTaskReportConfigS3Destination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketAccessRoleArn":
            suggest = "bucket_access_role_arn"
        elif key == "s3BucketArn":
            suggest = "s3_bucket_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskTaskReportConfigS3Destination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskTaskReportConfigS3Destination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskTaskReportConfigS3Destination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_access_role_arn: builtins.str,
                 s3_bucket_arn: builtins.str,
                 subdirectory: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_access_role_arn: Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket.
        :param builtins.str s3_bucket_arn: Specifies the ARN of the S3 bucket where DataSync uploads your report.
        :param builtins.str subdirectory: Specifies a bucket prefix for your report.
        """
        pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)
        pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> builtins.str:
        """
        Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket.
        """
        return pulumi.get(self, "bucket_access_role_arn")

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> builtins.str:
        """
        Specifies the ARN of the S3 bucket where DataSync uploads your report.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[builtins.str]:
        """
        Specifies a bucket prefix for your report.
        """
        return pulumi.get(self, "subdirectory")


