# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TaskArgs', 'Task']

@pulumi.input_type
class TaskArgs:
    def __init__(__self__, *,
                 destination_location_arn: pulumi.Input[builtins.str],
                 source_location_arn: pulumi.Input[builtins.str],
                 cloudwatch_log_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input['TaskExcludesArgs']] = None,
                 includes: Optional[pulumi.Input['TaskIncludesArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input['TaskOptionsArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['TaskScheduleArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 task_mode: Optional[pulumi.Input[builtins.str]] = None,
                 task_report_config: Optional[pulumi.Input['TaskTaskReportConfigArgs']] = None):
        """
        The set of arguments for constructing a Task resource.
        :param pulumi.Input[builtins.str] destination_location_arn: Amazon Resource Name (ARN) of destination DataSync Location.
        :param pulumi.Input[builtins.str] source_location_arn: Amazon Resource Name (ARN) of source DataSync Location.
        :param pulumi.Input[builtins.str] cloudwatch_log_group_arn: Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
        :param pulumi.Input['TaskExcludesArgs'] excludes: Filter rules that determines which files to exclude from a task.
        :param pulumi.Input['TaskIncludesArgs'] includes: Filter rules that determines which files to include in a task.
        :param pulumi.Input[builtins.str] name: Name of the DataSync Task.
        :param pulumi.Input['TaskOptionsArgs'] options: Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['TaskScheduleArgs'] schedule: Specifies a schedule used to periodically transfer files from a source to a destination location.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] task_mode: One of the following task modes for your data transfer:
               * `BASIC` (default) - Transfer files or objects between Amazon Web Services storage and on-premises, edge, or other cloud storage.
               * `ENHANCED` - Transfer virtually unlimited numbers of objects with enhanced metrics, more detailed logs, and higher performance than Basic mode. Currently available for transfers between Amazon S3 locations.
        :param pulumi.Input['TaskTaskReportConfigArgs'] task_report_config: Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
        """
        pulumi.set(__self__, "destination_location_arn", destination_location_arn)
        pulumi.set(__self__, "source_location_arn", source_location_arn)
        if cloudwatch_log_group_arn is not None:
            pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_mode is not None:
            pulumi.set(__self__, "task_mode", task_mode)
        if task_report_config is not None:
            pulumi.set(__self__, "task_report_config", task_report_config)

    @property
    @pulumi.getter(name="destinationLocationArn")
    def destination_location_arn(self) -> pulumi.Input[builtins.str]:
        """
        Amazon Resource Name (ARN) of destination DataSync Location.
        """
        return pulumi.get(self, "destination_location_arn")

    @destination_location_arn.setter
    def destination_location_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_location_arn", value)

    @property
    @pulumi.getter(name="sourceLocationArn")
    def source_location_arn(self) -> pulumi.Input[builtins.str]:
        """
        Amazon Resource Name (ARN) of source DataSync Location.
        """
        return pulumi.get(self, "source_location_arn")

    @source_location_arn.setter
    def source_location_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_location_arn", value)

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @cloudwatch_log_group_arn.setter
    def cloudwatch_log_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloudwatch_log_group_arn", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input['TaskExcludesArgs']]:
        """
        Filter rules that determines which files to exclude from a task.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input['TaskExcludesArgs']]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input['TaskIncludesArgs']]:
        """
        Filter rules that determines which files to include in a task.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input['TaskIncludesArgs']]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the DataSync Task.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['TaskOptionsArgs']]:
        """
        Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['TaskOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TaskScheduleArgs']]:
        """
        Specifies a schedule used to periodically transfer files from a source to a destination location.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TaskScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="taskMode")
    def task_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        One of the following task modes for your data transfer:
        * `BASIC` (default) - Transfer files or objects between Amazon Web Services storage and on-premises, edge, or other cloud storage.
        * `ENHANCED` - Transfer virtually unlimited numbers of objects with enhanced metrics, more detailed logs, and higher performance than Basic mode. Currently available for transfers between Amazon S3 locations.
        """
        return pulumi.get(self, "task_mode")

    @task_mode.setter
    def task_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_mode", value)

    @property
    @pulumi.getter(name="taskReportConfig")
    def task_report_config(self) -> Optional[pulumi.Input['TaskTaskReportConfigArgs']]:
        """
        Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
        """
        return pulumi.get(self, "task_report_config")

    @task_report_config.setter
    def task_report_config(self, value: Optional[pulumi.Input['TaskTaskReportConfigArgs']]):
        pulumi.set(self, "task_report_config", value)


@pulumi.input_type
class _TaskState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 cloudwatch_log_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_location_arn: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input['TaskExcludesArgs']] = None,
                 includes: Optional[pulumi.Input['TaskIncludesArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input['TaskOptionsArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['TaskScheduleArgs']] = None,
                 source_location_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 task_mode: Optional[pulumi.Input[builtins.str]] = None,
                 task_report_config: Optional[pulumi.Input['TaskTaskReportConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Task resources.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the DataSync Task.
        :param pulumi.Input[builtins.str] cloudwatch_log_group_arn: Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
        :param pulumi.Input[builtins.str] destination_location_arn: Amazon Resource Name (ARN) of destination DataSync Location.
        :param pulumi.Input['TaskExcludesArgs'] excludes: Filter rules that determines which files to exclude from a task.
        :param pulumi.Input['TaskIncludesArgs'] includes: Filter rules that determines which files to include in a task.
        :param pulumi.Input[builtins.str] name: Name of the DataSync Task.
        :param pulumi.Input['TaskOptionsArgs'] options: Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['TaskScheduleArgs'] schedule: Specifies a schedule used to periodically transfer files from a source to a destination location.
        :param pulumi.Input[builtins.str] source_location_arn: Amazon Resource Name (ARN) of source DataSync Location.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] task_mode: One of the following task modes for your data transfer:
               * `BASIC` (default) - Transfer files or objects between Amazon Web Services storage and on-premises, edge, or other cloud storage.
               * `ENHANCED` - Transfer virtually unlimited numbers of objects with enhanced metrics, more detailed logs, and higher performance than Basic mode. Currently available for transfers between Amazon S3 locations.
        :param pulumi.Input['TaskTaskReportConfigArgs'] task_report_config: Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cloudwatch_log_group_arn is not None:
            pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        if destination_location_arn is not None:
            pulumi.set(__self__, "destination_location_arn", destination_location_arn)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if source_location_arn is not None:
            pulumi.set(__self__, "source_location_arn", source_location_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if task_mode is not None:
            pulumi.set(__self__, "task_mode", task_mode)
        if task_report_config is not None:
            pulumi.set(__self__, "task_report_config", task_report_config)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the DataSync Task.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @cloudwatch_log_group_arn.setter
    def cloudwatch_log_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloudwatch_log_group_arn", value)

    @property
    @pulumi.getter(name="destinationLocationArn")
    def destination_location_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of destination DataSync Location.
        """
        return pulumi.get(self, "destination_location_arn")

    @destination_location_arn.setter
    def destination_location_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_location_arn", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input['TaskExcludesArgs']]:
        """
        Filter rules that determines which files to exclude from a task.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input['TaskExcludesArgs']]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input['TaskIncludesArgs']]:
        """
        Filter rules that determines which files to include in a task.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input['TaskIncludesArgs']]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the DataSync Task.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['TaskOptionsArgs']]:
        """
        Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['TaskOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TaskScheduleArgs']]:
        """
        Specifies a schedule used to periodically transfer files from a source to a destination location.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TaskScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="sourceLocationArn")
    def source_location_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of source DataSync Location.
        """
        return pulumi.get(self, "source_location_arn")

    @source_location_arn.setter
    def source_location_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_location_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="taskMode")
    def task_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        One of the following task modes for your data transfer:
        * `BASIC` (default) - Transfer files or objects between Amazon Web Services storage and on-premises, edge, or other cloud storage.
        * `ENHANCED` - Transfer virtually unlimited numbers of objects with enhanced metrics, more detailed logs, and higher performance than Basic mode. Currently available for transfers between Amazon S3 locations.
        """
        return pulumi.get(self, "task_mode")

    @task_mode.setter
    def task_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_mode", value)

    @property
    @pulumi.getter(name="taskReportConfig")
    def task_report_config(self) -> Optional[pulumi.Input['TaskTaskReportConfigArgs']]:
        """
        Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
        """
        return pulumi.get(self, "task_report_config")

    @task_report_config.setter
    def task_report_config(self, value: Optional[pulumi.Input['TaskTaskReportConfigArgs']]):
        pulumi.set(self, "task_report_config", value)


@pulumi.type_token("aws:datasync/task:Task")
class Task(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloudwatch_log_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_location_arn: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Union['TaskExcludesArgs', 'TaskExcludesArgsDict']]] = None,
                 includes: Optional[pulumi.Input[Union['TaskIncludesArgs', 'TaskIncludesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['TaskOptionsArgs', 'TaskOptionsArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']]] = None,
                 source_location_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 task_mode: Optional[pulumi.Input[builtins.str]] = None,
                 task_report_config: Optional[pulumi.Input[Union['TaskTaskReportConfigArgs', 'TaskTaskReportConfigArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AWS DataSync Task, which represents a configuration for synchronization. Starting an execution of these DataSync Tasks (actually synchronizing files) is performed outside of this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.Task("example",
            destination_location_arn=destination["arn"],
            name="example",
            source_location_arn=source["arn"],
            options={
                "bytes_per_second": -1,
            })
        ```

        ### With Scheduling

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.Task("example",
            destination_location_arn=destination["arn"],
            name="example",
            source_location_arn=source["arn"],
            schedule={
                "schedule_expression": "cron(0 12 ? * SUN,WED *)",
            })
        ```

        ### With Filtering

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.Task("example",
            destination_location_arn=destination["arn"],
            name="example",
            source_location_arn=source["arn"],
            excludes={
                "filter_type": "SIMPLE_PATTERN",
                "value": "/folder1|/folder2",
            },
            includes={
                "filter_type": "SIMPLE_PATTERN",
                "value": "/folder1|/folder2",
            })
        ```

        ### With Enhanced Task Mode

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.Task("example",
            destination_location_arn=destination["arn"],
            name="example",
            source_location_arn=source["arn"],
            task_mode="ENHANCED",
            options={
                "gid": "NONE",
                "posix_permissions": "NONE",
                "uid": "NONE",
                "verify_mode": "ONLY_FILES_TRANSFERRED",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_datasync_task` using the DataSync Task Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:datasync/task:Task example arn:aws:datasync:us-east-1:123456789012:task/task-12345678901234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloudwatch_log_group_arn: Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
        :param pulumi.Input[builtins.str] destination_location_arn: Amazon Resource Name (ARN) of destination DataSync Location.
        :param pulumi.Input[Union['TaskExcludesArgs', 'TaskExcludesArgsDict']] excludes: Filter rules that determines which files to exclude from a task.
        :param pulumi.Input[Union['TaskIncludesArgs', 'TaskIncludesArgsDict']] includes: Filter rules that determines which files to include in a task.
        :param pulumi.Input[builtins.str] name: Name of the DataSync Task.
        :param pulumi.Input[Union['TaskOptionsArgs', 'TaskOptionsArgsDict']] options: Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']] schedule: Specifies a schedule used to periodically transfer files from a source to a destination location.
        :param pulumi.Input[builtins.str] source_location_arn: Amazon Resource Name (ARN) of source DataSync Location.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] task_mode: One of the following task modes for your data transfer:
               * `BASIC` (default) - Transfer files or objects between Amazon Web Services storage and on-premises, edge, or other cloud storage.
               * `ENHANCED` - Transfer virtually unlimited numbers of objects with enhanced metrics, more detailed logs, and higher performance than Basic mode. Currently available for transfers between Amazon S3 locations.
        :param pulumi.Input[Union['TaskTaskReportConfigArgs', 'TaskTaskReportConfigArgsDict']] task_report_config: Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS DataSync Task, which represents a configuration for synchronization. Starting an execution of these DataSync Tasks (actually synchronizing files) is performed outside of this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.Task("example",
            destination_location_arn=destination["arn"],
            name="example",
            source_location_arn=source["arn"],
            options={
                "bytes_per_second": -1,
            })
        ```

        ### With Scheduling

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.Task("example",
            destination_location_arn=destination["arn"],
            name="example",
            source_location_arn=source["arn"],
            schedule={
                "schedule_expression": "cron(0 12 ? * SUN,WED *)",
            })
        ```

        ### With Filtering

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.Task("example",
            destination_location_arn=destination["arn"],
            name="example",
            source_location_arn=source["arn"],
            excludes={
                "filter_type": "SIMPLE_PATTERN",
                "value": "/folder1|/folder2",
            },
            includes={
                "filter_type": "SIMPLE_PATTERN",
                "value": "/folder1|/folder2",
            })
        ```

        ### With Enhanced Task Mode

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.datasync.Task("example",
            destination_location_arn=destination["arn"],
            name="example",
            source_location_arn=source["arn"],
            task_mode="ENHANCED",
            options={
                "gid": "NONE",
                "posix_permissions": "NONE",
                "uid": "NONE",
                "verify_mode": "ONLY_FILES_TRANSFERRED",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_datasync_task` using the DataSync Task Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:datasync/task:Task example arn:aws:datasync:us-east-1:123456789012:task/task-12345678901234567
        ```

        :param str resource_name: The name of the resource.
        :param TaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloudwatch_log_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_location_arn: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Union['TaskExcludesArgs', 'TaskExcludesArgsDict']]] = None,
                 includes: Optional[pulumi.Input[Union['TaskIncludesArgs', 'TaskIncludesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['TaskOptionsArgs', 'TaskOptionsArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']]] = None,
                 source_location_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 task_mode: Optional[pulumi.Input[builtins.str]] = None,
                 task_report_config: Optional[pulumi.Input[Union['TaskTaskReportConfigArgs', 'TaskTaskReportConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskArgs.__new__(TaskArgs)

            __props__.__dict__["cloudwatch_log_group_arn"] = cloudwatch_log_group_arn
            if destination_location_arn is None and not opts.urn:
                raise TypeError("Missing required property 'destination_location_arn'")
            __props__.__dict__["destination_location_arn"] = destination_location_arn
            __props__.__dict__["excludes"] = excludes
            __props__.__dict__["includes"] = includes
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["region"] = region
            __props__.__dict__["schedule"] = schedule
            if source_location_arn is None and not opts.urn:
                raise TypeError("Missing required property 'source_location_arn'")
            __props__.__dict__["source_location_arn"] = source_location_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["task_mode"] = task_mode
            __props__.__dict__["task_report_config"] = task_report_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Task, __self__).__init__(
            'aws:datasync/task:Task',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            cloudwatch_log_group_arn: Optional[pulumi.Input[builtins.str]] = None,
            destination_location_arn: Optional[pulumi.Input[builtins.str]] = None,
            excludes: Optional[pulumi.Input[Union['TaskExcludesArgs', 'TaskExcludesArgsDict']]] = None,
            includes: Optional[pulumi.Input[Union['TaskIncludesArgs', 'TaskIncludesArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            options: Optional[pulumi.Input[Union['TaskOptionsArgs', 'TaskOptionsArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']]] = None,
            source_location_arn: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            task_mode: Optional[pulumi.Input[builtins.str]] = None,
            task_report_config: Optional[pulumi.Input[Union['TaskTaskReportConfigArgs', 'TaskTaskReportConfigArgsDict']]] = None) -> 'Task':
        """
        Get an existing Task resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the DataSync Task.
        :param pulumi.Input[builtins.str] cloudwatch_log_group_arn: Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
        :param pulumi.Input[builtins.str] destination_location_arn: Amazon Resource Name (ARN) of destination DataSync Location.
        :param pulumi.Input[Union['TaskExcludesArgs', 'TaskExcludesArgsDict']] excludes: Filter rules that determines which files to exclude from a task.
        :param pulumi.Input[Union['TaskIncludesArgs', 'TaskIncludesArgsDict']] includes: Filter rules that determines which files to include in a task.
        :param pulumi.Input[builtins.str] name: Name of the DataSync Task.
        :param pulumi.Input[Union['TaskOptionsArgs', 'TaskOptionsArgsDict']] options: Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['TaskScheduleArgs', 'TaskScheduleArgsDict']] schedule: Specifies a schedule used to periodically transfer files from a source to a destination location.
        :param pulumi.Input[builtins.str] source_location_arn: Amazon Resource Name (ARN) of source DataSync Location.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] task_mode: One of the following task modes for your data transfer:
               * `BASIC` (default) - Transfer files or objects between Amazon Web Services storage and on-premises, edge, or other cloud storage.
               * `ENHANCED` - Transfer virtually unlimited numbers of objects with enhanced metrics, more detailed logs, and higher performance than Basic mode. Currently available for transfers between Amazon S3 locations.
        :param pulumi.Input[Union['TaskTaskReportConfigArgs', 'TaskTaskReportConfigArgsDict']] task_report_config: Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TaskState.__new__(_TaskState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["cloudwatch_log_group_arn"] = cloudwatch_log_group_arn
        __props__.__dict__["destination_location_arn"] = destination_location_arn
        __props__.__dict__["excludes"] = excludes
        __props__.__dict__["includes"] = includes
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["region"] = region
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["source_location_arn"] = source_location_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["task_mode"] = task_mode
        __props__.__dict__["task_report_config"] = task_report_config
        return Task(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the DataSync Task.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @property
    @pulumi.getter(name="destinationLocationArn")
    def destination_location_arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of destination DataSync Location.
        """
        return pulumi.get(self, "destination_location_arn")

    @property
    @pulumi.getter
    def excludes(self) -> pulumi.Output[Optional['outputs.TaskExcludes']]:
        """
        Filter rules that determines which files to exclude from a task.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> pulumi.Output[Optional['outputs.TaskIncludes']]:
        """
        Filter rules that determines which files to include in a task.
        """
        return pulumi.get(self, "includes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the DataSync Task.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional['outputs.TaskOptions']]:
        """
        Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.TaskSchedule']]:
        """
        Specifies a schedule used to periodically transfer files from a source to a destination location.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="sourceLocationArn")
    def source_location_arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of source DataSync Location.
        """
        return pulumi.get(self, "source_location_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="taskMode")
    def task_mode(self) -> pulumi.Output[builtins.str]:
        """
        One of the following task modes for your data transfer:
        * `BASIC` (default) - Transfer files or objects between Amazon Web Services storage and on-premises, edge, or other cloud storage.
        * `ENHANCED` - Transfer virtually unlimited numbers of objects with enhanced metrics, more detailed logs, and higher performance than Basic mode. Currently available for transfers between Amazon S3 locations.
        """
        return pulumi.get(self, "task_mode")

    @property
    @pulumi.getter(name="taskReportConfig")
    def task_report_config(self) -> pulumi.Output[Optional['outputs.TaskTaskReportConfig']]:
        """
        Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
        """
        return pulumi.get(self, "task_report_config")

