# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDomainResult',
    'AwaitableGetDomainResult',
    'get_domain',
    'get_domain_output',
]

@pulumi.output_type
class GetDomainResult:
    """
    A collection of values returned by getDomain.
    """
    def __init__(__self__, arn=None, created_at=None, description=None, domain_version=None, id=None, last_updated_at=None, managed_account_id=None, name=None, portal_url=None, region=None, status=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_version and not isinstance(domain_version, str):
            raise TypeError("Expected argument 'domain_version' to be a str")
        pulumi.set(__self__, "domain_version", domain_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if managed_account_id and not isinstance(managed_account_id, str):
            raise TypeError("Expected argument 'managed_account_id' to be a str")
        pulumi.set(__self__, "managed_account_id", managed_account_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if portal_url and not isinstance(portal_url, str):
            raise TypeError("Expected argument 'portal_url' to be a str")
        pulumi.set(__self__, "portal_url", portal_url)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the Domain.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date and time the Domain was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the Domain.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainVersion")
    def domain_version(self) -> builtins.str:
        """
        Version of the Domain.
        """
        return pulumi.get(self, "domain_version")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> builtins.str:
        """
        The date and time the Domain was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter(name="managedAccountId")
    def managed_account_id(self) -> builtins.str:
        """
        The AWS account ID that owns the Domain.
        """
        return pulumi.get(self, "managed_account_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portalUrl")
    def portal_url(self) -> builtins.str:
        """
        URL of the Domain.
        """
        return pulumi.get(self, "portal_url")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the Domain.
        """
        return pulumi.get(self, "status")


class AwaitableGetDomainResult(GetDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainResult(
            arn=self.arn,
            created_at=self.created_at,
            description=self.description,
            domain_version=self.domain_version,
            id=self.id,
            last_updated_at=self.last_updated_at,
            managed_account_id=self.managed_account_id,
            name=self.name,
            portal_url=self.portal_url,
            region=self.region,
            status=self.status)


def get_domain(id: Optional[builtins.str] = None,
               name: Optional[builtins.str] = None,
               region: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainResult:
    """
    Data source for managing an AWS DataZone Domain.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.datazone.get_domain(name="example_domain")
    ```


    :param builtins.str id: ID of the Domain. One of `name` or `id` is required
    :param builtins.str name: Name of the Domain. One of `name` or `id` is required.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:datazone/getDomain:getDomain', __args__, opts=opts, typ=GetDomainResult).value

    return AwaitableGetDomainResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        domain_version=pulumi.get(__ret__, 'domain_version'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_at=pulumi.get(__ret__, 'last_updated_at'),
        managed_account_id=pulumi.get(__ret__, 'managed_account_id'),
        name=pulumi.get(__ret__, 'name'),
        portal_url=pulumi.get(__ret__, 'portal_url'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'))
def get_domain_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainResult]:
    """
    Data source for managing an AWS DataZone Domain.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.datazone.get_domain(name="example_domain")
    ```


    :param builtins.str id: ID of the Domain. One of `name` or `id` is required
    :param builtins.str name: Name of the Domain. One of `name` or `id` is required.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:datazone/getDomain:getDomain', __args__, opts=opts, typ=GetDomainResult)
    return __ret__.apply(lambda __response__: GetDomainResult(
        arn=pulumi.get(__response__, 'arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        domain_version=pulumi.get(__response__, 'domain_version'),
        id=pulumi.get(__response__, 'id'),
        last_updated_at=pulumi.get(__response__, 'last_updated_at'),
        managed_account_id=pulumi.get(__response__, 'managed_account_id'),
        name=pulumi.get(__response__, 'name'),
        portal_url=pulumi.get(__response__, 'portal_url'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status')))
