# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GlossaryArgs', 'Glossary']

@pulumi.input_type
class GlossaryArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[builtins.str],
                 owning_project_identifier: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Glossary resource.
        :param pulumi.Input[builtins.str] owning_project_identifier: ID of the project that owns business glossary. Must follow regex of ^[a-zA-Z0-9_-]{1,36}$.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] description: Description of the glossary. Must have a length between 0 and 4096.
        :param pulumi.Input[builtins.str] name: Name of the glossary. Must have length between 1 and 256.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: Status of business glossary. Valid values are DISABLED and ENABLED.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "owning_project_identifier", owning_project_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="owningProjectIdentifier")
    def owning_project_identifier(self) -> pulumi.Input[builtins.str]:
        """
        ID of the project that owns business glossary. Must follow regex of ^[a-zA-Z0-9_-]{1,36}$.

        The following arguments are optional:
        """
        return pulumi.get(self, "owning_project_identifier")

    @owning_project_identifier.setter
    def owning_project_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "owning_project_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the glossary. Must have a length between 0 and 4096.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the glossary. Must have length between 1 and 256.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of business glossary. Valid values are DISABLED and ENABLED.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _GlossaryState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owning_project_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Glossary resources.
        :param pulumi.Input[builtins.str] description: Description of the glossary. Must have a length between 0 and 4096.
        :param pulumi.Input[builtins.str] name: Name of the glossary. Must have length between 1 and 256.
        :param pulumi.Input[builtins.str] owning_project_identifier: ID of the project that owns business glossary. Must follow regex of ^[a-zA-Z0-9_-]{1,36}$.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: Status of business glossary. Valid values are DISABLED and ENABLED.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_identifier is not None:
            pulumi.set(__self__, "domain_identifier", domain_identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owning_project_identifier is not None:
            pulumi.set(__self__, "owning_project_identifier", owning_project_identifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the glossary. Must have a length between 0 and 4096.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the glossary. Must have length between 1 and 256.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="owningProjectIdentifier")
    def owning_project_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the project that owns business glossary. Must follow regex of ^[a-zA-Z0-9_-]{1,36}$.

        The following arguments are optional:
        """
        return pulumi.get(self, "owning_project_identifier")

    @owning_project_identifier.setter
    def owning_project_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owning_project_identifier", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of business glossary. Valid values are DISABLED and ENABLED.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("aws:datazone/glossary:Glossary")
class Glossary(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owning_project_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS DataZone Glossary.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        domain_execution_role = aws.iam.Role("domain_execution_role",
            name="example_name",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "datazone.amazonaws.com",
                        },
                    },
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "cloudformation.amazonaws.com",
                        },
                    },
                ],
            }),
            inline_policies=[{
                "name": "example_name",
                "policy": json.dumps({
                    "Version": "2012-10-17",
                    "Statement": [{
                        "Action": [
                            "datazone:*",
                            "ram:*",
                            "sso:*",
                            "kms:*",
                        ],
                        "Effect": "Allow",
                        "Resource": "*",
                    }],
                }),
            }])
        test = aws.datazone.Domain("test",
            name="example_name",
            domain_execution_role=domain_execution_role.arn)
        test_security_group = aws.ec2.SecurityGroup("test", name="example_name")
        test_project = aws.datazone.Project("test",
            domain_identifier=test.id,
            glossary_terms=["2N8w6XJCwZf"],
            name="example_name",
            description="desc",
            skip_deletion_check=True)
        test_glossary = aws.datazone.Glossary("test",
            description="description",
            name="example_name",
            owning_project_identifier=test_project.id,
            status="DISABLED",
            domain_identifier=test_project.domain_identifier)
        ```

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.datazone.Glossary("test",
            description="description",
            name="example_name",
            owning_project_identifier=test_aws_datazone_project["id"],
            status="DISABLED",
            domain_identifier=test_aws_datazone_project["domainIdentifier"])
        ```

        ## Import

        Using `pulumi import`, import DataZone Glossary using the import Datazone Glossary using a comma-delimited string combining the domain id, glossary id, and the id of the project it's under. For example:

        ```sh
        $ pulumi import aws:datazone/glossary:Glossary example domain-id,glossary-id,owning-project-identifier
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the glossary. Must have a length between 0 and 4096.
        :param pulumi.Input[builtins.str] name: Name of the glossary. Must have length between 1 and 256.
        :param pulumi.Input[builtins.str] owning_project_identifier: ID of the project that owns business glossary. Must follow regex of ^[a-zA-Z0-9_-]{1,36}$.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: Status of business glossary. Valid values are DISABLED and ENABLED.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlossaryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS DataZone Glossary.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        domain_execution_role = aws.iam.Role("domain_execution_role",
            name="example_name",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "datazone.amazonaws.com",
                        },
                    },
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "cloudformation.amazonaws.com",
                        },
                    },
                ],
            }),
            inline_policies=[{
                "name": "example_name",
                "policy": json.dumps({
                    "Version": "2012-10-17",
                    "Statement": [{
                        "Action": [
                            "datazone:*",
                            "ram:*",
                            "sso:*",
                            "kms:*",
                        ],
                        "Effect": "Allow",
                        "Resource": "*",
                    }],
                }),
            }])
        test = aws.datazone.Domain("test",
            name="example_name",
            domain_execution_role=domain_execution_role.arn)
        test_security_group = aws.ec2.SecurityGroup("test", name="example_name")
        test_project = aws.datazone.Project("test",
            domain_identifier=test.id,
            glossary_terms=["2N8w6XJCwZf"],
            name="example_name",
            description="desc",
            skip_deletion_check=True)
        test_glossary = aws.datazone.Glossary("test",
            description="description",
            name="example_name",
            owning_project_identifier=test_project.id,
            status="DISABLED",
            domain_identifier=test_project.domain_identifier)
        ```

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.datazone.Glossary("test",
            description="description",
            name="example_name",
            owning_project_identifier=test_aws_datazone_project["id"],
            status="DISABLED",
            domain_identifier=test_aws_datazone_project["domainIdentifier"])
        ```

        ## Import

        Using `pulumi import`, import DataZone Glossary using the import Datazone Glossary using a comma-delimited string combining the domain id, glossary id, and the id of the project it's under. For example:

        ```sh
        $ pulumi import aws:datazone/glossary:Glossary example domain-id,glossary-id,owning-project-identifier
        ```

        :param str resource_name: The name of the resource.
        :param GlossaryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlossaryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owning_project_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlossaryArgs.__new__(GlossaryArgs)

            __props__.__dict__["description"] = description
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            __props__.__dict__["name"] = name
            if owning_project_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'owning_project_identifier'")
            __props__.__dict__["owning_project_identifier"] = owning_project_identifier
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = status
        super(Glossary, __self__).__init__(
            'aws:datazone/glossary:Glossary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owning_project_identifier: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None) -> 'Glossary':
        """
        Get an existing Glossary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the glossary. Must have a length between 0 and 4096.
        :param pulumi.Input[builtins.str] name: Name of the glossary. Must have length between 1 and 256.
        :param pulumi.Input[builtins.str] owning_project_identifier: ID of the project that owns business glossary. Must follow regex of ^[a-zA-Z0-9_-]{1,36}$.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: Status of business glossary. Valid values are DISABLED and ENABLED.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlossaryState.__new__(_GlossaryState)

        __props__.__dict__["description"] = description
        __props__.__dict__["domain_identifier"] = domain_identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["owning_project_identifier"] = owning_project_identifier
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return Glossary(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the glossary. Must have a length between 0 and 4096.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the glossary. Must have length between 1 and 256.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="owningProjectIdentifier")
    def owning_project_identifier(self) -> pulumi.Output[builtins.str]:
        """
        ID of the project that owns business glossary. Must follow regex of ^[a-zA-Z0-9_-]{1,36}$.

        The following arguments are optional:
        """
        return pulumi.get(self, "owning_project_identifier")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Status of business glossary. Valid values are DISABLED and ENABLED.
        """
        return pulumi.get(self, "status")

