# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GlossaryTermArgs', 'GlossaryTerm']

@pulumi.input_type
class GlossaryTermArgs:
    def __init__(__self__, *,
                 glossary_identifier: pulumi.Input[builtins.str],
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 long_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 short_description: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 term_relations: Optional[pulumi.Input['GlossaryTermTermRelationsArgs']] = None,
                 timeouts: Optional[pulumi.Input['GlossaryTermTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a GlossaryTerm resource.
        :param pulumi.Input[builtins.str] glossary_identifier: Identifier of glossary.
        :param pulumi.Input[builtins.str] domain_identifier: Identifier of domain.
        :param pulumi.Input[builtins.str] long_description: Long description of entry.
        :param pulumi.Input[builtins.str] name: Name of glossary term.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] short_description: Short description of entry.
        :param pulumi.Input[builtins.str] status: If glossary term is ENABLED or DISABLED.
        :param pulumi.Input['GlossaryTermTermRelationsArgs'] term_relations: Object classifying the term relations through the following attributes:
        """
        pulumi.set(__self__, "glossary_identifier", glossary_identifier)
        if domain_identifier is not None:
            pulumi.set(__self__, "domain_identifier", domain_identifier)
        if long_description is not None:
            pulumi.set(__self__, "long_description", long_description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if short_description is not None:
            pulumi.set(__self__, "short_description", short_description)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if term_relations is not None:
            pulumi.set(__self__, "term_relations", term_relations)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="glossaryIdentifier")
    def glossary_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of glossary.
        """
        return pulumi.get(self, "glossary_identifier")

    @glossary_identifier.setter
    def glossary_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "glossary_identifier", value)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of domain.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Long description of entry.
        """
        return pulumi.get(self, "long_description")

    @long_description.setter
    def long_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "long_description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of glossary term.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Short description of entry.
        """
        return pulumi.get(self, "short_description")

    @short_description.setter
    def short_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "short_description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If glossary term is ENABLED or DISABLED.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="termRelations")
    def term_relations(self) -> Optional[pulumi.Input['GlossaryTermTermRelationsArgs']]:
        """
        Object classifying the term relations through the following attributes:
        """
        return pulumi.get(self, "term_relations")

    @term_relations.setter
    def term_relations(self, value: Optional[pulumi.Input['GlossaryTermTermRelationsArgs']]):
        pulumi.set(self, "term_relations", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GlossaryTermTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GlossaryTermTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _GlossaryTermState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 glossary_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 long_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 short_description: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 term_relations: Optional[pulumi.Input['GlossaryTermTermRelationsArgs']] = None,
                 timeouts: Optional[pulumi.Input['GlossaryTermTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering GlossaryTerm resources.
        :param pulumi.Input[builtins.str] created_at: Time of glossary term creation.
        :param pulumi.Input[builtins.str] created_by: Creator of glossary term.
        :param pulumi.Input[builtins.str] domain_identifier: Identifier of domain.
        :param pulumi.Input[builtins.str] glossary_identifier: Identifier of glossary.
        :param pulumi.Input[builtins.str] long_description: Long description of entry.
        :param pulumi.Input[builtins.str] name: Name of glossary term.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] short_description: Short description of entry.
        :param pulumi.Input[builtins.str] status: If glossary term is ENABLED or DISABLED.
        :param pulumi.Input['GlossaryTermTermRelationsArgs'] term_relations: Object classifying the term relations through the following attributes:
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if domain_identifier is not None:
            pulumi.set(__self__, "domain_identifier", domain_identifier)
        if glossary_identifier is not None:
            pulumi.set(__self__, "glossary_identifier", glossary_identifier)
        if long_description is not None:
            pulumi.set(__self__, "long_description", long_description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if short_description is not None:
            pulumi.set(__self__, "short_description", short_description)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if term_relations is not None:
            pulumi.set(__self__, "term_relations", term_relations)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time of glossary term creation.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creator of glossary term.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of domain.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="glossaryIdentifier")
    def glossary_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of glossary.
        """
        return pulumi.get(self, "glossary_identifier")

    @glossary_identifier.setter
    def glossary_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "glossary_identifier", value)

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Long description of entry.
        """
        return pulumi.get(self, "long_description")

    @long_description.setter
    def long_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "long_description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of glossary term.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Short description of entry.
        """
        return pulumi.get(self, "short_description")

    @short_description.setter
    def short_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "short_description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If glossary term is ENABLED or DISABLED.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="termRelations")
    def term_relations(self) -> Optional[pulumi.Input['GlossaryTermTermRelationsArgs']]:
        """
        Object classifying the term relations through the following attributes:
        """
        return pulumi.get(self, "term_relations")

    @term_relations.setter
    def term_relations(self, value: Optional[pulumi.Input['GlossaryTermTermRelationsArgs']]):
        pulumi.set(self, "term_relations", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GlossaryTermTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GlossaryTermTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:datazone/glossaryTerm:GlossaryTerm")
class GlossaryTerm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 glossary_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 long_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 short_description: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 term_relations: Optional[pulumi.Input[Union['GlossaryTermTermRelationsArgs', 'GlossaryTermTermRelationsArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['GlossaryTermTimeoutsArgs', 'GlossaryTermTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS DataZone Glossary Term.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.iam.Role("example",
            name="example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "datazone.amazonaws.com",
                        },
                    },
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "cloudformation.amazonaws.com",
                        },
                    },
                ],
            }),
            inline_policies=[{
                "name": "example",
                "policy": json.dumps({
                    "Version": "2012-10-17",
                    "Statement": [{
                        "Action": [
                            "datazone:*",
                            "ram:*",
                            "sso:*",
                            "kms:*",
                        ],
                        "Effect": "Allow",
                        "Resource": "*",
                    }],
                }),
            }])
        example_domain = aws.datazone.Domain("example",
            name="example_name",
            domain_execution_role=example.arn)
        example_security_group = aws.ec2.SecurityGroup("example", name="example_name")
        example_project = aws.datazone.Project("example",
            domain_identifier=example_domain.id,
            glossary_terms=["2N8w6XJCwZf"],
            name="example",
            skip_deletion_check=True)
        example_glossary = aws.datazone.Glossary("example",
            description="description",
            name="example",
            owning_project_identifier=example_project.id,
            status="ENABLED",
            domain_identifier=example_project.domain_identifier)
        example_glossary_term = aws.datazone.GlossaryTerm("example",
            domain_identifier=example_domain.id,
            glossary_identifier=example_glossary.id,
            name="example",
            status="ENABLED")
        ```

        ## Import

        Using `pulumi import`, import DataZone Glossary Term using a comma-delimited string combining the `domain_identifier`, `id`, and the `glossary_identifier`. For example:

        ```sh
        $ pulumi import aws:datazone/glossaryTerm:GlossaryTerm example domain-id,glossary-term-id,glossary-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_identifier: Identifier of domain.
        :param pulumi.Input[builtins.str] glossary_identifier: Identifier of glossary.
        :param pulumi.Input[builtins.str] long_description: Long description of entry.
        :param pulumi.Input[builtins.str] name: Name of glossary term.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] short_description: Short description of entry.
        :param pulumi.Input[builtins.str] status: If glossary term is ENABLED or DISABLED.
        :param pulumi.Input[Union['GlossaryTermTermRelationsArgs', 'GlossaryTermTermRelationsArgsDict']] term_relations: Object classifying the term relations through the following attributes:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlossaryTermArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS DataZone Glossary Term.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.iam.Role("example",
            name="example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "datazone.amazonaws.com",
                        },
                    },
                    {
                        "Action": [
                            "sts:AssumeRole",
                            "sts:TagSession",
                        ],
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "cloudformation.amazonaws.com",
                        },
                    },
                ],
            }),
            inline_policies=[{
                "name": "example",
                "policy": json.dumps({
                    "Version": "2012-10-17",
                    "Statement": [{
                        "Action": [
                            "datazone:*",
                            "ram:*",
                            "sso:*",
                            "kms:*",
                        ],
                        "Effect": "Allow",
                        "Resource": "*",
                    }],
                }),
            }])
        example_domain = aws.datazone.Domain("example",
            name="example_name",
            domain_execution_role=example.arn)
        example_security_group = aws.ec2.SecurityGroup("example", name="example_name")
        example_project = aws.datazone.Project("example",
            domain_identifier=example_domain.id,
            glossary_terms=["2N8w6XJCwZf"],
            name="example",
            skip_deletion_check=True)
        example_glossary = aws.datazone.Glossary("example",
            description="description",
            name="example",
            owning_project_identifier=example_project.id,
            status="ENABLED",
            domain_identifier=example_project.domain_identifier)
        example_glossary_term = aws.datazone.GlossaryTerm("example",
            domain_identifier=example_domain.id,
            glossary_identifier=example_glossary.id,
            name="example",
            status="ENABLED")
        ```

        ## Import

        Using `pulumi import`, import DataZone Glossary Term using a comma-delimited string combining the `domain_identifier`, `id`, and the `glossary_identifier`. For example:

        ```sh
        $ pulumi import aws:datazone/glossaryTerm:GlossaryTerm example domain-id,glossary-term-id,glossary-id
        ```

        :param str resource_name: The name of the resource.
        :param GlossaryTermArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlossaryTermArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 glossary_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 long_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 short_description: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 term_relations: Optional[pulumi.Input[Union['GlossaryTermTermRelationsArgs', 'GlossaryTermTermRelationsArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['GlossaryTermTimeoutsArgs', 'GlossaryTermTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlossaryTermArgs.__new__(GlossaryTermArgs)

            __props__.__dict__["domain_identifier"] = domain_identifier
            if glossary_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'glossary_identifier'")
            __props__.__dict__["glossary_identifier"] = glossary_identifier
            __props__.__dict__["long_description"] = long_description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["short_description"] = short_description
            __props__.__dict__["status"] = status
            __props__.__dict__["term_relations"] = term_relations
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
        super(GlossaryTerm, __self__).__init__(
            'aws:datazone/glossaryTerm:GlossaryTerm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            created_by: Optional[pulumi.Input[builtins.str]] = None,
            domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
            glossary_identifier: Optional[pulumi.Input[builtins.str]] = None,
            long_description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            short_description: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            term_relations: Optional[pulumi.Input[Union['GlossaryTermTermRelationsArgs', 'GlossaryTermTermRelationsArgsDict']]] = None,
            timeouts: Optional[pulumi.Input[Union['GlossaryTermTimeoutsArgs', 'GlossaryTermTimeoutsArgsDict']]] = None) -> 'GlossaryTerm':
        """
        Get an existing GlossaryTerm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: Time of glossary term creation.
        :param pulumi.Input[builtins.str] created_by: Creator of glossary term.
        :param pulumi.Input[builtins.str] domain_identifier: Identifier of domain.
        :param pulumi.Input[builtins.str] glossary_identifier: Identifier of glossary.
        :param pulumi.Input[builtins.str] long_description: Long description of entry.
        :param pulumi.Input[builtins.str] name: Name of glossary term.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] short_description: Short description of entry.
        :param pulumi.Input[builtins.str] status: If glossary term is ENABLED or DISABLED.
        :param pulumi.Input[Union['GlossaryTermTermRelationsArgs', 'GlossaryTermTermRelationsArgsDict']] term_relations: Object classifying the term relations through the following attributes:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlossaryTermState.__new__(_GlossaryTermState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["domain_identifier"] = domain_identifier
        __props__.__dict__["glossary_identifier"] = glossary_identifier
        __props__.__dict__["long_description"] = long_description
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["short_description"] = short_description
        __props__.__dict__["status"] = status
        __props__.__dict__["term_relations"] = term_relations
        __props__.__dict__["timeouts"] = timeouts
        return GlossaryTerm(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Time of glossary term creation.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.str]:
        """
        Creator of glossary term.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of domain.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter(name="glossaryIdentifier")
    def glossary_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of glossary.
        """
        return pulumi.get(self, "glossary_identifier")

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Long description of entry.
        """
        return pulumi.get(self, "long_description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of glossary term.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Short description of entry.
        """
        return pulumi.get(self, "short_description")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If glossary term is ENABLED or DISABLED.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="termRelations")
    def term_relations(self) -> pulumi.Output[Optional['outputs.GlossaryTermTermRelations']]:
        """
        Object classifying the term relations through the following attributes:
        """
        return pulumi.get(self, "term_relations")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.GlossaryTermTimeouts']]:
        return pulumi.get(self, "timeouts")

