# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 skip_deletion_check: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['ProjectTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[builtins.str] domain_identifier: Identifier of domain which the project is part of. Must follow the regex of `^dzd[-_][a-zA-Z0-9_-]{1,36}$`.
        :param pulumi.Input[builtins.str] description: Description of project.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] glossary_terms: List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of `[a-zA-Z0-9_-]{1,36}$`.
        :param pulumi.Input[builtins.str] name: Name of the project. Must follow the regex of `^[\\w -]+$`. and have a length of at most 64.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] skip_deletion_check: Optional flag to delete all child entities within the project.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if glossary_terms is not None:
            pulumi.set(__self__, "glossary_terms", glossary_terms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if skip_deletion_check is not None:
            pulumi.set(__self__, "skip_deletion_check", skip_deletion_check)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of domain which the project is part of. Must follow the regex of `^dzd[-_][a-zA-Z0-9_-]{1,36}$`.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="glossaryTerms")
    def glossary_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of `[a-zA-Z0-9_-]{1,36}$`.
        """
        return pulumi.get(self, "glossary_terms")

    @glossary_terms.setter
    def glossary_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "glossary_terms", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the project. Must follow the regex of `^[\\w -]+$`. and have a length of at most 64.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="skipDeletionCheck")
    def skip_deletion_check(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional flag to delete all child entities within the project.
        """
        return pulumi.get(self, "skip_deletion_check")

    @skip_deletion_check.setter
    def skip_deletion_check(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_deletion_check", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ProjectTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ProjectTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 failure_reasons: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFailureReasonArgs']]]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 last_updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_status: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 skip_deletion_check: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['ProjectTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[builtins.str] created_at: Timestamp of when the project was made.
        :param pulumi.Input[builtins.str] created_by: Creator of the project.
        :param pulumi.Input[builtins.str] description: Description of project.
        :param pulumi.Input[builtins.str] domain_identifier: Identifier of domain which the project is part of. Must follow the regex of `^dzd[-_][a-zA-Z0-9_-]{1,36}$`.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectFailureReasonArgs']]] failure_reasons: List of error messages if operation cannot be completed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] glossary_terms: List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of `[a-zA-Z0-9_-]{1,36}$`.
        :param pulumi.Input[builtins.str] last_updated_at: Timestamp of when the project was last updated.
        :param pulumi.Input[builtins.str] name: Name of the project. Must follow the regex of `^[\\w -]+$`. and have a length of at most 64.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] project_status: Enum that conveys state of project. Can be `ACTIVE`, `DELETING`, or `DELETE_FAILED`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] skip_deletion_check: Optional flag to delete all child entities within the project.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_identifier is not None:
            pulumi.set(__self__, "domain_identifier", domain_identifier)
        if failure_reasons is not None:
            pulumi.set(__self__, "failure_reasons", failure_reasons)
        if glossary_terms is not None:
            pulumi.set(__self__, "glossary_terms", glossary_terms)
        if last_updated_at is not None:
            pulumi.set(__self__, "last_updated_at", last_updated_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_status is not None:
            pulumi.set(__self__, "project_status", project_status)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if skip_deletion_check is not None:
            pulumi.set(__self__, "skip_deletion_check", skip_deletion_check)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp of when the project was made.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creator of the project.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of domain which the project is part of. Must follow the regex of `^dzd[-_][a-zA-Z0-9_-]{1,36}$`.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="failureReasons")
    def failure_reasons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFailureReasonArgs']]]]:
        """
        List of error messages if operation cannot be completed.
        """
        return pulumi.get(self, "failure_reasons")

    @failure_reasons.setter
    def failure_reasons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFailureReasonArgs']]]]):
        pulumi.set(self, "failure_reasons", value)

    @property
    @pulumi.getter(name="glossaryTerms")
    def glossary_terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of `[a-zA-Z0-9_-]{1,36}$`.
        """
        return pulumi.get(self, "glossary_terms")

    @glossary_terms.setter
    def glossary_terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "glossary_terms", value)

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp of when the project was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @last_updated_at.setter
    def last_updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_updated_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the project. Must follow the regex of `^[\\w -]+$`. and have a length of at most 64.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectStatus")
    def project_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enum that conveys state of project. Can be `ACTIVE`, `DELETING`, or `DELETE_FAILED`.
        """
        return pulumi.get(self, "project_status")

    @project_status.setter
    def project_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_status", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="skipDeletionCheck")
    def skip_deletion_check(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional flag to delete all child entities within the project.
        """
        return pulumi.get(self, "skip_deletion_check")

    @skip_deletion_check.setter
    def skip_deletion_check(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_deletion_check", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ProjectTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ProjectTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:datazone/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 skip_deletion_check: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['ProjectTimeoutsArgs', 'ProjectTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS DataZone Project.

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.datazone.Project("test",
            domain_identifier=test_aws_datazone_domain["id"],
            name="name")
        ```

        ## Import

        Using `pulumi import`, import DataZone Project using a colon-delimited string combining `domain_id` and `id`. For example:

        ```sh
        $ pulumi import aws:datazone/project:Project example domain-1234:project-1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of project.
        :param pulumi.Input[builtins.str] domain_identifier: Identifier of domain which the project is part of. Must follow the regex of `^dzd[-_][a-zA-Z0-9_-]{1,36}$`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] glossary_terms: List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of `[a-zA-Z0-9_-]{1,36}$`.
        :param pulumi.Input[builtins.str] name: Name of the project. Must follow the regex of `^[\\w -]+$`. and have a length of at most 64.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] skip_deletion_check: Optional flag to delete all child entities within the project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS DataZone Project.

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.datazone.Project("test",
            domain_identifier=test_aws_datazone_domain["id"],
            name="name")
        ```

        ## Import

        Using `pulumi import`, import DataZone Project using a colon-delimited string combining `domain_id` and `id`. For example:

        ```sh
        $ pulumi import aws:datazone/project:Project example domain-1234:project-1234
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 skip_deletion_check: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['ProjectTimeoutsArgs', 'ProjectTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["description"] = description
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            __props__.__dict__["glossary_terms"] = glossary_terms
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["skip_deletion_check"] = skip_deletion_check
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["failure_reasons"] = None
            __props__.__dict__["last_updated_at"] = None
            __props__.__dict__["project_status"] = None
        super(Project, __self__).__init__(
            'aws:datazone/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            created_by: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
            failure_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectFailureReasonArgs', 'ProjectFailureReasonArgsDict']]]]] = None,
            glossary_terms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            last_updated_at: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_status: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            skip_deletion_check: Optional[pulumi.Input[builtins.bool]] = None,
            timeouts: Optional[pulumi.Input[Union['ProjectTimeoutsArgs', 'ProjectTimeoutsArgsDict']]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: Timestamp of when the project was made.
        :param pulumi.Input[builtins.str] created_by: Creator of the project.
        :param pulumi.Input[builtins.str] description: Description of project.
        :param pulumi.Input[builtins.str] domain_identifier: Identifier of domain which the project is part of. Must follow the regex of `^dzd[-_][a-zA-Z0-9_-]{1,36}$`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectFailureReasonArgs', 'ProjectFailureReasonArgsDict']]]] failure_reasons: List of error messages if operation cannot be completed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] glossary_terms: List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of `[a-zA-Z0-9_-]{1,36}$`.
        :param pulumi.Input[builtins.str] last_updated_at: Timestamp of when the project was last updated.
        :param pulumi.Input[builtins.str] name: Name of the project. Must follow the regex of `^[\\w -]+$`. and have a length of at most 64.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] project_status: Enum that conveys state of project. Can be `ACTIVE`, `DELETING`, or `DELETE_FAILED`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] skip_deletion_check: Optional flag to delete all child entities within the project.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_identifier"] = domain_identifier
        __props__.__dict__["failure_reasons"] = failure_reasons
        __props__.__dict__["glossary_terms"] = glossary_terms
        __props__.__dict__["last_updated_at"] = last_updated_at
        __props__.__dict__["name"] = name
        __props__.__dict__["project_status"] = project_status
        __props__.__dict__["region"] = region
        __props__.__dict__["skip_deletion_check"] = skip_deletion_check
        __props__.__dict__["timeouts"] = timeouts
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp of when the project was made.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.str]:
        """
        Creator of the project.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of domain which the project is part of. Must follow the regex of `^dzd[-_][a-zA-Z0-9_-]{1,36}$`.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter(name="failureReasons")
    def failure_reasons(self) -> pulumi.Output[Sequence['outputs.ProjectFailureReason']]:
        """
        List of error messages if operation cannot be completed.
        """
        return pulumi.get(self, "failure_reasons")

    @property
    @pulumi.getter(name="glossaryTerms")
    def glossary_terms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of `[a-zA-Z0-9_-]{1,36}$`.
        """
        return pulumi.get(self, "glossary_terms")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp of when the project was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the project. Must follow the regex of `^[\\w -]+$`. and have a length of at most 64.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectStatus")
    def project_status(self) -> pulumi.Output[builtins.str]:
        """
        Enum that conveys state of project. Can be `ACTIVE`, `DELETING`, or `DELETE_FAILED`.
        """
        return pulumi.get(self, "project_status")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="skipDeletionCheck")
    def skip_deletion_check(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Optional flag to delete all child entities within the project.
        """
        return pulumi.get(self, "skip_deletion_check")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ProjectTimeouts']]:
        return pulumi.get(self, "timeouts")

