# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotificationChannelArgs', 'NotificationChannel']

@pulumi.input_type
class NotificationChannelArgs:
    def __init__(__self__, *,
                 filters: Optional[pulumi.Input['NotificationChannelFiltersArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns: Optional[pulumi.Input['NotificationChannelSnsArgs']] = None):
        """
        The set of arguments for constructing a NotificationChannel resource.
        :param pulumi.Input['NotificationChannelFiltersArgs'] filters: Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['NotificationChannelSnsArgs'] sns: SNS noficiation channel configurations. See the `sns` argument reference below.
               
               The following arguments are optional:
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['NotificationChannelFiltersArgs']]:
        """
        Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['NotificationChannelFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input['NotificationChannelSnsArgs']]:
        """
        SNS noficiation channel configurations. See the `sns` argument reference below.

        The following arguments are optional:
        """
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input['NotificationChannelSnsArgs']]):
        pulumi.set(self, "sns", value)


@pulumi.input_type
class _NotificationChannelState:
    def __init__(__self__, *,
                 filters: Optional[pulumi.Input['NotificationChannelFiltersArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns: Optional[pulumi.Input['NotificationChannelSnsArgs']] = None):
        """
        Input properties used for looking up and filtering NotificationChannel resources.
        :param pulumi.Input['NotificationChannelFiltersArgs'] filters: Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['NotificationChannelSnsArgs'] sns: SNS noficiation channel configurations. See the `sns` argument reference below.
               
               The following arguments are optional:
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['NotificationChannelFiltersArgs']]:
        """
        Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['NotificationChannelFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input['NotificationChannelSnsArgs']]:
        """
        SNS noficiation channel configurations. See the `sns` argument reference below.

        The following arguments are optional:
        """
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input['NotificationChannelSnsArgs']]):
        pulumi.set(self, "sns", value)


@pulumi.type_token("aws:devopsguru/notificationChannel:NotificationChannel")
class NotificationChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filters: Optional[pulumi.Input[Union['NotificationChannelFiltersArgs', 'NotificationChannelFiltersArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns: Optional[pulumi.Input[Union['NotificationChannelSnsArgs', 'NotificationChannelSnsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS DevOps Guru Notification Channel.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devopsguru.NotificationChannel("example", sns={
            "topic_arn": example_aws_sns_topic["arn"],
        })
        ```

        ### Filters

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devopsguru.NotificationChannel("example",
            sns={
                "topic_arn": example_aws_sns_topic["arn"],
            },
            filters={
                "message_types": ["NEW_INSIGHT"],
                "severities": ["HIGH"],
            })
        ```

        ## Import

        Using `pulumi import`, import DevOps Guru Notification Channel using the `id`. For example:

        ```sh
        $ pulumi import aws:devopsguru/notificationChannel:NotificationChannel example id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NotificationChannelFiltersArgs', 'NotificationChannelFiltersArgsDict']] filters: Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['NotificationChannelSnsArgs', 'NotificationChannelSnsArgsDict']] sns: SNS noficiation channel configurations. See the `sns` argument reference below.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NotificationChannelArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS DevOps Guru Notification Channel.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devopsguru.NotificationChannel("example", sns={
            "topic_arn": example_aws_sns_topic["arn"],
        })
        ```

        ### Filters

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.devopsguru.NotificationChannel("example",
            sns={
                "topic_arn": example_aws_sns_topic["arn"],
            },
            filters={
                "message_types": ["NEW_INSIGHT"],
                "severities": ["HIGH"],
            })
        ```

        ## Import

        Using `pulumi import`, import DevOps Guru Notification Channel using the `id`. For example:

        ```sh
        $ pulumi import aws:devopsguru/notificationChannel:NotificationChannel example id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param NotificationChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filters: Optional[pulumi.Input[Union['NotificationChannelFiltersArgs', 'NotificationChannelFiltersArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns: Optional[pulumi.Input[Union['NotificationChannelSnsArgs', 'NotificationChannelSnsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationChannelArgs.__new__(NotificationChannelArgs)

            __props__.__dict__["filters"] = filters
            __props__.__dict__["region"] = region
            __props__.__dict__["sns"] = sns
        super(NotificationChannel, __self__).__init__(
            'aws:devopsguru/notificationChannel:NotificationChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filters: Optional[pulumi.Input[Union['NotificationChannelFiltersArgs', 'NotificationChannelFiltersArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            sns: Optional[pulumi.Input[Union['NotificationChannelSnsArgs', 'NotificationChannelSnsArgsDict']]] = None) -> 'NotificationChannel':
        """
        Get an existing NotificationChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NotificationChannelFiltersArgs', 'NotificationChannelFiltersArgsDict']] filters: Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['NotificationChannelSnsArgs', 'NotificationChannelSnsArgsDict']] sns: SNS noficiation channel configurations. See the `sns` argument reference below.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationChannelState.__new__(_NotificationChannelState)

        __props__.__dict__["filters"] = filters
        __props__.__dict__["region"] = region
        __props__.__dict__["sns"] = sns
        return NotificationChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.NotificationChannelFilters']]:
        """
        Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def sns(self) -> pulumi.Output[Optional['outputs.NotificationChannelSns']]:
        """
        SNS noficiation channel configurations. See the `sns` argument reference below.

        The following arguments are optional:
        """
        return pulumi.get(self, "sns")

