# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicationConfigArgs', 'ReplicationConfig']

@pulumi.input_type
class ReplicationConfigArgs:
    def __init__(__self__, *,
                 compute_config: pulumi.Input['ReplicationConfigComputeConfigArgs'],
                 replication_config_identifier: pulumi.Input[builtins.str],
                 replication_type: pulumi.Input[builtins.str],
                 source_endpoint_arn: pulumi.Input[builtins.str],
                 table_mappings: pulumi.Input[builtins.str],
                 target_endpoint_arn: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_settings: Optional[pulumi.Input[builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 start_replication: Optional[pulumi.Input[builtins.bool]] = None,
                 supplemental_settings: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ReplicationConfig resource.
        :param pulumi.Input['ReplicationConfigComputeConfigArgs'] compute_config: Configuration block for provisioning an DMS Serverless replication.
        :param pulumi.Input[builtins.str] replication_config_identifier: Unique identifier that you want to use to create the config.
        :param pulumi.Input[builtins.str] replication_type: The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        :param pulumi.Input[builtins.str] source_endpoint_arn: The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
        :param pulumi.Input[builtins.str] table_mappings: An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        :param pulumi.Input[builtins.str] target_endpoint_arn: The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] replication_settings: An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
        :param pulumi.Input[builtins.str] resource_identifier: Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
        :param pulumi.Input[builtins.bool] start_replication: Whether to run or stop the serverless replication, default is false.
        :param pulumi.Input[builtins.str] supplemental_settings: JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "compute_config", compute_config)
        pulumi.set(__self__, "replication_config_identifier", replication_config_identifier)
        pulumi.set(__self__, "replication_type", replication_type)
        pulumi.set(__self__, "source_endpoint_arn", source_endpoint_arn)
        pulumi.set(__self__, "table_mappings", table_mappings)
        pulumi.set(__self__, "target_endpoint_arn", target_endpoint_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_settings is not None:
            pulumi.set(__self__, "replication_settings", replication_settings)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)
        if start_replication is not None:
            pulumi.set(__self__, "start_replication", start_replication)
        if supplemental_settings is not None:
            pulumi.set(__self__, "supplemental_settings", supplemental_settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="computeConfig")
    def compute_config(self) -> pulumi.Input['ReplicationConfigComputeConfigArgs']:
        """
        Configuration block for provisioning an DMS Serverless replication.
        """
        return pulumi.get(self, "compute_config")

    @compute_config.setter
    def compute_config(self, value: pulumi.Input['ReplicationConfigComputeConfigArgs']):
        pulumi.set(self, "compute_config", value)

    @property
    @pulumi.getter(name="replicationConfigIdentifier")
    def replication_config_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier that you want to use to create the config.
        """
        return pulumi.get(self, "replication_config_identifier")

    @replication_config_identifier.setter
    def replication_config_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "replication_config_identifier", value)

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> pulumi.Input[builtins.str]:
        """
        The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        """
        return pulumi.get(self, "replication_type")

    @replication_type.setter
    def replication_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "replication_type", value)

    @property
    @pulumi.getter(name="sourceEndpointArn")
    def source_endpoint_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
        """
        return pulumi.get(self, "source_endpoint_arn")

    @source_endpoint_arn.setter
    def source_endpoint_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_endpoint_arn", value)

    @property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> pulumi.Input[builtins.str]:
        """
        An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        """
        return pulumi.get(self, "table_mappings")

    @table_mappings.setter
    def table_mappings(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_mappings", value)

    @property
    @pulumi.getter(name="targetEndpointArn")
    def target_endpoint_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
        """
        return pulumi.get(self, "target_endpoint_arn")

    @target_endpoint_arn.setter
    def target_endpoint_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_endpoint_arn", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicationSettings")
    def replication_settings(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
        """
        return pulumi.get(self, "replication_settings")

    @replication_settings.setter
    def replication_settings(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_settings", value)

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
        """
        return pulumi.get(self, "resource_identifier")

    @resource_identifier.setter
    def resource_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_identifier", value)

    @property
    @pulumi.getter(name="startReplication")
    def start_replication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to run or stop the serverless replication, default is false.
        """
        return pulumi.get(self, "start_replication")

    @start_replication.setter
    def start_replication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "start_replication", value)

    @property
    @pulumi.getter(name="supplementalSettings")
    def supplemental_settings(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
        """
        return pulumi.get(self, "supplemental_settings")

    @supplemental_settings.setter
    def supplemental_settings(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "supplemental_settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ReplicationConfigState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 compute_config: Optional[pulumi.Input['ReplicationConfigComputeConfigArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_config_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 replication_settings: Optional[pulumi.Input[builtins.str]] = None,
                 replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
                 start_replication: Optional[pulumi.Input[builtins.bool]] = None,
                 supplemental_settings: Optional[pulumi.Input[builtins.str]] = None,
                 table_mappings: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_endpoint_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReplicationConfig resources.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) for the serverless replication config.
        :param pulumi.Input['ReplicationConfigComputeConfigArgs'] compute_config: Configuration block for provisioning an DMS Serverless replication.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] replication_config_identifier: Unique identifier that you want to use to create the config.
        :param pulumi.Input[builtins.str] replication_settings: An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
        :param pulumi.Input[builtins.str] replication_type: The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        :param pulumi.Input[builtins.str] resource_identifier: Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
        :param pulumi.Input[builtins.str] source_endpoint_arn: The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
        :param pulumi.Input[builtins.bool] start_replication: Whether to run or stop the serverless replication, default is false.
        :param pulumi.Input[builtins.str] supplemental_settings: JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
        :param pulumi.Input[builtins.str] table_mappings: An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] target_endpoint_arn: The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if compute_config is not None:
            pulumi.set(__self__, "compute_config", compute_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_config_identifier is not None:
            pulumi.set(__self__, "replication_config_identifier", replication_config_identifier)
        if replication_settings is not None:
            pulumi.set(__self__, "replication_settings", replication_settings)
        if replication_type is not None:
            pulumi.set(__self__, "replication_type", replication_type)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)
        if source_endpoint_arn is not None:
            pulumi.set(__self__, "source_endpoint_arn", source_endpoint_arn)
        if start_replication is not None:
            pulumi.set(__self__, "start_replication", start_replication)
        if supplemental_settings is not None:
            pulumi.set(__self__, "supplemental_settings", supplemental_settings)
        if table_mappings is not None:
            pulumi.set(__self__, "table_mappings", table_mappings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_endpoint_arn is not None:
            pulumi.set(__self__, "target_endpoint_arn", target_endpoint_arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the serverless replication config.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="computeConfig")
    def compute_config(self) -> Optional[pulumi.Input['ReplicationConfigComputeConfigArgs']]:
        """
        Configuration block for provisioning an DMS Serverless replication.
        """
        return pulumi.get(self, "compute_config")

    @compute_config.setter
    def compute_config(self, value: Optional[pulumi.Input['ReplicationConfigComputeConfigArgs']]):
        pulumi.set(self, "compute_config", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicationConfigIdentifier")
    def replication_config_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier that you want to use to create the config.
        """
        return pulumi.get(self, "replication_config_identifier")

    @replication_config_identifier.setter
    def replication_config_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_config_identifier", value)

    @property
    @pulumi.getter(name="replicationSettings")
    def replication_settings(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
        """
        return pulumi.get(self, "replication_settings")

    @replication_settings.setter
    def replication_settings(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_settings", value)

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        """
        return pulumi.get(self, "replication_type")

    @replication_type.setter
    def replication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_type", value)

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
        """
        return pulumi.get(self, "resource_identifier")

    @resource_identifier.setter
    def resource_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_identifier", value)

    @property
    @pulumi.getter(name="sourceEndpointArn")
    def source_endpoint_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
        """
        return pulumi.get(self, "source_endpoint_arn")

    @source_endpoint_arn.setter
    def source_endpoint_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_endpoint_arn", value)

    @property
    @pulumi.getter(name="startReplication")
    def start_replication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to run or stop the serverless replication, default is false.
        """
        return pulumi.get(self, "start_replication")

    @start_replication.setter
    def start_replication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "start_replication", value)

    @property
    @pulumi.getter(name="supplementalSettings")
    def supplemental_settings(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
        """
        return pulumi.get(self, "supplemental_settings")

    @supplemental_settings.setter
    def supplemental_settings(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "supplemental_settings", value)

    @property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        """
        return pulumi.get(self, "table_mappings")

    @table_mappings.setter
    def table_mappings(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table_mappings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="targetEndpointArn")
    def target_endpoint_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
        """
        return pulumi.get(self, "target_endpoint_arn")

    @target_endpoint_arn.setter
    def target_endpoint_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_endpoint_arn", value)


@pulumi.type_token("aws:dms/replicationConfig:ReplicationConfig")
class ReplicationConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_config: Optional[pulumi.Input[Union['ReplicationConfigComputeConfigArgs', 'ReplicationConfigComputeConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_config_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 replication_settings: Optional[pulumi.Input[builtins.str]] = None,
                 replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
                 start_replication: Optional[pulumi.Input[builtins.bool]] = None,
                 supplemental_settings: Optional[pulumi.Input[builtins.str]] = None,
                 table_mappings: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a DMS Serverless replication config resource.

        > **NOTE:** Changing most arguments will stop the replication if it is running. You can set `start_replication` to resume the replication afterwards.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        name = aws.dms.ReplicationConfig("name",
            replication_config_identifier="test-dms-serverless-replication-tf",
            resource_identifier="test-dms-serverless-replication-tf",
            replication_type="cdc",
            source_endpoint_arn=source["endpointArn"],
            target_endpoint_arn=target["endpointArn"],
            table_mappings=\"\"\"  {
            "rules":[{"rule-type":"selection","rule-id":"1","rule-name":"1","rule-action":"include","object-locator":{"schema-name":"%%","table-name":"%%"}}]
          }
        \"\"\",
            start_replication=True,
            compute_config={
                "replication_subnet_group_id": default["replicationSubnetGroupId"],
                "max_capacity_units": 64,
                "min_capacity_units": 2,
                "preferred_maintenance_window": "sun:23:45-mon:00:30",
            })
        ```

        ## Import

        Using `pulumi import`, import a replication config using the `arn`. For example:

        ```sh
        $ pulumi import aws:dms/replicationConfig:ReplicationConfig example arn:aws:dms:us-east-1:123456789012:replication-config:UX6OL6MHMMJKFFOXE3H7LLJCMEKBDUG4ZV7DRSI
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ReplicationConfigComputeConfigArgs', 'ReplicationConfigComputeConfigArgsDict']] compute_config: Configuration block for provisioning an DMS Serverless replication.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] replication_config_identifier: Unique identifier that you want to use to create the config.
        :param pulumi.Input[builtins.str] replication_settings: An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
        :param pulumi.Input[builtins.str] replication_type: The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        :param pulumi.Input[builtins.str] resource_identifier: Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
        :param pulumi.Input[builtins.str] source_endpoint_arn: The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
        :param pulumi.Input[builtins.bool] start_replication: Whether to run or stop the serverless replication, default is false.
        :param pulumi.Input[builtins.str] supplemental_settings: JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
        :param pulumi.Input[builtins.str] table_mappings: An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] target_endpoint_arn: The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicationConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DMS Serverless replication config resource.

        > **NOTE:** Changing most arguments will stop the replication if it is running. You can set `start_replication` to resume the replication afterwards.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        name = aws.dms.ReplicationConfig("name",
            replication_config_identifier="test-dms-serverless-replication-tf",
            resource_identifier="test-dms-serverless-replication-tf",
            replication_type="cdc",
            source_endpoint_arn=source["endpointArn"],
            target_endpoint_arn=target["endpointArn"],
            table_mappings=\"\"\"  {
            "rules":[{"rule-type":"selection","rule-id":"1","rule-name":"1","rule-action":"include","object-locator":{"schema-name":"%%","table-name":"%%"}}]
          }
        \"\"\",
            start_replication=True,
            compute_config={
                "replication_subnet_group_id": default["replicationSubnetGroupId"],
                "max_capacity_units": 64,
                "min_capacity_units": 2,
                "preferred_maintenance_window": "sun:23:45-mon:00:30",
            })
        ```

        ## Import

        Using `pulumi import`, import a replication config using the `arn`. For example:

        ```sh
        $ pulumi import aws:dms/replicationConfig:ReplicationConfig example arn:aws:dms:us-east-1:123456789012:replication-config:UX6OL6MHMMJKFFOXE3H7LLJCMEKBDUG4ZV7DRSI
        ```

        :param str resource_name: The name of the resource.
        :param ReplicationConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_config: Optional[pulumi.Input[Union['ReplicationConfigComputeConfigArgs', 'ReplicationConfigComputeConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replication_config_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 replication_settings: Optional[pulumi.Input[builtins.str]] = None,
                 replication_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
                 start_replication: Optional[pulumi.Input[builtins.bool]] = None,
                 supplemental_settings: Optional[pulumi.Input[builtins.str]] = None,
                 table_mappings: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationConfigArgs.__new__(ReplicationConfigArgs)

            if compute_config is None and not opts.urn:
                raise TypeError("Missing required property 'compute_config'")
            __props__.__dict__["compute_config"] = compute_config
            __props__.__dict__["region"] = region
            if replication_config_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'replication_config_identifier'")
            __props__.__dict__["replication_config_identifier"] = replication_config_identifier
            __props__.__dict__["replication_settings"] = replication_settings
            if replication_type is None and not opts.urn:
                raise TypeError("Missing required property 'replication_type'")
            __props__.__dict__["replication_type"] = replication_type
            __props__.__dict__["resource_identifier"] = resource_identifier
            if source_endpoint_arn is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_arn'")
            __props__.__dict__["source_endpoint_arn"] = source_endpoint_arn
            __props__.__dict__["start_replication"] = start_replication
            __props__.__dict__["supplemental_settings"] = supplemental_settings
            if table_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'table_mappings'")
            __props__.__dict__["table_mappings"] = table_mappings
            __props__.__dict__["tags"] = tags
            if target_endpoint_arn is None and not opts.urn:
                raise TypeError("Missing required property 'target_endpoint_arn'")
            __props__.__dict__["target_endpoint_arn"] = target_endpoint_arn
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(ReplicationConfig, __self__).__init__(
            'aws:dms/replicationConfig:ReplicationConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            compute_config: Optional[pulumi.Input[Union['ReplicationConfigComputeConfigArgs', 'ReplicationConfigComputeConfigArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            replication_config_identifier: Optional[pulumi.Input[builtins.str]] = None,
            replication_settings: Optional[pulumi.Input[builtins.str]] = None,
            replication_type: Optional[pulumi.Input[builtins.str]] = None,
            resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
            source_endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
            start_replication: Optional[pulumi.Input[builtins.bool]] = None,
            supplemental_settings: Optional[pulumi.Input[builtins.str]] = None,
            table_mappings: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_endpoint_arn: Optional[pulumi.Input[builtins.str]] = None) -> 'ReplicationConfig':
        """
        Get an existing ReplicationConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) for the serverless replication config.
        :param pulumi.Input[Union['ReplicationConfigComputeConfigArgs', 'ReplicationConfigComputeConfigArgsDict']] compute_config: Configuration block for provisioning an DMS Serverless replication.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] replication_config_identifier: Unique identifier that you want to use to create the config.
        :param pulumi.Input[builtins.str] replication_settings: An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
        :param pulumi.Input[builtins.str] replication_type: The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        :param pulumi.Input[builtins.str] resource_identifier: Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
        :param pulumi.Input[builtins.str] source_endpoint_arn: The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
        :param pulumi.Input[builtins.bool] start_replication: Whether to run or stop the serverless replication, default is false.
        :param pulumi.Input[builtins.str] supplemental_settings: JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
        :param pulumi.Input[builtins.str] table_mappings: An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] target_endpoint_arn: The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicationConfigState.__new__(_ReplicationConfigState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["compute_config"] = compute_config
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_config_identifier"] = replication_config_identifier
        __props__.__dict__["replication_settings"] = replication_settings
        __props__.__dict__["replication_type"] = replication_type
        __props__.__dict__["resource_identifier"] = resource_identifier
        __props__.__dict__["source_endpoint_arn"] = source_endpoint_arn
        __props__.__dict__["start_replication"] = start_replication
        __props__.__dict__["supplemental_settings"] = supplemental_settings
        __props__.__dict__["table_mappings"] = table_mappings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_endpoint_arn"] = target_endpoint_arn
        return ReplicationConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the serverless replication config.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="computeConfig")
    def compute_config(self) -> pulumi.Output['outputs.ReplicationConfigComputeConfig']:
        """
        Configuration block for provisioning an DMS Serverless replication.
        """
        return pulumi.get(self, "compute_config")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicationConfigIdentifier")
    def replication_config_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier that you want to use to create the config.
        """
        return pulumi.get(self, "replication_config_identifier")

    @property
    @pulumi.getter(name="replicationSettings")
    def replication_settings(self) -> pulumi.Output[builtins.str]:
        """
        An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
        """
        return pulumi.get(self, "replication_settings")

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> pulumi.Output[builtins.str]:
        """
        The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
        """
        return pulumi.get(self, "replication_type")

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
        """
        return pulumi.get(self, "resource_identifier")

    @property
    @pulumi.getter(name="sourceEndpointArn")
    def source_endpoint_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
        """
        return pulumi.get(self, "source_endpoint_arn")

    @property
    @pulumi.getter(name="startReplication")
    def start_replication(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to run or stop the serverless replication, default is false.
        """
        return pulumi.get(self, "start_replication")

    @property
    @pulumi.getter(name="supplementalSettings")
    def supplemental_settings(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
        """
        return pulumi.get(self, "supplemental_settings")

    @property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> pulumi.Output[builtins.str]:
        """
        An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
        """
        return pulumi.get(self, "table_mappings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="targetEndpointArn")
    def target_endpoint_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
        """
        return pulumi.get(self, "target_endpoint_arn")

