# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClusterInstanceArgs', 'ClusterInstance']

@pulumi.input_type
class ClusterInstanceArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[builtins.str],
                 instance_class: pulumi.Input[builtins.str],
                 apply_immediately: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_performance_insights: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 identifier_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 promotion_tier: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ClusterInstance resource.
        :param pulumi.Input[builtins.str] cluster_identifier: The identifier of the `docdb.Cluster` in which to launch this instance.
        :param pulumi.Input[builtins.str] instance_class: The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
               DocumentDB currently supports the below instance classes.
               Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
               - db.r6g.large
               - db.r6g.xlarge
               - db.r6g.2xlarge
               - db.r6g.4xlarge
               - db.r6g.8xlarge
               - db.r6g.12xlarge
               - db.r6g.16xlarge
               - db.r5.large
               - db.r5.xlarge
               - db.r5.2xlarge
               - db.r5.4xlarge
               - db.r5.12xlarge
               - db.r5.24xlarge
               - db.r4.large
               - db.r4.xlarge
               - db.r4.2xlarge
               - db.r4.4xlarge
               - db.r4.8xlarge
               - db.r4.16xlarge
               - db.t4g.medium
               - db.t3.medium
        :param pulumi.Input[builtins.bool] apply_immediately: Specifies whether any database modifications
               are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
        :param pulumi.Input[builtins.str] availability_zone: The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
        :param pulumi.Input[builtins.str] ca_cert_identifier: The identifier of the certificate authority (CA) certificate for the DB instance.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshot: Copy all DB instance `tags` to snapshots. Default is `false`.
        :param pulumi.Input[builtins.bool] enable_performance_insights: A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
        :param pulumi.Input[builtins.str] engine: The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
        :param pulumi.Input[builtins.str] identifier: The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
        :param pulumi.Input[builtins.str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[builtins.str] performance_insights_kms_key_id: The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[builtins.int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        pulumi.set(__self__, "instance_class", instance_class)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if ca_cert_identifier is not None:
            pulumi.set(__self__, "ca_cert_identifier", ca_cert_identifier)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if enable_performance_insights is not None:
            pulumi.set(__self__, "enable_performance_insights", enable_performance_insights)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if identifier_prefix is not None:
            pulumi.set(__self__, "identifier_prefix", identifier_prefix)
        if performance_insights_kms_key_id is not None:
            pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if promotion_tier is not None:
            pulumi.set(__self__, "promotion_tier", promotion_tier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the `docdb.Cluster` in which to launch this instance.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Input[builtins.str]:
        """
        The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
        DocumentDB currently supports the below instance classes.
        Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
        - db.r6g.large
        - db.r6g.xlarge
        - db.r6g.2xlarge
        - db.r6g.4xlarge
        - db.r6g.8xlarge
        - db.r6g.12xlarge
        - db.r6g.16xlarge
        - db.r5.large
        - db.r5.xlarge
        - db.r5.2xlarge
        - db.r5.4xlarge
        - db.r5.12xlarge
        - db.r5.24xlarge
        - db.r4.large
        - db.r4.xlarge
        - db.r4.2xlarge
        - db.r4.4xlarge
        - db.r4.8xlarge
        - db.r4.16xlarge
        - db.t4g.medium
        - db.t3.medium
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether any database modifications
        are applied immediately, or during the next maintenance window. Default is`false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="caCertIdentifier")
    def ca_cert_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the certificate authority (CA) certificate for the DB instance.
        """
        return pulumi.get(self, "ca_cert_identifier")

    @ca_cert_identifier.setter
    def ca_cert_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_cert_identifier", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Copy all DB instance `tags` to snapshots. Default is `false`.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="enablePerformanceInsights")
    def enable_performance_insights(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
        """
        return pulumi.get(self, "enable_performance_insights")

    @enable_performance_insights.setter
    def enable_performance_insights(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_performance_insights", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @identifier_prefix.setter
    def identifier_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier_prefix", value)

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @performance_insights_kms_key_id.setter
    def performance_insights_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "performance_insights_kms_key_id", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The window to perform maintenance in.
        Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        """
        return pulumi.get(self, "promotion_tier")

    @promotion_tier.setter
    def promotion_tier(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "promotion_tier", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterInstanceState:
    def __init__(__self__, *,
                 apply_immediately: Optional[pulumi.Input[builtins.bool]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 dbi_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_performance_insights: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 identifier_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 promotion_tier: Optional[pulumi.Input[builtins.int]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 writer: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ClusterInstance resources.
        :param pulumi.Input[builtins.bool] apply_immediately: Specifies whether any database modifications
               are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of cluster instance
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
        :param pulumi.Input[builtins.str] availability_zone: The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
        :param pulumi.Input[builtins.str] ca_cert_identifier: The identifier of the certificate authority (CA) certificate for the DB instance.
        :param pulumi.Input[builtins.str] cluster_identifier: The identifier of the `docdb.Cluster` in which to launch this instance.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshot: Copy all DB instance `tags` to snapshots. Default is `false`.
        :param pulumi.Input[builtins.str] db_subnet_group_name: The DB subnet group to associate with this DB instance.
        :param pulumi.Input[builtins.str] dbi_resource_id: The region-unique, immutable identifier for the DB instance.
        :param pulumi.Input[builtins.bool] enable_performance_insights: A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
        :param pulumi.Input[builtins.str] endpoint: The DNS address for this instance. May not be writable
        :param pulumi.Input[builtins.str] engine: The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
        :param pulumi.Input[builtins.str] engine_version: The database engine version
        :param pulumi.Input[builtins.str] identifier: The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
        :param pulumi.Input[builtins.str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[builtins.str] instance_class: The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
               DocumentDB currently supports the below instance classes.
               Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
               - db.r6g.large
               - db.r6g.xlarge
               - db.r6g.2xlarge
               - db.r6g.4xlarge
               - db.r6g.8xlarge
               - db.r6g.12xlarge
               - db.r6g.16xlarge
               - db.r5.large
               - db.r5.xlarge
               - db.r5.2xlarge
               - db.r5.4xlarge
               - db.r5.12xlarge
               - db.r5.24xlarge
               - db.r4.large
               - db.r4.xlarge
               - db.r4.2xlarge
               - db.r4.4xlarge
               - db.r4.8xlarge
               - db.r4.16xlarge
               - db.t4g.medium
               - db.t3.medium
        :param pulumi.Input[builtins.str] kms_key_id: The ARN for the KMS encryption key if one is set to the cluster.
        :param pulumi.Input[builtins.str] performance_insights_kms_key_id: The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
        :param pulumi.Input[builtins.int] port: The database port
        :param pulumi.Input[builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled.
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[builtins.int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] storage_encrypted: Specifies whether the DB cluster is encrypted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.bool] writer: Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if ca_cert_identifier is not None:
            pulumi.set(__self__, "ca_cert_identifier", ca_cert_identifier)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if dbi_resource_id is not None:
            pulumi.set(__self__, "dbi_resource_id", dbi_resource_id)
        if enable_performance_insights is not None:
            pulumi.set(__self__, "enable_performance_insights", enable_performance_insights)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if identifier_prefix is not None:
            pulumi.set(__self__, "identifier_prefix", identifier_prefix)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if performance_insights_kms_key_id is not None:
            pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if promotion_tier is not None:
            pulumi.set(__self__, "promotion_tier", promotion_tier)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if writer is not None:
            pulumi.set(__self__, "writer", writer)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether any database modifications
        are applied immediately, or during the next maintenance window. Default is`false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of cluster instance
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="caCertIdentifier")
    def ca_cert_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the certificate authority (CA) certificate for the DB instance.
        """
        return pulumi.get(self, "ca_cert_identifier")

    @ca_cert_identifier.setter
    def ca_cert_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_cert_identifier", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the `docdb.Cluster` in which to launch this instance.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Copy all DB instance `tags` to snapshots. Default is `false`.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DB subnet group to associate with this DB instance.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="dbiResourceId")
    def dbi_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region-unique, immutable identifier for the DB instance.
        """
        return pulumi.get(self, "dbi_resource_id")

    @dbi_resource_id.setter
    def dbi_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dbi_resource_id", value)

    @property
    @pulumi.getter(name="enablePerformanceInsights")
    def enable_performance_insights(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
        """
        return pulumi.get(self, "enable_performance_insights")

    @enable_performance_insights.setter
    def enable_performance_insights(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_performance_insights", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS address for this instance. May not be writable
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database engine version
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @identifier_prefix.setter
    def identifier_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier_prefix", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
        DocumentDB currently supports the below instance classes.
        Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
        - db.r6g.large
        - db.r6g.xlarge
        - db.r6g.2xlarge
        - db.r6g.4xlarge
        - db.r6g.8xlarge
        - db.r6g.12xlarge
        - db.r6g.16xlarge
        - db.r5.large
        - db.r5.xlarge
        - db.r5.2xlarge
        - db.r5.4xlarge
        - db.r5.12xlarge
        - db.r5.24xlarge
        - db.r4.large
        - db.r4.xlarge
        - db.r4.2xlarge
        - db.r4.4xlarge
        - db.r4.8xlarge
        - db.r4.16xlarge
        - db.t4g.medium
        - db.t3.medium
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN for the KMS encryption key if one is set to the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @performance_insights_kms_key_id.setter
    def performance_insights_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "performance_insights_kms_key_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The database port
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The daily time range during which automated backups are created if automated backups are enabled.
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The window to perform maintenance in.
        Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        """
        return pulumi.get(self, "promotion_tier")

    @promotion_tier.setter
    def promotion_tier(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "promotion_tier", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB cluster is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def writer(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        return pulumi.get(self, "writer")

    @writer.setter
    def writer(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "writer", value)


@pulumi.type_token("aws:docdb/clusterInstance:ClusterInstance")
class ClusterInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_performance_insights: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 identifier_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 promotion_tier: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an DocumentDB Cluster Resource Instance. A Cluster Instance Resource defines
        attributes that are specific to a single instance in a [DocumentDB Cluster][1].

        You do not designate a primary and subsequent replicas. Instead, you simply add DocumentDB
        Instances and DocumentDB manages the replication. You can use the [count][3]
        meta-parameter to make multiple instances and join them all to the same DocumentDB
        Cluster, or you may specify different Cluster Instance resources with various
        `instance_class` sizes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.docdb.Cluster("default",
            cluster_identifier="docdb-cluster-demo",
            availability_zones=[
                "us-west-2a",
                "us-west-2b",
                "us-west-2c",
            ],
            master_username="foo",
            master_password="barbut8chars")
        cluster_instances = []
        for range in [{"value": i} for i in range(0, 2)]:
            cluster_instances.append(aws.docdb.ClusterInstance(f"cluster_instances-{range['value']}",
                identifier=f"docdb-cluster-demo-{range['value']}",
                cluster_identifier=default.id,
                instance_class="db.r5.large"))
        ```

        ## Import

        Using `pulumi import`, import DocumentDB Cluster Instances using the `identifier`. For example:

        ```sh
        $ pulumi import aws:docdb/clusterInstance:ClusterInstance prod_instance_1 aurora-cluster-instance-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] apply_immediately: Specifies whether any database modifications
               are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
        :param pulumi.Input[builtins.str] availability_zone: The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
        :param pulumi.Input[builtins.str] ca_cert_identifier: The identifier of the certificate authority (CA) certificate for the DB instance.
        :param pulumi.Input[builtins.str] cluster_identifier: The identifier of the `docdb.Cluster` in which to launch this instance.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshot: Copy all DB instance `tags` to snapshots. Default is `false`.
        :param pulumi.Input[builtins.bool] enable_performance_insights: A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
        :param pulumi.Input[builtins.str] engine: The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
        :param pulumi.Input[builtins.str] identifier: The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
        :param pulumi.Input[builtins.str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[builtins.str] instance_class: The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
               DocumentDB currently supports the below instance classes.
               Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
               - db.r6g.large
               - db.r6g.xlarge
               - db.r6g.2xlarge
               - db.r6g.4xlarge
               - db.r6g.8xlarge
               - db.r6g.12xlarge
               - db.r6g.16xlarge
               - db.r5.large
               - db.r5.xlarge
               - db.r5.2xlarge
               - db.r5.4xlarge
               - db.r5.12xlarge
               - db.r5.24xlarge
               - db.r4.large
               - db.r4.xlarge
               - db.r4.2xlarge
               - db.r4.4xlarge
               - db.r4.8xlarge
               - db.r4.16xlarge
               - db.t4g.medium
               - db.t3.medium
        :param pulumi.Input[builtins.str] performance_insights_kms_key_id: The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[builtins.int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an DocumentDB Cluster Resource Instance. A Cluster Instance Resource defines
        attributes that are specific to a single instance in a [DocumentDB Cluster][1].

        You do not designate a primary and subsequent replicas. Instead, you simply add DocumentDB
        Instances and DocumentDB manages the replication. You can use the [count][3]
        meta-parameter to make multiple instances and join them all to the same DocumentDB
        Cluster, or you may specify different Cluster Instance resources with various
        `instance_class` sizes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.docdb.Cluster("default",
            cluster_identifier="docdb-cluster-demo",
            availability_zones=[
                "us-west-2a",
                "us-west-2b",
                "us-west-2c",
            ],
            master_username="foo",
            master_password="barbut8chars")
        cluster_instances = []
        for range in [{"value": i} for i in range(0, 2)]:
            cluster_instances.append(aws.docdb.ClusterInstance(f"cluster_instances-{range['value']}",
                identifier=f"docdb-cluster-demo-{range['value']}",
                cluster_identifier=default.id,
                instance_class="db.r5.large"))
        ```

        ## Import

        Using `pulumi import`, import DocumentDB Cluster Instances using the `identifier`. For example:

        ```sh
        $ pulumi import aws:docdb/clusterInstance:ClusterInstance prod_instance_1 aurora-cluster-instance-1
        ```

        :param str resource_name: The name of the resource.
        :param ClusterInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_performance_insights: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 identifier_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 promotion_tier: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterInstanceArgs.__new__(ClusterInstanceArgs)

            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["ca_cert_identifier"] = ca_cert_identifier
            if cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_identifier'")
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
            __props__.__dict__["enable_performance_insights"] = enable_performance_insights
            __props__.__dict__["engine"] = engine
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["identifier_prefix"] = identifier_prefix
            if instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'instance_class'")
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["performance_insights_kms_key_id"] = performance_insights_kms_key_id
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["promotion_tier"] = promotion_tier
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["db_subnet_group_name"] = None
            __props__.__dict__["dbi_resource_id"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["engine_version"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["preferred_backup_window"] = None
            __props__.__dict__["publicly_accessible"] = None
            __props__.__dict__["storage_encrypted"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["writer"] = None
        super(ClusterInstance, __self__).__init__(
            'aws:docdb/clusterInstance:ClusterInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_immediately: Optional[pulumi.Input[builtins.bool]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
            availability_zone: Optional[pulumi.Input[builtins.str]] = None,
            ca_cert_identifier: Optional[pulumi.Input[builtins.str]] = None,
            cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
            copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
            db_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
            dbi_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            enable_performance_insights: Optional[pulumi.Input[builtins.bool]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            engine: Optional[pulumi.Input[builtins.str]] = None,
            engine_version: Optional[pulumi.Input[builtins.str]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            identifier_prefix: Optional[pulumi.Input[builtins.str]] = None,
            instance_class: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
            preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
            promotion_tier: Optional[pulumi.Input[builtins.int]] = None,
            publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            writer: Optional[pulumi.Input[builtins.bool]] = None) -> 'ClusterInstance':
        """
        Get an existing ClusterInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] apply_immediately: Specifies whether any database modifications
               are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of cluster instance
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
        :param pulumi.Input[builtins.str] availability_zone: The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
        :param pulumi.Input[builtins.str] ca_cert_identifier: The identifier of the certificate authority (CA) certificate for the DB instance.
        :param pulumi.Input[builtins.str] cluster_identifier: The identifier of the `docdb.Cluster` in which to launch this instance.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshot: Copy all DB instance `tags` to snapshots. Default is `false`.
        :param pulumi.Input[builtins.str] db_subnet_group_name: The DB subnet group to associate with this DB instance.
        :param pulumi.Input[builtins.str] dbi_resource_id: The region-unique, immutable identifier for the DB instance.
        :param pulumi.Input[builtins.bool] enable_performance_insights: A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
        :param pulumi.Input[builtins.str] endpoint: The DNS address for this instance. May not be writable
        :param pulumi.Input[builtins.str] engine: The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
        :param pulumi.Input[builtins.str] engine_version: The database engine version
        :param pulumi.Input[builtins.str] identifier: The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
        :param pulumi.Input[builtins.str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[builtins.str] instance_class: The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
               DocumentDB currently supports the below instance classes.
               Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
               - db.r6g.large
               - db.r6g.xlarge
               - db.r6g.2xlarge
               - db.r6g.4xlarge
               - db.r6g.8xlarge
               - db.r6g.12xlarge
               - db.r6g.16xlarge
               - db.r5.large
               - db.r5.xlarge
               - db.r5.2xlarge
               - db.r5.4xlarge
               - db.r5.12xlarge
               - db.r5.24xlarge
               - db.r4.large
               - db.r4.xlarge
               - db.r4.2xlarge
               - db.r4.4xlarge
               - db.r4.8xlarge
               - db.r4.16xlarge
               - db.t4g.medium
               - db.t3.medium
        :param pulumi.Input[builtins.str] kms_key_id: The ARN for the KMS encryption key if one is set to the cluster.
        :param pulumi.Input[builtins.str] performance_insights_kms_key_id: The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
        :param pulumi.Input[builtins.int] port: The database port
        :param pulumi.Input[builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled.
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The window to perform maintenance in.
               Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[builtins.int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] storage_encrypted: Specifies whether the DB cluster is encrypted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.bool] writer: Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterInstanceState.__new__(_ClusterInstanceState)

        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["ca_cert_identifier"] = ca_cert_identifier
        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
        __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
        __props__.__dict__["dbi_resource_id"] = dbi_resource_id
        __props__.__dict__["enable_performance_insights"] = enable_performance_insights
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["identifier_prefix"] = identifier_prefix
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["performance_insights_kms_key_id"] = performance_insights_kms_key_id
        __props__.__dict__["port"] = port
        __props__.__dict__["preferred_backup_window"] = preferred_backup_window
        __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
        __props__.__dict__["promotion_tier"] = promotion_tier
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["region"] = region
        __props__.__dict__["storage_encrypted"] = storage_encrypted
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["writer"] = writer
        return ClusterInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether any database modifications
        are applied immediately, or during the next maintenance window. Default is`false`.
        """
        return pulumi.get(self, "apply_immediately")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of cluster instance
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set (see [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_DBInstance.html)). Default `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[builtins.str]:
        """
        The EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/documentdb/latest/developerguide/API_CreateDBInstance.html) about the details.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="caCertIdentifier")
    def ca_cert_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the certificate authority (CA) certificate for the DB instance.
        """
        return pulumi.get(self, "ca_cert_identifier")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the `docdb.Cluster` in which to launch this instance.
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Copy all DB instance `tags` to snapshots. Default is `false`.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The DB subnet group to associate with this DB instance.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @property
    @pulumi.getter(name="dbiResourceId")
    def dbi_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The region-unique, immutable identifier for the DB instance.
        """
        return pulumi.get(self, "dbi_resource_id")

    @property
    @pulumi.getter(name="enablePerformanceInsights")
    def enable_performance_insights(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether to enable Performance Insights for the DB Instance. Default `false`. See [docs] (https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html) about the details.
        """
        return pulumi.get(self, "enable_performance_insights")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The DNS address for this instance. May not be writable
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the database engine to be used for the DocumentDB instance. Defaults to `docdb`. Valid Values: `docdb`.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[builtins.str]:
        """
        The database engine version
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        The identifier for the DocumentDB instance, if omitted, the provider will assign a random, unique identifier.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> pulumi.Output[builtins.str]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[builtins.str]:
        """
        The instance class to use. For details on CPU and memory, see [Scaling for DocumentDB Instances](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-manage-performance.html#db-cluster-manage-scaling-instance).
        DocumentDB currently supports the below instance classes.
        Please see [AWS Documentation](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-classes.html#db-instance-class-specs) for complete details.
        - db.r6g.large
        - db.r6g.xlarge
        - db.r6g.2xlarge
        - db.r6g.4xlarge
        - db.r6g.8xlarge
        - db.r6g.12xlarge
        - db.r6g.16xlarge
        - db.r5.large
        - db.r5.xlarge
        - db.r5.2xlarge
        - db.r5.4xlarge
        - db.r5.12xlarge
        - db.r5.24xlarge
        - db.r4.large
        - db.r4.xlarge
        - db.r4.2xlarge
        - db.r4.4xlarge
        - db.r4.8xlarge
        - db.r4.16xlarge
        - db.t4g.medium
        - db.t3.medium
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        The ARN for the KMS encryption key if one is set to the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        The database port
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[builtins.str]:
        """
        The daily time range during which automated backups are created if automated backups are enabled.
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[builtins.str]:
        """
        The window to perform maintenance in.
        Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
        """
        return pulumi.get(self, "promotion_tier")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the DB cluster is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def writer(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        return pulumi.get(self, "writer")

