# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOrderableDbInstanceResult',
    'AwaitableGetOrderableDbInstanceResult',
    'get_orderable_db_instance',
    'get_orderable_db_instance_output',
]

@pulumi.output_type
class GetOrderableDbInstanceResult:
    """
    A collection of values returned by getOrderableDbInstance.
    """
    def __init__(__self__, availability_zones=None, engine=None, engine_version=None, id=None, instance_class=None, license_model=None, preferred_instance_classes=None, region=None, vpc=None):
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_class and not isinstance(instance_class, str):
            raise TypeError("Expected argument 'instance_class' to be a str")
        pulumi.set(__self__, "instance_class", instance_class)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if preferred_instance_classes and not isinstance(preferred_instance_classes, list):
            raise TypeError("Expected argument 'preferred_instance_classes' to be a list")
        pulumi.set(__self__, "preferred_instance_classes", preferred_instance_classes)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vpc and not isinstance(vpc, bool):
            raise TypeError("Expected argument 'vpc' to be a bool")
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[builtins.str]:
        """
        Availability zones where the instance is available.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter
    def engine(self) -> Optional[builtins.str]:
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> builtins.str:
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> builtins.str:
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[builtins.str]:
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="preferredInstanceClasses")
    def preferred_instance_classes(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "preferred_instance_classes")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def vpc(self) -> builtins.bool:
        return pulumi.get(self, "vpc")


class AwaitableGetOrderableDbInstanceResult(GetOrderableDbInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrderableDbInstanceResult(
            availability_zones=self.availability_zones,
            engine=self.engine,
            engine_version=self.engine_version,
            id=self.id,
            instance_class=self.instance_class,
            license_model=self.license_model,
            preferred_instance_classes=self.preferred_instance_classes,
            region=self.region,
            vpc=self.vpc)


def get_orderable_db_instance(engine: Optional[builtins.str] = None,
                              engine_version: Optional[builtins.str] = None,
                              instance_class: Optional[builtins.str] = None,
                              license_model: Optional[builtins.str] = None,
                              preferred_instance_classes: Optional[Sequence[builtins.str]] = None,
                              region: Optional[builtins.str] = None,
                              vpc: Optional[builtins.bool] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrderableDbInstanceResult:
    """
    Information about DocumentDB orderable DB instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.docdb.get_orderable_db_instance(engine="docdb",
        engine_version="3.6.0",
        license_model="na",
        preferred_instance_classes=[
            "db.r5.large",
            "db.r4.large",
            "db.t3.medium",
        ])
    ```


    :param builtins.str engine: DB engine. Default: `docdb`
    :param builtins.str engine_version: Version of the DB engine.
    :param builtins.str instance_class: DB instance class. Examples of classes are `db.r5.12xlarge`, `db.r5.24xlarge`, `db.r5.2xlarge`, `db.r5.4xlarge`, `db.r5.large`, `db.r5.xlarge`, and `db.t3.medium`. (Conflicts with `preferred_instance_classes`.)
    :param builtins.str license_model: License model. Default: `na`
    :param Sequence[builtins.str] preferred_instance_classes: Ordered list of preferred DocumentDB DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. (Conflicts with `instance_class`.)
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.bool vpc: Enable to show only VPC.
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    __args__['instanceClass'] = instance_class
    __args__['licenseModel'] = license_model
    __args__['preferredInstanceClasses'] = preferred_instance_classes
    __args__['region'] = region
    __args__['vpc'] = vpc
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:docdb/getOrderableDbInstance:getOrderableDbInstance', __args__, opts=opts, typ=GetOrderableDbInstanceResult).value

    return AwaitableGetOrderableDbInstanceResult(
        availability_zones=pulumi.get(__ret__, 'availability_zones'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        id=pulumi.get(__ret__, 'id'),
        instance_class=pulumi.get(__ret__, 'instance_class'),
        license_model=pulumi.get(__ret__, 'license_model'),
        preferred_instance_classes=pulumi.get(__ret__, 'preferred_instance_classes'),
        region=pulumi.get(__ret__, 'region'),
        vpc=pulumi.get(__ret__, 'vpc'))
def get_orderable_db_instance_output(engine: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     engine_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     instance_class: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     license_model: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     preferred_instance_classes: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                     region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     vpc: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrderableDbInstanceResult]:
    """
    Information about DocumentDB orderable DB instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.docdb.get_orderable_db_instance(engine="docdb",
        engine_version="3.6.0",
        license_model="na",
        preferred_instance_classes=[
            "db.r5.large",
            "db.r4.large",
            "db.t3.medium",
        ])
    ```


    :param builtins.str engine: DB engine. Default: `docdb`
    :param builtins.str engine_version: Version of the DB engine.
    :param builtins.str instance_class: DB instance class. Examples of classes are `db.r5.12xlarge`, `db.r5.24xlarge`, `db.r5.2xlarge`, `db.r5.4xlarge`, `db.r5.large`, `db.r5.xlarge`, and `db.t3.medium`. (Conflicts with `preferred_instance_classes`.)
    :param builtins.str license_model: License model. Default: `na`
    :param Sequence[builtins.str] preferred_instance_classes: Ordered list of preferred DocumentDB DB instance classes. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. (Conflicts with `instance_class`.)
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.bool vpc: Enable to show only VPC.
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    __args__['instanceClass'] = instance_class
    __args__['licenseModel'] = license_model
    __args__['preferredInstanceClasses'] = preferred_instance_classes
    __args__['region'] = region
    __args__['vpc'] = vpc
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:docdb/getOrderableDbInstance:getOrderableDbInstance', __args__, opts=opts, typ=GetOrderableDbInstanceResult)
    return __ret__.apply(lambda __response__: GetOrderableDbInstanceResult(
        availability_zones=pulumi.get(__response__, 'availability_zones'),
        engine=pulumi.get(__response__, 'engine'),
        engine_version=pulumi.get(__response__, 'engine_version'),
        id=pulumi.get(__response__, 'id'),
        instance_class=pulumi.get(__response__, 'instance_class'),
        license_model=pulumi.get(__response__, 'license_model'),
        preferred_instance_classes=pulumi.get(__response__, 'preferred_instance_classes'),
        region=pulumi.get(__response__, 'region'),
        vpc=pulumi.get(__response__, 'vpc')))
