# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterMasterUserSecret',
    'ClusterParameterGroupParameter',
    'ClusterRestoreToPointInTime',
    'ElasticClusterTimeouts',
    'GlobalClusterGlobalClusterMember',
]

@pulumi.output_type
class ClusterMasterUserSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "secretArn":
            suggest = "secret_arn"
        elif key == "secretStatus":
            suggest = "secret_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterUserSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterUserSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterUserSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[builtins.str] = None,
                 secret_arn: Optional[builtins.str] = None,
                 secret_status: Optional[builtins.str] = None):
        """
        :param builtins.str kms_key_id: The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_status is not None:
            pulumi.set(__self__, "secret_status", secret_status)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "secret_arn")

    @property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "secret_status")


@pulumi.output_type
class ClusterParameterGroupParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyMethod":
            suggest = "apply_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterParameterGroupParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterParameterGroupParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterParameterGroupParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str,
                 apply_method: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the DocumentDB parameter.
        :param builtins.str value: The value of the DocumentDB parameter.
        :param builtins.str apply_method: Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the DocumentDB parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the DocumentDB parameter.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[builtins.str]:
        """
        Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        return pulumi.get(self, "apply_method")


@pulumi.output_type
class ClusterRestoreToPointInTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceClusterIdentifier":
            suggest = "source_cluster_identifier"
        elif key == "restoreToTime":
            suggest = "restore_to_time"
        elif key == "restoreType":
            suggest = "restore_type"
        elif key == "useLatestRestorableTime":
            suggest = "use_latest_restorable_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRestoreToPointInTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRestoreToPointInTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRestoreToPointInTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_cluster_identifier: builtins.str,
                 restore_to_time: Optional[builtins.str] = None,
                 restore_type: Optional[builtins.str] = None,
                 use_latest_restorable_time: Optional[builtins.bool] = None):
        """
        :param builtins.str source_cluster_identifier: The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
        :param builtins.str restore_to_time: The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        :param builtins.str restore_type: The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
        :param builtins.bool use_latest_restorable_time: A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
        """
        pulumi.set(__self__, "source_cluster_identifier", source_cluster_identifier)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)

    @property
    @pulumi.getter(name="sourceClusterIdentifier")
    def source_cluster_identifier(self) -> builtins.str:
        """
        The identifier of the source DB cluster from which to restore. Must match the identifier of an existing DB cluster.
        """
        return pulumi.get(self, "source_cluster_identifier")

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[builtins.str]:
        """
        The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        """
        return pulumi.get(self, "restore_to_time")

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[builtins.str]:
        """
        The type of restore to be performed. Valid values are `full-copy`, `copy-on-write`.
        """
        return pulumi.get(self, "restore_type")

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[builtins.bool]:
        """
        A boolean value that indicates whether the DB cluster is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_to_time`.
        """
        return pulumi.get(self, "use_latest_restorable_time")


@pulumi.output_type
class ElasticClusterTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class GlobalClusterGlobalClusterMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbClusterArn":
            suggest = "db_cluster_arn"
        elif key == "isWriter":
            suggest = "is_writer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClusterGlobalClusterMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClusterGlobalClusterMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClusterGlobalClusterMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_cluster_arn: Optional[builtins.str] = None,
                 is_writer: Optional[builtins.bool] = None):
        """
        :param builtins.str db_cluster_arn: Amazon Resource Name (ARN) of member DB Cluster.
        :param builtins.bool is_writer: Whether the member is the primary DB Cluster.
        """
        if db_cluster_arn is not None:
            pulumi.set(__self__, "db_cluster_arn", db_cluster_arn)
        if is_writer is not None:
            pulumi.set(__self__, "is_writer", is_writer)

    @property
    @pulumi.getter(name="dbClusterArn")
    def db_cluster_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of member DB Cluster.
        """
        return pulumi.get(self, "db_cluster_arn")

    @property
    @pulumi.getter(name="isWriter")
    def is_writer(self) -> Optional[builtins.bool]:
        """
        Whether the member is the primary DB Cluster.
        """
        return pulumi.get(self, "is_writer")


