# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterEncryptionDetailArgs',
    'ClusterEncryptionDetailArgsDict',
    'ClusterMultiRegionPropertiesArgs',
    'ClusterMultiRegionPropertiesArgsDict',
    'ClusterPeeringTimeoutsArgs',
    'ClusterPeeringTimeoutsArgsDict',
    'ClusterTimeoutsArgs',
    'ClusterTimeoutsArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterEncryptionDetailArgsDict(TypedDict):
        encryption_status: pulumi.Input[builtins.str]
        """
        The status of encryption for the DSQL Cluster.
        """
        encryption_type: pulumi.Input[builtins.str]
        """
        The type of encryption that protects the data on the DSQL Cluster.
        """
elif False:
    ClusterEncryptionDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEncryptionDetailArgs:
    def __init__(__self__, *,
                 encryption_status: pulumi.Input[builtins.str],
                 encryption_type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] encryption_status: The status of encryption for the DSQL Cluster.
        :param pulumi.Input[builtins.str] encryption_type: The type of encryption that protects the data on the DSQL Cluster.
        """
        pulumi.set(__self__, "encryption_status", encryption_status)
        pulumi.set(__self__, "encryption_type", encryption_type)

    @property
    @pulumi.getter(name="encryptionStatus")
    def encryption_status(self) -> pulumi.Input[builtins.str]:
        """
        The status of encryption for the DSQL Cluster.
        """
        return pulumi.get(self, "encryption_status")

    @encryption_status.setter
    def encryption_status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "encryption_status", value)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of encryption that protects the data on the DSQL Cluster.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "encryption_type", value)


if not MYPY:
    class ClusterMultiRegionPropertiesArgsDict(TypedDict):
        clusters: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of DSQL Cluster ARNs peered to this cluster.
        """
        witness_region: NotRequired[pulumi.Input[builtins.str]]
        """
        Witness region for the multi-region clusters. Setting this makes this cluster a multi-region cluster. Changing it recreates the resource.
        """
elif False:
    ClusterMultiRegionPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMultiRegionPropertiesArgs:
    def __init__(__self__, *,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 witness_region: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] clusters: List of DSQL Cluster ARNs peered to this cluster.
        :param pulumi.Input[builtins.str] witness_region: Witness region for the multi-region clusters. Setting this makes this cluster a multi-region cluster. Changing it recreates the resource.
        """
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if witness_region is not None:
            pulumi.set(__self__, "witness_region", witness_region)

    @property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of DSQL Cluster ARNs peered to this cluster.
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "clusters", value)

    @property
    @pulumi.getter(name="witnessRegion")
    def witness_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Witness region for the multi-region clusters. Setting this makes this cluster a multi-region cluster. Changing it recreates the resource.
        """
        return pulumi.get(self, "witness_region")

    @witness_region.setter
    def witness_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "witness_region", value)


if not MYPY:
    class ClusterPeeringTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    ClusterPeeringTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPeeringTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)


if not MYPY:
    class ClusterTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        update: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    ClusterTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None,
                 delete: Optional[pulumi.Input[builtins.str]] = None,
                 update: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[builtins.str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[builtins.str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update", value)


