# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterEncryptionDetail',
    'ClusterMultiRegionProperties',
    'ClusterPeeringTimeouts',
    'ClusterTimeouts',
]

@pulumi.output_type
class ClusterEncryptionDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionStatus":
            suggest = "encryption_status"
        elif key == "encryptionType":
            suggest = "encryption_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_status: builtins.str,
                 encryption_type: builtins.str):
        """
        :param builtins.str encryption_status: The status of encryption for the DSQL Cluster.
        :param builtins.str encryption_type: The type of encryption that protects the data on the DSQL Cluster.
        """
        pulumi.set(__self__, "encryption_status", encryption_status)
        pulumi.set(__self__, "encryption_type", encryption_type)

    @property
    @pulumi.getter(name="encryptionStatus")
    def encryption_status(self) -> builtins.str:
        """
        The status of encryption for the DSQL Cluster.
        """
        return pulumi.get(self, "encryption_status")

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> builtins.str:
        """
        The type of encryption that protects the data on the DSQL Cluster.
        """
        return pulumi.get(self, "encryption_type")


@pulumi.output_type
class ClusterMultiRegionProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "witnessRegion":
            suggest = "witness_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMultiRegionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMultiRegionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMultiRegionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clusters: Optional[Sequence[builtins.str]] = None,
                 witness_region: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] clusters: List of DSQL Cluster ARNs peered to this cluster.
        :param builtins.str witness_region: Witness region for the multi-region clusters. Setting this makes this cluster a multi-region cluster. Changing it recreates the resource.
        """
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if witness_region is not None:
            pulumi.set(__self__, "witness_region", witness_region)

    @property
    @pulumi.getter
    def clusters(self) -> Optional[Sequence[builtins.str]]:
        """
        List of DSQL Cluster ARNs peered to this cluster.
        """
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter(name="witnessRegion")
    def witness_region(self) -> Optional[builtins.str]:
        """
        Witness region for the multi-region clusters. Setting this makes this cluster a multi-region cluster. Changing it recreates the resource.
        """
        return pulumi.get(self, "witness_region")


@pulumi.output_type
class ClusterPeeringTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class ClusterTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


