# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GlobalTableArgs', 'GlobalTable']

@pulumi.input_type
class GlobalTableArgs:
    def __init__(__self__, *,
                 replicas: pulumi.Input[Sequence[pulumi.Input['GlobalTableReplicaArgs']]],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a GlobalTable resource.
        :param pulumi.Input[Sequence[pulumi.Input['GlobalTableReplicaArgs']]] replicas: Underlying DynamoDB Table. At least 1 replica must be defined. See below.
        :param pulumi.Input[builtins.str] name: The name of the global table. Must match underlying DynamoDB Table names in all regions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "replicas", replicas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Input[Sequence[pulumi.Input['GlobalTableReplicaArgs']]]:
        """
        Underlying DynamoDB Table. At least 1 replica must be defined. See below.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: pulumi.Input[Sequence[pulumi.Input['GlobalTableReplicaArgs']]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the global table. Must match underlying DynamoDB Table names in all regions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _GlobalTableState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalTableReplicaArgs']]]] = None):
        """
        Input properties used for looking up and filtering GlobalTable resources.
        :param pulumi.Input[builtins.str] arn: The ARN of the DynamoDB Global Table
        :param pulumi.Input[builtins.str] name: The name of the global table. Must match underlying DynamoDB Table names in all regions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['GlobalTableReplicaArgs']]] replicas: Underlying DynamoDB Table. At least 1 replica must be defined. See below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the DynamoDB Global Table
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the global table. Must match underlying DynamoDB Table names in all regions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GlobalTableReplicaArgs']]]]:
        """
        Underlying DynamoDB Table. At least 1 replica must be defined. See below.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GlobalTableReplicaArgs']]]]):
        pulumi.set(self, "replicas", value)


@pulumi.type_token("aws:dynamodb/globalTable:GlobalTable")
class GlobalTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GlobalTableReplicaArgs', 'GlobalTableReplicaArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages [DynamoDB Global Tables V1 (version 2017.11.29)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html). These are layered on top of existing DynamoDB Tables.

        > **NOTE:** To instead manage [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html), use the `dynamodb.Table` resource `replica` configuration block.

        > Note: There are many restrictions before you can properly create DynamoDB Global Tables in multiple regions. See the [AWS DynamoDB Global Table Requirements](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables_reqs_bestpractices.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        us_east_1 = aws.dynamodb.Table("us-east-1",
            hash_key="myAttribute",
            name="myTable",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            read_capacity=1,
            write_capacity=1,
            attributes=[{
                "name": "myAttribute",
                "type": "S",
            }])
        us_west_2 = aws.dynamodb.Table("us-west-2",
            hash_key="myAttribute",
            name="myTable",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            read_capacity=1,
            write_capacity=1,
            attributes=[{
                "name": "myAttribute",
                "type": "S",
            }])
        my_table = aws.dynamodb.GlobalTable("myTable",
            name="myTable",
            replicas=[
                {
                    "region_name": "us-east-1",
                },
                {
                    "region_name": "us-west-2",
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    us_east_1,
                    us_west_2,
                ]))
        ```

        ## Import

        Using `pulumi import`, import DynamoDB Global Tables using the global table name. For example:

        ```sh
        $ pulumi import aws:dynamodb/globalTable:GlobalTable MyTable MyTable
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the global table. Must match underlying DynamoDB Table names in all regions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GlobalTableReplicaArgs', 'GlobalTableReplicaArgsDict']]]] replicas: Underlying DynamoDB Table. At least 1 replica must be defined. See below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlobalTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages [DynamoDB Global Tables V1 (version 2017.11.29)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html). These are layered on top of existing DynamoDB Tables.

        > **NOTE:** To instead manage [DynamoDB Global Tables V2 (version 2019.11.21)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html), use the `dynamodb.Table` resource `replica` configuration block.

        > Note: There are many restrictions before you can properly create DynamoDB Global Tables in multiple regions. See the [AWS DynamoDB Global Table Requirements](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables_reqs_bestpractices.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        us_east_1 = aws.dynamodb.Table("us-east-1",
            hash_key="myAttribute",
            name="myTable",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            read_capacity=1,
            write_capacity=1,
            attributes=[{
                "name": "myAttribute",
                "type": "S",
            }])
        us_west_2 = aws.dynamodb.Table("us-west-2",
            hash_key="myAttribute",
            name="myTable",
            stream_enabled=True,
            stream_view_type="NEW_AND_OLD_IMAGES",
            read_capacity=1,
            write_capacity=1,
            attributes=[{
                "name": "myAttribute",
                "type": "S",
            }])
        my_table = aws.dynamodb.GlobalTable("myTable",
            name="myTable",
            replicas=[
                {
                    "region_name": "us-east-1",
                },
                {
                    "region_name": "us-west-2",
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    us_east_1,
                    us_west_2,
                ]))
        ```

        ## Import

        Using `pulumi import`, import DynamoDB Global Tables using the global table name. For example:

        ```sh
        $ pulumi import aws:dynamodb/globalTable:GlobalTable MyTable MyTable
        ```

        :param str resource_name: The name of the resource.
        :param GlobalTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GlobalTableReplicaArgs', 'GlobalTableReplicaArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalTableArgs.__new__(GlobalTableArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if replicas is None and not opts.urn:
                raise TypeError("Missing required property 'replicas'")
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["arn"] = None
        super(GlobalTable, __self__).__init__(
            'aws:dynamodb/globalTable:GlobalTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GlobalTableReplicaArgs', 'GlobalTableReplicaArgsDict']]]]] = None) -> 'GlobalTable':
        """
        Get an existing GlobalTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The ARN of the DynamoDB Global Table
        :param pulumi.Input[builtins.str] name: The name of the global table. Must match underlying DynamoDB Table names in all regions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GlobalTableReplicaArgs', 'GlobalTableReplicaArgsDict']]]] replicas: Underlying DynamoDB Table. At least 1 replica must be defined. See below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalTableState.__new__(_GlobalTableState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["replicas"] = replicas
        return GlobalTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the DynamoDB Global Table
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the global table. Must match underlying DynamoDB Table names in all regions.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[Sequence['outputs.GlobalTableReplica']]:
        """
        Underlying DynamoDB Table. At least 1 replica must be defined. See below.
        """
        return pulumi.get(self, "replicas")

