# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GlobalTableReplica',
    'TableAttribute',
    'TableExportIncrementalExportSpecification',
    'TableGlobalSecondaryIndex',
    'TableGlobalSecondaryIndexOnDemandThroughput',
    'TableImportTable',
    'TableImportTableInputFormatOptions',
    'TableImportTableInputFormatOptionsCsv',
    'TableImportTableS3BucketSource',
    'TableLocalSecondaryIndex',
    'TableOnDemandThroughput',
    'TablePointInTimeRecovery',
    'TableReplica',
    'TableServerSideEncryption',
    'TableTtl',
    'GetTableAttributeResult',
    'GetTableGlobalSecondaryIndexResult',
    'GetTableGlobalSecondaryIndexOnDemandThroughputResult',
    'GetTableLocalSecondaryIndexResult',
    'GetTableOnDemandThroughputResult',
    'GetTablePointInTimeRecoveryResult',
    'GetTableReplicaResult',
    'GetTableServerSideEncryptionResult',
    'GetTableTtlResult',
]

@pulumi.output_type
class GlobalTableReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_name: builtins.str):
        """
        :param builtins.str region_name: AWS region name of replica DynamoDB TableE.g., `us-east-1`
        """
        pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> builtins.str:
        """
        AWS region name of replica DynamoDB TableE.g., `us-east-1`
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class TableAttribute(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str name: Name of the attribute
        :param builtins.str type: Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the attribute
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Attribute type. Valid values are `S` (string), `N` (number), `B` (binary).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TableExportIncrementalExportSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exportFromTime":
            suggest = "export_from_time"
        elif key == "exportToTime":
            suggest = "export_to_time"
        elif key == "exportViewType":
            suggest = "export_view_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExportIncrementalExportSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExportIncrementalExportSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExportIncrementalExportSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 export_from_time: Optional[builtins.str] = None,
                 export_to_time: Optional[builtins.str] = None,
                 export_view_type: Optional[builtins.str] = None):
        if export_from_time is not None:
            pulumi.set(__self__, "export_from_time", export_from_time)
        if export_to_time is not None:
            pulumi.set(__self__, "export_to_time", export_to_time)
        if export_view_type is not None:
            pulumi.set(__self__, "export_view_type", export_view_type)

    @property
    @pulumi.getter(name="exportFromTime")
    def export_from_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "export_from_time")

    @property
    @pulumi.getter(name="exportToTime")
    def export_to_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "export_to_time")

    @property
    @pulumi.getter(name="exportViewType")
    def export_view_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "export_view_type")


@pulumi.output_type
class TableGlobalSecondaryIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hashKey":
            suggest = "hash_key"
        elif key == "projectionType":
            suggest = "projection_type"
        elif key == "nonKeyAttributes":
            suggest = "non_key_attributes"
        elif key == "onDemandThroughput":
            suggest = "on_demand_throughput"
        elif key == "rangeKey":
            suggest = "range_key"
        elif key == "readCapacity":
            suggest = "read_capacity"
        elif key == "writeCapacity":
            suggest = "write_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableGlobalSecondaryIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableGlobalSecondaryIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableGlobalSecondaryIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hash_key: builtins.str,
                 name: builtins.str,
                 projection_type: builtins.str,
                 non_key_attributes: Optional[Sequence[builtins.str]] = None,
                 on_demand_throughput: Optional['outputs.TableGlobalSecondaryIndexOnDemandThroughput'] = None,
                 range_key: Optional[builtins.str] = None,
                 read_capacity: Optional[builtins.int] = None,
                 write_capacity: Optional[builtins.int] = None):
        """
        :param builtins.str hash_key: Name of the hash key in the index; must be defined as an attribute in the resource.
        :param builtins.str name: Name of the index.
        :param builtins.str projection_type: One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        :param Sequence[builtins.str] non_key_attributes: Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        :param 'TableGlobalSecondaryIndexOnDemandThroughputArgs' on_demand_throughput: Sets the maximum number of read and write units for the specified on-demand table. See below.
        :param builtins.str range_key: Name of the range key; must be defined
        :param builtins.int read_capacity: Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
        :param builtins.int write_capacity: Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        pulumi.set(__self__, "hash_key", hash_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "projection_type", projection_type)
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        if on_demand_throughput is not None:
            pulumi.set(__self__, "on_demand_throughput", on_demand_throughput)
        if range_key is not None:
            pulumi.set(__self__, "range_key", range_key)
        if read_capacity is not None:
            pulumi.set(__self__, "read_capacity", read_capacity)
        if write_capacity is not None:
            pulumi.set(__self__, "write_capacity", write_capacity)

    @property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> builtins.str:
        """
        Name of the hash key in the index; must be defined as an attribute in the resource.
        """
        return pulumi.get(self, "hash_key")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the index.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> builtins.str:
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        """
        return pulumi.get(self, "projection_type")

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[Sequence[builtins.str]]:
        """
        Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        return pulumi.get(self, "non_key_attributes")

    @property
    @pulumi.getter(name="onDemandThroughput")
    def on_demand_throughput(self) -> Optional['outputs.TableGlobalSecondaryIndexOnDemandThroughput']:
        """
        Sets the maximum number of read and write units for the specified on-demand table. See below.
        """
        return pulumi.get(self, "on_demand_throughput")

    @property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> Optional[builtins.str]:
        """
        Name of the range key; must be defined
        """
        return pulumi.get(self, "range_key")

    @property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> Optional[builtins.int]:
        """
        Number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        return pulumi.get(self, "read_capacity")

    @property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> Optional[builtins.int]:
        """
        Number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        return pulumi.get(self, "write_capacity")


@pulumi.output_type
class TableGlobalSecondaryIndexOnDemandThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReadRequestUnits":
            suggest = "max_read_request_units"
        elif key == "maxWriteRequestUnits":
            suggest = "max_write_request_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableGlobalSecondaryIndexOnDemandThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableGlobalSecondaryIndexOnDemandThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableGlobalSecondaryIndexOnDemandThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_read_request_units: Optional[builtins.int] = None,
                 max_write_request_units: Optional[builtins.int] = None):
        """
        :param builtins.int max_read_request_units: Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        :param builtins.int max_write_request_units: Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        if max_read_request_units is not None:
            pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        if max_write_request_units is not None:
            pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> Optional[builtins.int]:
        """
        Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_read_request_units")

    @property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> Optional[builtins.int]:
        """
        Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class TableImportTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputFormat":
            suggest = "input_format"
        elif key == "s3BucketSource":
            suggest = "s3_bucket_source"
        elif key == "inputCompressionType":
            suggest = "input_compression_type"
        elif key == "inputFormatOptions":
            suggest = "input_format_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableImportTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableImportTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableImportTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_format: builtins.str,
                 s3_bucket_source: 'outputs.TableImportTableS3BucketSource',
                 input_compression_type: Optional[builtins.str] = None,
                 input_format_options: Optional['outputs.TableImportTableInputFormatOptions'] = None):
        """
        :param builtins.str input_format: The format of the source data.
               Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
        :param 'TableImportTableS3BucketSourceArgs' s3_bucket_source: Values for the S3 bucket the source file is imported from.
               See below.
        :param builtins.str input_compression_type: Type of compression to be used on the input coming from the imported table.
               Valid values are `GZIP`, `ZSTD` and `NONE`.
        :param 'TableImportTableInputFormatOptionsArgs' input_format_options: Describe the format options for the data that was imported into the target table.
               There is one value, `csv`.
               See below.
        """
        pulumi.set(__self__, "input_format", input_format)
        pulumi.set(__self__, "s3_bucket_source", s3_bucket_source)
        if input_compression_type is not None:
            pulumi.set(__self__, "input_compression_type", input_compression_type)
        if input_format_options is not None:
            pulumi.set(__self__, "input_format_options", input_format_options)

    @property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> builtins.str:
        """
        The format of the source data.
        Valid values are `CSV`, `DYNAMODB_JSON`, and `ION`.
        """
        return pulumi.get(self, "input_format")

    @property
    @pulumi.getter(name="s3BucketSource")
    def s3_bucket_source(self) -> 'outputs.TableImportTableS3BucketSource':
        """
        Values for the S3 bucket the source file is imported from.
        See below.
        """
        return pulumi.get(self, "s3_bucket_source")

    @property
    @pulumi.getter(name="inputCompressionType")
    def input_compression_type(self) -> Optional[builtins.str]:
        """
        Type of compression to be used on the input coming from the imported table.
        Valid values are `GZIP`, `ZSTD` and `NONE`.
        """
        return pulumi.get(self, "input_compression_type")

    @property
    @pulumi.getter(name="inputFormatOptions")
    def input_format_options(self) -> Optional['outputs.TableImportTableInputFormatOptions']:
        """
        Describe the format options for the data that was imported into the target table.
        There is one value, `csv`.
        See below.
        """
        return pulumi.get(self, "input_format_options")


@pulumi.output_type
class TableImportTableInputFormatOptions(dict):
    def __init__(__self__, *,
                 csv: Optional['outputs.TableImportTableInputFormatOptionsCsv'] = None):
        """
        :param 'TableImportTableInputFormatOptionsCsvArgs' csv: This block contains the processing options for the CSV file being imported:
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)

    @property
    @pulumi.getter
    def csv(self) -> Optional['outputs.TableImportTableInputFormatOptionsCsv']:
        """
        This block contains the processing options for the CSV file being imported:
        """
        return pulumi.get(self, "csv")


@pulumi.output_type
class TableImportTableInputFormatOptionsCsv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerLists":
            suggest = "header_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableImportTableInputFormatOptionsCsv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableImportTableInputFormatOptionsCsv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableImportTableInputFormatOptionsCsv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: Optional[builtins.str] = None,
                 header_lists: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str delimiter: The delimiter used for separating items in the CSV file being imported.
        :param Sequence[builtins.str] header_lists: List of the headers used to specify a common header for all source CSV files being imported.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if header_lists is not None:
            pulumi.set(__self__, "header_lists", header_lists)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[builtins.str]:
        """
        The delimiter used for separating items in the CSV file being imported.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="headerLists")
    def header_lists(self) -> Optional[Sequence[builtins.str]]:
        """
        List of the headers used to specify a common header for all source CSV files being imported.
        """
        return pulumi.get(self, "header_lists")


@pulumi.output_type
class TableImportTableS3BucketSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketOwner":
            suggest = "bucket_owner"
        elif key == "keyPrefix":
            suggest = "key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableImportTableS3BucketSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableImportTableS3BucketSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableImportTableS3BucketSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 bucket_owner: Optional[builtins.str] = None,
                 key_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: The S3 bucket that is being imported from.
        :param builtins.str bucket_owner: The account number of the S3 bucket that is being imported from.
        :param builtins.str key_prefix: The key prefix shared by all S3 Objects that are being imported.
        """
        pulumi.set(__self__, "bucket", bucket)
        if bucket_owner is not None:
            pulumi.set(__self__, "bucket_owner", bucket_owner)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The S3 bucket that is being imported from.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> Optional[builtins.str]:
        """
        The account number of the S3 bucket that is being imported from.
        """
        return pulumi.get(self, "bucket_owner")

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[builtins.str]:
        """
        The key prefix shared by all S3 Objects that are being imported.
        """
        return pulumi.get(self, "key_prefix")


@pulumi.output_type
class TableLocalSecondaryIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectionType":
            suggest = "projection_type"
        elif key == "rangeKey":
            suggest = "range_key"
        elif key == "nonKeyAttributes":
            suggest = "non_key_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableLocalSecondaryIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableLocalSecondaryIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableLocalSecondaryIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 projection_type: builtins.str,
                 range_key: builtins.str,
                 non_key_attributes: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: Name of the index
        :param builtins.str projection_type: One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        :param builtins.str range_key: Name of the range key.
        :param Sequence[builtins.str] non_key_attributes: Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "projection_type", projection_type)
        pulumi.set(__self__, "range_key", range_key)
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the index
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> builtins.str:
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY` where `ALL` projects every attribute into the index, `KEYS_ONLY` projects  into the index only the table and index hash_key and sort_key attributes ,  `INCLUDE` projects into the index all of the attributes that are defined in `non_key_attributes` in addition to the attributes that that`KEYS_ONLY` project.
        """
        return pulumi.get(self, "projection_type")

    @property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> builtins.str:
        """
        Name of the range key.
        """
        return pulumi.get(self, "range_key")

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[Sequence[builtins.str]]:
        """
        Only required with `INCLUDE` as a projection type; a list of attributes to project into the index. These do not need to be defined as attributes on the table.
        """
        return pulumi.get(self, "non_key_attributes")


@pulumi.output_type
class TableOnDemandThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReadRequestUnits":
            suggest = "max_read_request_units"
        elif key == "maxWriteRequestUnits":
            suggest = "max_write_request_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableOnDemandThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableOnDemandThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableOnDemandThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_read_request_units: Optional[builtins.int] = None,
                 max_write_request_units: Optional[builtins.int] = None):
        """
        :param builtins.int max_read_request_units: Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        :param builtins.int max_write_request_units: Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        if max_read_request_units is not None:
            pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        if max_write_request_units is not None:
            pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> Optional[builtins.int]:
        """
        Maximum number of read request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_read_request_units")

    @property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> Optional[builtins.int]:
        """
        Maximum number of write request units for the specified table. To specify set the value greater than or equal to 1. To remove set the value to -1.
        """
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class TablePointInTimeRecovery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recoveryPeriodInDays":
            suggest = "recovery_period_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TablePointInTimeRecovery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TablePointInTimeRecovery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TablePointInTimeRecovery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 recovery_period_in_days: Optional[builtins.int] = None):
        """
        :param builtins.bool enabled: Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
        :param builtins.int recovery_period_in_days: Number of preceding days for which continuous backups are taken and maintained. Default is 35.
        """
        pulumi.set(__self__, "enabled", enabled)
        if recovery_period_in_days is not None:
            pulumi.set(__self__, "recovery_period_in_days", recovery_period_in_days)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether to enable point-in-time recovery. It can take 10 minutes to enable for new tables. If the `point_in_time_recovery` block is not provided, this defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="recoveryPeriodInDays")
    def recovery_period_in_days(self) -> Optional[builtins.int]:
        """
        Number of preceding days for which continuous backups are taken and maintained. Default is 35.
        """
        return pulumi.get(self, "recovery_period_in_days")


@pulumi.output_type
class TableReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionName":
            suggest = "region_name"
        elif key == "consistencyMode":
            suggest = "consistency_mode"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "pointInTimeRecovery":
            suggest = "point_in_time_recovery"
        elif key == "propagateTags":
            suggest = "propagate_tags"
        elif key == "streamArn":
            suggest = "stream_arn"
        elif key == "streamLabel":
            suggest = "stream_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_name: builtins.str,
                 arn: Optional[builtins.str] = None,
                 consistency_mode: Optional[builtins.str] = None,
                 kms_key_arn: Optional[builtins.str] = None,
                 point_in_time_recovery: Optional[builtins.bool] = None,
                 propagate_tags: Optional[builtins.bool] = None,
                 stream_arn: Optional[builtins.str] = None,
                 stream_label: Optional[builtins.str] = None):
        """
        :param builtins.str region_name: Region name of the replica.
        :param builtins.str arn: ARN of the table
        :param builtins.str consistency_mode: Whether this global table will be using `STRONG` consistency mode or `EVENTUAL` consistency mode. Default value is `EVENTUAL`.
        :param builtins.str kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption.
               This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`.
               **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
               **Note:** Changing this value will recreate the replica.
        :param builtins.bool point_in_time_recovery: Whether to enable Point In Time Recovery for the replica. Default is `false`.
        :param builtins.bool propagate_tags: Whether to propagate the global table's tags to a replica.
               Default is `false`.
               Changes to tags only move in one direction: from global (source) to replica.
               Tag drift on a replica will not trigger an update.
               Tag changes on the global table are propagated to replicas.
               Changing from `true` to `false` on a subsequent `apply` leaves replica tags as-is and no longer manages them.
        :param builtins.str stream_arn: ARN of the Table Stream. Only available when `stream_enabled = true`
        :param builtins.str stream_label: Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        """
        pulumi.set(__self__, "region_name", region_name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if consistency_mode is not None:
            pulumi.set(__self__, "consistency_mode", consistency_mode)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if point_in_time_recovery is not None:
            pulumi.set(__self__, "point_in_time_recovery", point_in_time_recovery)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)
        if stream_label is not None:
            pulumi.set(__self__, "stream_label", stream_label)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> builtins.str:
        """
        Region name of the replica.
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        ARN of the table
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="consistencyMode")
    def consistency_mode(self) -> Optional[builtins.str]:
        """
        Whether this global table will be using `STRONG` consistency mode or `EVENTUAL` consistency mode. Default value is `EVENTUAL`.
        """
        return pulumi.get(self, "consistency_mode")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        ARN of the CMK that should be used for the AWS KMS encryption.
        This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`.
        **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        **Note:** Changing this value will recreate the replica.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="pointInTimeRecovery")
    def point_in_time_recovery(self) -> Optional[builtins.bool]:
        """
        Whether to enable Point In Time Recovery for the replica. Default is `false`.
        """
        return pulumi.get(self, "point_in_time_recovery")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[builtins.bool]:
        """
        Whether to propagate the global table's tags to a replica.
        Default is `false`.
        Changes to tags only move in one direction: from global (source) to replica.
        Tag drift on a replica will not trigger an update.
        Tag changes on the global table are propagated to replicas.
        Changing from `true` to `false` on a subsequent `apply` leaves replica tags as-is and no longer manages them.
        """
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[builtins.str]:
        """
        ARN of the Table Stream. Only available when `stream_enabled = true`
        """
        return pulumi.get(self, "stream_arn")

    @property
    @pulumi.getter(name="streamLabel")
    def stream_label(self) -> Optional[builtins.str]:
        """
        Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
        """
        return pulumi.get(self, "stream_label")


@pulumi.output_type
class TableServerSideEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableServerSideEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableServerSideEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableServerSideEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 kms_key_arn: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Whether or not to enable encryption at rest using an AWS managed KMS customer master key (CMK). If `enabled` is `false` then server-side encryption is set to AWS-_owned_ key (shown as `DEFAULT` in the AWS console). Potentially confusingly, if `enabled` is `true` and no `kms_key_arn` is specified then server-side encryption is set to the _default_ KMS-_managed_ key (shown as `KMS` in the AWS console). The [AWS KMS documentation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) explains the difference between AWS-_owned_ and KMS-_managed_ keys.
        :param builtins.str kms_key_arn: ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        pulumi.set(__self__, "enabled", enabled)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether or not to enable encryption at rest using an AWS managed KMS customer master key (CMK). If `enabled` is `false` then server-side encryption is set to AWS-_owned_ key (shown as `DEFAULT` in the AWS console). Potentially confusingly, if `enabled` is `true` and no `kms_key_arn` is specified then server-side encryption is set to the _default_ KMS-_managed_ key (shown as `KMS` in the AWS console). The [AWS KMS documentation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) explains the difference between AWS-_owned_ and KMS-_managed_ keys.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class TableTtl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTtl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTtl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTtl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: Optional[builtins.str] = None,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str attribute_name: Name of the table attribute to store the TTL timestamp in.
               Required if `enabled` is `true`, must not be set otherwise.
        :param builtins.bool enabled: Whether TTL is enabled.
               Default value is `false`.
        """
        if attribute_name is not None:
            pulumi.set(__self__, "attribute_name", attribute_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> Optional[builtins.str]:
        """
        Name of the table attribute to store the TTL timestamp in.
        Required if `enabled` is `true`, must not be set otherwise.
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Whether TTL is enabled.
        Default value is `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetTableAttributeResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str name: Name of the DynamoDB table.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTableGlobalSecondaryIndexResult(dict):
    def __init__(__self__, *,
                 hash_key: builtins.str,
                 name: builtins.str,
                 non_key_attributes: Sequence[builtins.str],
                 on_demand_throughputs: Sequence['outputs.GetTableGlobalSecondaryIndexOnDemandThroughputResult'],
                 projection_type: builtins.str,
                 range_key: builtins.str,
                 read_capacity: builtins.int,
                 write_capacity: builtins.int):
        """
        :param builtins.str name: Name of the DynamoDB table.
        """
        pulumi.set(__self__, "hash_key", hash_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        pulumi.set(__self__, "on_demand_throughputs", on_demand_throughputs)
        pulumi.set(__self__, "projection_type", projection_type)
        pulumi.set(__self__, "range_key", range_key)
        pulumi.set(__self__, "read_capacity", read_capacity)
        pulumi.set(__self__, "write_capacity", write_capacity)

    @property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> builtins.str:
        return pulumi.get(self, "hash_key")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "non_key_attributes")

    @property
    @pulumi.getter(name="onDemandThroughputs")
    def on_demand_throughputs(self) -> Sequence['outputs.GetTableGlobalSecondaryIndexOnDemandThroughputResult']:
        return pulumi.get(self, "on_demand_throughputs")

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> builtins.str:
        return pulumi.get(self, "projection_type")

    @property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> builtins.str:
        return pulumi.get(self, "range_key")

    @property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> builtins.int:
        return pulumi.get(self, "read_capacity")

    @property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> builtins.int:
        return pulumi.get(self, "write_capacity")


@pulumi.output_type
class GetTableGlobalSecondaryIndexOnDemandThroughputResult(dict):
    def __init__(__self__, *,
                 max_read_request_units: builtins.int,
                 max_write_request_units: builtins.int):
        pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> builtins.int:
        return pulumi.get(self, "max_read_request_units")

    @property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> builtins.int:
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class GetTableLocalSecondaryIndexResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 non_key_attributes: Sequence[builtins.str],
                 projection_type: builtins.str,
                 range_key: builtins.str):
        """
        :param builtins.str name: Name of the DynamoDB table.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        pulumi.set(__self__, "projection_type", projection_type)
        pulumi.set(__self__, "range_key", range_key)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "non_key_attributes")

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> builtins.str:
        return pulumi.get(self, "projection_type")

    @property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> builtins.str:
        return pulumi.get(self, "range_key")


@pulumi.output_type
class GetTableOnDemandThroughputResult(dict):
    def __init__(__self__, *,
                 max_read_request_units: builtins.int,
                 max_write_request_units: builtins.int):
        pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> builtins.int:
        return pulumi.get(self, "max_read_request_units")

    @property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> builtins.int:
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class GetTablePointInTimeRecoveryResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 recovery_period_in_days: builtins.int):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "recovery_period_in_days", recovery_period_in_days)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="recoveryPeriodInDays")
    def recovery_period_in_days(self) -> builtins.int:
        return pulumi.get(self, "recovery_period_in_days")


@pulumi.output_type
class GetTableReplicaResult(dict):
    def __init__(__self__, *,
                 kms_key_arn: builtins.str,
                 region_name: builtins.str):
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> builtins.str:
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> builtins.str:
        return pulumi.get(self, "region_name")


@pulumi.output_type
class GetTableServerSideEncryptionResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 kms_key_arn: builtins.str):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> builtins.str:
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class GetTableTtlResult(dict):
    def __init__(__self__, *,
                 attribute_name: builtins.str,
                 enabled: builtins.bool):
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> builtins.str:
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        return pulumi.get(self, "enabled")


