# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AmiArgs', 'Ami']

@pulumi.input_type
class AmiArgs:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[builtins.str]] = None,
                 deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiEbsBlockDeviceArgs']]]] = None,
                 ena_support: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiEphemeralBlockDeviceArgs']]]] = None,
                 image_location: Optional[pulumi.Input[builtins.str]] = None,
                 imds_support: Optional[pulumi.Input[builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ramdisk_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 root_device_name: Optional[pulumi.Input[builtins.str]] = None,
                 sriov_net_support: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tpm_support: Optional[pulumi.Input[builtins.str]] = None,
                 uefi_data: Optional[pulumi.Input[builtins.str]] = None,
                 virtualization_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Ami resource.
        :param pulumi.Input[builtins.str] architecture: Machine architecture for created instances. Defaults to `x86_64`.
        :param pulumi.Input[builtins.str] boot_mode: Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[Sequence[pulumi.Input['AmiEbsBlockDeviceArgs']]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.bool] ena_support: Whether enhanced networking with ENA is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['AmiEphemeralBlockDeviceArgs']]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.str] imds_support: If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        :param pulumi.Input[builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] root_device_name: Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] tpm_support: If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] uefi_data: Base64 representation of the non-volatile UEFI variable store.
        :param pulumi.Input[builtins.str] virtualization_type: Keyword to choose what virtualization mode created instances
               will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
               changes the set of further arguments that are required, as described below.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if boot_mode is not None:
            pulumi.set(__self__, "boot_mode", boot_mode)
        if deprecation_time is not None:
            pulumi.set(__self__, "deprecation_time", deprecation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ena_support is not None:
            pulumi.set(__self__, "ena_support", ena_support)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if image_location is not None:
            pulumi.set(__self__, "image_location", image_location)
        if imds_support is not None:
            pulumi.set(__self__, "imds_support", imds_support)
        if kernel_id is not None:
            pulumi.set(__self__, "kernel_id", kernel_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ramdisk_id is not None:
            pulumi.set(__self__, "ramdisk_id", ramdisk_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_device_name is not None:
            pulumi.set(__self__, "root_device_name", root_device_name)
        if sriov_net_support is not None:
            pulumi.set(__self__, "sriov_net_support", sriov_net_support)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tpm_support is not None:
            pulumi.set(__self__, "tpm_support", tpm_support)
        if uefi_data is not None:
            pulumi.set(__self__, "uefi_data", uefi_data)
        if virtualization_type is not None:
            pulumi.set(__self__, "virtualization_type", virtualization_type)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Machine architecture for created instances. Defaults to `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "boot_mode")

    @boot_mode.setter
    def boot_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_mode", value)

    @property
    @pulumi.getter(name="deprecationTime")
    def deprecation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        """
        return pulumi.get(self, "deprecation_time")

    @deprecation_time.setter
    def deprecation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deprecation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Longer, human-readable description for the AMI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiEbsBlockDeviceArgs']]]]:
        """
        Nested block describing an EBS block device that should be
        attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="enaSupport")
    def ena_support(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether enhanced networking with ENA is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ena_support")

    @ena_support.setter
    def ena_support(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ena_support", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiEphemeralBlockDeviceArgs']]]]:
        """
        Nested block describing an ephemeral block device that
        should be attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter(name="imageLocation")
    def image_location(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "image_location")

    @image_location.setter
    def image_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_location", value)

    @property
    @pulumi.getter(name="imdsSupport")
    def imds_support(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        """
        return pulumi.get(self, "imds_support")

    @imds_support.setter
    def imds_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "imds_support", value)

    @property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "kernel_id")

    @kernel_id.setter
    def kernel_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kernel_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region-unique name for the AMI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ramdisk_id")

    @ramdisk_id.setter
    def ramdisk_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ramdisk_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootDeviceName")
    def root_device_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        """
        return pulumi.get(self, "root_device_name")

    @root_device_name.setter
    def root_device_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_device_name", value)

    @property
    @pulumi.getter(name="sriovNetSupport")
    def sriov_net_support(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "sriov_net_support")

    @sriov_net_support.setter
    def sriov_net_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sriov_net_support", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tpmSupport")
    def tpm_support(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "tpm_support")

    @tpm_support.setter
    def tpm_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tpm_support", value)

    @property
    @pulumi.getter(name="uefiData")
    def uefi_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64 representation of the non-volatile UEFI variable store.
        """
        return pulumi.get(self, "uefi_data")

    @uefi_data.setter
    def uefi_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uefi_data", value)

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Keyword to choose what virtualization mode created instances
        will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
        changes the set of further arguments that are required, as described below.
        """
        return pulumi.get(self, "virtualization_type")

    @virtualization_type.setter
    def virtualization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtualization_type", value)


@pulumi.input_type
class _AmiState:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[builtins.str]] = None,
                 deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiEbsBlockDeviceArgs']]]] = None,
                 ena_support: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiEphemeralBlockDeviceArgs']]]] = None,
                 hypervisor: Optional[pulumi.Input[builtins.str]] = None,
                 image_location: Optional[pulumi.Input[builtins.str]] = None,
                 image_owner_alias: Optional[pulumi.Input[builtins.str]] = None,
                 image_type: Optional[pulumi.Input[builtins.str]] = None,
                 imds_support: Optional[pulumi.Input[builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_launched_time: Optional[pulumi.Input[builtins.str]] = None,
                 manage_ebs_snapshots: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 platform_details: Optional[pulumi.Input[builtins.str]] = None,
                 public: Optional[pulumi.Input[builtins.bool]] = None,
                 ramdisk_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 root_device_name: Optional[pulumi.Input[builtins.str]] = None,
                 root_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 sriov_net_support: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tpm_support: Optional[pulumi.Input[builtins.str]] = None,
                 uefi_data: Optional[pulumi.Input[builtins.str]] = None,
                 usage_operation: Optional[pulumi.Input[builtins.str]] = None,
                 virtualization_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ami resources.
        :param pulumi.Input[builtins.str] architecture: Machine architecture for created instances. Defaults to `x86_64`.
        :param pulumi.Input[builtins.str] arn: ARN of the AMI.
        :param pulumi.Input[builtins.str] boot_mode: Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[Sequence[pulumi.Input['AmiEbsBlockDeviceArgs']]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.bool] ena_support: Whether enhanced networking with ENA is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['AmiEphemeralBlockDeviceArgs']]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.str] hypervisor: Hypervisor type of the image.
        :param pulumi.Input[builtins.str] image_owner_alias: AWS account alias (for example, amazon, self) or the AWS account ID of the AMI owner.
        :param pulumi.Input[builtins.str] image_type: Type of image.
        :param pulumi.Input[builtins.str] imds_support: If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        :param pulumi.Input[builtins.str] last_launched_time: Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        :param pulumi.Input[builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[builtins.str] owner_id: AWS account ID of the image owner.
        :param pulumi.Input[builtins.str] platform: This value is set to windows for Windows AMIs; otherwise, it is blank.
        :param pulumi.Input[builtins.str] platform_details: Platform details associated with the billing code of the AMI.
        :param pulumi.Input[builtins.bool] public: Whether the image has public launch permissions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] root_device_name: Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        :param pulumi.Input[builtins.str] root_snapshot_id: Snapshot ID for the root volume (for EBS-backed AMIs)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] tpm_support: If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] uefi_data: Base64 representation of the non-volatile UEFI variable store.
        :param pulumi.Input[builtins.str] usage_operation: Operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
        :param pulumi.Input[builtins.str] virtualization_type: Keyword to choose what virtualization mode created instances
               will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
               changes the set of further arguments that are required, as described below.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if boot_mode is not None:
            pulumi.set(__self__, "boot_mode", boot_mode)
        if deprecation_time is not None:
            pulumi.set(__self__, "deprecation_time", deprecation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ena_support is not None:
            pulumi.set(__self__, "ena_support", ena_support)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if hypervisor is not None:
            pulumi.set(__self__, "hypervisor", hypervisor)
        if image_location is not None:
            pulumi.set(__self__, "image_location", image_location)
        if image_owner_alias is not None:
            pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if imds_support is not None:
            pulumi.set(__self__, "imds_support", imds_support)
        if kernel_id is not None:
            pulumi.set(__self__, "kernel_id", kernel_id)
        if last_launched_time is not None:
            pulumi.set(__self__, "last_launched_time", last_launched_time)
        if manage_ebs_snapshots is not None:
            pulumi.set(__self__, "manage_ebs_snapshots", manage_ebs_snapshots)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if platform_details is not None:
            pulumi.set(__self__, "platform_details", platform_details)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if ramdisk_id is not None:
            pulumi.set(__self__, "ramdisk_id", ramdisk_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_device_name is not None:
            pulumi.set(__self__, "root_device_name", root_device_name)
        if root_snapshot_id is not None:
            pulumi.set(__self__, "root_snapshot_id", root_snapshot_id)
        if sriov_net_support is not None:
            pulumi.set(__self__, "sriov_net_support", sriov_net_support)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tpm_support is not None:
            pulumi.set(__self__, "tpm_support", tpm_support)
        if uefi_data is not None:
            pulumi.set(__self__, "uefi_data", uefi_data)
        if usage_operation is not None:
            pulumi.set(__self__, "usage_operation", usage_operation)
        if virtualization_type is not None:
            pulumi.set(__self__, "virtualization_type", virtualization_type)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Machine architecture for created instances. Defaults to `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the AMI.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "boot_mode")

    @boot_mode.setter
    def boot_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_mode", value)

    @property
    @pulumi.getter(name="deprecationTime")
    def deprecation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        """
        return pulumi.get(self, "deprecation_time")

    @deprecation_time.setter
    def deprecation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deprecation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Longer, human-readable description for the AMI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiEbsBlockDeviceArgs']]]]:
        """
        Nested block describing an EBS block device that should be
        attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="enaSupport")
    def ena_support(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether enhanced networking with ENA is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ena_support")

    @ena_support.setter
    def ena_support(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ena_support", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiEphemeralBlockDeviceArgs']]]]:
        """
        Nested block describing an ephemeral block device that
        should be attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter
    def hypervisor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hypervisor type of the image.
        """
        return pulumi.get(self, "hypervisor")

    @hypervisor.setter
    def hypervisor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hypervisor", value)

    @property
    @pulumi.getter(name="imageLocation")
    def image_location(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "image_location")

    @image_location.setter
    def image_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_location", value)

    @property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS account alias (for example, amazon, self) or the AWS account ID of the AMI owner.
        """
        return pulumi.get(self, "image_owner_alias")

    @image_owner_alias.setter
    def image_owner_alias(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_owner_alias", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of image.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="imdsSupport")
    def imds_support(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        """
        return pulumi.get(self, "imds_support")

    @imds_support.setter
    def imds_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "imds_support", value)

    @property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "kernel_id")

    @kernel_id.setter
    def kernel_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kernel_id", value)

    @property
    @pulumi.getter(name="lastLaunchedTime")
    def last_launched_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        """
        return pulumi.get(self, "last_launched_time")

    @last_launched_time.setter
    def last_launched_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_launched_time", value)

    @property
    @pulumi.getter(name="manageEbsSnapshots")
    def manage_ebs_snapshots(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "manage_ebs_snapshots")

    @manage_ebs_snapshots.setter
    def manage_ebs_snapshots(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "manage_ebs_snapshots", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region-unique name for the AMI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS account ID of the image owner.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This value is set to windows for Windows AMIs; otherwise, it is blank.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="platformDetails")
    def platform_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Platform details associated with the billing code of the AMI.
        """
        return pulumi.get(self, "platform_details")

    @platform_details.setter
    def platform_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_details", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the image has public launch permissions.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ramdisk_id")

    @ramdisk_id.setter
    def ramdisk_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ramdisk_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootDeviceName")
    def root_device_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        """
        return pulumi.get(self, "root_device_name")

    @root_device_name.setter
    def root_device_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_device_name", value)

    @property
    @pulumi.getter(name="rootSnapshotId")
    def root_snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot ID for the root volume (for EBS-backed AMIs)
        """
        return pulumi.get(self, "root_snapshot_id")

    @root_snapshot_id.setter
    def root_snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_snapshot_id", value)

    @property
    @pulumi.getter(name="sriovNetSupport")
    def sriov_net_support(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "sriov_net_support")

    @sriov_net_support.setter
    def sriov_net_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sriov_net_support", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="tpmSupport")
    def tpm_support(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "tpm_support")

    @tpm_support.setter
    def tpm_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tpm_support", value)

    @property
    @pulumi.getter(name="uefiData")
    def uefi_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64 representation of the non-volatile UEFI variable store.
        """
        return pulumi.get(self, "uefi_data")

    @uefi_data.setter
    def uefi_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uefi_data", value)

    @property
    @pulumi.getter(name="usageOperation")
    def usage_operation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
        """
        return pulumi.get(self, "usage_operation")

    @usage_operation.setter
    def usage_operation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "usage_operation", value)

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Keyword to choose what virtualization mode created instances
        will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
        changes the set of further arguments that are required, as described below.
        """
        return pulumi.get(self, "virtualization_type")

    @virtualization_type.setter
    def virtualization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtualization_type", value)


@pulumi.type_token("aws:ec2/ami:Ami")
class Ami(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[builtins.str]] = None,
                 deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiEbsBlockDeviceArgs', 'AmiEbsBlockDeviceArgsDict']]]]] = None,
                 ena_support: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiEphemeralBlockDeviceArgs', 'AmiEphemeralBlockDeviceArgsDict']]]]] = None,
                 image_location: Optional[pulumi.Input[builtins.str]] = None,
                 imds_support: Optional[pulumi.Input[builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ramdisk_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 root_device_name: Optional[pulumi.Input[builtins.str]] = None,
                 sriov_net_support: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tpm_support: Optional[pulumi.Input[builtins.str]] = None,
                 uefi_data: Optional[pulumi.Input[builtins.str]] = None,
                 virtualization_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The AMI resource allows the creation and management of a completely-custom
        *Amazon Machine Image* (AMI).

        If you just want to duplicate an existing AMI, possibly copying it to another
        region, it's better to use `ec2.AmiCopy` instead.

        If you just want to share an existing AMI with another AWS account,
        it's better to use `ec2.AmiLaunchPermission` instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create an AMI that will start a machine whose root device is backed by
        # an EBS volume populated from a snapshot. We assume that such a snapshot
        # already exists with the id "snap-xxxxxxxx".
        example = aws.ec2.Ami("example",
            name="example",
            virtualization_type="hvm",
            root_device_name="/dev/xvda",
            imds_support="v2.0",
            ebs_block_devices=[{
                "device_name": "/dev/xvda",
                "snapshot_id": "snap-xxxxxxxx",
                "volume_size": 8,
            }])
        ```

        ## Import

        Using `pulumi import`, import `aws_ami` using the ID of the AMI. For example:

        ```sh
        $ pulumi import aws:ec2/ami:Ami example ami-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] architecture: Machine architecture for created instances. Defaults to `x86_64`.
        :param pulumi.Input[builtins.str] boot_mode: Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiEbsBlockDeviceArgs', 'AmiEbsBlockDeviceArgsDict']]]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.bool] ena_support: Whether enhanced networking with ENA is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiEphemeralBlockDeviceArgs', 'AmiEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.str] imds_support: If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        :param pulumi.Input[builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] root_device_name: Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] tpm_support: If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] uefi_data: Base64 representation of the non-volatile UEFI variable store.
        :param pulumi.Input[builtins.str] virtualization_type: Keyword to choose what virtualization mode created instances
               will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
               changes the set of further arguments that are required, as described below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AmiArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AMI resource allows the creation and management of a completely-custom
        *Amazon Machine Image* (AMI).

        If you just want to duplicate an existing AMI, possibly copying it to another
        region, it's better to use `ec2.AmiCopy` instead.

        If you just want to share an existing AMI with another AWS account,
        it's better to use `ec2.AmiLaunchPermission` instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create an AMI that will start a machine whose root device is backed by
        # an EBS volume populated from a snapshot. We assume that such a snapshot
        # already exists with the id "snap-xxxxxxxx".
        example = aws.ec2.Ami("example",
            name="example",
            virtualization_type="hvm",
            root_device_name="/dev/xvda",
            imds_support="v2.0",
            ebs_block_devices=[{
                "device_name": "/dev/xvda",
                "snapshot_id": "snap-xxxxxxxx",
                "volume_size": 8,
            }])
        ```

        ## Import

        Using `pulumi import`, import `aws_ami` using the ID of the AMI. For example:

        ```sh
        $ pulumi import aws:ec2/ami:Ami example ami-12345678
        ```

        :param str resource_name: The name of the resource.
        :param AmiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AmiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[builtins.str]] = None,
                 deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiEbsBlockDeviceArgs', 'AmiEbsBlockDeviceArgsDict']]]]] = None,
                 ena_support: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiEphemeralBlockDeviceArgs', 'AmiEphemeralBlockDeviceArgsDict']]]]] = None,
                 image_location: Optional[pulumi.Input[builtins.str]] = None,
                 imds_support: Optional[pulumi.Input[builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ramdisk_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 root_device_name: Optional[pulumi.Input[builtins.str]] = None,
                 sriov_net_support: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tpm_support: Optional[pulumi.Input[builtins.str]] = None,
                 uefi_data: Optional[pulumi.Input[builtins.str]] = None,
                 virtualization_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AmiArgs.__new__(AmiArgs)

            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["boot_mode"] = boot_mode
            __props__.__dict__["deprecation_time"] = deprecation_time
            __props__.__dict__["description"] = description
            __props__.__dict__["ebs_block_devices"] = ebs_block_devices
            __props__.__dict__["ena_support"] = ena_support
            __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
            __props__.__dict__["image_location"] = image_location
            __props__.__dict__["imds_support"] = imds_support
            __props__.__dict__["kernel_id"] = kernel_id
            __props__.__dict__["name"] = name
            __props__.__dict__["ramdisk_id"] = ramdisk_id
            __props__.__dict__["region"] = region
            __props__.__dict__["root_device_name"] = root_device_name
            __props__.__dict__["sriov_net_support"] = sriov_net_support
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tpm_support"] = tpm_support
            __props__.__dict__["uefi_data"] = uefi_data
            __props__.__dict__["virtualization_type"] = virtualization_type
            __props__.__dict__["arn"] = None
            __props__.__dict__["hypervisor"] = None
            __props__.__dict__["image_owner_alias"] = None
            __props__.__dict__["image_type"] = None
            __props__.__dict__["last_launched_time"] = None
            __props__.__dict__["manage_ebs_snapshots"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["platform"] = None
            __props__.__dict__["platform_details"] = None
            __props__.__dict__["public"] = None
            __props__.__dict__["root_snapshot_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["usage_operation"] = None
        super(Ami, __self__).__init__(
            'aws:ec2/ami:Ami',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architecture: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            boot_mode: Optional[pulumi.Input[builtins.str]] = None,
            deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiEbsBlockDeviceArgs', 'AmiEbsBlockDeviceArgsDict']]]]] = None,
            ena_support: Optional[pulumi.Input[builtins.bool]] = None,
            ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiEphemeralBlockDeviceArgs', 'AmiEphemeralBlockDeviceArgsDict']]]]] = None,
            hypervisor: Optional[pulumi.Input[builtins.str]] = None,
            image_location: Optional[pulumi.Input[builtins.str]] = None,
            image_owner_alias: Optional[pulumi.Input[builtins.str]] = None,
            image_type: Optional[pulumi.Input[builtins.str]] = None,
            imds_support: Optional[pulumi.Input[builtins.str]] = None,
            kernel_id: Optional[pulumi.Input[builtins.str]] = None,
            last_launched_time: Optional[pulumi.Input[builtins.str]] = None,
            manage_ebs_snapshots: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner_id: Optional[pulumi.Input[builtins.str]] = None,
            platform: Optional[pulumi.Input[builtins.str]] = None,
            platform_details: Optional[pulumi.Input[builtins.str]] = None,
            public: Optional[pulumi.Input[builtins.bool]] = None,
            ramdisk_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            root_device_name: Optional[pulumi.Input[builtins.str]] = None,
            root_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
            sriov_net_support: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tpm_support: Optional[pulumi.Input[builtins.str]] = None,
            uefi_data: Optional[pulumi.Input[builtins.str]] = None,
            usage_operation: Optional[pulumi.Input[builtins.str]] = None,
            virtualization_type: Optional[pulumi.Input[builtins.str]] = None) -> 'Ami':
        """
        Get an existing Ami resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] architecture: Machine architecture for created instances. Defaults to `x86_64`.
        :param pulumi.Input[builtins.str] arn: ARN of the AMI.
        :param pulumi.Input[builtins.str] boot_mode: Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiEbsBlockDeviceArgs', 'AmiEbsBlockDeviceArgsDict']]]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.bool] ena_support: Whether enhanced networking with ENA is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiEphemeralBlockDeviceArgs', 'AmiEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.str] hypervisor: Hypervisor type of the image.
        :param pulumi.Input[builtins.str] image_owner_alias: AWS account alias (for example, amazon, self) or the AWS account ID of the AMI owner.
        :param pulumi.Input[builtins.str] image_type: Type of image.
        :param pulumi.Input[builtins.str] imds_support: If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        :param pulumi.Input[builtins.str] last_launched_time: Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        :param pulumi.Input[builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[builtins.str] owner_id: AWS account ID of the image owner.
        :param pulumi.Input[builtins.str] platform: This value is set to windows for Windows AMIs; otherwise, it is blank.
        :param pulumi.Input[builtins.str] platform_details: Platform details associated with the billing code of the AMI.
        :param pulumi.Input[builtins.bool] public: Whether the image has public launch permissions.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] root_device_name: Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        :param pulumi.Input[builtins.str] root_snapshot_id: Snapshot ID for the root volume (for EBS-backed AMIs)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] tpm_support: If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] uefi_data: Base64 representation of the non-volatile UEFI variable store.
        :param pulumi.Input[builtins.str] usage_operation: Operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
        :param pulumi.Input[builtins.str] virtualization_type: Keyword to choose what virtualization mode created instances
               will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
               changes the set of further arguments that are required, as described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AmiState.__new__(_AmiState)

        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["arn"] = arn
        __props__.__dict__["boot_mode"] = boot_mode
        __props__.__dict__["deprecation_time"] = deprecation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["ebs_block_devices"] = ebs_block_devices
        __props__.__dict__["ena_support"] = ena_support
        __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
        __props__.__dict__["hypervisor"] = hypervisor
        __props__.__dict__["image_location"] = image_location
        __props__.__dict__["image_owner_alias"] = image_owner_alias
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["imds_support"] = imds_support
        __props__.__dict__["kernel_id"] = kernel_id
        __props__.__dict__["last_launched_time"] = last_launched_time
        __props__.__dict__["manage_ebs_snapshots"] = manage_ebs_snapshots
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["platform"] = platform
        __props__.__dict__["platform_details"] = platform_details
        __props__.__dict__["public"] = public
        __props__.__dict__["ramdisk_id"] = ramdisk_id
        __props__.__dict__["region"] = region
        __props__.__dict__["root_device_name"] = root_device_name
        __props__.__dict__["root_snapshot_id"] = root_snapshot_id
        __props__.__dict__["sriov_net_support"] = sriov_net_support
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tpm_support"] = tpm_support
        __props__.__dict__["uefi_data"] = uefi_data
        __props__.__dict__["usage_operation"] = usage_operation
        __props__.__dict__["virtualization_type"] = virtualization_type
        return Ami(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Machine architecture for created instances. Defaults to `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the AMI.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "boot_mode")

    @property
    @pulumi.getter(name="deprecationTime")
    def deprecation_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        """
        return pulumi.get(self, "deprecation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Longer, human-readable description for the AMI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> pulumi.Output[Sequence['outputs.AmiEbsBlockDevice']]:
        """
        Nested block describing an EBS block device that should be
        attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @property
    @pulumi.getter(name="enaSupport")
    def ena_support(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether enhanced networking with ENA is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ena_support")

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> pulumi.Output[Sequence['outputs.AmiEphemeralBlockDevice']]:
        """
        Nested block describing an ephemeral block device that
        should be attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @property
    @pulumi.getter
    def hypervisor(self) -> pulumi.Output[builtins.str]:
        """
        Hypervisor type of the image.
        """
        return pulumi.get(self, "hypervisor")

    @property
    @pulumi.getter(name="imageLocation")
    def image_location(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "image_location")

    @property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> pulumi.Output[builtins.str]:
        """
        AWS account alias (for example, amazon, self) or the AWS account ID of the AMI owner.
        """
        return pulumi.get(self, "image_owner_alias")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of image.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="imdsSupport")
    def imds_support(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        """
        return pulumi.get(self, "imds_support")

    @property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "kernel_id")

    @property
    @pulumi.getter(name="lastLaunchedTime")
    def last_launched_time(self) -> pulumi.Output[builtins.str]:
        """
        Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        """
        return pulumi.get(self, "last_launched_time")

    @property
    @pulumi.getter(name="manageEbsSnapshots")
    def manage_ebs_snapshots(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "manage_ebs_snapshots")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Region-unique name for the AMI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[builtins.str]:
        """
        AWS account ID of the image owner.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[builtins.str]:
        """
        This value is set to windows for Windows AMIs; otherwise, it is blank.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="platformDetails")
    def platform_details(self) -> pulumi.Output[builtins.str]:
        """
        Platform details associated with the billing code of the AMI.
        """
        return pulumi.get(self, "platform_details")

    @property
    @pulumi.getter
    def public(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the image has public launch permissions.
        """
        return pulumi.get(self, "public")

    @property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "ramdisk_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootDeviceName")
    def root_device_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        """
        return pulumi.get(self, "root_device_name")

    @property
    @pulumi.getter(name="rootSnapshotId")
    def root_snapshot_id(self) -> pulumi.Output[builtins.str]:
        """
        Snapshot ID for the root volume (for EBS-backed AMIs)
        """
        return pulumi.get(self, "root_snapshot_id")

    @property
    @pulumi.getter(name="sriovNetSupport")
    def sriov_net_support(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "sriov_net_support")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="tpmSupport")
    def tpm_support(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "tpm_support")

    @property
    @pulumi.getter(name="uefiData")
    def uefi_data(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Base64 representation of the non-volatile UEFI variable store.
        """
        return pulumi.get(self, "uefi_data")

    @property
    @pulumi.getter(name="usageOperation")
    def usage_operation(self) -> pulumi.Output[builtins.str]:
        """
        Operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
        """
        return pulumi.get(self, "usage_operation")

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Keyword to choose what virtualization mode created instances
        will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
        changes the set of further arguments that are required, as described below.
        """
        return pulumi.get(self, "virtualization_type")

