# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AmiCopyArgs', 'AmiCopy']

@pulumi.input_type
class AmiCopyArgs:
    def __init__(__self__, *,
                 source_ami_id: pulumi.Input[builtins.str],
                 source_ami_region: pulumi.Input[builtins.str],
                 deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEbsBlockDeviceArgs']]]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEphemeralBlockDeviceArgs']]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AmiCopy resource.
        :param pulumi.Input[builtins.str] source_ami_id: Id of the AMI to copy. This id must be valid in the region
               given by `source_ami_region`.
        :param pulumi.Input[builtins.str] source_ami_region: Region from which the AMI will be copied. This may be the
               same as the AWS provider region in order to create a copy within the same region.
        :param pulumi.Input[builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[builtins.str] destination_outpost_arn: ARN of the Outpost to which to copy the AMI.
               Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
        :param pulumi.Input[Sequence[pulumi.Input['AmiCopyEbsBlockDeviceArgs']]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.bool] encrypted: Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
        :param pulumi.Input[Sequence[pulumi.Input['AmiCopyEphemeralBlockDeviceArgs']]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.str] kms_key_id: Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
        :param pulumi.Input[builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "source_ami_id", source_ami_id)
        pulumi.set(__self__, "source_ami_region", source_ami_region)
        if deprecation_time is not None:
            pulumi.set(__self__, "deprecation_time", deprecation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_outpost_arn is not None:
            pulumi.set(__self__, "destination_outpost_arn", destination_outpost_arn)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="sourceAmiId")
    def source_ami_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the AMI to copy. This id must be valid in the region
        given by `source_ami_region`.
        """
        return pulumi.get(self, "source_ami_id")

    @source_ami_id.setter
    def source_ami_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_ami_id", value)

    @property
    @pulumi.getter(name="sourceAmiRegion")
    def source_ami_region(self) -> pulumi.Input[builtins.str]:
        """
        Region from which the AMI will be copied. This may be the
        same as the AWS provider region in order to create a copy within the same region.
        """
        return pulumi.get(self, "source_ami_region")

    @source_ami_region.setter
    def source_ami_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_ami_region", value)

    @property
    @pulumi.getter(name="deprecationTime")
    def deprecation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        """
        return pulumi.get(self, "deprecation_time")

    @deprecation_time.setter
    def deprecation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deprecation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Longer, human-readable description for the AMI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationOutpostArn")
    def destination_outpost_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Outpost to which to copy the AMI.
        Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
        """
        return pulumi.get(self, "destination_outpost_arn")

    @destination_outpost_arn.setter
    def destination_outpost_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_outpost_arn", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEbsBlockDeviceArgs']]]]:
        """
        Nested block describing an EBS block device that should be
        attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEphemeralBlockDeviceArgs']]]]:
        """
        Nested block describing an ephemeral block device that
        should be attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region-unique name for the AMI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AmiCopyState:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[builtins.str]] = None,
                 deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEbsBlockDeviceArgs']]]] = None,
                 ena_support: Optional[pulumi.Input[builtins.bool]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEphemeralBlockDeviceArgs']]]] = None,
                 hypervisor: Optional[pulumi.Input[builtins.str]] = None,
                 image_location: Optional[pulumi.Input[builtins.str]] = None,
                 image_owner_alias: Optional[pulumi.Input[builtins.str]] = None,
                 image_type: Optional[pulumi.Input[builtins.str]] = None,
                 imds_support: Optional[pulumi.Input[builtins.str]] = None,
                 kernel_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_launched_time: Optional[pulumi.Input[builtins.str]] = None,
                 manage_ebs_snapshots: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 platform_details: Optional[pulumi.Input[builtins.str]] = None,
                 public: Optional[pulumi.Input[builtins.bool]] = None,
                 ramdisk_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 root_device_name: Optional[pulumi.Input[builtins.str]] = None,
                 root_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_ami_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_ami_region: Optional[pulumi.Input[builtins.str]] = None,
                 sriov_net_support: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tpm_support: Optional[pulumi.Input[builtins.str]] = None,
                 uefi_data: Optional[pulumi.Input[builtins.str]] = None,
                 usage_operation: Optional[pulumi.Input[builtins.str]] = None,
                 virtualization_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AmiCopy resources.
        :param pulumi.Input[builtins.str] architecture: Machine architecture for created instances. Defaults to `x86_64`.
        :param pulumi.Input[builtins.str] arn: ARN of the AMI.
        :param pulumi.Input[builtins.str] boot_mode: Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[builtins.str] destination_outpost_arn: ARN of the Outpost to which to copy the AMI.
               Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
        :param pulumi.Input[Sequence[pulumi.Input['AmiCopyEbsBlockDeviceArgs']]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.bool] ena_support: Whether enhanced networking with ENA is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] encrypted: Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
        :param pulumi.Input[Sequence[pulumi.Input['AmiCopyEphemeralBlockDeviceArgs']]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.str] image_location: Path to an S3 object containing an image manifest, e.g., created
               by the `ec2-upload-bundle` command in the EC2 command line tools.
        :param pulumi.Input[builtins.str] imds_support: If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        :param pulumi.Input[builtins.str] kernel_id: ID of the kernel image (AKI) that will be used as the paravirtual
               kernel in created instances.
        :param pulumi.Input[builtins.str] kms_key_id: Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
        :param pulumi.Input[builtins.str] last_launched_time: Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        :param pulumi.Input[builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[builtins.str] ramdisk_id: ID of an initrd image (ARI) that will be used when booting the
               created instances.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] root_device_name: Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        :param pulumi.Input[builtins.str] source_ami_id: Id of the AMI to copy. This id must be valid in the region
               given by `source_ami_region`.
        :param pulumi.Input[builtins.str] source_ami_region: Region from which the AMI will be copied. This may be the
               same as the AWS provider region in order to create a copy within the same region.
        :param pulumi.Input[builtins.str] sriov_net_support: When set to "simple" (the default), enables enhanced networking
               for created instances. No other value is supported at this time.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] tpm_support: If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] uefi_data: Base64 representation of the non-volatile UEFI variable store.
        :param pulumi.Input[builtins.str] virtualization_type: Keyword to choose what virtualization mode created instances
               will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
               changes the set of further arguments that are required, as described below.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if boot_mode is not None:
            pulumi.set(__self__, "boot_mode", boot_mode)
        if deprecation_time is not None:
            pulumi.set(__self__, "deprecation_time", deprecation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_outpost_arn is not None:
            pulumi.set(__self__, "destination_outpost_arn", destination_outpost_arn)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ena_support is not None:
            pulumi.set(__self__, "ena_support", ena_support)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if hypervisor is not None:
            pulumi.set(__self__, "hypervisor", hypervisor)
        if image_location is not None:
            pulumi.set(__self__, "image_location", image_location)
        if image_owner_alias is not None:
            pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if imds_support is not None:
            pulumi.set(__self__, "imds_support", imds_support)
        if kernel_id is not None:
            pulumi.set(__self__, "kernel_id", kernel_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if last_launched_time is not None:
            pulumi.set(__self__, "last_launched_time", last_launched_time)
        if manage_ebs_snapshots is not None:
            pulumi.set(__self__, "manage_ebs_snapshots", manage_ebs_snapshots)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if platform_details is not None:
            pulumi.set(__self__, "platform_details", platform_details)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if ramdisk_id is not None:
            pulumi.set(__self__, "ramdisk_id", ramdisk_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_device_name is not None:
            pulumi.set(__self__, "root_device_name", root_device_name)
        if root_snapshot_id is not None:
            pulumi.set(__self__, "root_snapshot_id", root_snapshot_id)
        if source_ami_id is not None:
            pulumi.set(__self__, "source_ami_id", source_ami_id)
        if source_ami_region is not None:
            pulumi.set(__self__, "source_ami_region", source_ami_region)
        if sriov_net_support is not None:
            pulumi.set(__self__, "sriov_net_support", sriov_net_support)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tpm_support is not None:
            pulumi.set(__self__, "tpm_support", tpm_support)
        if uefi_data is not None:
            pulumi.set(__self__, "uefi_data", uefi_data)
        if usage_operation is not None:
            pulumi.set(__self__, "usage_operation", usage_operation)
        if virtualization_type is not None:
            pulumi.set(__self__, "virtualization_type", virtualization_type)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Machine architecture for created instances. Defaults to `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the AMI.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "boot_mode")

    @boot_mode.setter
    def boot_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_mode", value)

    @property
    @pulumi.getter(name="deprecationTime")
    def deprecation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        """
        return pulumi.get(self, "deprecation_time")

    @deprecation_time.setter
    def deprecation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deprecation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Longer, human-readable description for the AMI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationOutpostArn")
    def destination_outpost_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Outpost to which to copy the AMI.
        Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
        """
        return pulumi.get(self, "destination_outpost_arn")

    @destination_outpost_arn.setter
    def destination_outpost_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_outpost_arn", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEbsBlockDeviceArgs']]]]:
        """
        Nested block describing an EBS block device that should be
        attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="enaSupport")
    def ena_support(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether enhanced networking with ENA is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ena_support")

    @ena_support.setter
    def ena_support(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ena_support", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEphemeralBlockDeviceArgs']]]]:
        """
        Nested block describing an ephemeral block device that
        should be attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AmiCopyEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter
    def hypervisor(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "hypervisor")

    @hypervisor.setter
    def hypervisor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hypervisor", value)

    @property
    @pulumi.getter(name="imageLocation")
    def image_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to an S3 object containing an image manifest, e.g., created
        by the `ec2-upload-bundle` command in the EC2 command line tools.
        """
        return pulumi.get(self, "image_location")

    @image_location.setter
    def image_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_location", value)

    @property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "image_owner_alias")

    @image_owner_alias.setter
    def image_owner_alias(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_owner_alias", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="imdsSupport")
    def imds_support(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        """
        return pulumi.get(self, "imds_support")

    @imds_support.setter
    def imds_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "imds_support", value)

    @property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the kernel image (AKI) that will be used as the paravirtual
        kernel in created instances.
        """
        return pulumi.get(self, "kernel_id")

    @kernel_id.setter
    def kernel_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kernel_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lastLaunchedTime")
    def last_launched_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        """
        return pulumi.get(self, "last_launched_time")

    @last_launched_time.setter
    def last_launched_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_launched_time", value)

    @property
    @pulumi.getter(name="manageEbsSnapshots")
    def manage_ebs_snapshots(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "manage_ebs_snapshots")

    @manage_ebs_snapshots.setter
    def manage_ebs_snapshots(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "manage_ebs_snapshots", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region-unique name for the AMI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="platformDetails")
    def platform_details(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "platform_details")

    @platform_details.setter
    def platform_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_details", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of an initrd image (ARI) that will be used when booting the
        created instances.
        """
        return pulumi.get(self, "ramdisk_id")

    @ramdisk_id.setter
    def ramdisk_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ramdisk_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootDeviceName")
    def root_device_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        """
        return pulumi.get(self, "root_device_name")

    @root_device_name.setter
    def root_device_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_device_name", value)

    @property
    @pulumi.getter(name="rootSnapshotId")
    def root_snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "root_snapshot_id")

    @root_snapshot_id.setter
    def root_snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_snapshot_id", value)

    @property
    @pulumi.getter(name="sourceAmiId")
    def source_ami_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the AMI to copy. This id must be valid in the region
        given by `source_ami_region`.
        """
        return pulumi.get(self, "source_ami_id")

    @source_ami_id.setter
    def source_ami_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_ami_id", value)

    @property
    @pulumi.getter(name="sourceAmiRegion")
    def source_ami_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region from which the AMI will be copied. This may be the
        same as the AWS provider region in order to create a copy within the same region.
        """
        return pulumi.get(self, "source_ami_region")

    @source_ami_region.setter
    def source_ami_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_ami_region", value)

    @property
    @pulumi.getter(name="sriovNetSupport")
    def sriov_net_support(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When set to "simple" (the default), enables enhanced networking
        for created instances. No other value is supported at this time.
        """
        return pulumi.get(self, "sriov_net_support")

    @sriov_net_support.setter
    def sriov_net_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sriov_net_support", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="tpmSupport")
    def tpm_support(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "tpm_support")

    @tpm_support.setter
    def tpm_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tpm_support", value)

    @property
    @pulumi.getter(name="uefiData")
    def uefi_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64 representation of the non-volatile UEFI variable store.
        """
        return pulumi.get(self, "uefi_data")

    @uefi_data.setter
    def uefi_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uefi_data", value)

    @property
    @pulumi.getter(name="usageOperation")
    def usage_operation(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "usage_operation")

    @usage_operation.setter
    def usage_operation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "usage_operation", value)

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Keyword to choose what virtualization mode created instances
        will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
        changes the set of further arguments that are required, as described below.
        """
        return pulumi.get(self, "virtualization_type")

    @virtualization_type.setter
    def virtualization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtualization_type", value)


@pulumi.type_token("aws:ec2/amiCopy:AmiCopy")
class AmiCopy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEbsBlockDeviceArgs', 'AmiCopyEbsBlockDeviceArgsDict']]]]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEphemeralBlockDeviceArgs', 'AmiCopyEphemeralBlockDeviceArgsDict']]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_ami_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_ami_region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        The "AMI copy" resource allows duplication of an Amazon Machine Image (AMI),
        including cross-region copies.

        If the source AMI has associated EBS snapshots, those will also be duplicated
        along with the AMI.

        This is useful for taking a single AMI provisioned in one region and making
        it available in another for a multi-region deployment.

        Copying an AMI can take several minutes. The creation of this resource will
        block until the new AMI is available for use on new instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiCopy("example",
            name="example",
            source_ami_id="ami-xxxxxxxx",
            source_ami_region="us-west-1",
            tags={
                "Name": "HelloWorld",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[builtins.str] destination_outpost_arn: ARN of the Outpost to which to copy the AMI.
               Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEbsBlockDeviceArgs', 'AmiCopyEbsBlockDeviceArgsDict']]]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.bool] encrypted: Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEphemeralBlockDeviceArgs', 'AmiCopyEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.str] kms_key_id: Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
        :param pulumi.Input[builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] source_ami_id: Id of the AMI to copy. This id must be valid in the region
               given by `source_ami_region`.
        :param pulumi.Input[builtins.str] source_ami_region: Region from which the AMI will be copied. This may be the
               same as the AWS provider region in order to create a copy within the same region.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AmiCopyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The "AMI copy" resource allows duplication of an Amazon Machine Image (AMI),
        including cross-region copies.

        If the source AMI has associated EBS snapshots, those will also be duplicated
        along with the AMI.

        This is useful for taking a single AMI provisioned in one region and making
        it available in another for a multi-region deployment.

        Copying an AMI can take several minutes. The creation of this resource will
        block until the new AMI is available for use on new instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiCopy("example",
            name="example",
            source_ami_id="ami-xxxxxxxx",
            source_ami_region="us-west-1",
            tags={
                "Name": "HelloWorld",
            })
        ```

        :param str resource_name: The name of the resource.
        :param AmiCopyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AmiCopyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEbsBlockDeviceArgs', 'AmiCopyEbsBlockDeviceArgsDict']]]]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEphemeralBlockDeviceArgs', 'AmiCopyEphemeralBlockDeviceArgsDict']]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_ami_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_ami_region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AmiCopyArgs.__new__(AmiCopyArgs)

            __props__.__dict__["deprecation_time"] = deprecation_time
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_outpost_arn"] = destination_outpost_arn
            __props__.__dict__["ebs_block_devices"] = ebs_block_devices
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if source_ami_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_ami_id'")
            __props__.__dict__["source_ami_id"] = source_ami_id
            if source_ami_region is None and not opts.urn:
                raise TypeError("Missing required property 'source_ami_region'")
            __props__.__dict__["source_ami_region"] = source_ami_region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["architecture"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["boot_mode"] = None
            __props__.__dict__["ena_support"] = None
            __props__.__dict__["hypervisor"] = None
            __props__.__dict__["image_location"] = None
            __props__.__dict__["image_owner_alias"] = None
            __props__.__dict__["image_type"] = None
            __props__.__dict__["imds_support"] = None
            __props__.__dict__["kernel_id"] = None
            __props__.__dict__["last_launched_time"] = None
            __props__.__dict__["manage_ebs_snapshots"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["platform"] = None
            __props__.__dict__["platform_details"] = None
            __props__.__dict__["public"] = None
            __props__.__dict__["ramdisk_id"] = None
            __props__.__dict__["root_device_name"] = None
            __props__.__dict__["root_snapshot_id"] = None
            __props__.__dict__["sriov_net_support"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["tpm_support"] = None
            __props__.__dict__["uefi_data"] = None
            __props__.__dict__["usage_operation"] = None
            __props__.__dict__["virtualization_type"] = None
        super(AmiCopy, __self__).__init__(
            'aws:ec2/amiCopy:AmiCopy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architecture: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            boot_mode: Optional[pulumi.Input[builtins.str]] = None,
            deprecation_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destination_outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
            ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEbsBlockDeviceArgs', 'AmiCopyEbsBlockDeviceArgsDict']]]]] = None,
            ena_support: Optional[pulumi.Input[builtins.bool]] = None,
            encrypted: Optional[pulumi.Input[builtins.bool]] = None,
            ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEphemeralBlockDeviceArgs', 'AmiCopyEphemeralBlockDeviceArgsDict']]]]] = None,
            hypervisor: Optional[pulumi.Input[builtins.str]] = None,
            image_location: Optional[pulumi.Input[builtins.str]] = None,
            image_owner_alias: Optional[pulumi.Input[builtins.str]] = None,
            image_type: Optional[pulumi.Input[builtins.str]] = None,
            imds_support: Optional[pulumi.Input[builtins.str]] = None,
            kernel_id: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            last_launched_time: Optional[pulumi.Input[builtins.str]] = None,
            manage_ebs_snapshots: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner_id: Optional[pulumi.Input[builtins.str]] = None,
            platform: Optional[pulumi.Input[builtins.str]] = None,
            platform_details: Optional[pulumi.Input[builtins.str]] = None,
            public: Optional[pulumi.Input[builtins.bool]] = None,
            ramdisk_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            root_device_name: Optional[pulumi.Input[builtins.str]] = None,
            root_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
            source_ami_id: Optional[pulumi.Input[builtins.str]] = None,
            source_ami_region: Optional[pulumi.Input[builtins.str]] = None,
            sriov_net_support: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tpm_support: Optional[pulumi.Input[builtins.str]] = None,
            uefi_data: Optional[pulumi.Input[builtins.str]] = None,
            usage_operation: Optional[pulumi.Input[builtins.str]] = None,
            virtualization_type: Optional[pulumi.Input[builtins.str]] = None) -> 'AmiCopy':
        """
        Get an existing AmiCopy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] architecture: Machine architecture for created instances. Defaults to `x86_64`.
        :param pulumi.Input[builtins.str] arn: ARN of the AMI.
        :param pulumi.Input[builtins.str] boot_mode: Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] deprecation_time: Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        :param pulumi.Input[builtins.str] description: Longer, human-readable description for the AMI.
        :param pulumi.Input[builtins.str] destination_outpost_arn: ARN of the Outpost to which to copy the AMI.
               Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEbsBlockDeviceArgs', 'AmiCopyEbsBlockDeviceArgsDict']]]] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.bool] ena_support: Whether enhanced networking with ENA is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] encrypted: Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AmiCopyEphemeralBlockDeviceArgs', 'AmiCopyEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[builtins.str] image_location: Path to an S3 object containing an image manifest, e.g., created
               by the `ec2-upload-bundle` command in the EC2 command line tools.
        :param pulumi.Input[builtins.str] imds_support: If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        :param pulumi.Input[builtins.str] kernel_id: ID of the kernel image (AKI) that will be used as the paravirtual
               kernel in created instances.
        :param pulumi.Input[builtins.str] kms_key_id: Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
        :param pulumi.Input[builtins.str] last_launched_time: Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        :param pulumi.Input[builtins.str] name: Region-unique name for the AMI.
        :param pulumi.Input[builtins.str] ramdisk_id: ID of an initrd image (ARI) that will be used when booting the
               created instances.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] root_device_name: Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        :param pulumi.Input[builtins.str] source_ami_id: Id of the AMI to copy. This id must be valid in the region
               given by `source_ami_region`.
        :param pulumi.Input[builtins.str] source_ami_region: Region from which the AMI will be copied. This may be the
               same as the AWS provider region in order to create a copy within the same region.
        :param pulumi.Input[builtins.str] sriov_net_support: When set to "simple" (the default), enables enhanced networking
               for created instances. No other value is supported at this time.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] tpm_support: If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        :param pulumi.Input[builtins.str] uefi_data: Base64 representation of the non-volatile UEFI variable store.
        :param pulumi.Input[builtins.str] virtualization_type: Keyword to choose what virtualization mode created instances
               will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
               changes the set of further arguments that are required, as described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AmiCopyState.__new__(_AmiCopyState)

        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["arn"] = arn
        __props__.__dict__["boot_mode"] = boot_mode
        __props__.__dict__["deprecation_time"] = deprecation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_outpost_arn"] = destination_outpost_arn
        __props__.__dict__["ebs_block_devices"] = ebs_block_devices
        __props__.__dict__["ena_support"] = ena_support
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
        __props__.__dict__["hypervisor"] = hypervisor
        __props__.__dict__["image_location"] = image_location
        __props__.__dict__["image_owner_alias"] = image_owner_alias
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["imds_support"] = imds_support
        __props__.__dict__["kernel_id"] = kernel_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["last_launched_time"] = last_launched_time
        __props__.__dict__["manage_ebs_snapshots"] = manage_ebs_snapshots
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["platform"] = platform
        __props__.__dict__["platform_details"] = platform_details
        __props__.__dict__["public"] = public
        __props__.__dict__["ramdisk_id"] = ramdisk_id
        __props__.__dict__["region"] = region
        __props__.__dict__["root_device_name"] = root_device_name
        __props__.__dict__["root_snapshot_id"] = root_snapshot_id
        __props__.__dict__["source_ami_id"] = source_ami_id
        __props__.__dict__["source_ami_region"] = source_ami_region
        __props__.__dict__["sriov_net_support"] = sriov_net_support
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tpm_support"] = tpm_support
        __props__.__dict__["uefi_data"] = uefi_data
        __props__.__dict__["usage_operation"] = usage_operation
        __props__.__dict__["virtualization_type"] = virtualization_type
        return AmiCopy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[builtins.str]:
        """
        Machine architecture for created instances. Defaults to `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the AMI.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> pulumi.Output[builtins.str]:
        """
        Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "boot_mode")

    @property
    @pulumi.getter(name="deprecationTime")
    def deprecation_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
        """
        return pulumi.get(self, "deprecation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Longer, human-readable description for the AMI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationOutpostArn")
    def destination_outpost_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the Outpost to which to copy the AMI.
        Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
        """
        return pulumi.get(self, "destination_outpost_arn")

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> pulumi.Output[Sequence['outputs.AmiCopyEbsBlockDevice']]:
        """
        Nested block describing an EBS block device that should be
        attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @property
    @pulumi.getter(name="enaSupport")
    def ena_support(self) -> pulumi.Output[builtins.bool]:
        """
        Whether enhanced networking with ENA is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ena_support")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> pulumi.Output[Sequence['outputs.AmiCopyEphemeralBlockDevice']]:
        """
        Nested block describing an ephemeral block device that
        should be attached to created instances. The structure of this block is described below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @property
    @pulumi.getter
    def hypervisor(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "hypervisor")

    @property
    @pulumi.getter(name="imageLocation")
    def image_location(self) -> pulumi.Output[builtins.str]:
        """
        Path to an S3 object containing an image manifest, e.g., created
        by the `ec2-upload-bundle` command in the EC2 command line tools.
        """
        return pulumi.get(self, "image_location")

    @property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "image_owner_alias")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="imdsSupport")
    def imds_support(self) -> pulumi.Output[builtins.str]:
        """
        If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
        """
        return pulumi.get(self, "imds_support")

    @property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the kernel image (AKI) that will be used as the paravirtual
        kernel in created instances.
        """
        return pulumi.get(self, "kernel_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lastLaunchedTime")
    def last_launched_time(self) -> pulumi.Output[builtins.str]:
        """
        Date and time, in ISO 8601 date-time format , when the AMI was last used to launch an EC2 instance. When the AMI is used to launch an instance, there is a 24-hour delay before that usage is reported. For more information, see the following [AWS document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-last-launched-time.html).
        """
        return pulumi.get(self, "last_launched_time")

    @property
    @pulumi.getter(name="manageEbsSnapshots")
    def manage_ebs_snapshots(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "manage_ebs_snapshots")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Region-unique name for the AMI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="platformDetails")
    def platform_details(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "platform_details")

    @property
    @pulumi.getter
    def public(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "public")

    @property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of an initrd image (ARI) that will be used when booting the
        created instances.
        """
        return pulumi.get(self, "ramdisk_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootDeviceName")
    def root_device_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        """
        return pulumi.get(self, "root_device_name")

    @property
    @pulumi.getter(name="rootSnapshotId")
    def root_snapshot_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "root_snapshot_id")

    @property
    @pulumi.getter(name="sourceAmiId")
    def source_ami_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the AMI to copy. This id must be valid in the region
        given by `source_ami_region`.
        """
        return pulumi.get(self, "source_ami_id")

    @property
    @pulumi.getter(name="sourceAmiRegion")
    def source_ami_region(self) -> pulumi.Output[builtins.str]:
        """
        Region from which the AMI will be copied. This may be the
        same as the AWS provider region in order to create a copy within the same region.
        """
        return pulumi.get(self, "source_ami_region")

    @property
    @pulumi.getter(name="sriovNetSupport")
    def sriov_net_support(self) -> pulumi.Output[builtins.str]:
        """
        When set to "simple" (the default), enables enhanced networking
        for created instances. No other value is supported at this time.
        """
        return pulumi.get(self, "sriov_net_support")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="tpmSupport")
    def tpm_support(self) -> pulumi.Output[builtins.str]:
        """
        If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
        """
        return pulumi.get(self, "tpm_support")

    @property
    @pulumi.getter(name="uefiData")
    def uefi_data(self) -> pulumi.Output[builtins.str]:
        """
        Base64 representation of the non-volatile UEFI variable store.
        """
        return pulumi.get(self, "uefi_data")

    @property
    @pulumi.getter(name="usageOperation")
    def usage_operation(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "usage_operation")

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> pulumi.Output[builtins.str]:
        """
        Keyword to choose what virtualization mode created instances
        will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
        changes the set of further arguments that are required, as described below.
        """
        return pulumi.get(self, "virtualization_type")

