# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DefaultCreditSpecificationArgs', 'DefaultCreditSpecification']

@pulumi.input_type
class DefaultCreditSpecificationArgs:
    def __init__(__self__, *,
                 cpu_credits: pulumi.Input[builtins.str],
                 instance_family: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['DefaultCreditSpecificationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a DefaultCreditSpecification resource.
        :param pulumi.Input[builtins.str] cpu_credits: Credit option for CPU usage of the instance family. Valid values: `standard`, `unlimited`.
        :param pulumi.Input[builtins.str] instance_family: Instance family. Valid values are `t2`, `t3`, `t3a`, `t4g`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "cpu_credits", cpu_credits)
        pulumi.set(__self__, "instance_family", instance_family)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="cpuCredits")
    def cpu_credits(self) -> pulumi.Input[builtins.str]:
        """
        Credit option for CPU usage of the instance family. Valid values: `standard`, `unlimited`.
        """
        return pulumi.get(self, "cpu_credits")

    @cpu_credits.setter
    def cpu_credits(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cpu_credits", value)

    @property
    @pulumi.getter(name="instanceFamily")
    def instance_family(self) -> pulumi.Input[builtins.str]:
        """
        Instance family. Valid values are `t2`, `t3`, `t3a`, `t4g`.
        """
        return pulumi.get(self, "instance_family")

    @instance_family.setter
    def instance_family(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_family", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DefaultCreditSpecificationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DefaultCreditSpecificationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _DefaultCreditSpecificationState:
    def __init__(__self__, *,
                 cpu_credits: Optional[pulumi.Input[builtins.str]] = None,
                 instance_family: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['DefaultCreditSpecificationTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering DefaultCreditSpecification resources.
        :param pulumi.Input[builtins.str] cpu_credits: Credit option for CPU usage of the instance family. Valid values: `standard`, `unlimited`.
        :param pulumi.Input[builtins.str] instance_family: Instance family. Valid values are `t2`, `t3`, `t3a`, `t4g`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if cpu_credits is not None:
            pulumi.set(__self__, "cpu_credits", cpu_credits)
        if instance_family is not None:
            pulumi.set(__self__, "instance_family", instance_family)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="cpuCredits")
    def cpu_credits(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Credit option for CPU usage of the instance family. Valid values: `standard`, `unlimited`.
        """
        return pulumi.get(self, "cpu_credits")

    @cpu_credits.setter
    def cpu_credits(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpu_credits", value)

    @property
    @pulumi.getter(name="instanceFamily")
    def instance_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Instance family. Valid values are `t2`, `t3`, `t3a`, `t4g`.
        """
        return pulumi.get(self, "instance_family")

    @instance_family.setter
    def instance_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_family", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DefaultCreditSpecificationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DefaultCreditSpecificationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:ec2/defaultCreditSpecification:DefaultCreditSpecification")
class DefaultCreditSpecification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_credits: Optional[pulumi.Input[builtins.str]] = None,
                 instance_family: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['DefaultCreditSpecificationTimeoutsArgs', 'DefaultCreditSpecificationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS EC2 (Elastic Compute Cloud) Default Credit Specification.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.DefaultCreditSpecification("example",
            instance_family="t2",
            cpu_credits="standard")
        ```

        ## Import

        Using `pulumi import`, import EC2 (Elastic Compute Cloud) Default Credit Specification using the `instance_family`. For example:

        console

        % pulumi import aws_ec2_default_credit_specification.example t2

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cpu_credits: Credit option for CPU usage of the instance family. Valid values: `standard`, `unlimited`.
        :param pulumi.Input[builtins.str] instance_family: Instance family. Valid values are `t2`, `t3`, `t3a`, `t4g`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultCreditSpecificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS EC2 (Elastic Compute Cloud) Default Credit Specification.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.DefaultCreditSpecification("example",
            instance_family="t2",
            cpu_credits="standard")
        ```

        ## Import

        Using `pulumi import`, import EC2 (Elastic Compute Cloud) Default Credit Specification using the `instance_family`. For example:

        console

        % pulumi import aws_ec2_default_credit_specification.example t2

        :param str resource_name: The name of the resource.
        :param DefaultCreditSpecificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultCreditSpecificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_credits: Optional[pulumi.Input[builtins.str]] = None,
                 instance_family: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['DefaultCreditSpecificationTimeoutsArgs', 'DefaultCreditSpecificationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultCreditSpecificationArgs.__new__(DefaultCreditSpecificationArgs)

            if cpu_credits is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_credits'")
            __props__.__dict__["cpu_credits"] = cpu_credits
            if instance_family is None and not opts.urn:
                raise TypeError("Missing required property 'instance_family'")
            __props__.__dict__["instance_family"] = instance_family
            __props__.__dict__["region"] = region
            __props__.__dict__["timeouts"] = timeouts
        super(DefaultCreditSpecification, __self__).__init__(
            'aws:ec2/defaultCreditSpecification:DefaultCreditSpecification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cpu_credits: Optional[pulumi.Input[builtins.str]] = None,
            instance_family: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['DefaultCreditSpecificationTimeoutsArgs', 'DefaultCreditSpecificationTimeoutsArgsDict']]] = None) -> 'DefaultCreditSpecification':
        """
        Get an existing DefaultCreditSpecification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cpu_credits: Credit option for CPU usage of the instance family. Valid values: `standard`, `unlimited`.
        :param pulumi.Input[builtins.str] instance_family: Instance family. Valid values are `t2`, `t3`, `t3a`, `t4g`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefaultCreditSpecificationState.__new__(_DefaultCreditSpecificationState)

        __props__.__dict__["cpu_credits"] = cpu_credits
        __props__.__dict__["instance_family"] = instance_family
        __props__.__dict__["region"] = region
        __props__.__dict__["timeouts"] = timeouts
        return DefaultCreditSpecification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cpuCredits")
    def cpu_credits(self) -> pulumi.Output[builtins.str]:
        """
        Credit option for CPU usage of the instance family. Valid values: `standard`, `unlimited`.
        """
        return pulumi.get(self, "cpu_credits")

    @property
    @pulumi.getter(name="instanceFamily")
    def instance_family(self) -> pulumi.Output[builtins.str]:
        """
        Instance family. Valid values are `t2`, `t3`, `t3a`, `t4g`.
        """
        return pulumi.get(self, "instance_family")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DefaultCreditSpecificationTimeouts']]:
        return pulumi.get(self, "timeouts")

